ScriptName SexLabSquirt extends Quest

SexLabFramework property SexLab auto

Armor Property slSquirtTinkle01 Auto
Armor Property slSquirtTinkle02 Auto
Armor Property slSquirtTinkle03 Auto
Armor Property slSquirtTinkle04 Auto
Armor Property slSquirtGush01 Auto
Armor Property slSquirtGush02 Auto
GlobalVariable Property SexLabSquirtChance Auto
GlobalVariable Property SexLabSquirtPCChance Auto
GlobalVariable Property SexLabSquirtDebug Auto
GlobalVariable Property SexLabSquirtStream Auto
GlobalVariable Property SexLabSquirtGush Auto

Actor Property PlayerREF Auto 

bool[] bSquirters
Armor[] aGushes
Armor[] aStreams

event OnInit()
    RegisterForModEvent("OrgasmStart", "ActorStartSquirt")
    RegisterForModEvent("OrgasmEnd", "ActorEndSquirt")
endEvent

event ActorStartSquirt(string eventName, string argString, float argNum, form sender)
    actor[] aActors = SexLab.HookActors(argString)
    
    bSquirters = new bool[10]
    aGushes = new Armor[10]
    aStreams = new Armor[10]
    
    int i = 0
    
    while i<aActors.Length
        
        if aActors[i].GetLeveledActorBase().GetSex() == 1
            
            int iSquirtChance

            if aActors[i]==PlayerREF
                iSquirtChance = SexLabSquirtPCChance.GetValue() As int
            else
                iSquirtChance = SexLabSquirtChance.GetValue() As int
            endIf
            
            int iRan = Utility.RandomInt(1,100)
            if iRan<=iSquirtChance

                int iGushType
                int iStreamType

                bSquirters[i] = true

                if SexLabSquirtGush.GetValue()==3
                    iGushType = Utility.RandomInt(0,2)
                else
                    iGushType = SexLabSquirtGush.GetValue() As int
                endIf
                
                if SexLabSquirtStream.GetValue()==5
                    iStreamType = Utility.RandomInt(0,4)
                else
                    iStreamType = SexLabSquirtStream.GetValue() As int
                endIf


                if SexLabSquirtDebug.GetValue()==1
                    String akName = aActors[i].GetLeveledActorBase().GetName()
                    String msg = akName + " is squirting"
                    Debug.Notification(msg)
                endIf

                if iGushType==1
                    aActors[i].EquipItem(slSquirtGush01, true, true)
                    aGushes[i] = slSquirtGush01
                endIf
                if iGushType==2
                    aActors[i].EquipItem(slSquirtGush02, true, true)
                    aGushes[i] = slSquirtGush02
                endIf
                
                if iStreamType==1
                    aActors[i].EquipItem(slSquirtTinkle01, true, true)
                    aStreams[i] = slSquirtTinkle01
                endIf
                if iStreamType==2
                    aActors[i].EquipItem(slSquirtTinkle02, true, true)
                    aStreams[i] = slSquirtTinkle02
                endIf
                if iStreamType==3
                    aActors[i].EquipItem(slSquirtTinkle03, true, true)
                    aStreams[i] = slSquirtTinkle03
                endIf
                if iStreamType==4
                    aActors[i].EquipItem(slSquirtTinkle04, true, true)
                    aStreams[i] = slSquirtTinkle04
                endIf

            else 
                bSquirters[i] = false
            endIf
        endIf    

        i += 1
    endWhile
    
endEvent

event ActorEndSquirt(string eventName, string argString, float argNum, form sender)
    actor[] aActors =SexLab.HookActors(argString)
    
    int i = 0
    
    while i<aActors.Length
        
        if aActors[i].GetLeveledActorBase().GetSex() == 1
            if bSquirters[i]
                if SexLabSquirtDebug.GetValue()==1
                    String akName = aActors[i].GetLeveledActorBase().GetName()
                    String msg = akName + " stopped squirting"
                    Debug.Notification(msg)
                endIf

                if aGushes[i]!=none
                    aActors[i].RemoveItem(aGushes[i], 1, true)
                endIf
                if aStreams[i]!=none
                    aActors[i].RemoveItem(aStreams[i], 1, true)
                endIf

            endIf
        endIf    

        i += 1
    endWhile

endEvent
