scriptname SexLabSquirtMenu extends SKI_ConfigBase

GlobalVariable Property SexLabSquirtChance Auto
GlobalVariable Property SexLabSquirtPCChance Auto
GlobalVariable Property SexLabSquirtDebug Auto
GlobalVariable Property SexLabSquirtStream Auto
GlobalVariable Property SexLabSquirtGush Auto

; MCM Option IDs
int OID_SquirtChance
int OID_SquirtPCChance
int OID_SquirtDebug
int OID_Stream0
int OID_Stream1
int OID_Stream2
int OID_Stream3
int OID_Stream4
int OID_Stream5
int OID_Gush0
int OID_Gush1
int OID_Gush2
int OID_Gush3

Event OnConfigInit()
	Pages = new string[1]
    Pages[0] = "Settings"
EndEvent

Event OnPageReset(string Page)
	SetCursorFillMode(TOP_TO_BOTTOM)

	If Page == "Settings"	
	   AddHeaderOption("Squirt Settings")
       OID_SquirtChance = AddSliderOption("NPC Squirt Chance:", SexLabSquirtChance.GetValue(), "{0}%")
	   AddEmptyOption()
       OID_SquirtPCChance = AddSliderOption("PC Squirt Chance:", SexLabSquirtPCChance.GetValue(), "{0}%")
	   AddEmptyOption()

	   AddHeaderOption("Debug Settings")
	   OID_SquirtDebug = AddToggleOption("Debug Messages?", SexLabSquirtDebug.GetValue())
	   AddEmptyOption()
       
       SetCursorPosition(1)
	   AddHeaderOption("Squirt Effects")
       SetCursorPosition(5)
	   AddHeaderOption("Gushing")
       if SexLabSquirtGush.GetValue()==0
	       OID_Gush0 = AddToggleOption("None", true)
       else 
	       OID_Gush0 = AddToggleOption("None", false)
       endIf        
       if SexLabSquirtGush.GetValue()==1
	       OID_Gush1 = AddToggleOption("Small Gush", true)
       else 
	       OID_Gush1 = AddToggleOption("Small Gush", false)
       endIf        
       if SexLabSquirtGush.GetValue()==2
	       OID_Gush2 = AddToggleOption("Large Gush", true)
       else 
	       OID_Gush2 = AddToggleOption("Large Gush", false)
       endIf        
       if SexLabSquirtGush.GetValue()==3
	       OID_Gush3 = AddToggleOption("Random", true)
       else 
	       OID_Gush3 = AddToggleOption("Random", false)
       endIf        
       SetCursorPosition(17)
	   AddHeaderOption("Stream")
       if SexLabSquirtStream.GetValue()==0
	       OID_Stream0 = AddToggleOption("None", true)
       else 
	       OID_Stream0 = AddToggleOption("None", false)
       endIf        
       if SexLabSquirtStream.GetValue()==1
	       OID_Stream1 = AddToggleOption("Weak Yellow", true)
       else 
	       OID_Stream1 = AddToggleOption("Weak Yellow", false)
       endIf        
       if SexLabSquirtStream.GetValue()==2
	       OID_Stream2 = AddToggleOption("Strong Yellow", true)
       else 
	       OID_Stream2 = AddToggleOption("Strong Yellow", false)
       endIf        
       if SexLabSquirtStream.GetValue()==3
	       OID_Stream3 = AddToggleOption("Weak White", true)
       else 
	       OID_Stream3 = AddToggleOption("Weak White", false)
       endIf        
       if SexLabSquirtStream.GetValue()==4
	       OID_Stream4 = AddToggleOption("Strong White", true)
       else 
	       OID_Stream4 = AddToggleOption("Strong White", false)
       endIf        
       if SexLabSquirtStream.GetValue()==5
	       OID_Stream5 = AddToggleOption("Random", true)
       else 
	       OID_Stream5 = AddToggleOption("Random", false)
       endIf        
       
       
    EndIf
EndEvent

Event OnOptionSelect(int Option)
    If Option == OID_SquirtDebug
        ToggleValue(SexLabSquirtDebug)
    	SetToggleOptionValue(Option, SexLabSquirtDebug.GetValue())    
    EndIf
    If Option == OID_Gush0
        SexLabSquirtGush.SetValue(0)
    	SetToggleOptionValue(OID_Gush0,true)    
    	SetToggleOptionValue(OID_Gush1,false)    
    	SetToggleOptionValue(OID_Gush2,false)    
    	SetToggleOptionValue(OID_Gush3,false)    
    EndIf
    If Option == OID_Gush1
        SexLabSquirtGush.SetValue(1)
    	SetToggleOptionValue(OID_Gush0,false)    
    	SetToggleOptionValue(OID_Gush1,true)    
    	SetToggleOptionValue(OID_Gush2,false)    
    	SetToggleOptionValue(OID_Gush3,false)    
    EndIf
    If Option == OID_Gush2
        SexLabSquirtGush.SetValue(2)
    	SetToggleOptionValue(OID_Gush0,false)    
    	SetToggleOptionValue(OID_Gush1,false)    
    	SetToggleOptionValue(OID_Gush2,true)    
    	SetToggleOptionValue(OID_Gush3,false)    
    EndIf
    If Option == OID_Gush3
        SexLabSquirtGush.SetValue(3)
    	SetToggleOptionValue(OID_Gush0,false)    
    	SetToggleOptionValue(OID_Gush1,false)    
    	SetToggleOptionValue(OID_Gush2,false)    
    	SetToggleOptionValue(OID_Gush3,true)    
    EndIf
    If Option == OID_Stream0
        SexLabSquirtStream.SetValue(0)
    	SetToggleOptionValue(OID_Stream0,true)    
    	SetToggleOptionValue(OID_Stream1,false)    
    	SetToggleOptionValue(OID_Stream2,false)    
    	SetToggleOptionValue(OID_Stream3,false)    
    	SetToggleOptionValue(OID_Stream4,false)    
    	SetToggleOptionValue(OID_Stream5,false)    
    EndIf
    If Option == OID_Stream1
        SexLabSquirtStream.SetValue(1)
    	SetToggleOptionValue(OID_Stream0,false)    
    	SetToggleOptionValue(OID_Stream1,true)    
    	SetToggleOptionValue(OID_Stream2,false)    
    	SetToggleOptionValue(OID_Stream3,false)    
    	SetToggleOptionValue(OID_Stream4,false)    
    	SetToggleOptionValue(OID_Stream5,false)    
    EndIf
    If Option == OID_Stream2
        SexLabSquirtStream.SetValue(2)
    	SetToggleOptionValue(OID_Stream0,false)    
    	SetToggleOptionValue(OID_Stream1,false)    
    	SetToggleOptionValue(OID_Stream2,true)    
    	SetToggleOptionValue(OID_Stream3,false)    
    	SetToggleOptionValue(OID_Stream4,false)    
    	SetToggleOptionValue(OID_Stream5,false)    
    EndIf
    If Option == OID_Stream3
        SexLabSquirtStream.SetValue(3)
    	SetToggleOptionValue(OID_Stream0,false)    
    	SetToggleOptionValue(OID_Stream1,false)    
    	SetToggleOptionValue(OID_Stream2,false)    
    	SetToggleOptionValue(OID_Stream3,true)    
    	SetToggleOptionValue(OID_Stream4,false)    
    	SetToggleOptionValue(OID_Stream5,false)    
    EndIf
    If Option == OID_Stream4
        SexLabSquirtStream.SetValue(4)
    	SetToggleOptionValue(OID_Stream0,false)    
    	SetToggleOptionValue(OID_Stream1,false)    
    	SetToggleOptionValue(OID_Stream2,false)    
    	SetToggleOptionValue(OID_Stream3,false)    
    	SetToggleOptionValue(OID_Stream4,true)    
    	SetToggleOptionValue(OID_Stream5,false)    
    EndIf
    If Option == OID_Stream5
        SexLabSquirtStream.SetValue(5)
    	SetToggleOptionValue(OID_Stream0,false)    
    	SetToggleOptionValue(OID_Stream1,false)    
    	SetToggleOptionValue(OID_Stream2,false)    
    	SetToggleOptionValue(OID_Stream3,false)    
    	SetToggleOptionValue(OID_Stream4,false)    
    	SetToggleOptionValue(OID_Stream5,true)    
    EndIf
EndEvent

Event OnOptionHighlight(int Option)
    If Option == OID_SquirtChance
        SetInfoText("Percentage chance of female NPCs squirting during a SexLab orgasm.")
    EndIf
    If Option == OID_SquirtPCChance
        SetInfoText("Percentage chance of female players squirting during a SexLab orgasm.")
    EndIf
    If Option == OID_SquirtDebug
        SetInfoText("Turn on/off debug notification messages.")
    EndIf
    If Option == OID_Gush0
        SetInfoText("Select the desired gush effect (if any).")
    EndIf
    If Option == OID_Gush1
        SetInfoText("Select the desired gush effect (if any).")
    EndIf
    If Option == OID_Gush2
        SetInfoText("Select the desired gush effect (if any).")
    EndIf
    If Option == OID_Gush3
        SetInfoText("Select the desired gush effect (if any). NOTE: Random selection includes 'none'.")
    EndIf
    If Option == OID_Stream0
        SetInfoText("Select the desired stream effect (if any).")
    EndIf
    If Option == OID_Stream1
        SetInfoText("Select the desired stream effect (if any).")
    EndIf
    If Option == OID_Stream2
        SetInfoText("Select the desired stream effect (if any).")
    EndIf
    If Option == OID_Stream3
        SetInfoText("Select the desired stream effect (if any).")
    EndIf
    If Option == OID_Stream4
        SetInfoText("Select the desired stream effect (if any).")
    EndIf
    If Option == OID_Stream5
        SetInfoText("Select the desired stream effect (if any). NOTE: Random selection includes 'none'.")
    EndIf
EndEvent

Event OnOptionSliderOpen(int Option)
	If Option == OID_SquirtChance
		SetSliderDialogStartValue(SexLabSquirtChance.GetValue())
		SetSliderDialogDefaultValue(50.0)
		SetSliderDialogRange(0.0, 100.0)
		SetSliderDialogInterval(1.0)
    EndIf
	If Option == OID_SquirtPCChance
		SetSliderDialogStartValue(SexLabSquirtPCChance.GetValue())
		SetSliderDialogDefaultValue(50.0)
		SetSliderDialogRange(0.0, 100.0)
		SetSliderDialogInterval(1.0)
    EndIf
EndEvent

Event OnOptionSliderAccept(int Option, float Value)
	If Option == OID_SquirtChance
		SexLabSquirtChance.SetValue(Value)
		SetSliderOptionValue(OID_SquirtChance, SexLabSquirtChance.GetValue(), "{0}%")
    EndIf
	If Option == OID_SquirtPCChance
		SexLabSquirtPCChance.SetValue(Value)
		SetSliderOptionValue(OID_SquirtPCChance, SexLabSquirtPCChance.GetValue(), "{0}%")
    EndIf
EndEvent

Function ToggleValue(GlobalVariable gVar)
    If gVar.GetValue()==0 
        gVar.SetValue(1)
    Else 
        gVar.SetValue(0)
    EndIf
EndFunction
