<?php

/**
 * Indonesian language file
 *
 *
 *
 * This Source Code Form is subject to the terms of the Mozilla Public License,
 * v. 2.0. If a copy of the MPL was not distributed with this file, You can
 * obtain one at http://mozilla.org/MPL/2.0/.
 *
 * @package phpMyFAQ
 * @author Tri Agus Prayitno <tap@ruangweb.co.id>
 * @copyright 2009-2020 phpMyFAQ Team
 * @license http://www.mozilla.org/MPL/2.0/ Mozilla Public License Version 2.0
 * @link https://www.phpmyfaq.de
 * @since 2009-12-28
 */

$PMF_LANG['metaCharset'] = 'utf-8';
$PMF_LANG['metaLanguage'] = 'id';
$PMF_LANG['language'] = 'indonesian';
$PMF_LANG['dir'] = 'ltr';
$PMF_LANG["nplurals"] = "1";

// Navigation
$PMF_LANG["msgCategory"] = "Kategori";
$PMF_LANG["msgShowAllCategories"] = "Semua kategori";
$PMF_LANG["msgSearch"] = "Cari";
$PMF_LANG["msgAddContent"] = "Kirim Artikel";
$PMF_LANG["msgQuestion"] = "Kirim Pertanyaan";
$PMF_LANG["msgOpenQuestions"] = "Jawab Pertanyaan";
$PMF_LANG["msgHelp"] = "Bantuan";
$PMF_LANG["msgContact"] = "Kontak";
$PMF_LANG["msgHome"] = "Halaman Depan";
$PMF_LANG["msgNews"] = "Berita";
$PMF_LANG["msgUserOnline"] = " Pengunjung online";
$PMF_LANG["msgBack2Home"] = "Kembali ke halaman depan";

// Contentpages
$PMF_LANG["msgFullCategories"] = "Kategori dan Isi";
$PMF_LANG["msgFullCategoriesIn"] = "Kategori dan Isi dalam ";
$PMF_LANG["msgSubCategories"] = "Subkategori";
$PMF_LANG["msgEntries"] = "Entri";
$PMF_LANG["msgEntriesIn"] = "Pertanyaan dalam ";
$PMF_LANG["msgViews"] = "kunjungan";
$PMF_LANG["msgPage"] = "Halaman ";
$PMF_LANG["msgPages"] = " Halaman";
$PMF_LANG["msgPrevious"] = "sebelumnya";
$PMF_LANG["msgNext"] = "berikutnya";
$PMF_LANG["msgCategoryUp"] = "naik satu kategori";
$PMF_LANG["msgLastUpdateArticle"] = "Update terakhir: ";
$PMF_LANG["msgAuthor"] = "Penulis: ";
$PMF_LANG["msgPrinterFriendly"] = "versi ramah-cetak";
$PMF_LANG["msgPrintArticle"] = "Cetak artikel ini";
$PMF_LANG["msgMakeXMLExport"] = "Ekspor sbg Berkas XML";
$PMF_LANG["msgAverageVote"] = "Nilai rata-rata";
$PMF_LANG["msgVoteUsability"] = "Beri nilai materi ini";
$PMF_LANG["msgVoteFrom"] = "dari";
$PMF_LANG["msgVoteBad"] = "sangat tak berguna";
$PMF_LANG["msgVoteGood"] = "sangat berguna";
$PMF_LANG["msgVotings"] = "Suara ";
$PMF_LANG["msgVoteSubmit"] = "Pilih";
$PMF_LANG["msgVoteThanks"] = "Terima kasih atas penilaian anda!";
$PMF_LANG["msgYouCan"] = "Anda bisa ";
$PMF_LANG["msgWriteComment"] = "mengirim komentar atas materi ini";
$PMF_LANG["msgShowCategory"] = "Ikhtisar: ";
$PMF_LANG["msgCommentBy"] = "Komentar atas ";
$PMF_LANG["msgCommentHeader"] = "Komentar pada materi ini";
$PMF_LANG["msgYourComment"] = "Komentar anda";
$PMF_LANG["msgCommentThanks"] = "Terima kasih atas komentar anda!";
$PMF_LANG["msgSeeXMLFile"] = "buka Berkas XML";
$PMF_LANG["msgSend2Friend"] = "Kirim materi ke e-mail";
$PMF_LANG["msgS2FName"] = "Nama anda";
$PMF_LANG["msgS2FEMail"] = "Alamat e-mail anda";
$PMF_LANG["msgS2FFriends"] = "Nama Tujuan";
$PMF_LANG["msgS2FEMails"] = ". alamat e-mail ";
$PMF_LANG["msgS2FText"] = "Teks berikut bisa dikirim";
$PMF_LANG["msgS2FText2"] = "Anda bisa membaca materi pada alamat berikut";
$PMF_LANG["msgS2FMessage"] = "Pesan tambahan dari pengirim";
$PMF_LANG["msgS2FButton"] = "kirim e-mail";
$PMF_LANG["msgS2FThx"] = "Terima kasih atas rekomendasi anda!";
$PMF_LANG["msgS2FMailSubject"] = "Rekomendasi dari";

// Search
$PMF_LANG["msgSearchWord"] = "Kata kunci";
$PMF_LANG["msgSearchFind"] = "Hasil pencarian ";
$PMF_LANG["msgSearchAmount"] = " hasil";
$PMF_LANG["msgSearchAmounts"] = " hasil";
$PMF_LANG["msgSearchCategory"] = "Kategori: ";
$PMF_LANG["msgSearchContent"] = "Jawaban: ";

// new Content
$PMF_LANG["msgNewContentHeader"] = "Usulan materi/artikel baru";
$PMF_LANG["msgNewContentAddon"] = "Usulan anda tidak langsung akan ditampilkan, tetapi perlu ditinjau dulu oleh pengelola. Bagian yang harus diisi adalah: <strong>Nama Anda</strong>, <strong>Alamat Email</strong>, <strong>Kategori</strong>, <strong>Pengantar</strong> dan <strong>Isi Materi</strong>. Mohon pisahkan kata kunci dengan spasi.";
$PMF_LANG["msgNewContentName"] = "Nama Anda";
$PMF_LANG["msgNewContentMail"] = "Alamat Email";
$PMF_LANG["msgNewContentCategory"] = "Kategori";
$PMF_LANG["msgNewContentTheme"] = "Pengantar";
$PMF_LANG["msgNewContentArticle"] = "Isi Materi";
$PMF_LANG["msgNewContentKeywords"] = "Kata Kunci";
$PMF_LANG["msgNewContentLink"] = "Link ke materi ini";
$PMF_LANG["msgNewContentSubmit"] = "kirim";
$PMF_LANG["msgInfo"] = "Informasi tambahan: ";
$PMF_LANG["msgNewContentThanks"] = "Terima kasih atas kontribusi anda!";
$PMF_LANG["msgNoQuestionsAvailable"] = "Saat ini tidak ada pertanyaan dalam antrian.";

// ask Question
$PMF_LANG["msgNewQuestion"] = "Kirim pertanyaan anda di bawah ini";
$PMF_LANG["msgAskCategory"] = "Kategori";
$PMF_LANG["msgAskYourQuestion"] = "Pertanyaan";
$PMF_LANG["msgAskThx4Mail"] = "<h2>Terima kasih atas pertanyaan anda!</h2>";
$PMF_LANG["msgDate_User"] = "Tanggal / Pengguna";
$PMF_LANG["msgQuestion2"] = "Pertanyaan";
$PMF_LANG["msg2answer"] = "Jawaban";
$PMF_LANG["msgQuestionText"] = "Di sini anda bisa bertanya pada pengguna lainnya. Jika anda menjawab pertanyaan ini dengan baik, jawaban anda mungkin akan dimasukkan ke dalam materi.";

// Help
$PMF_LANG["msgHelpText"] = "Struktur situs ini sangatlah sederhana. Di sini anda bisa melakukan pencarian menurut <strong><a href=\"?action=show\">kategori</a></strong> atau gunakan <strong><a href=\"?action=search\">mesin pencari</a></strong> untuk melakukan pencarian atas kata kunci tertentu.";

// Contact
$PMF_LANG["msgContactEMail"] = "Kirim pesan ke pengelola";
$PMF_LANG["msgMessage"] = "Pesan anda";

// Startseite
$PMF_LANG["msgNews"] = " Berita";
$PMF_LANG["msgTopTen"] = "Artikel Populer";
$PMF_LANG["msgHomeThereAre"] = "Saat ini ada ";
$PMF_LANG["msgHomeArticlesOnline"] = " materi yang bisa dilihat";
$PMF_LANG["msgNoNews"] = "Tidak ada berita adalah berita bagus.";
$PMF_LANG["msgLatestArticles"] = "Artikel Terbaru";

// E-Mailbenachrichtigung
$PMF_LANG["msgMailThanks"] = "Terima kasih banyak atas masukan pada pada situs kami.";
$PMF_LANG["msgMailCheck"] = "Ada entri materi baru! Silakan periksa bagian admin!";
$PMF_LANG["msgMailContact"] = "Pesan anda sudah dikirim ke pengelola.";

// Fehlermeldungen
$PMF_LANG["err_noDatabase"] = "Koneksi database sedang bermasalah.";
$PMF_LANG["err_noHeaders"] = "Tidak ditemukan kategori.";
$PMF_LANG["err_noArticles"] = "Tidak ada materi yang tersedia.";
$PMF_LANG["err_badID"] = "ID Salah.";
$PMF_LANG["err_noTopTen"] = "Belum ada materi yang populer.";
$PMF_LANG["err_nothingFound"] = "Tidak ada materi yang ditemukan.";
$PMF_LANG["err_SaveEntries"] = "Bagian yang harus diisi adalah <strong>Nama Anda</strong>, <strong>Alamat Email</strong>, <strong>Kategori</strong>, <strong>Pengantar</strong>, <strong>Isi Materi</strong> dan, jika diminta, <strong>kode <a href=\"http://id.wikipedia.org/wiki/CAPTCHA\" title=\"lebih lanjut tentang Captcha di Wikipedia\" target=\"_blank\">Captcha</a></strong>!<br><br><a href=\"javascript:history.back();\">mundur satu halaman</a><br><br>";
$PMF_LANG["err_SaveComment"] = "Bagian yang harus diisi adalah <strong>Nama Anda</strong>, <strong>Alamat Email</strong>, <strong>Isi Komentar</strong> dan, jika diminta, <strong>kode <a href=\"http://id.wikipedia.org/wiki/CAPTCHA\" title=\"lebih lanjut tentang Captcha di Wikipedia\" target=\"_blank\">Captcha</a></strong>!<br><br><a href=\"javascript:history.back();\">mundur satu halaman</a><br><br>";
$PMF_LANG["err_VoteTooMuch"] = "Anda sudah pernah menilai sebelumnya. Klik di sini, untuk kembali.";
$PMF_LANG["err_noVote"] = "<strong>Anda belum memasukkan penilaian anda!</strong> <a href=\"javascript:history.back();\">Klik di sini</a>, untuk memberi penilaian.";
$PMF_LANG["err_noMailAdress"] = "Alamat email anda tidak benar.<br><a href=\"javascript:history.back();\">kembali</a>";
$PMF_LANG["err_sendMail"] = "Bagian yang harus diisi adalah <strong>Nama Anda</strong>, <strong>Alamat Email</strong>, <strong>Pertanyaan Anda</strong> dan, jika diminta, <strong>kode <a href=\"http://id.wikipedia.org/wiki/CAPTCHA\" title=\"lebih lanjut tentang Captcha di Wikipedia\" target=\"_blank\">Captcha</a></strong>!";

// Hilfe zur Suche
$PMF_LANG["help_search"] = "<strong>Pencarian materi:</strong><br>Dengan entri seperti <strong style=\"color: Red;\">kata1 kata2</strong> anda bisa melakukan pencarian menurut relevansi atas dua atau lebih kata.<strong>Perhatian:</strong> Kriteria pencarian anda minimal berisi 4 huruf.";

// Men?
$PMF_LANG["ad"] = "BAGIAN ADMIN";
$PMF_LANG["ad_menu_user_administration"] = "Pengguna";
$PMF_LANG["ad_menu_entry_aprove"] = "Setujui Materi";
$PMF_LANG["ad_menu_entry_edit"] = "Edit materi";
$PMF_LANG["ad_menu_categ_add"] = "Tambah Kategori";
$PMF_LANG["ad_menu_categ_edit"] = "Edit Kategori";
$PMF_LANG["ad_menu_news_add"] = "Tambah Berita";
$PMF_LANG["ad_menu_news_edit"] = "Edit Berita";
$PMF_LANG["ad_menu_open"] = "Pertanyaan Terbuka";
$PMF_LANG["ad_menu_stat"] = "Statistik";
$PMF_LANG["ad_menu_cookie"] = "Setel cookies";
$PMF_LANG["ad_menu_session"] = "Lihat Sesi";
$PMF_LANG["ad_menu_adminlog"] = "Lihat Log Admin";
$PMF_LANG["ad_menu_passwd"] = "Ganti Password";
$PMF_LANG["ad_menu_logout"] = "Keluar";
$PMF_LANG["ad_menu_startpage"] = "Halaman awal";

// Nachrichten
$PMF_LANG["ad_msg_identify"] = "Silakan masukkan identitas anda.";
$PMF_LANG["ad_msg_passmatch"] = "Kedua password harus <strong>sama persis</strong>!";
$PMF_LANG["ad_msg_savedsuc_1"] = "Profil";
$PMF_LANG["ad_msg_savedsuc_2"] = "berhasil disimpan.";
$PMF_LANG["ad_msg_mysqlerr"] = "Karena ada <strong>kesalahan database</strong>, profil tidak bisa disimpan.";
$PMF_LANG["ad_msg_noauth"] = "Anda tidak memiliki kewenangan.";

// Allgemein
$PMF_LANG["ad_gen_page"] = "Halaman";
$PMF_LANG["ad_gen_of"] = "dari";
$PMF_LANG["ad_gen_lastpage"] = "Halaman Sebelumnya";
$PMF_LANG["ad_gen_nextpage"] = "Halaman Selanjutnya";
$PMF_LANG["ad_gen_save"] = "Simpan";
$PMF_LANG["ad_gen_reset"] = "Reset";
$PMF_LANG["ad_gen_yes"] = "Ya";
$PMF_LANG["ad_gen_no"] = "Tidak";
$PMF_LANG["ad_gen_top"] = "Atas halaman";
$PMF_LANG["ad_gen_ncf"] = "Tidak ada kategori yang ditemukan!";
$PMF_LANG["ad_gen_delete"] = "Hapus";

// Benutzerverwaltung
$PMF_LANG["ad_user"] = "Pengaturan Pengguna";
$PMF_LANG["ad_user_username"] = "Pengguna Terdaftar";
$PMF_LANG["ad_user_rights"] = "Hak Akses";
$PMF_LANG["ad_user_edit"] = "edit";
$PMF_LANG["ad_user_delete"] = "hapus";
$PMF_LANG["ad_user_add"] = "Tambah Pengguna";
$PMF_LANG["ad_user_profou"] = "Profil pengguna";
$PMF_LANG["ad_user_name"] = "Nama";
$PMF_LANG["ad_user_password"] = "Password";
$PMF_LANG["ad_user_confirm"] = "Ulangi password";
$PMF_LANG["ad_user_rights"] = "Hak Akses";
$PMF_LANG["ad_user_del_1"] = "Pengguna";
$PMF_LANG["ad_user_del_2"] = "ingin dihapus?";
$PMF_LANG["ad_user_del_3"] = "Anda yakin?";
$PMF_LANG["ad_user_deleted"] = "Pengguna barhasil dihapus.";
$PMF_LANG["ad_user_checkall"] = "Pilih semua";

// Beitragsverwaltung
$PMF_LANG["ad_entry_aor"] = "Pengelolaan Materi";
$PMF_LANG["ad_entry_id"] = "ID";
$PMF_LANG["ad_entry_topic"] = "Topik";
$PMF_LANG["ad_entry_action"] = "Perintah";
$PMF_LANG["ad_entry_edit_1"] = "Edit Materi";
$PMF_LANG["ad_entry_edit_2"] = "";
$PMF_LANG["ad_entry_theme"] = "Pertanyaan";
$PMF_LANG["ad_entry_content"] = "Jawaban";
$PMF_LANG["ad_entry_keywords"] = "Kata Kunci";
$PMF_LANG["ad_entry_author"] = "Penulis";
$PMF_LANG["ad_entry_category"] = "Kategori";
$PMF_LANG["ad_entry_active"] = "Aktif?";
$PMF_LANG["ad_entry_date"] = "Tanggal";
$PMF_LANG["ad_entry_status"] = "Status der FAQ";
$PMF_LANG["ad_entry_changed"] = "Berubah?";
$PMF_LANG["ad_entry_changelog"] = "Catatan perubahan";
$PMF_LANG["ad_entry_commentby"] = "Komentar oleh";
$PMF_LANG["ad_entry_comment"] = "Komentar";
$PMF_LANG["ad_entry_save"] = "Simpan";
$PMF_LANG["ad_entry_delete"] = "hapus";
$PMF_LANG["ad_entry_delcom_1"] = "Anda yakin bahwa komentar pengguna";
$PMF_LANG["ad_entry_delcom_2"] = "akan dihapus?";
$PMF_LANG["ad_entry_commentdelsuc"] = "Komentar <strong>berhasil</strong> dihapus.";
$PMF_LANG["ad_entry_back"] = "Kembali ke artikel";
$PMF_LANG["ad_entry_commentdelfail"] = "Komentar <strong>tidak</strong> dihapus.";
$PMF_LANG["ad_entry_savedsuc"] = "Perubahan <strong>berhasil</strong> disimpan.";
$PMF_LANG["ad_entry_savedfail"] = "Sayangnya, ada <strong>kesalahan database</strong>.";
$PMF_LANG["ad_entry_del_1"] = "Anda yakin bahwa topik";
$PMF_LANG["ad_entry_del_2"] = "dalam";
$PMF_LANG["ad_entry_del_3"] = "akan dihapus?";
$PMF_LANG["ad_entry_delsuc"] = "Isu <strong>berhasil</strong> dihapus.";
$PMF_LANG["ad_entry_delfail"] = "Isu <strong>tidak</strong> dihapus!";
$PMF_LANG["ad_entry_back"] = "Kembali";


// Newsverwaltung
$PMF_LANG["ad_news_header"] = "Pengantar materi";
$PMF_LANG["ad_news_text"] = "Isi materi";
$PMF_LANG["ad_news_link_url"] = "Link";
$PMF_LANG["ad_news_link_title"] = "Judul link";
$PMF_LANG["ad_news_link_target"] = "Target link";
$PMF_LANG["ad_news_link_window"] = "Link membuka jendela baru";
$PMF_LANG["ad_news_link_faq"] = "Link terbuka pada jendela sama";
$PMF_LANG["ad_news_add"] = "Tambah Berita";
$PMF_LANG["ad_news_id"] = "#";
$PMF_LANG["ad_news_headline"] = "Kepala Berita";
$PMF_LANG["ad_news_date"] = "Tanggal";
$PMF_LANG["ad_news_action"] = "Perintah";
$PMF_LANG["ad_news_update"] = "perbarui";
$PMF_LANG["ad_news_delete"] = "hapus";
$PMF_LANG["ad_news_nodata"] = "Tidak ada data dalam database";
$PMF_LANG["ad_news_updatesuc"] = "Berita sudah diperbarui.";
$PMF_LANG["ad_news_del"] = "Anda yakin ingin menghapus materi berita ini?";
$PMF_LANG["ad_news_yesdelete"] = "ya, hapus!";
$PMF_LANG["ad_news_nodelete"] = "tidak!";
$PMF_LANG["ad_news_delsuc"] = "Materi berita sudah dihapus.";
$PMF_LANG["ad_news_updatenews"] = "Materi berita sudah diperbarui.";

// Kategorieverwaltung
$PMF_LANG["ad_categ_new"] = "Tambah kategori baru";
$PMF_LANG["ad_categ_catnum"] = "Nomor Kategori";
$PMF_LANG["ad_categ_subcatnum"] = "Nomor Subkategori";
$PMF_LANG["ad_categ_nya"] = "<em>belum tersedia!</em>";
$PMF_LANG["ad_categ_titel"] = "Judul Kategori";
$PMF_LANG["ad_categ_add"] = "Tambah Kategori";
$PMF_LANG["ad_categ_existing"] = "Kategori yang Ada";
$PMF_LANG["ad_categ_id"] = "#";
$PMF_LANG["ad_categ_categ"] = "Kategori";
$PMF_LANG["ad_categ_subcateg"] = "Subkategori";
$PMF_LANG["ad_categ_titel"] = "Judul kategori";
$PMF_LANG["ad_categ_action"] = "Perintah";
$PMF_LANG["ad_categ_update"] = "perbarui";
$PMF_LANG["ad_categ_delete"] = "hapus";
$PMF_LANG["ad_categ_updatecateg"] = "Perbarui Kategori";
$PMF_LANG["ad_categ_nodata"] = "Data tidak ditemukan dalam database";
$PMF_LANG["ad_categ_remark"] = "Mohon perhatikan bahwa jika anda menghapus kategori entri yang sudah ada akan tidak bisa ditampilkan untuk publik. Anda perlu memasukkan entri yang sudah ada tersebut ke kategori lain atau menghapus artikelnya.";
$PMF_LANG["ad_categ_edit_1"] = "Edit";
$PMF_LANG["ad_categ_edit_2"] = "Kategori";
$PMF_LANG["ad_categ_add"] = "tambah Kategori";
$PMF_LANG["ad_categ_added"] = "Kategori sudah ditambahkan.";
$PMF_LANG["ad_categ_updated"] = "Kategori sudah diperbarui.";
$PMF_LANG["ad_categ_del_yes"] = "ya, hapus!";
$PMF_LANG["ad_categ_del_no"] = "tidal!";
$PMF_LANG["ad_categ_deletesure"] = "Anda yakin ingin menghapus kategori ini?";
$PMF_LANG["ad_categ_deleted"] = "Kategori sudah dihapus.";

// Cookies
$PMF_LANG["ad_cookie_cookiesuc"] = "Ccookie <strong>berhasil</strong> disetel.";
$PMF_LANG["ad_cookie_already"] = "Sebelumnya cookie sudah disetel. Anda punya opsi berikut";
$PMF_LANG["ad_cookie_again"] = "Setel cookie lagi";
$PMF_LANG["ad_cookie_delete"] = "Hapus cookie";
$PMF_LANG["ad_cookie_no"] = "Saat ini belum ada cookie yang disetel. Dengan cookie anda bisa menyimpan info login, sehingga tidak perlu login berulang-ulang. Anda punya opsi berikut";
$PMF_LANG["ad_cookie_set"] = "Setel cookie";
$PMF_LANG["ad_cookie_deleted"] = "Cookie berhasil dihapus.";

// Adminlog
$PMF_LANG["ad_adminlog"] = "Log Admin";

// Passwd
$PMF_LANG["ad_passwd_cop"] = "Ganti Kata Sandi Anda";
$PMF_LANG["ad_passwd_old"] = "Kata Sandi Lama";
$PMF_LANG["ad_passwd_new"] = "Kata Sandi Baru";
$PMF_LANG["ad_passwd_con"] = "Ulangi Sandi Baru";
$PMF_LANG["ad_passwd_change"] = "Ganti Kata Sandi";
$PMF_LANG["ad_passwd_suc"] = "Kata Sandi Berhasil Diganti.";
$PMF_LANG["ad_passwd_remark"] = "<strong>PERHATIAN:</strong><br>Cookie harus disetel ulang!";
$PMF_LANG["ad_passwd_fail"] = "Kata sandi lama yang benar <strong>harus</strong> dimasukkan dan kata sandi baru harus diisi dua kali <strong>sama persis</strong>.";

// Adduser
$PMF_LANG["ad_adus_adduser"] = "Tambah pengguna";
$PMF_LANG["ad_adus_name"] = "Nama";
$PMF_LANG["ad_adus_password"] = "Kata sandi";
$PMF_LANG["ad_adus_add"] = "Tambah pengguna";
$PMF_LANG["ad_adus_suc"] = "Pengguna <strong>berhasil</strong> ditambahkan.";
$PMF_LANG["ad_adus_edit"] = "Edit profil";
$PMF_LANG["ad_adus_dberr"] = "<strong>database error!</strong>";
$PMF_LANG["ad_adus_exerr"] = "Nama pengguna <strong>sudah ada</strong>.";

// Sessions
$PMF_LANG["ad_sess_id"] = "ID";
$PMF_LANG["ad_sess_sid"] = "ID Sesi";
$PMF_LANG["ad_sess_ip"] = "IP";
$PMF_LANG["ad_sess_time"] = "Waktu";
$PMF_LANG["ad_sess_pageviews"] = "Halaman";
$PMF_LANG["ad_sess_search"] = "Cari";
$PMF_LANG["ad_sess_sfs"] = "Pencarian sesi";
$PMF_LANG["ad_sess_s_ip"] = "IP";
$PMF_LANG["ad_sess_s_minct"] = "min. perintah";
$PMF_LANG["ad_sess_s_date"] = "Tanggal";
$PMF_LANG["ad_sess_s_after"] = "setelah";
$PMF_LANG["ad_sess_s_before"] = "sebelum";
$PMF_LANG["ad_sess_s_search"] = "Cari";
$PMF_LANG["ad_sess_session"] = "Sesi";
$PMF_LANG["ad_sess_r"] = "Hasil pencarian";
$PMF_LANG["ad_sess_referer"] = "Rujukan";
$PMF_LANG["ad_sess_browser"] = "Peramban";
$PMF_LANG["ad_sess_ai_rubrik"] = "Kategori";
$PMF_LANG["ad_sess_ai_artikel"] = "Data";
$PMF_LANG["ad_sess_ai_sb"] = "Teks pencarian";
$PMF_LANG["ad_sess_ai_sid"] = "ID Sesi";
$PMF_LANG["ad_sess_back"] = "Kembali";

// Statistik
$PMF_LANG["ad_rs"] = "Statistik Penilaian";
$PMF_LANG["ad_rs_rating_1"] = "Penilaian";
$PMF_LANG["ad_rs_rating_2"] = "pengguna menampilkan";
$PMF_LANG["ad_rs_red"] = "Merah";
$PMF_LANG["ad_rs_green"] = "Hijau";
$PMF_LANG["ad_rs_altt"] = "dengan rata-rata lebih rendah dari 20%";
$PMF_LANG["ad_rs_ahtf"] = "dengan rata-rata lebih tinggi dari 80%";
$PMF_LANG["ad_rs_no"] = "Penilaian tidak tersedia";

// Auth
$PMF_LANG["ad_auth_insert"] = "Silakan masukkan nama pengguna dan kata sandi anda.";
$PMF_LANG["ad_auth_user"] = "Nama pengguna";
$PMF_LANG["ad_auth_passwd"] = "Kata sandi";
$PMF_LANG["ad_auth_ok"] = "OK";
$PMF_LANG["ad_auth_reset"] = "Reset";
$PMF_LANG["ad_auth_fail"] = "Nama pengguna atau kata sandi tidak benar.";
$PMF_LANG["ad_auth_sess"] = "ID sesi dilewatkan.";

// Added v0.8 - 24.05.2001 - Bastian - Admin
$PMF_LANG["ad_config_edit"] = "Edit konfirguasi";
$PMF_LANG["ad_config_save"] = "Simpan konfigurasi";
$PMF_LANG["ad_config_reset"] = "Reset";
$PMF_LANG["ad_config_saved"] = "Konfigurasi berhasil disimpan.";
$PMF_LANG["ad_menu_editconfig"] = "Edit konfigurasi";
$PMF_LANG["ad_att_none"] = "Lampiran tidak tersedia";
$PMF_LANG["ad_att_att"] = "Lampiran";
$PMF_LANG["ad_att_add"] = "Lampirkan berkas";
$PMF_LANG["ad_entryins_suc"] = "Data berhasil disimpan.";
$PMF_LANG["ad_entryins_fail"] = "Terjadi kesalahan.";
$PMF_LANG["ad_att_del"] = "Hapus";
$PMF_LANG["ad_att_nope"] = "Lampiran hanya bisa dimasukkan saat mengedit materi.";
$PMF_LANG["ad_att_delsuc"] = "Lampiran berhasil dihapus.";
$PMF_LANG["ad_att_delfail"] = "Terjadi kesalahan saat menghapus lampiran.";
$PMF_LANG["ad_entry_add"] = "Tambah Materi";

// Added v0.85 - 08.06.2001 - Bastian - Admin
$PMF_LANG["ad_csv_make"] = "Backup adalah simpanan cadangan lengkap isi database. Format yang digunakan adalah berkas transaksi SQL, yang bisa diimpor dengan alat bantu seperti phpMyAdmin atau program SQL commandline. Backup sebaiknya dilakukan secara rutin sebulan sekali.";
$PMF_LANG["ad_csv_link"] = "Unduh backup";
$PMF_LANG["ad_csv_head"] = "Buat backup";
$PMF_LANG["ad_att_addto"] = "Tambahkan lampiran pada masalah ini";
$PMF_LANG["ad_att_addto_2"] = "";
$PMF_LANG["ad_att_att"] = "Berkas";
$PMF_LANG["ad_att_butt"] = "OK";
$PMF_LANG["ad_att_suc"] = "Berkas sudah berhasil dilampirkan.";
$PMF_LANG["ad_att_fail"] = "Terjadi kesalahan saat melampirkan berkas.";
$PMF_LANG["ad_att_close"] = "Tutup jendela ini";

// Added v0.85 - 08.07.2001 - Bastian - Admin
$PMF_LANG["ad_csv_restore"] = "Dengan form ini anda bisa mengembalikan (restore) isi database anda, dengan backup yang dibuat pada phpmyfaq. Mohon dicatat bahwa data yang sudah ada akan hilang, digantikan dengan yang dari backup.";
$PMF_LANG["ad_csv_file"] = "Berkas";
$PMF_LANG["ad_csv_ok"] = "OK";
$PMF_LANG["ad_csv_linklog"] = "Unduh backup Log";
$PMF_LANG["ad_csv_linkdat"] = "Unduh backup Data";
$PMF_LANG["ad_csv_head2"] = "Restore";
$PMF_LANG["ad_csv_no"] = "Berkas ini sepertinya bukan merupakan backup dari phpmyfaq.";
$PMF_LANG["ad_csv_prepare"] = "Menyiapkan kueri database ...";
$PMF_LANG["ad_csv_process"] = "Melakukan kueri...";
$PMF_LANG["ad_csv_of"] = "dari";
$PMF_LANG["ad_csv_suc"] = "berhasil.";
$PMF_LANG["ad_csv_backup"] = "Backup";
$PMF_LANG["ad_csv_rest"] = "Restore backup";

// Added v0.8 - 25.05.2001 - Bastian - Admin
$PMF_LANG["ad_menu_backup"] = "Backup";
$PMF_LANG["ad_logout"] = "Sesi berhasil diakhiri.";
$PMF_LANG["ad_news_add"] = "Tambah berita";
$PMF_LANG["ad_news_edit"] = "Edit berita";
$PMF_LANG["ad_cookie"] = "Cookies";
$PMF_LANG["ad_sess_head"] = "Lihat sesi";

// Added v1.1 - 06.01.2002 - Bastian
$PMF_LANG["ad_menu_categ_edit"] = "Kategori";
$PMF_LANG["ad_menu_stat"] = "Statistik Penilaian";
$PMF_LANG["ad_kateg_add"] = "tambah Kategori utama";
$PMF_LANG["ad_kateg_rename"] = "Ganti nama";
$PMF_LANG["ad_adminlog_date"] = "Tanggal";
$PMF_LANG["ad_adminlog_user"] = "Pengguna";
$PMF_LANG["ad_adminlog_ip"] = "Alamat-IP";

$PMF_LANG["ad_stat_sess"] = "Sesi";
$PMF_LANG["ad_stat_days"] = "Hari";
$PMF_LANG["ad_stat_vis"] = "Sesi (Kunjungan)";
$PMF_LANG["ad_stat_vpd"] = "Kunjungan per Hari";
$PMF_LANG["ad_stat_fien"] = "Log Pertama";
$PMF_LANG["ad_stat_laen"] = "Log Terakhir";
$PMF_LANG["ad_stat_browse"] = "telusuri Sesi";
$PMF_LANG["ad_stat_ok"] = "OK";

$PMF_LANG["ad_sess_time"] = "Waktu";
$PMF_LANG["ad_sess_sid"] = "ID-Sesi";
$PMF_LANG["ad_sess_ip"] = "Alamat-IP";

$PMF_LANG["ad_ques_take"] = "Lihat materi dan edit";
$PMF_LANG["no_cats"] = "Kategori Tidak Ditemukan.";

// Added v1.1 - 17.01.2002 - Bastian
$PMF_LANG["ad_log_lger"] = "Nama pengguna atau kata sandi tidak benar.";
$PMF_LANG["ad_log_sess"] = "Sesi suda berakhir.";
$PMF_LANG["ad_log_edit"] = "Form \"Edit Pengguna\" untuk pengguna berikut: ";
$PMF_LANG["ad_log_crea"] = "Form \"Artikel baru\".";
$PMF_LANG["ad_log_crsa"] = "Entri baru sudah dibuat.";
$PMF_LANG["ad_log_ussa"] = "Perbarui data untuk pengguna berikut: ";
$PMF_LANG["ad_log_usde"] = "Pengguna berikut sudah dihapus: ";
$PMF_LANG["ad_log_beed"] = "Form Edit untuk pengguna berikut: ";
$PMF_LANG["ad_log_bede"] = "Entri berikut sudah dihapus: ";

$PMF_LANG["ad_start_visits"] = "Kunjungan";
$PMF_LANG["ad_start_articles"] = "Artikel";
$PMF_LANG["ad_start_comments"] = "Komentar";


// Added v1.1 - 30.01.2002 - Bastian
$PMF_LANG["ad_categ_paste"] = "paste";
$PMF_LANG["ad_categ_cut"] = "cut";
$PMF_LANG["ad_categ_copy"] = "copy";
$PMF_LANG["ad_categ_process"] = "Memproses kategori...";

// Added v1.1.4 - 07.05.2002 - Thorsten
$PMF_LANG["err_NotAuth"] = "<strong>Anda tidak memiliki kewenangan.</strong>";

// Added v1.2.3 - 29.11.2002 - Thorsten
$PMF_LANG["msgPreviusPage"] = "halaman sebelumnya";
$PMF_LANG["msgNextPage"] = "halaman selanjutnya";
$PMF_LANG["msgPageDoublePoint"] = "Halaman: ";
$PMF_LANG["msgMainCategory"] = "Kategori utama";

// Added v1.2.4 - 30.01.2003 - Thorsten
$PMF_LANG["ad_passwdsuc"] = "Kata sandi anda sudah diganti.";

// Added v1.3.0 - 04.03.2003 - Thorsten
$PMF_LANG["msgPDF"] = "Tampilkan sebagai PDF";
$PMF_LANG["ad_xml_head"] = "XML-Backup";
$PMF_LANG["ad_xml_hint"] = "Simpan semua data materi dalam satu berkas.";
$PMF_LANG["ad_xml_gen"] = "buat berkas XML";
$PMF_LANG["ad_entry_locale"] = "Bahasa";
$PMF_LANG["msgLanguageSubmit"] = "Pilih bahasa";

// Added v1.3.1 - 29.04.2003 - Thorsten
$PMF_LANG["ad_entry_preview"] = "Pratinjau";
$PMF_LANG["ad_attach_1"] = "Silakan pilih direktori untuk lampiran dalam konfigurasi pertama.";
$PMF_LANG["ad_attach_2"] = "Silakan pilih link untuk lampiran dalam konfigurasi pertama.";
$PMF_LANG["ad_attach_3"] = "Berkas attachment.php tidak bisa dibuka tanpa otentifikasi yang benar.";
$PMF_LANG["ad_attach_4"] = "Berkas yang ingin dilampirkan harus lebih kecil dari %s byte.";
$PMF_LANG["ad_menu_export"] = "Ekspor isi materi anda";
$PMF_LANG["ad_export_1"] = "Buat Pasokan-RSS pada";
$PMF_LANG["ad_export_2"] = ".";
$PMF_LANG["ad_export_file"] = "Error: Tidak bisa membuat berkas.";
$PMF_LANG["ad_export_news"] = "Pasokan-RSS Berita";
$PMF_LANG["ad_export_topten"] = "Pasokan-RSS 10 teratas";
$PMF_LANG["ad_export_latest"] = "Pasokan-RSS 5 data terbaru";
$PMF_LANG["ad_export_pdf"] = "Ekspor semua data ke PDF";
$PMF_LANG["ad_export_generate"] = "bangun Pasokan-RSS";

$PMF_LANG["rightsLanguage"]['add_user'] = "tambah pengguna";
$PMF_LANG["rightsLanguage"]['edit_user'] = "edit pengguna";
$PMF_LANG["rightsLanguage"]['delete_user'] = "hapus pengguna";
$PMF_LANG["rightsLanguage"]['add_faq'] = "tambah data";
$PMF_LANG["rightsLanguage"]['edit_faq'] = "edit data";
$PMF_LANG["rightsLanguage"]['delete_faq'] = "hapus data";
$PMF_LANG["rightsLanguage"]['viewlog'] = "lihat log";
$PMF_LANG["rightsLanguage"]['adminlog'] = "lihat log admin";
$PMF_LANG["rightsLanguage"]['delcomment'] = "hapus komentar";
$PMF_LANG["rightsLanguage"]['addnews'] = "tambah berita";
$PMF_LANG["rightsLanguage"]['editnews'] = "edit berita";
$PMF_LANG["rightsLanguage"]['delnews'] = "hapus berita";
$PMF_LANG["rightsLanguage"]['addcateg'] = "tambah kategori";
$PMF_LANG["rightsLanguage"]['editcateg'] = "edit kategori";
$PMF_LANG["rightsLanguage"]['delcateg'] = "hapus kategori";
$PMF_LANG["rightsLanguage"]['passwd'] = "ganti kata sandi";
$PMF_LANG["rightsLanguage"]['editconfig'] = "edit konfigurasi";
$PMF_LANG["rightsLanguage"]['addatt'] = "tambah lampiran";
$PMF_LANG["rightsLanguage"]['delatt'] = "hapus lampiran";
$PMF_LANG["rightsLanguage"]['backup'] = "buat backup";
$PMF_LANG["rightsLanguage"]['restore'] = "restore backup";
$PMF_LANG["rightsLanguage"]['delquestion'] = "hapus pertanyaan terbuka";
$PMF_LANG["rightsLanguage"]['changebtrevs'] = "edit revisi";

$PMF_LANG["msgAttachedFiles"] = "attached files";

// Added v1.3.3 - 27.05.2003 - Thorsten
$PMF_LANG["ad_user_action"] = "perintah";
$PMF_LANG["ad_entry_email"] = "Alamat email";
$PMF_LANG["ad_entry_allowComments"] = "Bolehkan komentar";
$PMF_LANG["msgWriteNoComment"] = "Anda tidak bisa mengirim komentar pada artikel ini";
$PMF_LANG["ad_user_realname"] = "Nama Lengkap";
$PMF_LANG["ad_export_generate_pdf"] = "buat berkas PDF";
$PMF_LANG["ad_export_full_faq"] = "Materi anda dalam format PDF: ";
$PMF_LANG["err_bannedIP"] = "Alamat IP anda sudah diblokir.";
$PMF_LANG["err_SaveQuestion"] = "Bagian yang harus diisi adalah <strong>nama anda</strong>, <strong>alamat email</strong>, <strong>pertanyaan anda</strong> dan, jika diminta, <strong>kode <a href=\"http://id.wikipedia.org/wiki/CAPTCHA\" title=\"Lebih lanjut tentang Captcha di Wikipedia\" target=\"_blank\">Captcha</a></strong>.<br><br><a href=\"javascript:history.back();\">mundur satu halaman</a><br><br>";

// added v1.3.4 - 23.07.2003 - Thorsten
$PMF_LANG["ad_entry_fontcolor"] = "Warna huruf: ";
$PMF_LANG["ad_entry_fontsize"] = "Ukuran huruf: ";

// added v1.4.0 - 2003-12-04 by Thorsten / Mathias
$LANG_CONF['main.language'] = array(0 => "select", 1 => "Berkas-Bahasa");
$LANG_CONF["main.languageDetection"] = array(0 => "checkbox", 1 => "Aktifkan negosiasi konten otomatis");
$LANG_CONF['main.titleFAQ'] = array(0 => "input", 1 => "Judul Materi");
$LANG_CONF['main.currentVersion'] = array(0 => "print", 1 => "Revisi Materi");
$LANG_CONF["main.metaDescription"] = array(0 => "input", 1 => "Keterangan Halaman");
$LANG_CONF["main.metaKeywords"] = array(0 => "input", 1 => "Kata Kunci untuk Mesin Pencari");
$LANG_CONF["main.metaPublisher"] = array(0 => "input", 1 => "Nama Penerbit");
$LANG_CONF['main.administrationMail'] = array(0 => "input", 1 => "Alamat Email Admin");
$LANG_CONF["main.contactInformations"] = array(0 => "area", 1 => "Informasi Kontak");
$LANG_CONF["main.send2friendText"] = array(0 => "area", 1 => "Teks untuk halaman send2friend");
$LANG_CONF['records.maxAttachmentSize'] = array(0 => "input", 1 => "ukuran maksimal untuk lampiran dalam Bytes (maks. %sByte)");
$LANG_CONF["records.disableAttachments"] = array(0 => "checkbox", 1 => "Buat Link ke lampiran di bawah entri?");
$LANG_CONF["main.enableUserTracking"] = array(0 => "checkbox", 1 => "gunakan Penelusuran?");
$LANG_CONF["main.enableAdminLog"] = array(0 => "checkbox", 1 => "gunakan Log Admin?");
$LANG_CONF["security.ipCheck"] = array(0 => "checkbox", 1 => "Apakah anda ingin alamat IP dicek saat memeriksa UIN dalam admin.php?");
$LANG_CONF["records.numberOfRecordsPerPage"] = array(0 => "input", 1 => "Jumlah topik yang ditampilkan per halaman");
$LANG_CONF["records.numberOfShownNewsEntries"] = array(0 => "input", 1 => "Jumlah artikel berita");
$LANG_CONF['security.bannedIPs'] = array(0 => "area", 1 => "Blokir IP ini");
$LANG_CONF["main.enableRewriteRules"] = array(0 => "checkbox", 1 => "Aktifkan dukungan mod_rewrite? (default: non-aktif)");
$LANG_CONF["ldap.ldapSupport"] = array(0 => "checkbox", 1 => "Aktifkan dukungan LDAP? (default: non-aktif)");
$LANG_CONF["main.referenceURL"] = array(0 => "input", 1 => "URL dasar untuk verifikasi link (mis.: http://www.situsanda.com/faq)");
$LANG_CONF["main.urlValidateInterval"] = array(0 => "input", 1 => "Interval antara verifikasi link AJAX (dalam detik)");
$LANG_CONF["records.enableVisibilityQuestions"] = array(0 => "checkbox", 1 => "Nonaktifkan link untuk membuat Pertanyaan Baru?");
$LANG_CONF['security.permLevel'] = array(0 => "select", 1 => "Level Hak Akses");

$PMF_LANG["ad_categ_new_main_cat"] = "sebagai kategori utama baru";
$PMF_LANG["ad_categ_paste_error"] = "Memidahkan kategori ini tidak dimungkinkan.";
$PMF_LANG["ad_categ_move"] = "pindahkan kategori";
$PMF_LANG["ad_categ_lang"] = "Bahasa";
$PMF_LANG["ad_categ_desc"] = "Keterangan";
$PMF_LANG["ad_categ_change"] = "Ganti dengan";

$PMF_LANG["lostPassword"] = "Lupa kata sandi? Klik di sini.";
$PMF_LANG["lostpwd_err_1"] = "Error: nama pengguna dan alamat e-mail tidak ditemukan.";
$PMF_LANG["lostpwd_err_2"] = "Error: entri tidak benar!";
$PMF_LANG["lostpwd_text_1"] = "Terima kasih atas permintaan informasi akun anda.";
$PMF_LANG["lostpwd_text_2"] = "Silakan buat kata sandi baru pada bagian admin.";
$PMF_LANG["lostpwd_mail_okay"] = "E-Mail sudah dikirim.";

$PMF_LANG["ad_xmlrpc_button"] = "Lihat nomor versi phpMyFAQ terbaru lewat layanan web";
$PMF_LANG["ad_xmlrpc_latest"] = "Versi terbaru sudah tersedia di";

// added v1.5.0 - 2005-07-31 by Thorsten
$PMF_LANG['ad_categ_select'] = 'Pilih bahasa kategori';

// added v1.5.1 - 2005-09-06 by Thorsten
$PMF_LANG['msgSitemap'] = 'Peta situs';

// added v1.5.2 - 2005-09-23 by Lars
$PMF_LANG['err_inactiveArticle'] = 'Entri ini sedang dalam revisi dan tidak bisa ditampilkan.';
$PMF_LANG['msgArticleCategories'] = 'Kategori untuk entri ini';

// added v1.6.0 - 2006-02-02 by Thorsten
$PMF_LANG['ad_entry_solution_id'] = 'ID Solusi Unik';
$PMF_LANG['ad_entry_faq_record'] = 'Materi';
$PMF_LANG['ad_entry_new_revision'] = 'Buat revisi baru?';
$PMF_LANG['ad_entry_record_administration'] = 'Pengelolaan materi';
$PMF_LANG['ad_entry_changelog'] = 'Changelog';
$PMF_LANG['ad_entry_revision'] = 'Revisi';
$PMF_LANG['ad_changerev'] = 'Pilih Revisi';
$PMF_LANG['msgCaptcha'] = "Silakan ketik huruf dan angka yang anda lihat di bawah ini";
$PMF_LANG['msgSelectCategories'] = 'Cari di ...';
$PMF_LANG['msgAllCategories'] = '... semua kategori';
$PMF_LANG['ad_you_should_update'] = 'Versi phpMyFAQ anda sudah lama. Kami menyarankan anda memperbaruinya ke versi terbaru yang tersedia.';
$PMF_LANG['msgAdvancedSearch'] = 'Pencarian lanjutan';

// added v1.6.1 - 2006-04-25 by Matteo?and?Thorsten
$PMF_LANG['spamControlCenter'] = 'Pusat Kendali Spam';
$LANG_CONF["spam.enableSafeEmail"] = array(0 => "checkbox", 1 => "Tampilkan alamat email dengan cara yang aman (default: aktif).");
$LANG_CONF["spam.checkBannedWords"] = array(0 => "checkbox", 1 => "Periksa form atas kata-kata terlarang (default: aktif).");
$LANG_CONF["spam.enableCaptchaCode"] = array(0 => "checkbox", 1 => "Gunakan kode captcha pada form publik (default: aktif).");
$PMF_LANG['ad_session_expiring'] = 'Sesi anda akan berakhir dalam %d menit: anda ingin melanjutkan bekerja?';

// added v1.6.2 - 2006-06-13 by Matteo
$PMF_LANG['ad_stat_management'] = 'Pengelolaan Sesi';
$PMF_LANG['ad_stat_choose'] = 'Pilih Bulan';
$PMF_LANG['ad_stat_delete'] = 'Segera hapus sesi yang dipilih';

// added v2.0.0 - 2005-09-15 by Thorsten and by Minoru TODA
$PMF_LANG['ad_menu_glossary'] = 'Daftar Istilah';
$PMF_LANG['ad_glossary_add'] = 'Tambah entri istilah';
$PMF_LANG['ad_glossary_edit'] = 'Edit entri istilah';
$PMF_LANG['ad_glossary_item'] = 'Istilah';
$PMF_LANG['ad_glossary_definition'] = 'Pengertian';
$PMF_LANG['ad_glossary_save'] = 'Simpan entri';
$PMF_LANG['ad_glossary_save_success'] = 'Entri istilah berhasil disimpan!';
$PMF_LANG['ad_glossary_save_error'] = 'Entri istilah tidak bisa disimpan karena terjadi kesalahan.';
$PMF_LANG['ad_glossary_update_success'] = 'Entri istilah berhasil diperbarui!';
$PMF_LANG['ad_glossary_update_error'] = 'Entri istilah tidak bisa diperbarui karena terjadi kesalahan.';
$PMF_LANG['ad_glossary_delete'] = 'Hapus entri';
$PMF_LANG['ad_glossary_delete_success'] = 'Entri istilah berhasil dihapus!';
$PMF_LANG['ad_glossary_delete_error'] = 'Entri istilah tidak bisa dihapus karena terjadi kesalahan.';
$PMF_LANG['ad_linkcheck_noReferenceURL'] = 'Verifikasi link otomatis tidak diaktifkan (URL dasar untuk verifikasi link belum disetel)';
$PMF_LANG['ad_linkcheck_noAllowUrlOpen'] = 'Verifikasi link otomatis tidak diaktifkan (opsi allow_url_fopen pada PHP tidak diaktifkan)';
$PMF_LANG['ad_linkcheck_checkResult'] = 'hasil Verifikasi link otomatis';
$PMF_LANG['ad_linkcheck_checkSuccess'] = 'OK';
$PMF_LANG['ad_linkcheck_checkFailed'] = 'Gagal';
$PMF_LANG['ad_linkcheck_failReason'] = 'Alasan gagal:';
$PMF_LANG['ad_linkcheck_noLinksFound'] = 'Tidak ada URL yang kompitabel dengan fitur verifikasi link yang ada.';
$PMF_LANG['ad_linkcheck_searchbadonly'] = 'Hanya dengan link yang tidak benar';
$PMF_LANG['ad_linkcheck_infoReason'] = 'Informasi Tambahan:';
$PMF_LANG['ad_linkcheck_openurl_infoprefix'] = 'Ditemukan dalam pengujian <strong>%s</strong>: ';
$PMF_LANG['ad_linkcheck_openurl_notready'] = 'LinkVerifier belum siap.';
$PMF_LANG['ad_linkcheck_openurl_maxredirect'] = 'Melebihi pengalihan maksimal <strong>%d</strong>.';
$PMF_LANG['ad_linkcheck_openurl_urlisblank'] = 'URL tersebut kosong.';
$PMF_LANG['ad_linkcheck_openurl_tooslow'] = 'Host <strong>%s</strong> lambat atau tidak merespon.';
$PMF_LANG['ad_linkcheck_openurl_nodns'] = 'Resolusi DNS untuk host <strong>%s</strong> lambat atau gagal karena masalah DNS, bisa lokal atau remote.';
$PMF_LANG['ad_linkcheck_openurl_redirected'] = 'URL dialihkan ke <strong>%s</strong>.';
$PMF_LANG['ad_linkcheck_openurl_ambiguous'] = 'Diterima status HTTP yang ambigu <strong>%s</strong>.';
$PMF_LANG['ad_linkcheck_openurl_not_allowed'] = 'Metode <em>HEAD</em> tidak didukung oleh host <strong>%s</strong>, metode yang didukung: <strong>%s</strong>.';
$PMF_LANG['ad_linkcheck_openurl_not_found'] = 'Halaman tidak ditemukan dalam host <strong>%s</strong>.';
$PMF_LANG['ad_linkcheck_protocol_unsupported'] = 'Protokol %s tidak didukung oleh verifikasi link otomatis.';
$PMF_LANG['msgNewQuestionVisible'] = 'Pertanyaan akan ditinjau dulu sebelum diterbitkan.';
$PMF_LANG['msgQuestionsWaiting'] = 'Menunggu aktivasi oleh pengelola: ';
$PMF_LANG['ad_entry_visibility'] = 'Terbitkan?';

// added v2.0.0 - 2006-01-02 by Lars
$PMF_LANG['ad_user_error_password'] = "Silakan masukkan kata sandi. ";
$PMF_LANG['ad_user_error_passwordsDontMatch'] = "Kata sandi tidak cocok. ";
$PMF_LANG['ad_user_error_loginInvalid'] = "Nama pengguna yang dimaksud tidak benar.";
$PMF_LANG['ad_user_error_noEmail'] = "Silakan masukkan alamat email yang benar. ";
$PMF_LANG['ad_user_error_noRealName'] = "Silakan masukkan nama lengkap anda. ";
$PMF_LANG['ad_user_error_delete'] = "Akun pengguna tidak bisa dihapus. ";
$PMF_LANG['ad_user_error_noId'] = "Tidak ada ID yang dimasukkan. ";
$PMF_LANG['ad_user_error_protectedAccount'] = "Akun pengguna diproteksi. ";
$PMF_LANG['ad_user_deleteUser'] = "Hapus Pengguna";
$PMF_LANG['ad_user_status'] = "Status";
$PMF_LANG['ad_user_lastModified'] = "edit terakhir";
$PMF_LANG['ad_gen_cancel'] = "Batalkan";
$PMF_LANG["rightsLanguage"]['addglossary'] = "tambah entri istilah";
$PMF_LANG["rightsLanguage"]['editglossary'] = "edit entri istilah";
$PMF_LANG["rightsLanguage"]['delglossary'] = "hapus entri istilah";
$PMF_LANG["ad_menu_group_administration"] = "Grup";
$PMF_LANG['ad_user_loggedin'] = 'Login sebagai';

$PMF_LANG['ad_group_details'] = "Detail Grup";
$PMF_LANG['ad_group_add'] = "Tambah Grup";
$PMF_LANG['ad_group_add_link'] = "Tambah Grup";
$PMF_LANG['ad_group_name'] = "Nama";
$PMF_LANG['ad_group_description'] = "Keterangan";
$PMF_LANG['ad_group_autoJoin'] = "Gabung-otomatis";
$PMF_LANG['ad_group_suc'] = "Grup <strong>berhasil</strong> ditambahkan.";
$PMF_LANG['ad_group_error_noName'] = "Silakan masukkan nama grup. ";
$PMF_LANG['ad_group_error_delete'] = "Grup tidak bisa dihapus. ";
$PMF_LANG['ad_group_deleted'] = "Grup berhasil dihapus.";
$PMF_LANG['ad_group_deleteGroup'] = "Hapus Grup";
$PMF_LANG['ad_group_deleteQuestion'] = "Anda yakin ingin menghapus grup ini?";
$PMF_LANG['ad_user_uncheckall'] = "Tidak Pilih Semua";
$PMF_LANG['ad_group_membership'] = "Keanggotaan Grup";
$PMF_LANG['ad_group_members'] = "Anggota";
$PMF_LANG['ad_group_addMember'] = "+";
$PMF_LANG['ad_group_removeMember'] = "-";

// added v2.0.0 - 2006-07-20 by Matteo
$PMF_LANG['ad_export_which_cat'] = 'Batas jumlah data materi yang akan diekspor (tidak wajib)';
$PMF_LANG['ad_export_cat_downwards'] = 'Downwards?';
$PMF_LANG['ad_export_type'] = 'Format ekspor';
$PMF_LANG['ad_export_type_choose'] = 'Pilih salah satu format yang didukung:';
$PMF_LANG['ad_export_download_view'] = 'Unduh atau tampilkan saja?';
$PMF_LANG['ad_export_download'] = 'unduh';
$PMF_LANG['ad_export_view'] = 'tampilkan saja';
$PMF_LANG['ad_export_gen_xhtml'] = 'Buat berkas XHTML';
$PMF_LANG['ad_export_gen_docbook'] = 'Buat berkas Docbook';

// added v2.0.0 - 2006-07-22 by Matteo
$PMF_LANG['ad_news_data'] = 'Data berita';
$PMF_LANG['ad_news_author_name'] = 'Nama penulis:';
$PMF_LANG['ad_news_author_email'] = 'Email penulis:';
$PMF_LANG['ad_news_set_active'] = 'Aktifkan';
$PMF_LANG['ad_news_allowComments'] = 'Bolehkan komentar:';
$PMF_LANG['ad_news_expiration_window'] = 'Masa berlaku berita (tidak wajib)';
$PMF_LANG['ad_news_from'] = 'Dari:';
$PMF_LANG['ad_news_to'] = 'Sampai:';
$PMF_LANG['ad_news_insertfail'] = 'Terjadi kesalahan saat menyisipkan entri berita ke dalam database.';
$PMF_LANG['ad_news_updatefail'] = 'terjadi kesalahan saat memperbarui entri berita dalam database.';
$PMF_LANG['newsShowCurrent'] = 'Tampilkan berita yang sudah ada.';
$PMF_LANG['newsShowArchive'] = 'Arsip berita';
$PMF_LANG['newsArchive'] = ' Arsip berita';
$PMF_LANG['newsWriteComment'] = 'komentar atas artikel ini';
$PMF_LANG['newsCommentDate'] = 'Pada: ';

// added v2.0.0 - 2006-07-29 by Matteo & Thorsten
$PMF_LANG['ad_record_expiration_window'] = 'Masa berlaku (tidak wajib)';
$PMF_LANG['admin_mainmenu_home'] = 'Panel';
$PMF_LANG['admin_mainmenu_users'] = 'Pengguna';
$PMF_LANG['admin_mainmenu_content'] = 'Konten';
$PMF_LANG['admin_mainmenu_statistics'] = 'Statistik';
$PMF_LANG['admin_mainmenu_exports'] = 'Ekspor';
$PMF_LANG['admin_mainmenu_backup'] = 'Backup';
$PMF_LANG['admin_mainmenu_configuration'] = 'Konfigurasi';
$PMF_LANG['admin_mainmenu_logout'] = 'Keluar';

// added v2.0.0 - 2006-08-15 by Thorsten and Matteo
$PMF_LANG["ad_categ_owner"] = 'Pemilik kategori';
$PMF_LANG['adminSection'] = 'Administrasi';
$PMF_LANG['err_expiredArticle'] = 'Masa berlaku entri ini sudah berakhir sehingga tidak bisa ditampilkan';
$PMF_LANG['err_expiredNews'] = 'Masa berlaku berita ini sudah berakhir sehingga tidak bisa ditampilkan';
$PMF_LANG['err_inactiveNews'] = 'Berita ini sedang direvisi sehingga tidak bisa ditampilkan';
$PMF_LANG['msgSearchOnAllLanguages'] = 'Cari di semua bahasa:';
$PMF_LANG['ad_entry_tags'] = 'Tag';
$PMF_LANG['msg_tags'] = 'Tag';

// added v2.0.0 - 2006-09-03 by Matteo
$PMF_LANG['ad_linkcheck_feedback_url-batch1'] = 'Memeriksa...';
$PMF_LANG['ad_linkcheck_feedback_url-batch2'] = 'Memeriksa...';
$PMF_LANG['ad_linkcheck_feedback_url-batch3'] = 'Memeriksa...';
$PMF_LANG['ad_linkcheck_feedback_url-checking'] = 'Memeriksa...';
$PMF_LANG['ad_linkcheck_feedback_url-disabled'] = 'Non-aktif';
$PMF_LANG['ad_linkcheck_feedback_url-linkbad'] = 'Link Tidak Benar';
$PMF_LANG['ad_linkcheck_feedback_url-linkok'] = 'Link OK';
$PMF_LANG['ad_linkcheck_feedback_url-noaccess'] = 'Tidak ada Akses';
$PMF_LANG['ad_linkcheck_feedback_url-noajax'] = 'Tidak ada AJAX';
$PMF_LANG['ad_linkcheck_feedback_url-nolinks'] = 'Tidak ada Link';
$PMF_LANG['ad_linkcheck_feedback_url-noscript'] = 'Tidak ada Script';

// added v2.0.0 - 2006-09-02 by Thomas
$PMF_LANG['msg_related_articles'] = 'Entri terkait';
$LANG_CONF['records.numberOfRelatedArticles'] = array(0 => "input", 1 => "Jumlah entri terkait");

// added v2.0.0 - 2006-09-09 by Rudi
$PMF_LANG['ad_categ_trans_1'] = 'Terjemahkan';
$PMF_LANG['ad_categ_trans_2'] = 'Kategori';
$PMF_LANG['ad_categ_translatecateg'] = 'Terjemahkan Kategori';
$PMF_LANG['ad_categ_translate'] = 'Terjemahkan';
$PMF_LANG['ad_categ_transalready'] = 'Sudah diterjemahkan dalam: ';
$PMF_LANG["ad_categ_deletealllang"] = 'Hapus di semua bahasa?';
$PMF_LANG["ad_categ_deletethislang"] = 'Hapus dalam bahasa ini saja?';
$PMF_LANG["ad_categ_translated"] = "Kategori sudah diterjemahkan.";

// added v2.0.0 - 2006-09-21 by Rudi
$PMF_LANG["ad_categ_show"] = "Ikhtisar";
$PMF_LANG['ad_menu_categ_structure'] = "Ikhtisar Kategori termasuk bahasanya";

// added v2.0.0 - 2006-09-26 by Thorsten
$PMF_LANG['ad_entry_userpermission'] = 'Hak Akses Pengguna:';
$PMF_LANG['ad_entry_grouppermission'] = 'Hak Akses Grup:';
$PMF_LANG['ad_entry_all_users'] = 'Akses untuk semua pengguna';
$PMF_LANG['ad_entry_restricted_users'] = 'Batasi hanya untuk';
$PMF_LANG['ad_entry_all_groups'] = 'Akses untuk semua grup';
$PMF_LANG['ad_entry_restricted_groups'] = 'Batasi hanya untuk';
$PMF_LANG['ad_session_expiration'] = 'Sisa waktu sebelum sesi berakhir';
$PMF_LANG['ad_user_active'] = 'aktif';
$PMF_LANG['ad_user_blocked'] = 'diblokir';
$PMF_LANG['ad_user_protected'] = 'diproteksi';

// added v2.0.0 - 2006-10-07 by Matteo
$PMF_LANG['ad_entry_intlink'] = 'Pilih data materi yang ingin disisipkan sebagai link...';

//added 2.0.0 - 2006-10-10 by Rudi
$PMF_LANG["ad_categ_paste2"] = "Paste after";
$PMF_LANG["ad_categ_remark_move"] = "The exchange of 2 categories is only possible at the same level.";
$PMF_LANG["ad_categ_remark_overview"] = "The correct order of categories will be shown, if all categories are defined for the actual language (first column).";

// added v2.0.0 - 2006-10-15 by Matteo
$PMF_LANG['msgUsersOnline'] = '%d tamu dan %d anggota';
$PMF_LANG['ad_adminlog_del_older_30d'] = 'Delete immediately logs older than 30 days';
$PMF_LANG['ad_adminlog_delete_success'] = 'Older logs successfully deleted.';
$PMF_LANG['ad_adminlog_delete_failure'] = 'No logs deleted: an error occurred performing the request.';

// added 2.0.0 - 2006-11-19 by Thorsten
$PMF_LANG['opensearch_plugin_install'] = 'tambahkan plugin pencarian';
$PMF_LANG['ad_quicklinks'] = 'Quicklink';
$PMF_LANG['ad_quick_category'] = 'Tambah kategori baru';
$PMF_LANG['ad_quick_record'] = 'Tambah materi baru';
$PMF_LANG['ad_quick_user'] = 'Tambah pengguna baru';
$PMF_LANG['ad_quick_group'] = 'Tambah pengguna baru';

// added v2.0.0 - 2006-12-30 by Matteo
$PMF_LANG['msgNewTranslationHeader'] = 'Usulan terjemahan';
$PMF_LANG['msgNewTranslationAddon'] = 'Usulan anda tidak langsung akan ditampilkan, tetapi perlu ditinjau dulu oleh pengelola. Bagian yang harus diisi adalah: <strong>Nama Anda</strong>, <strong>Alamat Email</strong>, <strong>Terjemahan Pengantar</strong> dan <strong>Terjemahan Isi Materi</strong>. ';
$PMF_LANG['msgNewTransSourcePane'] = 'Panel Sumber';
$PMF_LANG['msgNewTranslationPane'] = 'Panel Terjemahan';
$PMF_LANG['msgNewTranslationName'] = "Nama Anda";
$PMF_LANG['msgNewTranslationMail'] = "Alamat Email";
$PMF_LANG['msgNewTranslationKeywords'] = "kata Kunci";
$PMF_LANG['msgNewTranslationSubmit'] = 'Kirim Usulan anda';
$PMF_LANG['msgTranslate'] = 'Usulkan terjemahan untuk';
$PMF_LANG['msgTranslateSubmit'] = 'Mulai penerjemahan...';
$PMF_LANG['msgNewTranslationThanks'] = "Terima kasih atas kontribusi anda!";

// added v2.0.0 - 2007-02-27 by Matteo
$PMF_LANG["rightsLanguage"]['addgroup'] = "tambah akun grup";
$PMF_LANG["rightsLanguage"]['editgroup'] = "edit akun grup";
$PMF_LANG["rightsLanguage"]['delgroup'] = "hapus akun grup";

// added v2.0.0 - 2007-02-27 by Thorsten
$PMF_LANG['ad_news_link_parent'] = 'Link membuka di jendela yang sama';

// added v2.0.0 - 2007-03-04 by Thorsten
$PMF_LANG['ad_menu_comments'] = 'Komentar';
$PMF_LANG['ad_comment_administration'] = 'Pengelolaan komentar';
$PMF_LANG['ad_comment_faqs'] = 'Komentar pada materi:';
$PMF_LANG['ad_comment_news'] = 'Komentar pada berita:';
$PMF_LANG['ad_groups'] = 'Grup';

// added v2.0.0 - 2007-03-10 by Thorsten
$LANG_CONF['records.orderby'] = array(0 => 'select', 1 => 'Pengurutan data (menurut properti)');
$LANG_CONF['records.sortby'] = array(0 => 'select', 1 => 'Pengurutan data (biasa atau terbalik)');
$PMF_LANG['ad_conf_order_id'] = 'ID (default)';
$PMF_LANG['ad_conf_order_thema'] = 'Judul';
$PMF_LANG['ad_conf_order_visits'] = 'Jumlah pengunjung';
$PMF_LANG['ad_conf_order_updated'] = 'Tanggal';
$PMF_LANG['ad_conf_order_author'] = 'Penulis';
$PMF_LANG['ad_conf_desc'] = 'terbalik';
$PMF_LANG['ad_conf_asc'] = 'biasa';
$PMF_LANG['mainControlCenter'] = 'Konfigurasi utama';
$PMF_LANG['recordsControlCenter'] = 'Konfigurasi konten materi';

// added v2.0.0 - 2007-03-29 by Thorsten
$LANG_CONF['records.defaultActivation'] = array(0 => "checkbox", 1 => "Aktifkan data baru (default: non-aktif)");
$LANG_CONF['records.defaultAllowComments'] = array(0 => "checkbox", 1 => "Bolehkan komentar atas data baru (default: tidak-boleh)");

// added v2.0.0 - 2007-04-04 by Thorsten
$PMF_LANG['msgAllCatArticles'] = 'Data dalam kategori ini';
$PMF_LANG['msgTagSearch'] = 'Entri dengan tag';
$PMF_LANG['ad_pmf_info'] = 'Informasi phpMyFAQ';
$PMF_LANG['ad_online_info'] = 'Periksa versi secara online';
$PMF_LANG['ad_system_info'] = 'Informasi Sistem';

// added 2.5.0-alpha - 2008-01-25 by Elger
$PMF_LANG['msgRegisterUser'] = 'Registrasi?';
$PMF_LANG["ad_user_loginname"] = 'Nama login:';
$PMF_LANG['errorRegistration'] = 'Bagian ini harus diisi!';
$PMF_LANG['submitRegister'] = 'Daftar';
$PMF_LANG['msgUserData'] = 'Informasi pengguna yang dibutuhkan dalam pendaftaran';
$PMF_LANG['captchaError'] = 'Silakan masukkan kode captcha yang benar!';
$PMF_LANG['msgRegError'] = 'Ditemukan kesalahan berikut. Mohon perbaiki:';
$PMF_LANG['successMessage'] = 'Pendaftaran anda berhasil. Anda akan segera menerima email konfirmasi yang berisi data anda!';
$PMF_LANG['msgRegThankYou'] = 'Terima kasih atas pendaftaran anda';
$PMF_LANG['emailRegSubject'] = 'Registrasi [%sitename%]: pengguna baru';

// added 2.5.0-alpha2 - 2009-01-24 by Thorsten
$PMF_LANG['msgMostPopularSearches'] = 'Pencarian yang paling populer adalah:';
$LANG_CONF['main.enableWysiwygEditor'] = array(0 => "checkbox", 1 => "Aktifkan editor WYSIWYG yang terbundel (default: aktif)");

// added 2.5.0-beta - 2009-03-30 by Anatoliy
$PMF_LANG['ad_menu_searchstats'] = 'Statistik Pencarian';
$PMF_LANG['ad_searchstats_search_term'] = 'Kata Kunci';
$PMF_LANG['ad_searchstats_search_term_count'] = 'Jumlah';
$PMF_LANG['ad_searchstats_search_term_lang'] = 'Bahasa';
$PMF_LANG['ad_searchstats_search_term_percentage'] = 'Persentase';

// added 2.5.0-beta - 2009-03-31 by Anatoliy
$PMF_LANG['ad_record_sticky'] = 'Sticky';
$PMF_LANG['ad_entry_sticky'] = 'Sticky';
$PMF_LANG['stickyRecordsHeader'] = 'Artikel Pilihan';

// added 2.5.0-beta - 2009-04-01 by Anatoliy
$PMF_LANG['ad_menu_stopwordsconfig'] = 'Kata Terlarang';
$PMF_LANG['ad_config_stopword_input'] = 'Tambah kata terlarang baru';

// added 2.5.0-beta - 2009-04-06 by Anatoliy
$PMF_LANG['msgSendMailDespiteEverything'] = 'Tidak, saat ini belum ada jawaban yang cocok (akan dikirim lewat email)';
$PMF_LANG['msgSendMailIfNothingIsFound'] = 'Apakah jawaban yang diinginkan sudah ada pada hasil di atas?';

// added 2.5.0-RC - 2009-05-11 by Anatoliy & Thorsten
$PMF_LANG['msgChooseLanguageToTranslate'] = 'Silakan pilih bahasa untuk terjemahan';
$PMF_LANG['msgLangDirIsntWritable'] = 'Direktori terjemahan tidak bisa ditulisi';
$PMF_LANG['ad_menu_translations'] = 'Antarmuka terjemahan';
$PMF_LANG['ad_start_notactive'] = 'Menunggu aktivasi';

// added 2.5.0-RC - 2009-05-20 by Anatoliy
$PMF_LANG['msgTransToolAddNewTranslation'] = 'Tambah terjemahan baru';
$PMF_LANG['msgTransToolLanguage'] = 'Bahasa';
$PMF_LANG['msgTransToolActions'] = 'Perintah';
$PMF_LANG['msgTransToolWritable'] = 'Bisa ditulisi';
$PMF_LANG['msgEdit'] = 'Edit';
$PMF_LANG['msgDelete'] = 'Hapus';
$PMF_LANG['msgYes'] = 'ya';
$PMF_LANG['msgNo'] = 'tidak';
$PMF_LANG['msgTransToolSureDeleteFile'] = 'Anda yakin ingin menghapus berkas bahasa ini?';
$PMF_LANG['msgTransToolFileRemoved'] = 'Berkas bahasa berhasil dihapus';
$PMF_LANG['msgTransToolErrorRemovingFile'] = 'Terjadi kesalahan dalam menghapus berkas bahasa';
$PMF_LANG['msgVariable'] = 'Variabel';
$PMF_LANG['msgCancel'] = 'Batalkan';
$PMF_LANG['msgSave'] = 'Simpan';
$PMF_LANG['msgSaving3Dots'] = 'menyimpan...';
$PMF_LANG['msgRemoving3Dots'] = 'menghapus ...';
$PMF_LANG['msgTransToolFileSaved'] = 'Berkas bahasa berhasil disimpan';
$PMF_LANG['msgTransToolErrorSavingFile'] = 'Ada kesalahan saat menyimpan berkas bahasa';
$PMF_LANG['msgLanguage'] = 'Bahasa';
$PMF_LANG['msgTransToolLanguageCharset'] = 'Charset bahasa';
$PMF_LANG['msgTransToolLanguageDir'] = 'Arah bahasa';
$PMF_LANG['msgTransToolLanguageDesc'] = 'Keterangan bahasa';
$PMF_LANG['msgAuthor'] = 'Penulis';
$PMF_LANG['msgTransToolAddAuthor'] = 'Tambah penulis';
$PMF_LANG['msgTransToolCreateTranslation'] = 'Buat terjemahan';
$PMF_LANG['msgTransToolTransCreated'] = 'Terjemahan baru berhasil dibuat';
$PMF_LANG['msgTransToolCouldntCreateTrans'] = 'Tidak bisa membuat terjemahan baru';
$PMF_LANG['msgAdding3Dots'] = 'menambahkan ...';
$PMF_LANG['msgTransToolSendToTeam'] = 'Kirim ke Tim phpMyFAQ';
$PMF_LANG['msgSending3Dots'] = 'mengirim ...';
$PMF_LANG['msgTransToolFileSent'] = 'Berkas bahasa berhasil dikirim ke Tim phpMyFAQ. Terima kasih banyak atas kontribusi anda.';
$PMF_LANG['msgTransToolErrorSendingFile'] = 'terjadi kesalahan saat mengirim berkas bahasa';
$PMF_LANG['msgTransToolPercent'] = 'Persentase';

// added 2.5.0-RC3 - 2009-06-23 by Anatoliy
$LANG_CONF['records.attachmentsPath'] = array(0 => "input", 1 => "Lokasi dimana lampiran akan disimpan.<br><small>Lokasi relatif berarti folder dalam web root</small>");

// added 2.5.0-RC3 - 2009-06-24 by Anatoliy
$PMF_LANG['msgAttachmentNotFound'] = "berkas yang ingin anda unduh tidak ditemukan dalam server ini";
$PMF_LANG['ad_sess_noentry'] = "Tidak ada entri";
