<?php
defined('WEKIT_VERSION') or exit(403);
/**
 * 全局产品级应用配置
 */
return array(
	'components' => array('resource' => 'CONF:components.php'),
	
	/**=====配置开始于此=====**/
	'web-apps' => array(
		'phpwind' => array(
			'root-path' => 'APPS:bbs',
			'modules' => array(
				'pattern' => array(
					'controller-path' => 'APPS:{m}.controller',
					'template-path' => 'TPL:{m}',
					'compile-path' => 'DATA:compile.template',
				),
				'default' => array(
					'controller-path' => 'APPS:bbs.controller', 
					'controller-suffix' => 'Controller', 
					'error-handler' => 'LIB:base.PwErrorController', 
					'template-path' => 'TPL:bbs',
					'compile-path' => 'DATA:compile.template.bbs',
					'theme-package' => 'THEMES:'
				),
				'admin' => array(
					'controller-path' => 'APPS:bbs.controller', 
					'controller-suffix' => 'Controller', 
					'error-handler' => 'LIB:base.PwErrorController', 
					'template-path' => 'TPL:bbs',
					'compile-path' => 'DATA:compile.template.bbs',
					'theme-package' => 'THEMES:'
				),
				'album' => array(
					'controller-path' => 'SRC:extensions.album.controller',
					'template-path' => 'SRC:extensions.album.template',
					'compile-path' => 'DATA:compile.template.album'
				)
			),
		), 
		
		'install' => array(
			'root-path' => 'APPS:install', 
			'modules' => array(
				'default' => array(
					'controller-path' => 'INSTALL:controller', 
					'controller-suffix' => 'Controller',
					'template-path' => 'TPL:install', 
					'compile-path' => 'DATA:compile.template.install',
					'error-handler' => 'INSTALL:controller.MessageController',
					'theme-package' => 'THEMES:'
				),
			),
		),
		
		'admin' => array(
			'root-path' => 'APPS:admin', 
			'modules' => array(
				'pattern' => array(
					'controller-path' => 'APPS:{m}.admin',
					'template-path' => 'TPL:{m}.admin',
					'compile-path' => 'DATA:compile.template'
				),
				'default' => array(
					'controller-path' => 'ADMIN:controller', 
					'controller-suffix' => 'Controller',
					'error-handler' => 'ADMIN:controller.MessageController', 
					'template-path' => 'TPL:admin', 
					'compile-path' => 'DATA:compile.template.admin',
					'theme-package' => 'THEMES:'
				),
				'album' => array(
					'controller-path' => 'SRC:extensions.album.admin',
					'template-path' => 'SRC:extensions.album.template.admin',
					'compile-path' => 'DATA:compile.template.album'
				)
			),
		),
	),
);

/**=====配置结束于此=====**/

