<?php
defined('WEKIT_VERSION') or exit(403);
/**
 * 组件配置文件
 * 
 * @author Qiong Wu <papa0924@gmail.com> 2010-11-2
 * @link http://www.phpwind.com
 * @copyright Copyright &copy; 2003-2010 phpwind.com
 * @license
 */
return array(
	'pwWidget' => array(
		'path' => 'LIB:engine.component.PwWidget',
		'scope' => 'singleton'
	),
	'pwComponent' => array(
		'path' => 'LIB:engine.component.PwComponent',
		'scope' => 'singleton',
		'config' => array('resource' => 'CONF:pwcomponents.php'),		
	),
	'security' => array(
		'path' => 'WIND:security.WindXxtea',
		'scope' => 'singleton',
	),
	'windLogger' => array(
		'config' => array('maxFileSize' => 10000)
	),
	'router' => array(
		'config' => array(
  			'routes' => array(
			    'pw' => array(
					'class' => 'APPS:rewrite.PwRewriteRoute',
				    'default' => true,
				),
  			),
		)
	),
	'windView' => array(
		'config' => array('themePackPattern' => '{pack}.{theme}.template')
	),
	'template' => array(
		'config' => array('resource' => 'CONF:compiler.php'),
	),
	'i18n' => array(
		'config' => array('path' => 'SRC:i18n', 'suffix' => '.lang'),
	),
	'db' => array('config' => array('resource' => 'CONF:database.php')),
	'windToken' => array(
		'path' => 'LIB:engine.extension.token.PwCsrfToken',
		'scope' => 'singleton',
	),
	'windCookie' => array(
		'path' => 'WIND:http.cookie.WindNormalCookie',
		'scope' => 'singleton',
	),
	'windiddb' => array(
		'path' => 'WIND:db.WindConnection',
		'scope' => 'singleton',
		'config' => array('resource' => 'WINDID:database.php')
	),
	'httptransfer' => array(
		'path' => 'WIND:http.transfer.WindHttpSocket',
		'scope' => 'prototype'
	),
	'storage' => array(
		'path' => 'LIB:storage.PwStorageLocal',
		'scope' => 'singleton'
	)
);