<?php
defined('WEKIT_VERSION') or exit(403);
/**
 * 系统hook配置文件
 */
return array(
	'c_post_run' => array(
		'description' => '发表帖子展示页',
		'param' => array(),
		'interface' => '',
		'list' => array(
			'poll' => array(
				'class' => 'SRV:forum.srv.post.injector.PwPostDoPollInjector', 
				'method' => 'run', 
				'expression' => 'special.get==1'
			)
		)
	),
	'm_PwTopicPost' => array(
		'description' => '发表帖子',
		'param' => array(),
		'interface' => 'SRV:forum.srv.post.do.PwPostDoBase',
		'list' => array(
			'fresh' => array(
				'class' => 'HOOK:PwPost.do.PwPostDoFresh',
			),
			'task' => array(
				'class' => 'SRV:task.srv.condition.PwTaskBbsThreadDo'
			),
			'behavior' => array(
				'class' => 'SRV:misc.behavior.do.PwMiscThreadDo',
				'loadway' => 'load'
			),
			'medal' => array(
				'class' => 'SRV:medal.srv.condition.do.PwMedalThreadDo',
				'loadway' => 'load'
			),
			'remind' => array(
				'class' => 'SRV:forum.srv.post.do.PwPostDoRemind',
			)
		)
	),
	'm_PwReplyPost' => array(
		'description' => '发表回复',
		'param' => array(),
		'interface' => 'SRV:forum.srv.post.do.PwPostDoBase',
		'list' => array(
			'task' => array(
				'class' => 'SRV:task.srv.condition.PwTaskBbsPostDo'
			),
			'behavior' => array(
				'class' => 'SRV:misc.behavior.do.PwMiscPostDo',
				'loadway' => 'load'
			),
			'medal' => array(
				'class' => 'SRV:medal.srv.condition.do.PwMedalPostDo',
				'loadway' => 'load'
			),
			'remind' => array(
				'class' => 'SRV:forum.srv.post.do.PwReplyDoRemind',
			),
			'notice' => array(
				'class' => 'SRV:forum.srv.post.do.PwReplyDoNotice',
			),
		)
	),
	'c_post_doadd' => array(
		'description' => '发表帖子提交页',
		'param' => array(),
		'interface' => '',
		'list' => array(
			'poll' => array(
				'class' => 'SRV:forum.srv.post.injector.PwPostDoPollInjector', 
				'method' => 'doadd', 
				'expression' => 'special.post==1'
			), 
			'att' => array(
				'class' => 'SRV:forum.srv.post.injector.PwPostDoAttInjector', 
				'method' => 'run', 
				'expression' => 'flashatt.post!=0'
			), 
			'album' => array(
				'class' => 'SRC:extensions.album.service.srv.PwPostDoAlbumInjector',
				'method' => 'run',
				'expression' => 'toAlbums.post!=0'
			),
			'tag' => array(
				'class' => 'SRV:forum.srv.post.injector.PwPostDoTagInjector', 
				'method' => 'doadd'
			),
		)
	), 
	'c_post_doreply' => array(
		'description' => '发表回复提交页',
		'param' => array(),
		'interface' => '',
		'list' => array(
			'att' => array(
				'class' => 'SRV:forum.srv.post.injector.PwPostDoAttInjector', 
				'method' => 'run', 
				'expression' => 'flashatt.post!=0'
			), 
			'dolike_fast_reply' => array(
				'class' => 'SRV:like.srv.fresh.injector.PwLikeDoFreshInjector', 
				'method' => 'run', 
				'expression' => 'isfresh.post==1'
			), 
			'dolike_reply_lastpid' => array(
				'class' => 'SRV:like.srv.reply.injector.PwLikeDoReplyInjector', 
				'method' => 'run', 
				'expression' => 'from_type.post==like'
			),
		)
	), 
	'c_post_modify' => array(
		'description' => '帖子编辑页面',
		'param' => array(),
		'interface' => '',
		'list' => array(
			'poll' => array(
				'class' => 'SRV:forum.srv.post.injector.PwPostDoPollInjector', 
				'method' => 'modify', 
				'expression' => 'service:special==1'
			),
		)
	), 
	'c_post_domodify' => array(
		'description' => '帖子编辑提交页面',
		'param' => array(),
		'interface' => '',
		'list' => array(
			'poll' => array(
				'class' => 'SRV:forum.srv.post.injector.PwPostDoPollInjector', 
				'method' => 'domodify', 
				'expression' => 'service:action.info.special==1'
			), 
			'att' => array(
				'class' => 'SRV:forum.srv.post.injector.PwPostDoAttInjector', 
				'method' => 'domodify'
			),  //'expression' => 'flashatt.post!=0'
			'tag' => array(
				'class' => 'SRV:forum.srv.post.injector.PwPostDoTagInjector', 
				'method' => 'domodify'
			),
		)
	),
	'c_read_run' => array(
		'description' => '帖子阅读页',
		'param' => array(),
		'interface' => '',
		'list' => array(
			'poll' => array(
				'class' => 'SRV:forum.srv.threadDisplay.injector.PwThreadDisplayDoPollInjector', 
				'method' => 'run', 
				'expression' => 'service:thread.info.special==1'
			),
			'like' => array(
				'class' => 'SRV:like.srv.threadDisplay.injector.PwThreadDisplayDoLikeInjector', 
				'method' => 'run'
			),
			'tag' => array(
				'class' => 'SRV:forum.srv.threadDisplay.injector.PwThreadDisplayDoTagInjector', 
				'method' => 'run',
				'expression' => 'service:thread.info.tags!=NULL'
			),
			'medal' => array(
				'class' => 'SRV:medal.srv.threadDisplay.injector.PwThreadDisplayDoMedalInjector', 
				'method' => 'run'
			),
		)
	),
	'c_register' => array(
		'description' => '注册页面',
		'param' => array(),
		'interface' => 'LIB:engine.hook.PwBaseHookInjector',
		'list' => array(
			'invite' => array(
				'class' => 'SRV:user.srv.register.injector.PwRegisterDoInviteInjector',
				'method' => 'run',
				'expression' => 'service:isOpenInvite==1'
			),
			'inviteFriend' => array(
				'class' => 'SRV:user.srv.register.injector.PwRegisterDoInviteFriendInjector',
				'method' => 'run',
			),
		)
	),
	's_PwThreadsDao_add' => array(
		'description' => '增加一条帖子记录时，调用',
		'param' => array('@param int $id 新增的帖子tid', '@param array $fields 帖子字段', '@return void'),
		'interface' => '',
		'list' => array(
			'threadsIndex' => array(
				'class' => 'SRV:forum.dao.PwThreadsIndexDao',
				'method' => 'addThread',
				'loadway' => 'loadDao'
			),
			'threadsCateIndex' => array(
				'class' => 'SRV:forum.dao.PwThreadsCateIndexDao',
				'method' => 'addThread',
				'loadway' => 'loadDao'
			),
			'threadsDigestIndex' => array(
				'class' => 'SRV:forum.dao.PwThreadsDigestIndexDao',
				'method' => 'addThread',
				'loadway' => 'loadDao'
			),
		)
	),
	's_PwThreadsDao_update' => array(
		'description' => '更新一条帖子记录时，调用',
		'param' => array('@param int $id 帖子tid', '@param array $fields 更新的帖子字段数据', '@param array $increaseFields 递增的帖子字段数据', '@return void'),
		'interface' => '',
		'list' => array(
			'threadsIndex' => array(
				'class' => 'SRV:forum.dao.PwThreadsIndexDao',
				'method' => 'updateThread',
				'loadway' => 'loadDao'
			),
			'threadsCateIndex' => array(
				'class' => 'SRV:forum.dao.PwThreadsCateIndexDao',
				'method' => 'updateThread',
				'loadway' => 'loadDao'
			),
			'threadsDigestIndex' => array(
				'class' => 'SRV:forum.dao.PwThreadsDigestIndexDao',
				'method' => 'updateThread',
				'loadway' => 'loadDao'
			),
		)
	),
	's_PwThreadsDao_batchUpdate' => array(
		'description' => '批量更新多条帖子记录时，调用',
		'param' => array('@param array $ids 帖子tid序列', '@param array $fields 更新的帖子字段数据', '@param array $increaseFields 递增的帖子字段数据', '@return void'),
		'interface' => '',
		'list' => array(
			'threadsIndex' => array(
				'class' => 'SRV:forum.dao.PwThreadsIndexDao',
				'method' => 'batchUpdateThread',
				'loadway' => 'loadDao'
			),
			'threadsCateIndex' => array(
				'class' => 'SRV:forum.dao.PwThreadsCateIndexDao',
				'method' => 'batchUpdateThread',
				'loadway' => 'loadDao'
			),
			'threadsDigestIndex' => array(
				'class' => 'SRV:forum.dao.PwThreadsDigestIndexDao',
				'method' => 'batchUpdateThread',
				'loadway' => 'loadDao'
			),
		)
	),
	's_PwThreadsDao_delete' => array(
		'description' => '删除一个帖子时，调用',
		'param' => array('@param int $id 帖子tid', '@return void'),
		'interface' => '',
		'list' => array(
			'threadsIndex' => array(
				'class' => 'SRV:forum.dao.PwThreadsIndexDao',
				'method' => 'deleteThread',
				'loadway' => 'loadDao'
			),
			'threadsCateIndex' => array(
				'class' => 'SRV:forum.dao.PwThreadsCateIndexDao',
				'method' => 'deleteThread',
				'loadway' => 'loadDao'
			),
			'threadsDigestIndex' => array(
				'class' => 'SRV:forum.dao.PwThreadsDigestIndexDao',
				'method' => 'deleteThread',
				'loadway' => 'loadDao'
			),
		)
	),
	's_PwThreadsDao_batchDelete' => array(
		'description' => '批量删除多个帖子时，调用',
		'param' => array('@param array $ids 帖子tid序列', '@return void'),
		'interface' => '',
		'list' => array(
			'threadsIndex' => array(
				'class' => 'SRV:forum.dao.PwThreadsIndexDao',
				'method' => 'batchDeleteThread',
				'loadway' => 'loadDao'
			),
			'threadsCateIndex' => array(
				'class' => 'SRV:forum.dao.PwThreadsCateIndexDao',
				'method' => 'batchDeleteThread',
				'loadway' => 'loadDao'
			),
			'threadsDigestIndex' => array(
				'class' => 'SRV:forum.dao.PwThreadsDigestIndexDao',
				'method' => 'batchDeleteThread',
				'loadway' => 'loadDao'
			),
		)
	),
	's_addFollow' => array(
		'description' => '当发生关注操作时，调用',
		'param' => array('@param int $uid 用户', '@param int $touid 被关注用户', '@return void'),
		'interface' => '',
		'list' => array(
			'medal' => array(
				'class' => 'SRV:medal.srv.condition.do.PwMedalFansDo',
				'method' => 'addFollow',
				'loadway' => 'load'
			),
			'task' => array(
				'class' => 'SRV:task.srv.condition.PwTaskMemberFansDo',
				'method' => 'addFollow',
				'loadway' => 'load',
			),
			'message' => array(
				'class' => 'SRV:message.srv.do.PwNoticeFansDo',
				'method' => 'addFollow',
				'loadway' => 'load',
			),
		)
	),
	's_deleteFollow' => array(
		'description' => '当发生取消关注操作时，调用',
		'param' => array('@param int $uid 用户', '@param int $touid 被关注用户', '@return void'),
		'interface' => '',
		'list' => array(
			'medal' => array(
				'class' => 'SRV:medal.srv.condition.do.PwMedalFansDo',
				'method' => 'delFollow',
				'loadway' => 'load'
			),
		)
	),
	
	's_PwTaskDao_update' => array(
		'description' => '更新一条任务记录时，调用',
		'param' => array('@param int $id 帖子tid', '@param array $fields 更新的任务字段数据', '@param array $increaseFields 递增的任务字段数据', '@return void'),
		'interface' => '',
		'list' => array(
			'TaskUser' => array(
				'class' => 'SRV:task.dao.PwTaskUserDao',
				'method' => 'updateIsPeriod',
				'loadway' => 'loadDao'
			)
		)
	),
	's_PwUserService_editUser' => array(
		'description' => '更新用户资料时，调用',
		'param' => array('@param PwUserInfoDm $dm', '@return void'),
		'interface' => '',
		'list' => array(
			'task' => array(
				'class' => 'SRV:task.srv.condition.PwTaskProfileConditionDo',
				'loadway' => 'load',
				'method' => 'editUser',
			),
		)
	),
	's_update_avatar' => array(
		'description' => '更新用户头像时，调用',
		'param' => array('@param int $uid 用户id', '@return void'),
		'interface' => '',
		'list' => array(
			'task' => array(
				'class' => 'SRV:task.srv.condition.PwTaskMemberAvatarDo',
				'loadway' => 'load',
				'method' => 'uploadAvatar',
			),
			'album' => array(
				'class' => 'SRC:extensions.album.service.srv.PwPhotoUploadAvatarDo',
				'loadway' => 'load',
				'method' => 'uploadAvatar',
			)
		)
	),
	/*获取任务奖励钩子*/
	'm_task_gainreward' => array(
		'description' => '领取任务',
		'param' => array(),
		'interface' => 'SRV:task.srv.reward.PwTaskRewardDoBase',
		'list' => array(
			'group' => array(
				'class' => 'SRV:task.srv.reward.PwTaskGroupRewardDo',
				'expression' => 'service:type==group',
			),
			'credit' => array(
				'class' => 'SRV:task.srv.reward.PwTaskCreditRewardDo',
				'expression' => 'service:type==credit',
			),
		)
	),
	'm_PwLikeService' => array( //todo
		'description' => '喜欢',
		'param' => array(),
		'interface' => 'SRV:like.srv.bo.PwLikeDoBase',
		'list' => array(
			'task' => array(
				'class' => 'SRV:task.srv.condition.PwTaskBbsLikeDo',
				'loadway' => 'load'
			),
			'behavior' => array(
				'class' => 'SRV:misc.behavior.do.PwMiscLikeDo',
				'loadway' => 'load'
			),
			'medal' => array(
				'class' => 'SRV:medal.srv.condition.do.PwMedalLikeDo',
				'loadway' => 'load'
			)
		)
	),
	'm_PwMessageService' => array( //todo 金龙 simpleHook
		'description' => '消息服务',
		'param' => array(),
		'interface' => 'SRV:message.srv.do.PwMessageDoBase',
		'list' => array(
			'task' => array(
				'class' => 'SRV:task.srv.condition.PwTaskMemberMsgDo',
				'loadway' => 'load'
			)
		)
	),
	'm_login_welcome' => array(
		'description' => '用户登录之后的操作',
		'param' => array('@param PwUserBo $userBo 登录用户的对象', '@param string $ip 登录的IP'),
		'interface' => 'SRV:user.srv.login.PwUserLoginDoBase',
		'list' => array(
			'autotask' => array(
				'class' => 'SRV:task.srv.condition.PwAutoTaskLoginDo',
				'loadway' => 'load'
			),
			'behavior' => array(
				'class' => 'SRV:misc.behavior.do.PwMiscUserDo',
				'loadway' => 'load'
			),
			'medal' => array(
				'class' => 'SRV:medal.srv.condition.do.PwMedalUserDo',
				'loadway' => 'load'
			),
			'recommendUser' => array(
				'class' => 'SRV:attention.srv.recommend.PwRecommendUserDo',
				'loadway' => 'load'
			),
			'updateOnline' => array(
				'class' => 'SRV:online.srv.do.PwLoginDoUpdateOnline',
				'loadway' => 'load'
			),
		)
	),
	's_PwUser_delete' => array(
		'description' => '删除用户时，调用',
		'param' => array('@param int $uid 用户id', '@return void'),
		'interface' => '',
		'list' => array(
			'ban' => array(
				'class' => 'SRC:hooks.PwUser.PwUserDoBan',
				'method' => 'deleteBan',
				'loadway' => 'load'
			),
			'belong' => array(
				'class' => 'SRC:hooks.PwUser.PwUserDoBelong',
				'method' => 'deleteUser',
				'loadway' => 'load'
			),
			'registerCheck' => array(
				'class' => 'SRC:hooks.PwUser.PwUserDoRegisterCheck',
				'method' => 'deleteUser',
				'loadway' => 'load',
			),
			'task' => array(
				'class' => 'SRV:task.PwTaskUser',
				'method' => 'deleteByUid',
				'loadway' => 'load',
			),
			'usertag' => array(
				'class' => 'SRV:usertag.PwUserTagRelation',
				'method' => 'deleteRelationByUid',
				'loadway' => 'load',
			),
		)
	),
	's_PwUser_batchDelete' => array(
		'description' => '批量删除用户时，调用',
		'param' => array('@param array $uids 用户id序列', '@return void'),
		'interface' => '',
		'list' => array(
			'ban' => array(
				'class' => 'SRC:hooks.PwUser.PwUserDoBan',
				'method' => 'batchDeleteBan',
				'loadway' => 'load'
			),
			'belong' => array(
				'class' => 'SRC:hooks.PwUser.PwUserDoBelong',
				'method' => 'batchDeleteUser',
				'loadway' => 'load'
			),
			'registerCheck' => array(
				'class' => 'SRC:hooks.PwUser.PwUserDoRegisterCheck',
				'method' => 'batchDeleteUser',
				'loadway' => 'load',
			),
			'task' => array(
				'class' => 'SRV:task.PwTaskUser',
				'method' => 'batchDeleteByUid',
				'loadway' => 'load',
			),
			'usertag' => array(
				'class' => 'SRV:usertag.PwUserTagRelation',
				'method' => 'batchDeleteRelationByUids',
				'loadway' => 'load',
			),
		)
	),
	's_PwUser_add' => array(
		'description' => '添加用户时，调用',
		'param' => array('@param PwUserInfoDm $dm', '@return void'),
		'interface' => '',
		'list' => array(
			'belong' => array(
				'class' => 'SRC:hooks.PwUser.PwUserDoBelong',
				'method' => 'editUser',
				'loadway' => 'load'
			),
		)
	),
	's_PwUser_update' => array(
		'description' => '更新用户信息时，调用',
		'param' => array('@param PwUserInfoDm $dm', '@return void'),
		'interface' => '',
		'list' => array(
			'belong' => array(
				'class' => 'SRC:hooks.PwUser.PwUserDoBelong',
				'method' => 'editUser',
				'loadway' => 'load'
			),
		)
	),
	'c_space_profile' => array(
		'description' => '空间资料页面',
		'param' => array(''),
		'interface' => '',
		'list' => array( //这个顺序别改，pd要求的
			'education' => array(
				'class' => 'SRV:space.srv.profile.injector.PwSpaceProfileInjector', 
				'method' => 'extendEducation'
			),
			'work' => array(
				'class' => 'SRV:space.srv.profile.injector.PwSpaceProfileInjector', 
				'method' => 'extendWork'
			),
		)
	),
	's_PwUserDataDao_update' => array(
		'description' => '用户数据更新时，调用',
		'param' => array('@param int $id 用户id', '@param array $fields 更新的用户字段数据', '@param array $increaseFields 递增的用户字段数据', '@return void'),
		'interface' => '',
		'list' => array(
			'level' => array(
				'class' => 'SRV:usergroup.srv.PwUserGroupsService',
				'method' => 'updateLevel',
				'loadway' => 'load'
			),
			'autoBan' => array(
				'class' => 'SRV:user.srv.PwUserBanService',
				'method' => 'autoBan',
				'loadway' => 'load'
			),
		)
	),
	's_PwUserGroups_update' => array(
		'description' => '用户组资料更新时，调用',
		'param' => array('@param int $gid 用户组id', '@return void'),
		'interface' => '',
		'list' => array(
			'level_cache' => array(
				'class' => 'SRV:usergroup.srv.PwUserGroupsService',
				'method' => 'updateLevelCache',
				'loadway' => 'load'
			),
		)
	),
	's_PwUserGroupPermission_update' => array(
		'description' => '用户组权限变更时，调用',
		'param' => array('@param PwUserPermissionDm $dm', '@return void'),
		'interface' => '',
		'list' => array(
			'level_cache' => array(
				'class' => 'SRV:usergroup.srv.PwUserGroupsService',
				'method' => 'updatePermissionCache',
				'loadway' => 'load'
			),
		)
	),
	's_PwLikeService_delLike' => array( //todo
		'list' => array(
			'behavior' => array(
				'class' => 'SRV:misc.behavior.do.PwMiscLikeDo',
				'method' => 'delLike',
				'loadway' => 'load'
			),
			'delLike' => array(
				'class' => 'SRV:medal.srv.condition.do.PwMedalLikeDo',
				'method' => 'delLike',
				'loadway' => 'load'
			),
		)
	),
	's_PwUserTagRelationDao_deleteRelation' => array(
		'description' => '删除用户标签的关系，调用',
		'param' => array('@param int $tag_id 标签id', '@return void'),
		'interface' => '',
		'list' => array(
			'PwUserTag' => array(
				'class' => 'SRV:usertag.dao.PwUserTagDao',
				'method' => 'updateTag',
				'loadway' => 'loadDao'
			),
		)
	),
	's_PwUserTagDao_deleteTag' => array(
		'description' => '删除用户标签时，调用',
		'param' => array('@param int $tag_id 标签id', '@return void'),
		'interface' => '',
		'list' => array(
			'PwUserTagRelation' => array(
				'class' => 'SRV:usertag.dao.PwUserTagRelationDao',
				'method' => 'deleteRelationByTagid',
				'loadway' => 'loadDao'
			),
		)
	),
	's_PwUserTagDao_batchDeleteTag' => array(
		'description' => '批量删除用户标签时，调用',
		'param' => array('@param array $tag_ids 标签id序列', '@return void'),
		'interface' => '',
		'list' => array(
			'PwUserTagRelation' => array(
				'class' => 'SRV:usertag.dao.PwUserTagRelationDao',
				'method' => 'batchDeleteRelationByTagids',
				'loadway' => 'loadDao'
			),
		)
	),
	's_PwUserTagRelation_batchDeleteRelation' => array(
		'description' => '删除用户标签关系的时候',
		'param' => array('@param array $tag_ids ', '@param PwUserTagRelation ', '@return void'),
		'interface' => '',
		'list' => array(
			'PwDeleteRelationDoUpdateTag' => array(
				'class' => 'SRV:usertag.srv.do.PwDeleteRelationDoUpdateTag',
				'method' => 'batchDeleteRelation',
				'loadway' => 'load'
			),
		)
	),
	's_PwUserTagRelation_deleteRelationByUid' => array(
		'description' => '根据用户ID删除用户标签关系',
		'param' => array('@param int $uid ', '@return void'),
		'interface' => '',
		'list' => array(
			'PwDeleteRelationDoUpdateTag' => array(
				'class' => 'SRV:usertag.srv.do.PwDeleteRelationDoUpdateTag',
				'method' => 'deleteRelationByUid',
				'loadway' => 'load'
			),
		)
	),
	's_PwUserTagRelation_batchDeleteRelationByUids' => array(
		'description' => '根据用户ID列表批量删除用户标签关系',
		'param' => array('@param array $uid ', '@return void'),
		'interface' => '',
		'list' => array(
			'PwDeleteRelationDoUpdateTag' => array(
				'class' => 'SRV:usertag.srv.do.PwDeleteRelationDoUpdateTag',
				'method' => 'batchDeleteRelationByUids',
				'loadway' => 'load'
			),
		)
	),
	/*添加表情*/
	's_PwEmotionDao_add' => array(
		'description' => '添加表情时，调用',
		'param' => array('@param int $id id', '@param array $fields 字段信息', '@return void'),
		'interface' => '',
		'list' => array(
			'addEmotion' => array(
				'class' => 'SRV:emotion.srv.PwEmotionService',
				'method' => 'updateCache',
				'loadway' => 'load'
			),
		)
	),
	/*编辑表情*/
	's_PwEmotionDao_update' => array(
		'description' => '编辑表情时，调用',
		'param' => array('@param int $id 表情id', '@param array $fields 字段信息', '@param array $increaseFields 字段信息', '@return void'),
		'interface' => '',
		'list' => array(
			'addEmotion' => array(
				'class' => 'SRV:emotion.srv.PwEmotionService',
				'method' => 'updateCache',
				'loadway' => 'load'
			),
		)
	),
	/*删除表情*/
	's_PwEmotionDao_delete' => array(
		'description' => '删除表情时，调用',
		'param' => array('@param int $id 表情id', '@return void'),
		'interface' => '',
		'list' => array(
			'addEmotion' => array(
				'class' => 'SRV:emotion.srv.PwEmotionService',
				'method' => 'updateCache',
				'loadway' => 'load'
			),
		)
	),
	's_PwThreadType' => array(
		'description' => '获取帖子扩展类型时，调用',
		'param' => array('@param array $tType 帖子类型', '@return array'),
		'interface' => '',
		'list' => array(
			/*
			'debate' => array(
				'class' => 'HOOK:PwThreadType.PwThreadTypeDoDebate',
				'method' => 'getTtype',
				'loadway' => 'load'
			)*/
		)
	),
	'c_fresh_post' => array(
		'description' => '在新鲜事页面发布帖子',
		'param' => array(),
		'interface' => '',
		'list' => array(
			'att' => array(
				'class' => 'SRV:forum.srv.post.injector.PwPostDoAttInjector', 
				'method' => 'run', 
				'expression' => 'flashatt.post!=0'
			)
		)
	), 
	's_punch' => array(
		'description' => '打卡时，调用',
		'param' => array('@param PwUserInfoDm $dm', '@return void'),
		'interface' => '',
		'list' => array(
			'task' => array(
				'class' => 'SRV:task.srv.condition.PwTaskMemberPunchDo',
				'method' => 'doPunch',
				'loadway' => 'load'
			)
		)
	),
	/*扩展存储类型*/
	's_PwAttacmentService_getStorages' => array( //todo
	),
	'c_login_dorun' => array(
		'description' => '用户登录，表现层',
		'param' => array(),
		'interface' => 'PwBaseHookInjector',
		'list' => array(
			'inviteFriend' => array(
				'class' => 'SRV:user.srv.login.injector.PwLoginDoInviteFriendInjector',
				'method' => 'run'
			),
		)
	),
	'm_threadmanage_copy' => array( //todo
		'list' => array(
			'poll' => array(
				'class' => 'SRV:forum.srv.manage.do.PwThreadManageCopyDoPoll', 
				'loadway' => 'load',
				'expression' => 'service:special!=0',
			), 
			'att' => array(
				'class' => 'SRV:forum.srv.manage.do.PwThreadManageCopyDoAtt', 
				'loadway' => 'load',
				'expression' => 'service:ifupload!=0',
			),
		)
	),
	/* 用户退出之前的更新 */
	's_PwUserService_logout' => array(
		'description' => '退出登录',
		'param' => array('@param PwUserBo $loginUser', '@return void'),
		'interface' => 'PwLogoutDoBase',
		'list' => array(
			'updatelastvist' => array(
				'class' => 'SRV:user.srv.logout.do.PwLogoutDoUpdateLastvisit',
				'method' => 'beforeLogout',
				'loadway' => 'load'
			),
			'updateOnline' => array(
				'class' => 'SRV:online.srv.do.PwLogoutDoUpdateOnline',
				'method' => 'beforeLogout',
				'loadway' => 'load'
			),
		),
	),
);