<?php
! defined ( 'ACLOUD_PATH' ) && exit ( 'Forbidden' );

define ( 'PERMISSIONS_INVALID_PARAMS', 701 );
define ( 'PERMISSIONS_USER_NOT_EXISTS', 701 );
Wind::import('SRV:forum.bo.PwForumBo');

class ACloudVerCommonPermissions extends ACloudVerCommonBase {
	
	public function isUserBanned($uid) {
		$user = new PwUserBo ( $uid );
		if (! $user->isExists ())
			return $this->buildResponse ( PERMISSIONS_USER_NOT_EXISTS );
		$result = $this->getUserBanService ()->getBanInfoByUid ( $uid, 1 );
		if ($result instanceof PwError)
			return $this->buildResponse ( - 1, $result->getError () );
		$code = $result ? 500 : 0;
		return $this->buildResponse ( $code );
	}
	
	/**
	 * 
	 * 判断指定用户是否有访问指定版块的权限
	 *
	 * @param int $uid
	 * @param int $fid
	 */
	public function readForum($uid, $fid) {
		$forum = new PwForumBo($fid);
		$user = new PwUserBo($uid);
		$result = $forum->allowVisit($user);
		if ($result instanceof PwError)
			return $this->buildResponse ( - 1, $result->getError () );
		$code = $result ? 500 : 0;
		return $this->buildResponse ( $code );
	}
	
	private function getUserBanService() {
		return Wekit::load ( 'SRV:user.srv.PwUserBanService' );
	}
}