<?php
! defined ( 'ACLOUD_PATH' ) && exit ( 'Forbidden' );

define ( 'MESSAGE_INVALID_PARAMS', 601 );
define ( 'MESSAGE_UID_ERROR', 602 );
define ( 'MESSAGE_SEND_FAIL', 603 );

class ACloudVerCustomizedMessage extends ACloudVerCustomizedBase {
	/**
	 * 
	 * 统计用户未读通知
	 * 
	 * @param int $uid
	 * @return int
	 */
	public function countUnreadMessage($uid) {
		$user = new PwUserBo ( intval ( $uid ) );
		$result = $user->info ['messages'];
		if (! $result)
			return $this->buildResponse ( MESSAGE_UID_ERROR );
		return $this->buildResponse ( 0, array ('count' => intval ( $result ) ) );
	}
	
	/**
	 * 
	 * 获取用户对应的对话框列表
	 * 
	 * @param int $uid
	 * @param int $start
	 * @param int $limit
	 * @return array 
	 */
	public function getMessageByUid($uid, $offset, $limit) {
		$user = PwUserBo::getInstance ( $uid );
		if (! $user->isExists ())
			return $this->buildResponse ( MESSAGE_UID_ERROR );
		list ( $count, $result ) = $this->getPwMessageService ()->getDialogs ( $uid, $offset, $limit );
		if ($result instanceof PwError)
			return $this->buildResponse ( - 1, $result->getError () );
		$message = array ();
		foreach ( $result as $k => $v ) {
			$message [$k] ['messageid'] = $v ['dialog_id'];
			$message [$k] ['uid'] = $v ['from_uid'];
			$message [$k] ['username'] = PwUserBo::getInstance ( $v ['uid'] )->username;
			$message [$k] ['icon'] = Pw::getAvatar ( $v ['uid'] );
			$message [$k] ['postdate'] = 0;
			$message [$k] ['title'] = '';
			$message [$k] ['relationid'] = 0;
			$message [$k] ['status'] = 0;
			$message [$k] ['tid'] = 0;
			$message [$k] ['content'] = $v ['last_message'] ['content'];
			$message [$k] ['to_uid'] = $v ['uid'];
			$message [$k] ['unread_count'] = $v ['unread_count'];
			$message [$k] ['message_count'] = $v ['message_count'];
			$message [$k] ['last_message'] = $v ['last_message'];
		}
		return $this->buildResponse ( 0, array ('count' => $count, 'messages' => $message ) );
	}
	
	public function getReplyThreadMessage($uid, $offset, $limit) {
	
	}
	
	/**
	 * 按用户ID发送私信
	 * 
	 * @param int $uid
	 * @param string $content
	 * @return PwError|boolean
	 */
	public function sendMessage($fromUid, $toUid, $title, $content) {
		list ( $fromUid, $toUid, $content ) = array (intval ( $fromUid ), intval ( $toUid ), trim ( $content ) );
		if ($fromUid < 1 || $toUid < 1 || ! $content)
			return $this->buildResponse ( MESSAGE_INVALID_PARAMS );
		$result = $this->getPwMessageService ()->sendMessageByUid ( $toUid, $content, $fromUid );
		if ($result instanceof PwError)
			return $this->buildResponse ( - 1, $result->getError () );
		$result = ($result == true) ? 1 : 0;
		return $this->buildResponse ( 0, array ('messageid' => $result ) );
	}
	
	public function replyMessage($messageId, $relationId, $uid, $content) {
	
	}
	
	/**
	 * 获取对话消息列表
	 *
	 * @param int $dialogId
	 * @param int $start
	 * @param int $limit
	 * @return array
	 */
	public function getMessageAndReply($dialogId, $relationId = null, $uid = null, $offset, $limit) {
		list ( $dialogId, $offset, $limit ) = array (intval ( $dialogId ), intval ( $offset ), intval ( $limit ) );
		if ($dialogId < 1)
			return $this->buildResponse ( MESSAGE_INVALID_PARAMS );
		list ( $count, $dialogResult ) = $this->getPwMessageService ()->getDialogMessageList ( $dialogId, $offset, $limit );
		if ($dialogResult instanceof PwError)
			return $this->buildResponse ( - 1, $dialogResult->getError () );
		$result = array ();
		$dialogResult = array_values ( $dialogResult );
		foreach ( $dialogResult as $k => $v ) {
			$result [$k] ['messageid'] = $v ['message_id'];
			$result [$k] ['uid'] = $v ['from_uid'];
			$result [$k] ['username'] = PwUserBo::getInstance ( $v ['uid'] )->username;
			$result [$k] ['icon'] = Pw::getAvatar ( $v ['from_uid'] );
			$result [$k] ['postdate'] = $v ['created_time'];
			$result [$k] ['title'] = '';
			$result [$k] ['relationid'] = 0;
			$result [$k] ['status'] = 0;
			$result [$k] ['tid'] = 0;
			$result [$k] ['content'] = $v ['content'];
			$result [$k] ['id'] = $v ['id'];
			$result [$k] ['dialog_id'] = $dialogId;
			$result [$k] ['is_read'] = $v ['is_read'];
			$result [$k] ['from_username'] = $v ['from_username'];
		}
		return $this->buildResponse ( 0, array ('count' => $count, 'messages' => $result ) );
	}
	
	private function getPwMessageService() {
		return wekit::load ( 'SRV:message.srv.PwMessageService' );
	}
}