<?php
Wind::import('ADMIN:library.AdminBaseController');
/**
 * 后台应用主题框架操作处理类
 * 
 * 后台应用默认操作处理类,操作方法：<ul>
 * <li>run,后台主体框架页面处理</li>
 * <li>login,后台登录操作</li>
 * </ul>
 * 
 * @author Qiong Wu <papa0924@gmail.com> 2011-10-13
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: IndexController.php 17404 2012-09-05 07:30:58Z long.shi $
 * @package admin
 * @subpackage controller
 */
class IndexController extends AdminBaseController {

	/**
	 * 后台主体框架页面
	 * 
	 * @return void
	 */
	public function run() {
		/* @var $menuService AdminMenuService */
		$menuService = Wekit::load('ADMIN:service.srv.AdminMenuService');
		$menus = $menuService->getMyMenus($this->adminUser);
		
		//常用菜单
		if (isset($menus['custom']['items']) && is_array($menus['custom']['items'])) {
			$menus['custom']['items'] += $menuService->getCustomMenus($this->adminUser);
		}
		$this->setOutput($menus, 'menus');
	}

	/**
	 * 后台退出
	 *
	 * @return void
	 */
	public function logoutAction() {
		$adminUserService = Wekit::load('ADMIN:service.srv.AdminUserService');
		$result = $adminUserService->logout();
		if ($result instanceof PwError) $this->showError($result->getError());
		if ($result === false) $this->showError('logout.fail');
		$this->forwardRedirect(WindUrlHelper::createUrl('index/run'));
	}

	/**
	 * 后台登录操作
	 * 
	 * @return void
	 */
	public function loginAction() {
		list($username, $password) = $this->getInput(array('username', 'password'), 'post');
		if ($username && $password) {
			$this->checkVerify();
			Wind::import('APPS:admin.service.dm.AdminUserDm');
			$adminUser = new AdminUserDm();
			$adminUser->setUsername($username)->setPassword($password);
			/* @var $adminUserService AdminUserService */
			$adminUserService = Wekit::load('ADMIN:service.srv.AdminUserService');
			$adminUser = $adminUserService->login($adminUser);
			if ($adminUser instanceof PwError) $this->showError($adminUser->getError());
			if ($adminUser === false) $this->showError('login.fail');
			$this->setOutput($adminUser, 'adminUser');
			$this->forwardRedirect(WindUrlHelper::createUrl('index/run'));
		}
		$this->setOutput(in_array('adminlogin', Wekit::config('verify', 'showverify')), 'showVerify');
	}

	/**
	 * 检测用户的验证码是否正确
	 */
	private function checkVerify() {
		if (!in_array('adminlogin', Wekit::config('verify', 'showverify'))) 
			return true;
		/* @var $verifySrv PwCheckVerifyService */
		$verifySrv = Wekit::load("verify.srv.PwCheckVerifyService");
		if (!$verifySrv->checkVerify($this->getInput('code'))) {
			$this->showError('USER:verifycode.error');
		}
		return true;
	}
	
	/**
	 * 显示验证码
	 */
	public function showVerifyAction() {
		Wind::import("LIB:utility.PwVerifyCode");
		$veryfy = new PwVerifyCode();
		$veryfy->showVerifyCode();
	}
}
