<?php
Wind::import('WIND:filter.WindActionFilter');
/**
 * 后台管理平台默认过滤器
 * 
 * 后台管理平台默认过滤器，职责:<ol>
 * <li>设置后台所需全局变量信息</li>
 * <li>配置信息设置</li>
 * <li>检查后台用户是否登录</li>
 * </ol>
 *
 * @author Qiong Wu <papa0924@gmail.com> 2011-10-13
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: AdminDefaultFilter.php 15174 2012-08-01 07:26:34Z xiaoxia.xuxx $
 * @package wind
 */
class AdminDefaultFilter extends WindActionFilter {
	
	/* (non-PHPdoc)
	 * @see WindHandlerInterceptor::preHandle()
	 */
	public function preHandle() {
		$this->router->getRoute('pw') || $this->router->addRoute('pw', WindFactory::createInstance(Wind::import('APPS:rewrite.PwRewriteRoute')));
		
		/* @var $configParser WindConfigParser */
		$configParser = Wind::getApp()->getComponent('configParser');
		$config = $configParser->parse(Wind::getRealPath('WindManifest.xml', true, true), 'admin_config', '', 
			Wind::getApp()->getComponent('windCache'));
		$this->setGlobal($config['application'], 'c');
		$action = $this->router->getAction();
		if (in_array($action, array('login', 'showVerify'))) return;
		
		/* @var $userService AdminUserService */
		$userService = Wekit::load('ADMIN:service.srv.AdminUserService');
		if (!$adminUser = $userService->isLogin()) {
			if (!$this->getRequest()->getIsAjaxRequest()) {
				$this->forward->forwardAction('default/index/login');
			} else {
				$this->errorMessage->addError('logout', 'state');
				$this->errorMessage->sendError('ADMIN:login.fail.not.login');
			}
		}
		$_unVerifyTable = array('home', 'index');
		if (!in_array(strtolower($this->router->getController()), $_unVerifyTable)) {
			$_result = $userService->verifyUserMenuAuth($adminUser, $this->router->getModule(), 
				$this->router->getController(), $this->router->getAction());
			if ($_result instanceof PwError) $this->errorMessage->sendError($_result->getError());
		}
		$this->setOutput($adminUser, 'adminUser');
	}
	
	/* (non-PHPdoc)
	 * @see WindHandlerInterceptor::postHandle()
	 */
	public function postHandle() {}
}

?>