<?php
/**
 * 后台用户对象
 *
 * @author Qiong Wu <papa0924@gmail.com> 2011-10-18
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: AdminUserDm.php 17393 2012-09-05 07:05:25Z long.shi $
 * @package admin
 * @subpackage library.model
 */
class AdminUserDm extends PwBaseDm {

	/**
	 *
	 * @return string
	 */
	public function getEmail() {
		return $this->getField('email');
	}

	/**
	 *
	 * @param string $email        	
	 */
	public function setEmail($email) {
		$this->_data['email'] = $email;
		return $this;
	}

	/**
	 *
	 * @return string
	 */
	public function getUsername() {
		return $this->getField('username');
	}

	/**
	 *
	 * @return string
	 */
	public function getPassword() {
		return $this->getField('password');
	}

	/**
	 *
	 * @param string $username        	
	 */
	public function setUsername($username) {
		$this->_data['username'] = $username;
		return $this;
	}

	/**
	 *
	 * @param string $passwork        	
	 */
	public function setPassword($password) {
		$this->_data['password'] = $password;
		return $this;
	}

	/**
	 *
	 * @return int 用户id
	 */
	public function getUid() {
		if ($uid = $this->getField('uid')) {
			return $uid;
		}
		$r = Wekit::load('user.PwUser')->getUserByName($this->_data['username']);
		$this->_data['uid'] = $r['uid'];
		return $r['uid'];
	}

	/**
	 *
	 * @param int $uid
	 *        	用户ID
	 */
	public function setUid($uid) {
		$this->_data['uid'] = $uid;
		return $this;
	}
	
	/*
	 * (non-PHPdoc) @see PwBaseDm::_beforeAdd()
	 */
	protected function _beforeAdd() {
		// TODO Auto-generated method stub
	}
	
	/*
	 * (non-PHPdoc) @see PwBaseDm::_beforeUpdate()
	 */
	protected function _beforeUpdate() {
		// TODO Auto-generated method stub
	}
}

?>