<?php
/**
 * 后台管理帮助类
 *
 * @author Qiong Wu <papa0924@gmail.com> Oct 24, 2011
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: AdminHelper.php 2085 2011-11-02 04:57:33Z xiaoxia.xuxx $
 * @package admin
 * @subpackage service.srv.helper
 */
class AdminHelper {

	/**
	 * 获取缓存数据
	 *
	 * @param string $cacheKey
	 * @return mixed
	 */
	static public function getCache($cacheKey) {
		$cache = Wind::getApp()->getComponent('windCache');
		$cacheData = $cache ? $cache->get($cacheKey) : array();
		return $cacheData;
	}

	/**
	 * 添加缓存数据
	 *
	 * @param string $cacheKey
	 * @param mixed $cacheData
	 * @return boolean
	 */
	static public function setCache($cacheKey, $cacheData) {
		$cache = Wind::getApp()->getComponent('windCache');
		return $cache && $cache->set($cacheKey, $cacheData);
	}
}

?>