<?php
Wind::import('ADMIN:library.AdminBaseController');
Wind::import('APPS:appcenter.service.srv.helper.PwApplicationHelper');
/**
 * 后台 - 我的应用
 *
 * @author Zhu Dong <zhudong0808@gmail.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: AppController.php 17712 2012-09-08 04:59:53Z long.shi $
 * @package appcenter.admin
 */
class AppController extends AdminBaseController {
	private $perpage = 10;

	/**
	 * 应用已安装
	 *
	 * @see WindController::run()
	 */
	public function run() {
		$page = (int) $this->getInput('page');
		$page < 1 && $page = 1;
		
		$count = (int) $this->_appDs()->count();
		$_page = ceil($count / $this->perpage);
		$page > $_page && $page = $_page;
		list($start, $num) = Pw::page2limit($page, $this->perpage);
		$apps = $this->_appDs()->fetchByPage($num, $start);
		$this->setOutput(
			array('perpage' => $this->perpage, 'page' => $page, 'count' => $count, 'apps' => $apps));
	}

	/**
	 * 获取应用更新信息及卸载信息
	 */
	public function refreshAction() {
		$app_ids = $this->getInput('app_ids');
		$apps = $data = array();
		$url = PwApplicationHelper::acloudUrl(
			array('a' => 'forward', 'do' => 'fetchApp', 'appids' => $app_ids));
		$result = PwApplicationHelper::requestAcloudData($url);
		$result['code'] === '0' && $apps = $result['info'];
		foreach (explode(',', $app_ids) as $v) {
			$data[$v] = array(
				'update_url' => '', 
				'admin_url' => isset($apps[$v]['admin_url']) ? $apps[$v]['admin_url'] : '', 
				'update_url' => $apps[$v]['update'] ? 1 : 0, 
				'open_new' => $apps[$v]['open_new'] ? 1 : 0);
		}
		$this->setOutput($data, 'data');
		$this->showMessage('success');
	}

	/**
	 * 本地安装 - 上传
	 */
	public function uploadAction() {
		$authkey = 'AdminUser';
		$pre = Wekit::config('site', 'cookie.pre');
		$pre && $authkey = $pre . '_' . $authkey;
		$winduser = $this->getInput($authkey, 'post');
		if (!$winduser) $this->showError('login.not');
		list($type, $u, $pwd) = explode("\t", Pw::decrypt(urldecode($winduser)));
		if ($type == 'founder') {
			$founders = $this->_getFounders();
			if (!isset($founders[$u])) $this->showError('login.not');
			list($md5pwd, $salt) = explode('|', $founders[$u], 2);
			if (Pw::getPwdCode($md5pwd) != $pwd) $this->showError('login.not');
		} else {
			$r = Wekit::load('user.PwUser')->getUserByUid($u);
			if (!$r) $this->showError('login.not');
			if (Pw::getPwdCode($r['password']) != $pwd) $this->showError('login.not');
		}
		
		Wind::import('SRC:applications.appcenter.service.srv.helper.PwApplicationUpload');
		$upload = new PwApplicationUpload();
		$upload->dir = Wind::getRealDir($this->_installService()->getConfig('tmp_dir'), true) . '/';
		$uploaddb = $upload->execute();
		if ($uploaddb instanceof PwError) $this->showError($uploaddb->getError());
		$this->setOutput(
			array('filename' => $uploaddb[0]['name'], 'file' => $uploaddb[0]['fileuploadurl']), 
			'data');
		$this->showMessage('success');
	}

	/**
	 * 本地安装, 打印本地安装页面
	 */
	public function installAction() {}

	/**
	 * 本地安装, 分步模式执行应用安装
	 */
	public function doInstallAction() {
		list($file, $step, $hash) = $this->getInput(array('file', 'step', 'hash'));
		$install = $this->_installService();
		if ($file) {
			$file = Wind::getRealDir($install->getConfig('tmp_dir'), true) . '/' . $file;
			$install->setTmpPath(dirname($file));
			if (!WindFile::isFile($file)) $this->showError('APPCENTER:install.checkpackage.fail');
			$_r = $install->extractPackage($file);
			if (true !== $_r) $this->showError('APPCENTER:install.checkpackage.format.fail');
			$this->addMessage('APPCENTER:install.step.express');
			$_r = $install->initInstall();
			if (true !== $_r) $this->showError('APPCENTER:install.initinstall.fail');
			$this->addMessage('APPCENTER:install.step.init');
			$hash = $install->getHash();
			$this->addMessage('APPCENTER:install.step.install');
		}
		
		$step || $step = 0;
		$_r = $install->doInstall($step, $hash);
		if (true === $_r) {
			$install->clear();
			$this->showMessage('APPCENTER:install.success');
		} elseif (is_array($_r)) {
			$this->setOutput(array('step' => $_r[0], 'hash' => $hash), 'data');
			$this->showMessage($_r[1]);
		} else {
			$install->rollback();
			$this->addMessage(array('step' => $step, 'hash' => $hash), 'data');
			$this->showError($_r->getError());
		}
	}

	/**
	 * 测试升级流程
	 */
	public function testUpgradeAction() {
		list($file) = $this->getInput(array('file'));
		/* @var $install PwUpgradeApplication */
		$install = Wekit::load('APPS:appcenter.service.srv.PwUpgradeApplication');
		$install->_appId = 'L0001344318635mEhO';
		$file = Wind::getRealDir($install->getConfig('tmp_dir'), true) . '/' . $file;
		$install->setTmpPath(dirname($file));
		$install->extractPackage($file);
		$install->initInstall();
		$_r = $install->doUpgrade();
		if (true === $_r) {
			$install->clear();
			$this->showMessage('APPCENTER:install.success');
		} else {
			$install->rollback();
			$this->showError($_r->getError());
		}
	}

	/**
	 * 删除已上传压缩包
	 */
	public function delFileAction() {
		$file = $this->getInput('file');
		$file = ATTACH_PATH . $file;
		WindFile::del($file);
		$this->showMessage('success');
	}

	/**
	 * 应用搜索
	 */
	public function searchAction() {
		$keyword = $this->getInput('keyword', 'post');
		$apps = array();
		$count = $this->_appDs()->countSearchByName($keyword);
		if ($count > 0) {
			$page = intval($this->getInput('page'));
			$total = ceil($count / $this->perpage);
			$page < 1 && $page = 1;
			$page > $total && $page = $total;
			list($start, $num) = Pw::page2limit($page, $this->perpage);
			$apps = $this->_appDs()->searchByName($keyword, $num, $start);
		}
		$this->setOutput(
			array(
				'perpage' => $this->perpage, 
				'page' => $page, 
				'count' => $count, 
				'apps' => $apps, 
				'keyword' => $keyword, 
				'search' => 1));
		$this->setTemplate('app_run');
	}

	/**
	 * 获取扩展信息
	 */
	public function hookAction() {
		$alias = $this->getInput('alias');
		$manifest = Wind::getRealPath('SRC:extensions.' . $alias . '.Manifest.xml', true);
		$hooks = $injectors = array();
		if (is_file($manifest)) {
			Wind::import('APPS:appcenter.service.srv.helper.PwManifest');
			$man = new PwManifest($manifest);
			$hooks = $man->getHooks();
			$injectors = $man->getInjectServices();
		}
		$this->setOutput(array('hooks' => $hooks, 'injectors' => $injectors));
	}

	/**
	 * 卸载
	 */
	public function uninstallAction() {
		$id = $this->getInput('app_id');
		/* @var $uninstall PwUninstallApplication */
		if ($id[0] !== 'L') {
			$url = PwApplicationHelper::acloudUrl(
				array('a' => 'forward', 'do' => 'uninstallApp', 'appid' => $id));
			$info = PwApplicationHelper::requestAcloudData($url);
			if ($info['code'] !== '0')
				$this->showError($info['msg']);
			else
				$this->showMessage('success');
		} else {
			$uninstall = Wekit::load('APPS:appcenter.service.srv.PwUninstallApplication');
			$r = $uninstall->uninstall($id);
			if ($r === true) $this->showMessage('success');
			$this->showError($r->getError());
		}
	}

	/**
	 * 升级
	 */
	public function upgradeAction() {
		$id = $this->getInput('app_id');
		$url = PwApplicationHelper::acloudUrl(
			array('a' => 'forward', 'do' => 'upgradeApplication', 'appid' => $id));
		$info = PwApplicationHelper::requestAcloudData($url);
		if ($info['code'] !== '0')
			$this->showError(array('APPCENTER:update.fail', array($info['msg'])));
		else
			$this->showMessage('success');
	}

	/**
	 *
	 * @return PwApplication
	 */
	private function _appDs() {
		return Wekit::load('APPS:appcenter.service.PwApplication');
	}

	/**
	 * 读取创始人配置文件
	 *
	 * @return PwError array
	 */
	private function _getFounders() {
		$file = Wind::getRealPath('CONF:founder.php', true);
		if (!WindFile::isFile($file)) $this->showError('ADMIN:founder.file.exist.fail');
		$conf = include $file;
		if (!is_array($conf)) $this->showError('ADMIN:founder.file.read.fail');
		return $conf;
	}

	/**
	 *
	 * @return PwInstallApplication
	 */
	private function _installService() {
		return Wekit::load('APPS:appcenter.service.srv.PwInstallApplication');
	}
}

?>