<?php
/**
 * 应用中心本地化管理配置信息
 * 
 * @author Qiong Wu <papa0924@gmail.com> 2010-11-2
 * @link http://www.phpwind.com
 * @copyright Copyright &copy; 2003-2010 phpwind.com
 * @license
 */

return array(
	//'url' => 'https://github.com/downloads/phpwind/windframework/{appUrl}',
	'url' => 'http://open.phpwind-inc.com/attachment/{appUrl}', 
	'tmp_dir' => 'DATA:tmp', 
	'log_dir' => 'DATA:tmp', 
	'manifest' => 'Manifest.xml', 
	
	'install-type' => array(
		'app' => array(
			'class' => 'APPS:appcenter.service.srv.do.PwInstall', 
			'message' => '默认应用安装', 
			'step' => array(
				'after' => array(
					array('method' => 'registeApplication', 'message' => 'APPCENTER:install.step.registeApplication'), 
					array('method' => 'registeHooks', 'message' => 'APPCENTER:install.step.registeHooks'), 
					array(
						'method' => 'registeInjectServices', 
						'message' => 'APPCENTER:install.step.registeInjectServices'), 
					array('method' => 'registeData', 'message' => 'APPCENTER:install.step.registeData'), 
					array('method' => 'registeModules', 'message' => 'APPCENTER:install.step.registeModules'),
					array('method' => 'afterInstall', 'message' => 'APPCENTER:install.step.afterInstall')), 
				'before' => array(array('method' => 'install', 'message' => 'APPCENTER:install.step.install')))), 
		
		'style' => array(
			'class' => 'APPS:appcenter.service.srv.do.PwStyleInstall', 
			'message' => '风格安装',
			'step' => array(
				'after' => array(
					array('method' => 'registeApplication', 'message' => 'APPCENTER:install.step.registeStyle'),
					array('method' => 'afterInstall', 'message' => 'APPCENTER:install.step.movePack'),
				),
				'before' => array(array('method' => 'install', 'message' => 'APPCENTER:install.step.install'))
			),
				
	)), 
	
	'installation-service' => array(
		'admin' => array('class' => 'APPS:admin.service.srv.do.PwAdminInstall', 'message' => '注册应用 admin 扩展信息'),
		'appList' => array('class' => 'APPS:appcenter.service.srv.do.PwAppListInstall', 'message' => '注册应用列表菜单')
	), 
	
	'style-type' => array(
		// 别名 => array('名称', '相对于THEMES:目录', '预览地址')
		'site' => array('整站模板', 'site', ''), 
		'space' => array('个人空间', 'space', 'space/index/run'),
		'forum' => array('版块模板', 'forum', 'bbs/thread/run'),
		'portal' => array('门户模板', 'portal/appcenter', '')
	)
);