<?php
/**
 *
 * @author jinling.su<emily100813@gmail.com> 2012-5-28
 * @link http://www.phpwind.com
 * @copyright Copyright &copy; 2003-2010 phpwind.com
 * @version $Id: AppIndexController.php 16554 2012-08-24 09:18:35Z long.shi $
 */
class AppIndexController extends PwBaseController {

	public function run() {
		$list = (array) Wekit::config('site', 'appList');
		$ids = array_keys($list);
		$apps = array();
		$ids && $apps = $this->_appDs()->fetchByAppId($ids);
		$return = array();
		foreach ($apps as $k => $v) {
			$url = $list[$k];
			if (strpos($list[$k], 'http://') === false) {
				$url = WindUrlHelper::createUrl($list[$k]);
			}
			$return[] = array(
				'app_id' => $k, 
				'name' => $v['name'], 
				'logo' => $v['logo'], 
				'desc' => $v['description'] ? $v['description'] : '这家伙很懒', 
				'url' => $url);
		}
		$this->setOutput($return, 'apps');
		$this->setTemplate('app_index_run');
		// seo设置
		Wind::import('SRV:seo.bo.PwSeoBo');
		$lang = Wind::getComponent('i18n');
		PwSeoBo::setCustomSeo($lang->getMessage('SEO:appcenter.appindex.run.title'), '', '');
	}

	/**
	 *
	 * @return PwApplication
	 */
	private function _appDs() {
		return Wekit::load('APPS:appcenter.service.PwApplication');
	}
}