<?php
/**
 * @author Qiong Wu <papa0924@gmail.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: PwApplication.php 14072 2012-07-17 03:40:28Z long.shi $
 * @package products
 * @subpackage appcenter.service
 */
class PwApplication {

	/**
	 * 添加应用
	 *
	 * @param PwApplicationDm $application        	
	 * @return PwError true
	 */
	public function add($application) {
		$error = $application->beforeAdd();
		if (true !== $error) return new PwError('APPCENTER:validate.fail', array('error' => $error));
		return $this->_load()->add($application->getData());
	}

	/**
	 * 更具应用ID更新应用
	 *
	 * @param PwApplicationDm $application        	
	 * @return PwError true
	 */
	public function update($application) {
		if (true !== ($error = $application->beforeUpdate())) return new PwError('APPCENTER:validate.fail', 
			array('error' => $error));
		$_r = $this->_load()->update($application->getField('app_id'), $application->getData());
		if (!$_r) return new PwError('APPCENTER:update.fail');
		return true;
	}

	/**
	 * 根据appid删除
	 *
	 * @param int $app_id
	 * @return PwError|boolean
	 */
	public function delByAppId($app_id) {
		return $this->_load()->delByAppId($app_id);
	}

	/**
	 * 根据应用ID查找应用
	 *
	 * @param string $appId        	
	 * @return PwError boolean
	 */
	public function findByAppId($appId) {
		return $this->_load()->findByAppId($appId);
	}
	
	/**
	 * 根据应用名称模糊搜索
	 *
	 * @param string $name
	 * @param int $num
	 * @param int $start
	 * @return array
	 */
	public function searchByName($name, $num = 10, $start = 0) {
		return $this->_load()->searchByName($name, $num, $start);
	}
	
	/**
	 * 统计搜索结果
	 *
	 * @param string $name
	 * @return int
	 */
	public function countSearchByName($name) {
		return $this->_load()->countSearchByName($name);
	}

	/**
	 * 根据应用别名查找应用
	 *
	 * @param string $alias
	 * @return PwError|Ambigous <multitype:, boolean, multitype:unknown , mixed>
	 */
	public function findByAlias($alias) {
		return $this->_load()->findByAlias($alias);
	}

	/**
	 * 根据app_id批量获取
	 *
	 * @param array $ids
	 * @return array
	 */
	public function fetchByAppId($ids, $index = 'app_id') {
		return $this->_load()->fetchByAppId($ids, $index);
	}

	/**
	 * app列表
	 *
	 * @param int $num
	 * @param int $start
	 * @return array
	 */
	public function fetchByPage($num = 10, $start = 0, $index = 'app_id') {
		return $this->_load()->fetchByPage((int) $num, (int) $start, $index);
	}

	/**
	 * 获取app总数
	 *
	 * @return int
	 */
	public function count() {
		return $this->_load()->count();
	}

	/**
	 *
	 * @return PwApplicationDao
	 */
	private function _load() {
		return Wekit::loadDao('APPS:appcenter.service.dao.PwApplicationDao');
	}
}

?>