<?php
Wind::import('APPS:appcenter.service.srv.iPwInstall');
/**
 * 前台应用中心列表注册
 *
 * @author Shi Long <long.shi@alibaba-inc.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: PwAppListInstall.php 17152 2012-08-31 08:22:23Z long.shi $
 * @package appcenter.service.srv.do
 */
class PwAppListInstall implements iPwInstall {
	/*
	 * (non-PHPdoc) @see iPwInstall::install()
	 */
	public function install($install) {
		$list = (array) Wekit::config('site', 'appList');
		$appId = $install->getAppId();
		$manifest = $install->getManifest()->getManifest();
		$url = isset($manifest['front-url']) ? $manifest['front-url'] : $manifest['application']['alias'] . '/index/run';
		$list[$appId] = $url;
		$this->_configDs()->setConfig('site', 'appList', $list);
		$install->setInstallLog('appList', array($appId => $url));
		return true;
	}
	
	/*
	 * (non-PHPdoc) @see iPwInstall::backUp()
	 */
	public function backUp($upgrade) {
		if ($list = $upgrade->getBackLog('appList')) {
			$upgrade->setRevertLog('appList', $list);
			$appList = (array) Wekit::config('site', 'appList');
			unset($appList[key($list)]);
			$this->_configDs()->setConfig('site', 'appList', $appList);
		}
		return true;
	}
	
	/*
	 * (non-PHPdoc) @see iPwInstall::revert()
	 */
	public function revert($upgrade) {
		if ($list = $upgrade->getRevertLog('appList')) {
			$appList = (array) Wekit::config('site', 'appList');
			$appList[key($list)] = current($list);
			$this->_configDs()->setConfig('site', 'appList', $appList);
		}
		return true;
	}
	
	/*
	 * (non-PHPdoc) @see iPwInstall::unInstall()
	 */
	public function unInstall($uninstall) {
		if ($list = $uninstall->getInstallLog('appList')) {
			$appList = (array) Wekit::config('site', 'appList');
			unset($appList[key($list)]);
			$this->_configDs()->setConfig('site', 'appList', $appList);
		}
		return true;
	}
	
	/*
	 * (non-PHPdoc) @see iPwInstall::rollback()
	 */
	public function rollback($install) {
		if ($list = $install->getInstallLog('appList')) {
			$appList = (array) Wekit::config('site', 'appList');
			unset($appList[key($list)]);
			$this->_configDs()->setConfig('site', 'appList', $appList);
		}
		return true;
	}

	/**
	 *
	 * @return PwConfig
	 */
	private function _configDs() {
		return Wekit::load('config.PwConfig');
	}
}

?>