<?php
Wind::import('APPS:appcenter.service.srv.iPwInstall');
Wind::import('APPS:appcenter.service.dm.PwApplicationDm');
/**
 *
 * @author Qiong Wu <papa0924@gmail.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: PwInstall.php 18152 2012-09-11 11:15:10Z long.shi $
 * @package wind
 */
class PwInstall implements iPwInstall {
	const TARGET = 'SRC:extensions';
	const DB_TABLE = 'conf/data.sql';
	const CONTROLLER = 'controller';
	const ADMIN = 'admin';
	const TEMPLATE = 'template';
	
	/*
	 * (non-PHPdoc) @see iPwInstall::unInstall()
	 */
	public function unInstall($uninstall) {
		if ($table = $uninstall->getInstallLog('table')) {
			try {
				/* @var $db WindConnection */
				$db = Wind::getComponent('db');
				foreach ($table as $key => $value) {
					$db->execute('DROP TABLE IF EXISTS `' . $key . '`');
				}
			} catch (Exception $e) {}
		}
		if ($inject = $uninstall->getInstallLog('inject')) $this->_loadPwHookInject()->batchDel(
			$inject);
		if ($hooks = $uninstall->getInstallLog('hook')) $this->_loadPwHooks()->batchDelByName(
			$hooks);
		if ($appId = $uninstall->getInstallLog('appId')) $this->_load()->delByAppId($appId);
		if ($module = $uninstall->getInstallLog('module')) $this->_loadPwModule()->deleteModule(
			$module);
		if ($packs = $uninstall->getInstallLog('packs')) {
			foreach ($packs as $value) {
				if (is_dir($value)) WindFolder::rm($value, true);
				if (is_file($value)) WindFile::del($value);
			}
		}
		return true;
	}
	
	/*
	 * (non-PHPdoc) @see iPwInstall::install()
	 */
	public function install($install) {
		$manifest = $install->getManifest();
		
		$appId = $install->getAppId();
		$result = $this->_load()->findByAppId($appId);
		
		if ($result instanceof PwError) return $result;
		if ($result) return new PwError('APPCENTER:install.exist.fail', 
			array('{{error}}' => $manifest->getApplication('name')));
		$alias = $manifest->getApplication('alias');
		if (!$alias) return new PwError('APPCENTER:install.fail.alias.empty');
		$result = $this->_load()->findByAlias($alias);
		if ($result instanceof PwError) return $result;
		if ($result) return new PwError('APPCENTER:install.exist.fail', 
			array('{{error}}' => $manifest->getApplication('name')));
		
		$hooks = $manifest->getHooks();
		if ($hooks) {
			$result = $this->_loadPwHooks()->batchFetchByName(array_keys($hooks));
			if ($result) {
				return new PwError('HOOK:hook.exit', 
					array('{{error}}' => implode(',', array_keys($result))));
			}
		}
		
		$inject = $manifest->getInjectServices();
		if ($inject) {
			$hookNames = array();
			foreach ($inject as $value) {
				if (array_key_exists($value['hook_name'], $hooks)) continue;
				$hookNames[] = $value['hook_name'];
			}
			if ($hookNames) {
				$hook = $this->_loadPwHooks()->batchFetchByName(array_unique($hookNames));
				$result = $this->_loadPwHookInject()->fetchByHookName(array_unique($hookNames));
				$injects = array();
				foreach ($result as $v) {
					$injects[$v['hook_name']][] = $v['alias'];
				}
				if (!$hook) return new PwError('HOOK:hook.not.exit', 
					array('{{error}}' => implode(',', $hookNames)));
				foreach ($inject as $key => $value) {
					$_hookName = $value['hook_name'];
					if (!isset($hook[$_hookName])) {
						return new PwError('HOOK:hook.not.exit', array('{{error}}' => $_hookName));
					}
					if (in_array($value['alias'], $injects[$_hookName])) {
						return new PwError('HOOK:inject.exit', array('{{error}}' => $value['alias']));
					}
				}
			}
		}
		return true;
	}
	
	/*
	 * (non-PHPdoc) @see iPwInstall::backUp()
	 */
	public function backUp($upgrade) {
		/* @var $upgrade PwUpgradeApplication */
		if ($table = $upgrade->getBackLog('table')) {
			$upgrade->setRevertLog('table', $table);
			try {
				/* @var $db WindConnection */
				$db = Wind::getComponent('db');
				foreach ($table as $key => $value) {
					$db->execute('DROP TABLE IF EXISTS `' . $key . '`');
				}
			} catch (Exception $e) {}
		}
		if ($inject = $upgrade->getBackLog('inject')) {
			$upgrade->setRevertLog('inject', $this->_loadPwHookInject()->fetch($inject));
			$this->_loadPwHookInject()->batchDel($inject);
		}
		if ($hooks = $upgrade->getBackLog('hook')) {
			$upgrade->setRevertLog('hook', $this->_loadPwHooks()->batchFetchByName($hooks));
			$this->_loadPwHooks()->batchDelByName($hooks);
		}
		if ($appId = $upgrade->getBackLog('appId')) {
			$upgrade->setRevertLog('appId', $this->_load()->findByAppId($appId));
			$this->_load()->delByAppId($appId);
		}
		if ($module = $upgrade->getBackLog('module')) {
			$upgrade->setRevertLog('module', 
				array($module => $this->_loadPwModule()->getModule($module)));
			$this->_loadPwModule()->deleteModule($module);
		}
		if ($packs = $upgrade->getBackLog('packs')) {
			$targetDir = $upgrade->getTmpPath() . '/bak/';
			$log = array();
			foreach ($packs as $k => $value) {
				$target = $upgrade->getTmpPath() . '/' . basename($value) . '_' . $k . '.bak';
				if (!PwApplicationHelper::mvSourcePack($value, $target)) {
					return new PwError('APPCENTER:install.mv.fail', array('{{error}}' => $target));
				}
				$log[] = array($value, $target);
			}
			$upgrade->setRevertLog('packs', $log);
		}
		return true;
	}
	
	/*
	 * (non-PHPdoc) @see iPwInstall::revert()
	 */
	public function revert($upgrade) {
		/* @var $upgrade PwUpgradeApplication */
		if ($table = $upgrade->getRevertLog('table')) {
			try {
				/* @var $db WindConnection */
				$db = Wind::getComponent('db');
				foreach ($table as $key => $value) {
					$db->execute($value);
				}
			} catch (Exception $e) {}
		}
		if ($inject = $upgrade->getRevertLog('inject')) {
			$this->_loadPwHookInject()->batchAdd($inject);
		}
		if ($hooks = $upgrade->getRevertLog('hook')) {
			$this->_loadPwHooks()->batchAdd($hooks);
		}
		if ($app = $upgrade->getRevertLog('appId')) {
			$dm = new PwApplicationDm();
			$dm->setAppId($app['app_id']);
			$dm->setName($app['name']);
			$dm->setAlias($app['alias']);
			$dm->setVersion($app['version']);
			$dm->setPwVersion($app['pw_version']);
			$dm->setDescription($app['description']);
			$dm->setLogo($app['logo']);
			$dm->setAuthorName($app['author_name']);
			$dm->setAuthorEmail($app['author_email']);
			$dm->setAuthorIcon($app['author_icon']);
			$dm->setCreatedTime($app['created_time']);
			$dm->setModifiedTime($app['modified_time']);
			$this->_load()->add($dm);
		}
		if ($module = $upgrade->getRevertLog('module')) {
			$this->_loadPwModule()->registeModule(key($module), current($module));
		}
		if ($packs = $upgrade->getRevertLog('packs')) {
			foreach ($packs as $value) {
				if (!PwApplicationHelper::mvSourcePack($value[1], $value[0])) {
					return new PwError('APPCENTER:install.mv.fail', array('{{error}}' => $value[0]));
				}
			}
		}
		return true;
	}

	/**
	 *
	 * @see iPwInstall::afterInstall()
	 * @param PwInstallApplication $install        	
	 */
	public function afterInstall($install) {
		if ($install->getTmpPackage()) {
			$r = $this->registeResource($install);
			if ($r instanceof PwError) return $r;
			$name = $install->getManifest()->getApplication('alias');
			$targetPath = Wind::getRealPath(self::TARGET . '.' . $name, false);
			if (is_dir($targetPath)) return new PwError('APPCENTER:install.pack.exist', 
				array('{{error}}' => self::TARGET . '.' . $name));
			if (!PwApplicationHelper::mvSourcePack($install->getTmpPackage(), $targetPath)) {
				return new PwError('APPCENTER:install.mv.fail', 
					array('{{error}}' => self::TARGET . '.' . $name));
			}
			$install->addInstallLog('packs', $targetPath);
		}
		return true;
	}

	/**
	 *
	 * @see iPwInstall::rollback()
	 * @param PwInstallApplication $install        	
	 */
	public function rollback($install) {
		if ($appId = $install->getInstallLog('appId')) $this->_load()->delByAppId($appId);
		if ($hooks = $install->getInstallLog('hook')) $this->_loadPwHooks()->batchDelByName($hooks);
		if ($inject = $install->getInstallLog('inject')) $this->_loadPwHookInject()->batchDel(
			$inject);
		if ($module = $install->getInstallLog('module')) $this->_loadPwModule()->deleteModule(
			$module);
		if ($table = $install->getInstallLog('table')) {
			try {
				/* @var $db WindConnection */
				$db = Wind::getComponent('db');
				foreach ($table as $value) {
					$db->execute('DROP TABLE IF EXISTS `' . $value . '`');
				}
			} catch (Exception $e) {}
		}
		return true;
	}

	/**
	 * 注册数据文件
	 *
	 * @param PwInstallApplication $install        	
	 * @return PwError true
	 */
	public function registeData($install) {
		try {
			$sqlFile = $install->getTmpPackage() . '/' . self::DB_TABLE;
			if (!is_file($sqlFile)) return true;
			$strSql = WindFile::read($sqlFile);
			/* @var $db WindConnection */
			$db = Wind::getComponent('db');
			$sql = PwApplicationHelper::sqlParser($strSql, $db->getConfig('charset', '', 'utf8'), 
				$db->getTablePrefix(), $db->getConfig('engine', '', 'MYISAM'));
			if (!empty($sql['CREATE'])) {
				foreach ($sql['CREATE'] as $table => $statement) {
					$db->execute($statement);
				}
				$install->setInstallLog('table', $sql['CREATE']);
				foreach ($sql as $option => $statements) {
					if (!in_array($option, array('INSERT', 'UPDATE', 'REPLACE', 'ALERT'))) continue;
					foreach ($statements as $table => $statement) {
						if (!array_key_exists($table, $sql['CREATE'])) return new PwError(
							'APPCENTER:install.data.fail', array('{{error}}' => $table));
						$db->execute($statement);
					}
				}
			}
			return true;
		} catch (Exception $e) {
			return new PwError('APPCENTER:install.fail', array('{{error}}' => $e->getMessage()));
		}
	}

	/**
	 * 注册钩子信息
	 *
	 * @param PwInstallApplication $install        	
	 * @return PwError true
	 */
	public function registeHooks($install) {
		$manifest = $install->getManifest();
		$hooks = $manifest->getHooks();
		if (!$hooks) return true;
		foreach ($hooks as $key => $hook) {
			$hook['app_id'] = $install->getAppId();
			$hook['app_name'] = $install->getManifest()->getApplication('name');
			$hooks[$key] = $hook;
		}
		$this->_loadPwHooks()->batchAdd($hooks);
		$install->setInstallLog('hook', array_keys($hooks));
		return true;
	}

	/**
	 * 注册注入服务
	 *
	 * @param PwInstallApplication $install        	
	 * @return true PwError
	 */
	public function registeInjectServices($install) {
		$inject = $install->getManifest()->getInjectServices();
		if (!$inject) return true;
		$this->_loadPwHookInject()->batchAdd($inject);
		$alias = $hookName = array();
		foreach ($inject as $key => $value) {
			$alias[] = $value['alias'];
			$hookName[] = $value['hook_name'];
		}
		$injects = $this->_loadPwHookInject()->batchFetchByAlias($alias);
		foreach ($injects as $value) {
			if (!in_array($value['hook_name'], $hookName)) continue;
			$install->addInstallLog('inject', $value['id']);
		}
		return true;
	}

	/**
	 * 注册应用信息
	 *
	 * @param PwInstallApplication $install        	
	 * @return PwError true
	 */
	public function registeApplication($install) {
		$manifest = $install->getManifest();
		$application = new PwApplicationDm();
		$application->setAppId($install->getAppId());
		$application->setName($manifest->getApplication('name'));
		$application->setAlias($manifest->getApplication('alias'));
		$application->setVersion($manifest->getApplication('version'));
		$application->setPwVersion($manifest->getApplication('pw-version'));
		$application->setDescription($manifest->getApplication('description'));
		$application->setLogo($manifest->getApplication('logo'));
		$application->setWebsite($manifest->getApplication('website'));
		$application->setAuthorName($manifest->getApplication('author-name'));
		$application->setAuthorEmail($manifest->getApplication('author-email'));
		$application->setAuthorIcon($manifest->getApplication('author-icon'));
		$application->setCreatedTime(Pw::getTime());
		$application->setModifiedTime(pw::getTime());
		if (!$application->beforeAdd()) return new PwError('APPCENTER:install.mainfest.fail');
		$this->_load()->add($application);
		$install->setInstallLog('appId', $install->getAppId());
		return true;
	}

	/**
	 * 注册模块配置
	 *
	 * @param PwInstallApplication $install        	
	 * @return PwError true
	 */
	public function registeModules($install) {
		if ($tmp = $install->getTmpPackage()) {
			$alias = $install->getManifest()->getApplication('alias');
			$module = array();
			if (is_dir($tmp . '/' . self::CONTROLLER)) {
				$module['phpwind']['controller-path'] = 'SRC:extensions.' . $alias . '.' . self::CONTROLLER;
				if (is_dir($tmp . '/' . self::TEMPLATE)) {
					$module['phpwind']['template-path'] = 'SRC:extensions.' . $alias . '.' . self::TEMPLATE;
				}
			}
			if (is_dir($tmp . '/' . self::ADMIN)) {
				$module['admin']['controller-path'] = 'SRC:extensions.' . $alias . '.' . self::CONTROLLER;
				if (is_dir($tmp . '/' . self::TEMPLATE . '/admin')) {
					$module['admin']['template-path'] = 'SRC:extensions.' . $alias . '.' . self::TEMPLATE . '.admin';
				}
			}
			if (!$module) return true;
			$this->_loadPwModule()->registeModule($alias, $module);
			$install->setInstallLog('module', $alias);
		}
		return true;
	}

	/**
	 * 注册静态资源
	 *
	 * @param PwInstallApplication $install        	
	 * @return PwError true
	 */
	public function registeResource($install) {
		$manifest = $install->getManifest()->getManifest();
		if (!isset($manifest['res'])) return true;
		$name = $install->getManifest()->getApplication('alias');
		$source = $install->getTmpPackage() . '/' . str_replace('.', '/', $manifest['res']);
		$targetPath = Wind::getRealDir('THEMES:extres.' . $name, true);
		if (!is_dir($source)) return new PwError('APPCENTER:install.res.not.exist', array('{{error}}' => $manifest['res']));
		if (is_dir($targetPath)) return new PwError('APPCENTER:install.pack.exist', 
			array('{{error}}' => 'THEMES:extres.' . $name));
		if (!PwApplicationHelper::mvSourcePack($source, $targetPath)) {
			return new PwError('APPCENTER:install.mv.fail', 
				array('{{error}}' => 'THEMES:extres.' . $name));
		}
		$install->addInstallLog('packs', $targetPath);
	}

	/**
	 *
	 * @return PwHookInject
	 */
	private function _loadPwHookInject() {
		return wekit::load('SRV:hook.PwHookInject');
	}

	/**
	 *
	 * @return PwHooks
	 */
	private function _loadPwHooks() {
		return wekit::load('SRV:hook.PwHooks');
	}

	/**
	 *
	 * @return PwApplication
	 */
	private function _load() {
		return Wekit::load('APPS:appcenter.service.PwApplication');
	}

	/**
	 *
	 * @return PwModuleService
	 */
	private function _loadPwModule() {
		return Wekit::load('APPS:appcenter.service.srv.PwModuleService');
	}
}

?>