<?php
Wind::import('APPS:appcenter.service.srv.do.PwInstall');
Wind::import('APPS:appcenter.service.dm.PwStyleDm');
/**
 * 风格安装流程bp
 *
 * @author Shi Long <long.shi@alibaba-inc.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: PwStyleInstall.php 18155 2012-09-11 11:20:14Z long.shi $
 * @package service.style.srv
 */
class PwStyleInstall extends PwInstall {
	
	/*
	 * (non-PHPdoc) @see PwInstall::unInstall()
	 */
	public function unInstall($uninstall) {
		if ($appId = $uninstall->getInstallLog('appId')) $this->_load()->deleteStyle($appId);
		if ($packs = $uninstall->getInstallLog('packs')) {
			foreach ($packs as $value) {
				if (is_dir($value)) WindFolder::rm($value, true);
				if (is_file($value)) WindFile::del($value);
			}
		}
		return true;
	}
	
	/*
	 * (non-PHPdoc) @see PwInstall::install()
	 */
	public function install($install) {
		$manifest = $install->getManifest();
		
		$appId = $install->getAppId();
		$result = $this->_load()->findByAppId($appId);
		if ($result instanceof PwError) return $result;
		if ($result) return new PwError('APPCENTER:install.exist.fail');
		$alias = $manifest->getApplication('alias');
		if (!$alias) return new PwError('APPCENTER:install.fail.alias.empty');
		
		list($type) = $this->getStyleType($install);
		$result = $this->_load()->fetchStyleByAliasAndType($alias, $type);
		if ($result instanceof PwError) return $result;
		if ($result) return new PwError('APPCENTER:install.exist.fail', 
			array('{{error}}' => $manifest->getApplication('name')));
		
		return true;
	}
	
	/* (non-PHPdoc)
	 * @see PwInstall::backUp()
	 */
	public function backUp($upgrade) {
		/* @var $upgrade PwUpgradeApplication */
		if ($appId = $upgrade->getBackLog('appId')) {
			$upgrade->setRevertLog('appId', $this->_load()->findByAppId($appId));
			$this->_load()->deleteStyle($appId);
		}
		if ($packs = $upgrade->getBackLog('packs')) {
			$targetDir = $upgrade->getTmpPath() . '/bak/';
			$log = array();
			foreach ($packs as $value) {
				$target = $upgrade->getTmpPath() . '/' . basename($value) . '.bak';
				if (!PwApplicationHelper::mvSourcePack($value, $target)) {
					return new PwError('APPCENTER:install.mv.fail', array('{{error}}' => $target));
				}
				$log[] = array($value, $target);
			}
			$upgrade->setRevertLog('packs', $log);
		}
		return true;
	}
	
	/* (non-PHPdoc)
	 * @see PwInstall::revert()
	 */
	public function revert($upgrade) {
		/* @var $upgrade PwUpgradeApplication */
		if ($app = $upgrade->getRevertLog('appId')) {
			$dm = new PwStyleDm();
			$dm->setAppId($app['app_id']);
			$dm->setName($app['name']);
			$dm->setAlias($app['alias']);
			$dm->setVersion($app['version']);
			$dm->setPwVersion($app['pw_version']);
			$dm->setDescription($app['description']);
			$dm->setLogo($app['logo']);
			$dm->setAuthorName($app['author_name']);
			$dm->setAuthorEmail($app['author_email']);
			$dm->setAuthorIcon($app['author_icon']);
			$dm->setCreatedTime($app['created_time']);
			$dm->setModifiedTime($app['modified_time']);
			$dm->setType($app['style_type']);
			$this->_load()->addStyle($dm);
		}
		if ($packs = $upgrade->getRevertLog('packs')) {
			foreach ($packs as $value) {
				if (!PwApplicationHelper::mvSourcePack($value[1], $value[0])) {
					return new PwError('APPCENTER:install.mv.fail', array('{{error}}' => $value[0]));
				}
			}
		}
		return true;
	}

	/**
	 * (non-PHPdoc)
	 *
	 * @see PwInstall::afterInstall()
	 * @param PwInstallApplication $install        	
	 */
	public function afterInstall($install) {
		list(, $pack) = $this->getStyleType($install);
		$alias = $install->getManifest()->getApplication('alias');
		$targetDir = 'THEMES:' . $pack;
		$target = Wind::getRealDir($targetDir . '.' . $alias);
		if (is_dir($target)) return new PwError('APPCENTER:install.pack.exist',
			array('{{error}}' => $targetDir));
		if (!PwApplicationHelper::mvSourcePack($install->getTmpPackage(), $target)) {
			return new PwError('APPCENTER:install.mv.fail', array('{{error}}' => $targetDir));
		}
		$install->addInstallLog('packs', $target);
		return true;
	}

	/**
	 *
	 * @see PwInstall::rollback()
	 * @param PwInstallApplication $install        	
	 */
	public function rollback($install) {
		if (!$install instanceof PwInstallApplication) return false;
		if ($appId = $install->getInstallLog('appId')) $this->_load()->deleteStyle($appId);
		return true;
	}

	/**
	 * 注册应用信息
	 *
	 * @param PwInstallApplication $install        	
	 * @return PwError true
	 */
	public function registeApplication($install) {
		$manifest = $install->getManifest();
		$application = new PwStyleDm();
		$application->setAppId($install->getAppId());
		$application->setName($manifest->getApplication('name'));
		$application->setAlias($manifest->getApplication('alias'));
		$application->setVersion($manifest->getApplication('version'));
		$application->setPwVersion($manifest->getApplication('pw-version'));
		$application->setDescription($manifest->getApplication('description'));
		$application->setLogo($manifest->getApplication('logo'));
		$application->setWebsite($manifest->getApplication('website'));
		$application->setAuthorName($manifest->getApplication('author-name'));
		$application->setAuthorEmail($manifest->getApplication('author-email'));
		$application->setAuthorIcon($manifest->getApplication('author-icon'));
		$application->setCreatedTime(Pw::getTime());
		$application->setModifiedTime(pw::getTime());
		list($type) = $this->getStyleType($install);
		$application->setType($type);
		if (!$application->beforeAdd()) return new PwError('APPCENTER:install.mainfest.fail');
		$this->_load()->addStyle($application);
		$install->setInstallLog('appId', $install->getAppId());
		return true;
	}

	/**
	 *
	 * @param PwInstallApplication $install        	
	 */
	protected function getStyleType($install) {
		$allow_style_type = $install->getConfig('style-type');
		$style_type = $install->getManifest()->getApplication('style-type');
		if (!$style_type || !isset($allow_style_type[$style_type])) {
			$style_type = key($allow_style_type);
		}
		return array($style_type, $allow_style_type[$style_type][1]);
	}

	/**
	 *
	 * @return PwStyle
	 */
	private function _load() {
		return Wekit::load('APPS:appcenter.service.PwStyle');
	}
}

?>