<?php
/**
 * 帮助服务
 *
 * @author Qiong Wu <papa0924@gmail.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: PwApplicationHelper.php 18098 2012-09-11 07:12:59Z long.shi $
 * @package wind
 */
class PwApplicationHelper {

	/**
	 * 解析sql语句，并返回解析后的结果
	 *
	 * @param string $strSQL
	 * @param string $charset
	 * @param string $dbprefix
	 * @return array($sqlStatement,$sqlOptions)
	 */
	static public function sqlParser($strSQL, $charset, $dbprefix, $engine) {
		if (empty($strSQL)) return array();
		
		$dataSQL = array();
		$strSQL = str_replace(array("\r", "\n", "\r\n"), "\n", $strSQL);
		$arrSQL = explode("\n", $strSQL);
		$query = '';
		foreach ($arrSQL as $value) {
			$value = trim($value, " \t");
			if (!$value || substr($value, 0, 2) === '--') continue;
			$query .= $value;
			if (substr($query, -1) != ';') continue;
			$sql_key = strtoupper(substr($query, 0, strpos($query, ' ')));
			preg_match('/(DROP\s+TABLE\s+IF\s+EXISTS|CREATE\s+TABLE|INSERT\s+INTO|REPLACE\s+INTO)\s+`?(\w+)`?/is', 
				$query, $matches);
			$tablename = $matches['2'];
			$_tablename = preg_replace('/(pw_)(.*?)/i', $dbprefix . '\2', $tablename);
			if ($sql_key == 'CREATE') {
				$query = preg_replace('/\)([\w\s=]*);/i', ')ENGINE=' . $engine . ' DEFAULT CHARSET=' . $charset, $query);
			}
			$query = str_replace($tablename, $_tablename, $query);
			$dataSQL[$sql_key][$_tablename] = trim($query, ';');
			$query = '';
		}
		return $dataSQL;
	}

	/**
	 * @param string $logfile
	 * @return array
	 */
	static public function readInstallLog($logfile, $key = '') {
		static $log = array();
		if (!isset($log[$logfile])) {
			$log[$logfile] = is_file($logfile) ? @include $logfile : array();
		}
		return $key ? (isset($log[$logfile][$key]) ? $log[$logfile][$key] : '') : $log[$logfile];
	}

	/**
	 * 写log
	 *
	 * @param string $logfile
	 * @param array $data
	 * @param boolean $additional
	 */
	static public function writeInstallLog($logfile, $data, $additional = false) {
		if ($additional) {
			$_data = self::readInstallLog($logfile);
			if ($_data) {
				$data = array_merge($_data, $data);
			}
		}
		return WindFile::savePhpData($logfile, $data);
	}

	/**
	 * 获取在线应用中心访问地址
	 *
	 * @param array $args
	 * @return string
	 */
	static public function acloudUrl($args) {
		require_once Wind::getRealPath('ACLOUD:aCloud');
		Wind::import('ACLOUD:system.bench.service.ACloudSysBenchServiceAdministor');
		$administor = new ACloudSysBenchServiceAdministor();
		return $administor->getLink($args);
	}

	/**
	 * 请求一个Aclude数据信息
	 * 
	 * @param array $args
	 * @param string $tmpdir
	 */
	static public function requestAcloudData($url, $tmpdir = '') {
		Wind::import('WIND:http.transfer.WindHttpCurl');
		$http = new WindHttpCurl($url);
		if ($tmpdir !== '') {
			WindFolder::mkRecur($tmpdir);
			$_tmp = $tmpdir . '/tmp.' . Pw::getTime();
			$fp = fopen($_tmp, "w");
			$opt = array(
				CURLOPT_FILE => $fp, 
				CURLOPT_HEADER => 0, 
				CURLOPT_FOLLOWLOCATION => true, 
				CURLOPT_SSL_VERIFYPEER => false, 
				CURLOPT_SSL_VERIFYHOST => false);
			$http->send('GET', $opt);
			$info = $http->getInfo();
			$realname = basename($info["url"]);
			$http->close();
			fclose($fp);
			chmod($_tmp, 0766);
			rename($_tmp, $tmpdir . '/' . $realname);
			$result = $tmpdir . '/' . $realname;
		} else {
			$result = $http->send('GET');
			$result && $result = WindJson::decode($result);
		}
		return $result;
	}

	/**
	 * 将原安装包中的文件目录，移动到指定位置
	 *
	 * 将原安装包中的文件目录移动到指定位置
	 * @param 原位置 $source
	 * @param 目标位置 $target
	 * @return boolean|PwError
	 */
	static public function mvSourcePack($source, $target) {
		return !is_dir($target) && @rename($source, $target);
	}

	/**
	 * 从应用平台下载安装包到本地,
	 *
	 * @param string $url        	
	 * @param string $tmpdir        	
	 * @return string
	 */
	static public function download($url, $tmpdir) {
		WindFolder::mkRecur($tmpdir);
		$_tmp = $tmpdir . '/tmp.' . Pw::getTime();
		$fp = fopen($_tmp, "w");
		$curl = curl_init($url);
		curl_setopt_array($curl, 
			array(
				CURLOPT_FILE => $fp, 
				CURLOPT_HEADER => 0, 
				CURLOPT_FOLLOWLOCATION => true, 
				CURLOPT_SSL_VERIFYPEER => false, 
				CURLOPT_SSL_VERIFYHOST => false));
		curl_exec($curl);
		$info = curl_getinfo($curl);
		$realname = basename($info["url"]);
		curl_close($curl);
		fclose($fp);
		chmod($_tmp, 0766);
		rename($_tmp, $tmpdir . '/' . $realname);
		
		/* @var $handler WindHttpCurl */
		/* $handler = WindHttpCurl::getInstance($url);
		$data = $handler->send(WindHttpCurl::GET, 
			array(
				CURLOPT_HEADER => 0, 
				CURLOPT_FOLLOWLOCATION => true, 
				CURLOPT_SSL_VERIFYPEER => false, 
				CURLOPT_SSL_VERIFYHOST => false));
		WindFile::write($_tmp, $data); */
		return $tmpdir . '/' . $realname;
	}

	/**
	 * 解压压缩包,将源文件解压至目标文件
	 * 目前只支持zip文件的解压，返回解后包文件绝对路径地址
	 * 
	 * @param string $source        	
	 * @param string $target        	
	 * @return string
	 */
	static public function extract($source, $target) {
		Wind::import('APPS:appcenter.service.srv.helper.PwExtractZip');
		$zip = new PwExtractZip();
		if (!$data = $zip->extract($source)) return false;
		$_tmp = '';
		foreach ($data as $value) {
			if ($_tmp === '') list($_tmp) = explode('/', $value['filename'], 2);
			$filename = $target . '/' . $value['filename'];
			WindFolder::mkRecur(dirname($filename));
			WindFile::write($filename, $value['data']);
		}
		return $_tmp ? $target . '/' . $_tmp : false;
	}
	
}

?>