<?php
Wind::import('ADMIN:library.AdminBaseController');
/**
 * 后台菜单管理操作类
 *
 * @author Qiong Wu <papa0924@gmail.com> 2011-10-21
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: SetbbsController.php 17985 2012-09-10 12:59:55Z jieyin $
 * @package admin
 * @subpackage controller
 */

Wind::import('SRV:config.bo.PwConfigBo');

class SetbbsController extends AdminBaseController {
	
	public function run(){
		$this->forwardAction('bbs/setbbs/thread');
		$service = $this->_loadConfigService();
		$config = $service->getValues('bbs');
		$this->setOutput($config, 'config');
	}
	
	public function dorunAction(){
		list($showBirthdayMembers,$showLinks,$showOnlineUsers,$listOnlineUsers) = $this->getInput(array('show_birthday_members','show_links','show_online_users','list_online_users'));
		$config = new PwConfigBo('bbs');
		$config->set('index.show_birthday_members', $showBirthdayMembers)
			->set('index.show_links', $showLinks)
			->set('index.show_online_users', $showOnlineUsers)
			->set('index.list_online_users', $listOnlineUsers)
			->flush();
		$this->showMessage('success');
	}
	
	public function threadAction(){
		$service = $this->_loadConfigService();
		$config = $service->getValues('bbs');
		$this->setOutput($config, 'config');
	}
	
	public function dothreadAction(){
		list($newThreadMinutes, $perpage, $maxPages, $leftsideWidth, $hotthreadReplies) = $this->getInput(array('new_thread_minutes', 'perpage', 'max_pages', 'leftside_width', 'hotthread_replies'));
		$config = new PwConfigBo('bbs');
		$config->set('thread.new_thread_minutes', $newThreadMinutes)
			->set('thread.perpage', $perpage)
			->set('thread.max_pages', $maxPages)
			->set('thread.leftside_width', $leftsideWidth)
			->set('thread.hotthread_replies', $hotthreadReplies)
			->flush();
		$this->showMessage('success');
	}
	
	public function readAction(){
		$service = $this->_loadConfigService();
		$config = $service->getValues('bbs');
		
		$order = $config['read.display_info_vieworder'];
		is_array($order) || $order = array();
		
		$allInfo = array(
			'uid' => 'UID',
			'regdate' => '注册日期',
			'lastvisit' => '最后登录',
			'fans' => '粉丝',
			'follows' => '关注',
			'posts' => '发帖数',
			'homepage' => '个人主页',
			'location' => '来自',
			'qq' => 'QQ',
			'aliww' => '阿里旺旺',
			'birthday' => '生日',
			'hometown' => '家乡',
		);
		Wind::import('SRV:credit.bo.PwCreditBo');
		foreach (PwCreditBo::getInstance()->cType as $key => $value) {
			$allInfo[$key] = $value;
		}
		$i = 10000;
		foreach ($allInfo as $key => $value) {
			(!isset($order[$key]) || $order[$key] === '') && $order[$key] = $i++;
		}
		asort($order);
		reset($order);
		
		$this->setOutput($order, 'order');
		$this->setOutput($allInfo, 'allInfo');
		$this->setOutput($config, 'config');
	}
	
	public function doreadAction(){
		list($perpage, $anonymousDisplayname, $shiledBanThreads, $floorName, $definedFloorName, $displayMemberInfo, $display_info_vieworder, $displayInfo) = $this->getInput(array('perpage', 'anoymous_displayname', 'shield_banthreads', 'floor_name', 'defined_floor_name', 'display_member_info', 'display_info_vieworder', 'display_info'));
		
		$i = 10000;
		foreach ($display_info_vieworder as $key => $value) {
			$value === '' && $display_info_vieworder[$key] = $i++;
		}
		asort($display_info_vieworder);
		reset($display_info_vieworder);
		$i = 0;
		$tmp = array();
		foreach ($display_info_vieworder as $key => $value) {
			$display_info_vieworder[$key] = $i++;
			isset($displayInfo[$key]) && $tmp[$key] = 1;
		}

		$config = new PwConfigBo('bbs');
		$config->set('read.perpage', $perpage)
			->set('read.anoymous_displayname', $anonymousDisplayname)
			->set('read.shield_banthreads', $shiledBanThreads)
			->set('read.floor_name', $floorName)
			->set('read.defined_floor_name', $definedFloorName)
			->set('read.display_member_info', $displayMemberInfo)
			->set('read.display_info_vieworder', $display_info_vieworder)
			->set('read.display_info', $tmp)
			->flush();
		$this->showMessage('success', 'bbs/setbbs/read');
	}
	
	protected function _loadConfigService() {
		return Wekit::load('config.PwConfig');
	}
}
?>