<?php
Wind::import('LIB:base.PwBaseController');

/**
 * 我的帖子回复
 *
 * @author jinlong.panjl <jinlong.panjl@aliyun-inc.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: ArticleController.php 15836 2012-08-14 06:19:15Z long.shi $
 * @package wind
 */
class ArticleController extends PwBaseController {
	private $perpage = 20;
	
	public function beforeAction($handlerAdapter) {
		parent::beforeAction($handlerAdapter);
		if (!$this->loginUser->isExists()) {
			$this->forwardAction('u/login/run',array('backurl' => WindUrlHelper::createUrl('bbs/article/run')));
		}
	}
	
	public function run() {
		list($page, $perpage) = $this->getInput(array('page', 'perpage'));
		$page = $page ? $page : 1;
		$perpage = $perpage ? $perpage : $this->perpage;
		list($start, $limit) = Pw::page2limit($page, $perpage);
		$count = $this->_getThreadExpandDs()->countDisabledThreadByUid($this->loginUser->uid);
		if ($count) {
			$threads = $this->_getThreadExpandDs()->getDisabledThreadByUid($this->loginUser->uid,$limit,$start);
			$topic_type = array();
			foreach ($threads as $v) {
				$topic_type[] = $v['topic_type'];
			}
			$topictypes = Wekit::load('forum.PwTopicType')->fetchTopicType($topic_type);
		}
		$this->setOutput($count, 'count');
		$this->setOutput($page, 'page');
		$this->setOutput($perpage, 'perpage');
		$this->setOutput($threads, 'threads');
		$this->setOutput($topictypes, 'topictypes');
		
		// seo设置
		Wind::import('SRV:seo.bo.PwSeoBo');
		$lang = Wind::getComponent('i18n');
		PwSeoBo::setCustomSeo($lang->getMessage('SEO:bbs.article.run.title'), '', '');
	}
	
	public function replyAction() {
		list($page, $perpage) = $this->getInput(array('page', 'perpage'));
		$page = $page ? $page : 1;
		$perpage = $perpage ? $perpage : $this->perpage;
		list($start, $limit) = Pw::page2limit($page, $perpage);
		$count = $this->_getThreadExpandDs()->countDisabledPostByUid($this->loginUser->uid);
		if ($count) {
			$tmpPosts = $this->_getThreadExpandDs()->getDisabledPostByUid($this->loginUser->uid,$limit,$start);
			$posts = $tids = array();
			foreach ($tmpPosts as $v) {
				$tids[] = $v['tid'];
			}
			$threads = $this->_getThreadDs()->fetchThread($tids);
			foreach ($tmpPosts as $v) {
				$v['threadSubject'] = WindString::substr($threads[$v['tid']]['subject'], 0, 30, '', true);
				$v['content'] = WindString::substr($v['content'], 0, 30, '', true);
				$v['created_time'] = PW::time2str($v['created_time'],'auto');
				$posts[] = $v;
			}
		}
		$this->setOutput($count, 'count');
		$this->setOutput($page, 'page');
		$this->setOutput($perpage, 'perpage');
		$this->setOutput($posts, 'posts');
		
		// seo设置
		Wind::import('SRV:seo.bo.PwSeoBo');
		$lang = Wind::getComponent('i18n');
		PwSeoBo::setCustomSeo($lang->getMessage('SEO:bbs.article.reply.title'), '', '');
	}
	
	/**
	 * Enter description here ...
	 *
	 * @return PwThreadExpand
	 */
	protected function _getThreadExpandDs() {
		return Wekit::load('forum.PwThreadExpand');
	}
	
	/**
	 * Enter description here ...
	 *
	 * @return PwThread
	 */
	protected function _getThreadDs() {
		return Wekit::load('forum.PwThread');
	}
}
?>