<?php

/**
 * 附件操作
 *
 * @author Jianmin Chen <sky_hold@163.com>
 * @license http://www.phpwind.com
 * @version $Id: AttachController.php 17993 2012-09-10 13:15:53Z jieyin $
 * @package forum
 */

class AttachController extends PwBaseController {

	public function run() {

	}

	public function downloadAction() {
		
		$aid = $this->getInput('aid', 'get');
		$attach = Wekit::load('attach.PwThreadAttach')->getAttach($aid);
		
		Wind::import('SRV:forum.bo.PwForumBo');
		$forum = new PwForumBo($attach['fid']);
		if (!$forum->isForum()) {
			$this->showError('data.error');
		}
		if (!$forum->allowDownload($this->loginUser)) {
			$this->showError(array('BBS:forum.permissions.download.allow', array('{grouptitle}' => $this->loginUser->getGroupInfo('name'))));
		}
		if (!$forum->foruminfo['allow_download'] && !$this->loginUser->getPermission('allow_download')) {
			$this->showError(array('permission.download.allow', array('{grouptitle}' => $this->loginUser->getGroupInfo('name'))));
		}
		if ($attach['cost'] && $attach['created_userid'] != $this->loginUser->uid) {
			$attachbuy = Wekit::load('attach.PwThreadAttachBuy');
			if (!$attachbuy->getByAidAndUid($aid, $this->loginUser->uid)) {
				if ($attach['cost'] > $this->loginUser->getCredit($attach['ctype'])) {
					$this->showError('BBS:thread.attachbuy.error.credit.notenough');
				}

				Wind::import('SRV:attach.dm.PwThreadAttachBuyDm');
				$dm = new PwThreadAttachBuyDm();
				$dm->setAid($aid)
					->setCreatedUserid($this->loginUser->uid)
					->setCreatedTime(Pw::getTime())
					->setCtype($attach['ctype'])
					->setCost($attach['cost']);
				Wekit::load('attach.PwThreadAttachBuy')->add($dm);

				Wind::import('SRV:credit.bo.PwCreditBo');
				$creditBo = PwCreditBo::getInstance();
				$creditBo->addLog('attach_buy', array($attach['ctype'] => -$attach['cost']), $this->loginUser, array(
					'name' => $attach['name']
				));
				$creditBo->set($this->loginUser->uid, $attach['ctype'], -$attach['cost'], true);
				
				$user = new PwUserBo($attach['created_userid']);
				if (($max = $user->getPermission('sell_credit_range.maxincome')) && Wekit::load('attach.PwThreadAttachBuy')->sumCost($aid) > $max) {

				} else {
					$creditBo->addLog('attach_sell', array($attach['ctype'] => $attach['cost']), $user, array(
						'name' => $attach['name']
					));
					$creditBo->set($user->uid, $attach['ctype'], $attach['cost'], true);
				}
				$creditBo->execute();
			}
		}
		Wind::import('SRV:attach.dm.PwThreadAttachDm');
		$dm = new PwThreadAttachDm($aid);
		$dm->addHits(1);
		Wekit::load('attach.PwThreadAttach')->updateAttach($dm);

		// 积分
		$this->_operateCredit('download_att', $forum);
		
		$filename = basename($attach['path']);
		$fileext = substr(strrchr($attach['path'], '.'), 1);
		$filesize = 0;
		if (strpos(Wind::getApp()->getRequest()->getServer('HTTP_USER_AGENT'), 'MSIE') !== false && $fileext == 'torrent') {
			$attachment = 'inline';
		} else {
			$attachment = 'attachment';
		}
		$attach['name'] = trim(str_replace('&nbsp;', ' ', $attach['name']));
		if (Wekit::app()->charset == 'utf-8') {
			$attach['name'] = Pw::convert($attach['name'], "gbk", 'utf-8');
		}
		$fgeturl = ATTACH_PATH . $attach['path'];
		$filesize = filesize($fgeturl);

		/*
		if ($db_attachhide && $attach['size'] > $db_attachhide && $attach['type'] == 'zip' && !defined('FX')) {
			ObHeader($fgeturl[0]);
		} elseif ($fgeturl[1] == 'Local') {
			$fgeturl[0] = R_P . $fgeturl[0];
			$filesize = filesize($fgeturl[0]);
		}
		*/
		$timestamp = Pw::getTime();
		$ctype = '';
		switch ($fileext) {
			case "pdf":
				$ctype = "application/pdf";
				break;
			case "rar":
			case "zip":
				$ctype = "application/zip";
				break;
			case "doc":
				$ctype = "application/msword";
				break;
			case "xls":
				$ctype = "application/vnd.ms-excel";
				break;
			case "ppt":
				$ctype = "application/vnd.ms-powerpoint";
				break;
			case "gif":
				$ctype = "image/gif";
				break;
			case "png":
				$ctype = "image/png";
				break;
			case "jpeg":
			case "jpg":
				$ctype = "image/jpeg";
				break;
			case "wav":
				$ctype = "audio/x-wav";
				break;
			case "mpeg":
			case "mpg":
			case "mpe":
				$ctype = "video/x-mpeg";
				break;
			case "mov":
				$ctype = "video/quicktime";
				break;
			case "avi":
				$ctype = "video/x-msvideo";
				break;
			case "txt":
				$ctype = "text/plain";
				break;
			default:
				$ctype = "application/octet-stream";
		}
		ob_end_clean();
		header('Last-Modified: ' . gmdate('D, d M Y H:i:s', $timestamp + 86400) . ' GMT');
		header('Expires: ' . gmdate('D, d M Y H:i:s', $timestamp + 86400) . ' GMT');
		header('Cache-control: max-age=86400');
		header('Content-Encoding: none');
		header("Content-Disposition: $attachment; filename=\"{$attach['name']}\"");
		header("Content-type: $ctype");
		header("Content-Transfer-Encoding: binary");
		$filesize && header("Content-Length: $filesize");
		$i = 1;
		while (!@readfile($fgeturl)) {
			if (++$i > 3) break;
		}
		$this->setTemplate('');
	}

	public function deleteAction() {

		$aid = $this->getInput('aid', 'get');
		if (!$attach = Wekit::load('attach.PwThreadAttach')->getAttach($aid)) {
			$this->showError('data.error');
		}

		Wind::import('SRV:forum.bo.PwForumBo');
		$forum = new PwForumBo($attach['fid']);
		if (!$forum->isForum()) {
			$this->showError('data.error');
		}
		
		if ($this->loginUser->uid != $attach['created_userid'] && !$this->loginUser->getPermission('operate_thread.deleteatt', $forum->isBM($this->loginUser->username))) {
			$this->showError('permission.attach.delete.deny');
		}

		Wekit::load('attach.PwThreadAttach')->deleteAttach($aid);
		Pw::deleteAttach($attach['path'], $attach['ifthumb']);
		
		if ($attach['tid']) {
			if (!$attach['pid']) {
				$thread = Wekit::load('forum.PwThread')->getThread($attach['tid'], PwThread::FETCH_ALL);
				Wind::import('SRV:forum.dm.PwTopicDm');
				$dm = new PwTopicDm($attach['tid']);
			} else {
				$thread = Wekit::load('forum.PwThread')->getPost($attach['pid']);
				Wind::import('SRV:forum.dm.PwReplyDm');
				$dm = new PwReplyDm($attach['pid']);
			}
			if ($thread['aids'] > 0) {
				$thread['aids']--;
			}
			$dm->setAids($thread['aids']);
			if (($content = str_replace('[attachment=' . $aid . ']', '', $thread['content'])) != $thread['content']) {
				$dm->setContent($content);
			}
			if (!$attach['pid']) {
				Wekit::load('forum.PwThread')->updateThread($dm);
			} else {
				Wekit::load('forum.PwThread')->updatePost($dm);
			}
		}

		$this->showMessage('success');
	}
	
	/**
	 * 积分操作
	 */
	/**
	 * 更新积分
	 */
	protected function _operateCredit($operate, PwForumBo $forum) {
		Wind::import('SRV:credit.bo.PwCreditBo');
		$credit = PwCreditBo::getInstance();
		$user = PwUserBo::getLoginUser();
		$credit->operate($operate, $user, true, array('forumname' => $forum->foruminfo['name']),$forum->getCreditSet($operate));
		$credit->execute();
	}
}