<?php

Wind::import('SRV:forum.srv.dataSource.PwFetchTopicByTid');
Wind::import('SRV:forum.srv.PwThreadManage');

/**
 * 帖子-管理操作
 *
 * @author peihong <jhqblxt@gmail.com> Dec 2, 2011
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: ManageController.php 17196 2012-09-04 03:35:46Z xiaoxia.xuxx $
 * @package src.applications.bbs.controller
 */
class ManageController extends PwBaseController {
	
	public $action;
	
	protected $singleData = array();
	protected $manage;
	protected $doAction;
	protected $doCancel = array();
	
	/**
	 * preprocessing before any manage action
	 * 
	 * @see base/PwBaseController::beforeAction()
	 */
	public function beforeAction($handlerAdapter) {
		parent::beforeAction($handlerAdapter);

		if (!$this->loginUser->isExists()) {
			$this->showError('login.not');
		}
		$this->action = $handlerAdapter->getAction();
		$this->manage = $this->_getManage($this->action);
		if (($result = $this->manage->check()) !== true) {
			if (false === $result) $this->showError(new PwError('BBS:manage.permission.deny'));
			$this->showError($result->getError());
		}
		/*
		$action = $handlerAdapter->getAction();
		
		//get tids
		$tids = $this->getInput('tids');
		$tid = $this->getInput('tid');
		if ($tids && !is_array($tids)) {
			$tids = explode(',', $tids);
		} elseif (!$tids && $tid) {
			$tids = array($tid);
		}
		
		//empty threads
		if (!$tids) {
			$error = new PwError('BBS:manage.error.empty.threads');
			$this->showMessage($error->getError());
		}
		
		//set if a single thread manage
		count($tids) == 1 && $this->manageSingleThread = true;
		$this->tids = $tids;

		//set params for manage
		$this->params = $this->getInput('params');
		
		//set manage handler
		$this->manage = $this->_getManage($action);
		
		//set current action
		$this->action = $action;

		//set layout for common request
		if (!$this->getRequest()->getIsAjaxRequest()){
			$this->setLayout('layout_manage_threads');
		}

		//set current action
		$this->setOutput($action,'action');
		
		//set post action
		$this->setOutput($this->_getFormUrl(),'manage_formurl');
		*/
	}
	
	/**
	 * 
	 * manage action
	 */
	public function manageAction() {
		if (!$this->doAction) {
			$this->setOutput($this->action, 'action');
			$this->setTemplate('manage_threads');
		} else {
			if ($this->manage->user->getPermission('force_operate_reason')) {
				$reason = $this->getInput('reason');
				$reason or $this->showError('BBS:manage.error.empty.reason');
			}
			$sendnotice = $this->getInput('sendnotice', 'post');
			$this->manage->execute();
			if ($sendnotice) {
				$this->_sendMessage($this->action, $this->manage->getData());
			}
			$this->showMessage('operate.success');
		}

		/*
		if (!$this->manage) {
			$error = new PwError('BBS:manage.undefined.thread.manage');
			$this->showError($error->getError());
		}
		if ($this->manage instanceof PwError) {
			$this->showError($this->manage->getError());
		}
		$result = $this->manage->check();
		if ($result instanceof PwError) {
			$this->showError($result->getError());
		}
		
		if ($this->doAction) {
			//manage reason
			if ($this->loginUser->getPermission('force_operate_reason') && !$this->params['_other']['reason']) {
				$this->showError('BBS:manage.error.empty.reason');
			}
			
			$result = $this->manage->execute();
			if ($result instanceof PwError) $this->showError($result->getError());
			
			//send notice
			if ($this->params['_other']['sendnotice']) {
				$this->_sendMessage($this->action,$this->manage->threadsInfo);
			}
			$this->showMessage('BBS:manage.operate.success');
		} else {
			//get defalut values for single thread manage
			if ($this->manageSingleThread) {
				//$defaultValues = $this->manage->getDefaultValue();
				$defaultValues = $this->_getDefaultValues();
				$this->setOutput($defaultValues,'defaultValues');
			}
			$this->setOutput($this->action, 'action');
			$this->setOutput($this->tids,'tids');
		}
		*/
	}
	
	/**
	 * get manage handler
	 * 
	 * @param $action
	 */
	protected function _getManage($action) {
		$tids = $this->getInput('tids');
		$tid = $this->getInput('tid');
		if ($tids && !is_array($tids)) {
			$tids = explode(',', $tids);
		} elseif (!$tids && $tid) {
			$tids = array($tid);
		}
		$manage = new PwThreadManage(new PwFetchTopicByTid($tids), $this->loginUser);

		if (strpos($action,'do') === 0 && $action != 'down') {
			$this->doAction = true;
		} else {
			$this->doAction = false;

			$this->setOutput('帖子操作', 'title');
			$this->setOutput(count($manage->getData()), 'count');
			
			if (count($data = $manage->getData()) == 1) {
				$this->singleData = current($data);
			}
		}
		switch ($action) {
			case 'delete':
			case 'dodelete':
				$do = $this->_getDeleteManage($manage);
				break;
			case 'ban':
			case 'doban':
				$do = $this->_getBanManage($manage);
				break;
			case 'topped':
			case 'digest':
			case 'highlight':
			case 'up':
			case 'lock':
			case 'down':
			case 'copy':
			case 'type':
			case 'move':
			case 'docombined':
				$do = $this->_getCombinedManage($manage);
				break;
			default:
				$do = null;
				break;
		}
		if (is_array($do)) {
			foreach ($do as $do1) {
				$manage->appendDo($do1);
			}
		} else {
			$manage->appendDo($do);
		}
		return $manage;
	}
	
	protected function _getCombinedManage($manage) {
		$do = array();
		if (!$this->doAction) {
			$operateThread = $manage->getPermission();
			$method = sprintf('_get%sManage', ucfirst($this->action));
			$do[] = $this->$method($manage);
			$others = $this->_getOtherActions($this->action);
			foreach ($others as $key => $value) {
				if ($operateThread[$value]) {
					$method = sprintf('_get%sManage', ucfirst($value));
					$do[] = $this->$method($manage);
				}
			}
			$this->setOutput($operateThread, 'operateThread');
			$this->setOutput('docombined', 'doaction');
		} else {
			$actions = $this->getInput('actions', 'post');
			foreach ($actions as $key => $value) {
				$method = sprintf('_get%sManage', ucfirst($value));
				$do[] = $this->$method($manage);
			}
		}
		return $do;
	}

	protected function _getOtherActions($action) {
		$a1 = array('topped', 'digest', 'up', 'highlight', 'copy', 'type', 'move');
		$a2 = array('lock', 'down');
		if (in_array($action, $a1)) {
			return array_diff($a1, array($action));
		}
		if (in_array($action, $a2)) {
			return array_diff($a2, array($action));
		}
		return array();
	}

	protected function _getDigestManage($manage) {
		Wind::import('SRV:forum.srv.manage.PwThreadManageDoDigest');
		$do = new PwThreadManageDoDigest($manage);
		if (!$this->doAction) {

		} else {
			$digest = $this->getInput('digest', 'post');
			$do->setDigest($digest);
			!$digest && $this->doCancel[] = 'dodigest';
		}
		return $do;
	}

	protected function _getToppedManage($manage) {
		Wind::import('SRV:forum.srv.manage.PwThreadManageDoTopped');
		$do = new PwThreadManageDoTopped($manage);
		if (!$this->doAction) {
			$selectedFids = array();
			if ($this->singleData) {
				$defaultTopped = $this->singleData['topped'];
				$sort = Wekit::load('forum.PwSpecialSort')->getSpecialSortByTid($this->singleData['tid']);
				$defaultTopped == 3 && $selectedFids = array_keys($sort);
				$current = current($sort);
				$toppedOvertime = $current['end_time'] ? Pw::time2str($current['end_time'], 'Y-m-d') : '';
			} else {
				$defaultTopped = 1;
				$toppedOvertime = '';
			}
			$operateThread = $manage->getPermission();
			$forumOption = $operateThread['topped_type'] > 2 ? Wekit::load('forum.srv.PwForumService')->getForumOption($selectedFids) : '';
			$this->setOutput($toppedOvertime, 'toppedOvertime');
			$this->setOutput($defaultTopped, 'defaultTopped');
			$this->setOutput($forumOption, 'forumOption');
		} else {
			list($topped, $toppedOvertime, $toppedFids) = $this->getInput(array('topped', 'topped_overtime', 'topped_fids'), 'post');
			$do->setTopped($topped);
			$do->setFids($toppedFids);
			$do->setOvertime($toppedOvertime);
			!$topped && $this->doCancel[] = 'dotopped';
		}
		return $do;
	}
	
	protected function _getUpManage($manage) {
		Wind::import('SRV:forum.srv.manage.PwThreadManageDoUp');
		$do = new PwThreadManageDoUp($manage);
		if (!$this->doAction) {

		} else {
			$uptime = $this->getInput('uptime', 'post');
			$do->setUptime($uptime);
		}
		return $do;
	}

	protected function _getHighlightManage($manage) {
		Wind::import('SRV:forum.srv.manage.PwThreadManageDoHighlight');
		$do = new PwThreadManageDoHighlight($manage);
		if (!$this->doAction) {
			if ($this->singleData) {
				Wind::import("LIB:utility.PwHighlight");
				$hightlight = new PwHighlight();
				$hightlightStyle = $hightlight->parseHighlight($this->singleData['highlight']);
				$overtime = Wekit::load('forum.PwOvertime')->getOvertimeByTidAndType($this->singleData['tid'], 'highlight');
				$hightlightOvertime = ($overtime && $overtime['overtime']) ? Pw::time2str($overtime['overtime'], 'Y-m-d') : '';
			} else {
				$hightlightStyle = array('color' => '#F50');
				$hightlightOvertime = '';
			}
			$this->setOutput($hightlightStyle, 'hightlightStyle');
			$this->setOutput($hightlightOvertime, 'hightlightOvertime');
		} else {
			list($bold, $italic, $underline, $color, $highlightOvertime) = $this->getInput(array('bold', 'italic', 'underline', 'color', 'highlight_overtime'), 'post');
			Wind::import("LIB:utility.PwHighlight");
			$hightlight = new PwHighlight();
			$hightlight->setColor($color);
			$hightlight->setBold($bold);
			$hightlight->setItalic($italic);
			$hightlight->setUnderline($underline);
			$do->setHighlight($hightlight->getHighlight());
			$do->setOvertime($highlightOvertime);
			if (!$color && !$bold && !$italic && !$underline) $this->doCancel[] = 'dohighlight';
		}
		return $do;
	}

	protected function _getDeleteManage($manage) {
		Wind::import('SRV:forum.srv.manage.PwThreadManageDoDeleteTopic');
		$do = new PwThreadManageDoDeleteTopic($manage);
		if (!$this->doAction) {
			$this->setOutput('dodelete', 'doaction');
		} else {
			$deductCredit = $this->getInput('deductCredit', 'post');
			$reason = $this->getInput('reason', 'post');
			$do->setIsDeductCredit($deductCredit)
				->setReason($reason);
		}
		return $do;
	}
	
	protected function _getDownManage($manage) {
		Wind::import('SRV:forum.srv.manage.PwThreadManageDoDown');
		$do = new PwThreadManageDoDown($manage);
		if (!$this->doAction) {
			
		} else {
			list($downtime, $downed) = $this->getInput(array('downtime', 'downed'), 'post');
			$do->setDowntime($downtime)->setDowned($downed);
		}
		return $do;
	}
	
	protected function _getLockManage($manage) {
		Wind::import('SRV:forum.srv.manage.PwThreadManageDoLock');
		$do = new PwThreadManageDoLock($manage);
		if (!$this->doAction) {
			if ($this->singleData) {
				$defaultLocked = Pw::getstatus($this->singleData['tpcstatus'], PwThread::STATUS_CLOSED) ? 2 : 1;
			} else {
				$defaultLocked = 1;
			}
			$this->setOutput($defaultLocked, 'defaultLocked');
		} else {
			$locked = $this->getInput('locked', 'post');
			$do->setLocked($locked);
			!$locked && $this->doCancel[] = 'dolock';
		}
		return $do;
	}

	protected function _getMoveManage($manage) {
		Wind::import('SRV:forum.srv.manage.PwThreadManageDoMove');
		$do = new PwThreadManageDoMove($manage);
		if (!$this->doAction) {
			$this->setOutput($this->_getFroumService()->getForumOption($do->fid), 'option_html');
		} else {
			list($fid, $topictype) = $this->getInput(array('fid', 'topictype'), 'post');
			$do->setFid($fid)->setTopictype($topictype);
		}
		return $do;
	}

	protected function _getTypeManage($manage) {
		Wind::import('SRV:forum.srv.manage.PwThreadManageDoType');
		$do = new PwThreadManageDoType($manage);
		if (!$this->doAction) {
			$topicTypes = $do->getTopicTypes();
			$this->setOutput($topicTypes,'topicTypes');
		} else {
			list($topicType, $subTopicType) = $this->getInput(array('topictype', 'sub_topictype'), 'post');
			$do->setTopictype($topicType, $subTopicType);
		}
		return $do;
	}

	protected function _getCopyManage($manage) {
		Wind::import('SRV:forum.srv.manage.PwThreadManageDoCopy');
		$do = new PwThreadManageDoCopy($manage);
		
		if (!$this->doAction) {
			$this->setOutput($this->_getFroumService()->getForumOption($do->fid), 'option_html');
		} else {
			list($fid, $topictype) = $this->getInput(array('fid', 'topictype'), 'post');
			$do->setFid($fid)->setTopictype($topictype);
		}
		return $do;
	}

	protected function _getUniteManage() {
		Wind::import('SRV:forum.srv.manage.PwManageUnite');
		$manage = new PwManageUnite($this->tids);
		$params = $this->params['unite'];
		if ($params) {
//			$manage->setTargetFid($params['target_fid']);
//			$manage->setTargetTopictype($params['target_topictype']);
		}
		return $manage;
	}

	/**
	 * ban manage
	 * 
	 * @return PwThreadManageDoBan
	 */
	protected function _getBanManage($manage) {
		Wind::import('SRV:forum.srv.manage.PwThreadManageDoBan');
		$do = new PwThreadManageDoBan($manage, $this->loginUser);
		if ($this->doAction) {
			$banInfo = new stdClass();
			$banInfo->types = $this->getInput('types');
			$banInfo->uids = $this->getInput('uids');
			$banInfo->ban_others = $this->getInput('ban_others');
			$banInfo->end_time = $this->getInput('end_time');
			$banInfo->reason = $this->getInput('reason');
			$banInfo->ban_range = intval($this->getInput('ban_range'));
			$banInfo->sendNotice = intval($this->getInput('sendnotice'));
			
			$do->setBanInfo($banInfo)
				->setDeletes($this->getInput('delete'));
		} else {
			/* @var $banService PwUserBanService */
			$banService = Wekit::load('user.srv.PwUserBanService');
			$users = $do->getThreadUsername();
			$uid = $this->getInput('uid', 'get');
			$deleteCurrent = true;
			if ($uid) {
				if (!key_exists($uid, $users)) {
					$deleteCurrent = false;
				}
				$users = Wekit::load('user.PwUser')->getUserByUid($uid);
				$users = array($uid => $users['username']);
			}
			$this->setOutput($banService->getBanType(), 'types');
			$this->setOutput($users, 'userNames');
			$this->setOutput(count($users), 'count');
			$this->setOutput($do->getRight(), 'right');
			$this->setOutput($deleteCurrent, 'deleteCurrent');
			$this->setOutput('doban', 'doaction');
			$this->setOutput('用户禁止', 'title');
		}
		return $do;
	}
	
	/* (non-PHPdoc)
	 * @see PwBaseController::setDefaultTemplateName()
	 */
	/* protected function setDefaultTemplateName($handlerAdapter) {
		$controller = $handlerAdapter->getController();
		$action = $handlerAdapter->getAction();
		
		switch ($action) {
			case 'run':
				$this->setTemplate($controller . '_' . $action);;
				break;
			case 'ban':
				$this->setTemplate('manage_ban');;
				break;
			default:
				$this->setTemplate('manage_threads');
			break;
		}
	} */

	/**
	 * various manage actions routes to manageAction 
	 * 
	 * @see wind/web/WindController::resolvedActionMethod()
	 */
	public function resolvedActionMethod($handlerAdapter) {
		return $this->resolvedActionName('manage');
	}
	
	/**
	 * send messages
	 */
	protected function _sendMessage($action, $threads) {
		if (!is_array($threads) || !$threads || !$action || $action == 'doban') return false;
		$noticeService = Wekit::load('message.srv.PwNoticeService');
		$reason = $this->getInput('reason');
		foreach ($threads as $thread) {
			$params = array();
			$params['manageUsername'] = $this->manage->user->username;
			$params['manageUserid'] = $this->manage->user->uid;
			$params['manageThreadTitle'] = $thread['subject'];
			$params['manageThreadId'] = $thread['tid'];
			//$this->params['_other']['reason'] && $params['manageReason'] = $this->params['_other']['reason'];
			$reason && $params['manageReason'] = $reason;
			if ($action == 'docombined') {
				$actions = $this->getInput('actions');
				$tmp = array();
				foreach ($actions as $v){
					$tmp[] = $this->_getManageActionName('do' . $v);
				}
				$tmp && $params['manageTypeString'] = implode(',', $tmp);
			} else {
				$params['manageTypeString'] = $this->_getManageActionName($action);
			}
			$noticeService->sendNotice($thread['created_userid'], 'threadmanage', $thread['tid'], $params);
		}
	}
	
	protected function _getManageActionName($action) {
		$resource = Wind::getApp()->getComponent('i18n');
		$message = $resource->getMessage("BBS:manage.operate.name.$action");
		if (in_array($action, $this->doCancel)) {
			$message = $resource->getMessage("BBS:manage.operate.action.cancel") . $message;
		}
		return $message;
	}
	
	protected function _getFroumService() {
		return Wekit::load('forum.srv.PwForumService');
	}
}
