<?php

Wind::import('SRV:forum.srv.PwThreadDisplay');
Wind::import('SRV:credit.bo.PwCreditBo');

/**
 * 帖子阅读页
 *
 * @author Jianmin Chen <sky_hold@163.com>
 * @license http://www.phpwind.com
 * @version $Id: ReadController.php 17767 2012-09-09 08:36:12Z jieyin $
 * @package forum
 */
class ReadController extends PwBaseController {

	/**
	 * 帖子阅读页
	 */
	public function run() {
		$tid = $this->getInput('tid');
		list($page, $uid, $desc) = $this->getInput(array('page', 'uid', 'desc'), 'get');
		
		$threadDisplay = new PwThreadDisplay($tid, $this->loginUser);
		$this->runHook('c_read_run', $threadDisplay);
		
		if (($result = $threadDisplay->check()) !== true) {
			$this->showMessage($result->getError());
		}
		$pwforum = $threadDisplay->getForum();
		if ($pwforum->foruminfo['password']) {
			if (!$this->loginUser->isExists()) {
				$this->forwardAction('u/login/run', array('backurl' => WindUrlHelper::createUrl('bbs/cate/run?fid=' . $$pwforum->fid)));
			} elseif (Pw::getPwdCode($pwforum->foruminfo['password']) != Pw::getCookie('fp_' . $pwforum->fid)) {
				$this->forwardAction('bbs/forum/password', array('fid' => $pwforum->fid));
			}
		}
		if ($uid) {
			Wind::import('SRV:forum.srv.threadDisplay.PwUserRead');
			$dataSource = new PwUserRead($threadDisplay->thread, $uid);
		} else {
			Wind::import('SRV:forum.srv.threadDisplay.PwCommonRead');
			$dataSource = new PwCommonRead($threadDisplay->thread);
		}
		$dataSource->setPage($page);
		$dataSource->setPerpage($pwforum->forumset['readperpage'] ? $pwforum->forumset['readperpage'] : Wekit::config('bbs', 'read.perpage'));
		$dataSource->setDesc($desc);
		$threadDisplay->execute($dataSource);
		$_cache = Wekit::cache()->fetch(array('level', 'group_right'));
		
		$operateReply = $operateThread = array();
		$isBM = $pwforum->isBM($this->loginUser->username);
		if ($threadPermission = $this->loginUser->getPermission('operate_thread', $isBM, array())) {
			$operateReply = Pw::subArray(
				$threadPermission, 
				array('toppedreply',/* 'unite', 'split',  */'remind', 'shield', 'delete', 'ban', 'inspect', 'read')
			);
			$operateThread = Pw::subArray(
				$threadPermission, 
				array(
					'digest', 'topped', 'up', 'highlight', 
					'copy', 
					'type', 'move', /*'unite', 'print' */ 'lock', 
					'down', 
					'delete', 
					'ban'
				)
			);
		}
		$threadInfo = $threadDisplay->getThreadInfo();
		$this->setOutput($threadDisplay, 'threadDisplay');
		$this->setOutput($tid, 'tid');
		$this->setOutput($threadDisplay->fid, 'fid');
		$this->setOutput($threadInfo, 'threadInfo');
		$this->setOutput($threadDisplay->getList(), 'readdb');
		$this->setOutput($threadDisplay->getUsers(), 'users');
		$this->setOutput($threadDisplay->getArea(), 'area');
		$this->setOutput($pwforum, 'pwforum');
		$this->setOutput(PwCreditBo::getInstance(), 'creditBo');
		$this->setOutput($threadDisplay->getHeadguide(), 'headguide');
		$this->setOutput(Wekit::config('bbs', 'read.display_member_info'), 'displayMemberInfo');
		$this->setOutput(Wekit::config('bbs', 'read.display_info'), 'displayInfo');

		$this->setOutput($threadPermission, 'threadPermission');
		$this->setOutput($operateThread, 'operateThread');
		$this->setOutput($operateReply, 'operateReply');
		$this->setOutput((!$this->loginUser->uid && !$this->loginUser->getPermission('allow_post')) ? ' J_qlogin_trigger' : '', 'postNeedLogin');
		$this->setOutput((!$this->loginUser->uid && !$this->loginUser->getPermission('allow_reply')) ? ' J_qlogin_trigger' : '', 'replyNeedLogin');
		
		$this->setOutput($_cache['level']['ltitle'], 'ltitle');
		$this->setOutput($_cache['level']['lpic'], 'lpic');
		$this->setOutput($_cache['level']['lneed'], 'lneed');
		$this->setOutput($_cache['group_right'], 'groupRight');
		
		$this->setOutput($threadDisplay->page, 'page');
		$this->setOutput($threadDisplay->perpage, 'perpage');
		$this->setOutput($threadDisplay->total, 'count');
		$this->setOutput($threadDisplay->maxpage, 'totalpage');
		$this->setOutput($threadDisplay->getUrlArgs(), 'urlargs');
		$this->setOutput($threadDisplay->getUrlArgs('desc'), 'urlDescArgs');
		
		//版块风格
		$pwforum->foruminfo['style'] && $this->setTheme('forum', $pwforum->foruminfo['style']);
		
		// seo设置
		Wind::import('SRV:seo.bo.PwSeoBo');
		$lang = Wind::getComponent('i18n');
		$threadDisplay->page <=1 && PwSeoBo::setDefaultSeo($lang->getMessage('SEO:bbs.read.run.title'), '', $lang->getMessage('SEO:bbs.read.run.description'));
		PwSeoBo::init('bbs', 'read');
		PwSeoBo::set(
			array(
				'{forumname}' => $threadDisplay->forum->foruminfo['name'], 
				'{title}' => $threadDisplay->thread->info['subject'], 
				'{description}' => Pw::substrs($threadDisplay->thread->info['content'], 100, 0, false), 
				'{classfication}' => $threadDisplay->thread->info['topic_type'], 
				'{tags}' => '',
				'{page}' => $threadDisplay->page
			)
		);
		
		//是否显示回复
		$showReply = true;
		//锁定时间
		if($pwforum->forumset['locktime'] && ($threadInfo['created_time'] + $pwforum->forumset['locktime'] * 86400) < Pw::getTime()){
			$showReply = false;
		} else if (($threadInfo['tpcstatus'] & PwThread::STATUS_LOCKED) && !$this->loginUser->getPermission('reply_locked_threads')){
			$showReply = false;
		}
		$this->setOutput($showReply,'showReply');
	}

	/**
	 * 帖子阅读页-楼层跳转
	 */
	public function jumpAction() {
		$tid = $this->getInput('tid');
		$pid = $this->getInput('pid');
		if (!$tid) {
			$post = Wekit::load('forum.PwThread')->getPost($pid);
			$tid = $post['tid'];
		}
		Wind::import('SRV:forum.bo.PwForumBo');
		$thread = Wekit::load('forum.PwThread')->getThread($tid);
		$pwforum = new PwForumBo($thread['fid']);
		$perpage = $pwforum->forumset['readperpage'] ? $pwforum->forumset['readperpage'] : Wekit::config('bbs', 'read.perpage');
		$count = Wekit::load('forum.PwThread')->countPostByTidUnderPid($tid, $pid) + 1;
		$page = ceil(($count + 1) / $perpage);
		
		$this->forwardRedirect(WindUrlHelper::createUrl('bbs/read/run/', array('tid' => $tid, 'page' => $page), $pid));
	}

	/**
	 * 帖子阅读页-下一页
	 */
	public function nextAction() {
		$tid = $this->getInput('tid');
		$thread = Wekit::load('forum.PwThread')->getThread($tid);
		if (!$thread) {
			$this->showError('thread.not');
		}
		$nextThread = Wekit::load('forum.PwThreadExpand')->getThreadByFidUnderTime($thread['fid'], $thread['lastpost_time'], 1);
		if ($nextThread) {
			$nextTid = key($nextThread);
			$this->forwardRedirect(WindUrlHelper::createUrl('bbs/read/run/', array('tid' => $nextTid)));
		} else {
			$this->forwardRedirect(WindUrlHelper::createUrl('bbs/thread/run/', array('fid' => $thread['fid'])));
		}
	}

	/**
	 * 帖子阅读页-上一页
	 */
	public function preAction() {
		$tid = $this->getInput('tid');
		$thread = Wekit::load('forum.PwThread')->getThread($tid);
		if (!$thread) {
			$this->showError('thread.not');
		}
		$preThread = Wekit::load('forum.PwThreadExpand')->getThreadByFidOverTime($thread['fid'], $thread['lastpost_time'], 1);
		if ($preThread) {
			$preTid = key($preThread);
			$this->forwardRedirect(WindUrlHelper::createUrl('bbs/read/run/', array('tid' => $preTid)));
		} else {
			$this->forwardRedirect(WindUrlHelper::createUrl('bbs/thread/run/', array('fid' => $thread['fid'])));
		}
	}
}