<?php
defined('WEKIT_VERSION') || exit('Forbidden');

Wind::import('SRV:forum.bo.PwForumBo');
Wind::import('SRV:forum.srv.PwThreadList');

/**
 * 帖子列表页
 *
 * @author Jianmin Chen <sky_hold@163.com>
 * @license http://www.phpwind.com
 * @version $Id: ThreadController.php 17746 2012-09-09 03:39:50Z jieyin $
 * @package forum
 */

class ThreadController extends PwBaseController {
	
	/**
	 * 帖子列表页
	 */
	public function run() {

		$tab = $this->getInput('tab');
		$fid = $this->getInput('fid');
		$type = intval($this->getInput('type','get')); //主题分类ID
		$page = $this->getInput('page', 'get');
		list($orderby) = $this->getInput(array('orderby'), 'get');
		
		$pwforum = new PwForumBo($fid, true);
		if (!$pwforum->isForum()) {
			$this->showError('BBS:forum.exists.not');
		}
		if ($pwforum->allowVisit($this->loginUser) !== true) {
			$this->showError(array('BBS:forum.permissions.visit.allow', array('{grouptitle}' => $this->loginUser->getGroupInfo('name'))));
		}
		if ($pwforum->forumset['jumpurl']) {
			$this->forwardRedirect($pwforum->forumset['jumpurl']);
		}
		if ($pwforum->foruminfo['password']) {
			if (!$this->loginUser->isExists()) {
				$this->forwardAction('u/login/run', array('backurl' => WindUrlHelper::createUrl('bbs/cate/run?fid=' . $fid)));
			} elseif (Pw::getPwdCode($pwforum->foruminfo['password']) != Pw::getCookie('fp_' . $fid)) {
				$this->forwardAction('bbs/forum/password', array('fid' => $fid));
			}
		}
		$isBM = $pwforum->isBM($this->loginUser->username);
		if ($operateThread = $this->loginUser->getPermission('operate_thread', $isBM, array())) {
			$operateThread = Pw::subArray($operateThread, array('topped', 'digest', 'highlight', 'up', 'copy', 'type', 'move', /*'unite',*/ 'lock', 'down', 'delete', 'ban'));
		}

		$threadList = new PwThreadList();
		//$this->runHook('c_thread_run', $forumDisplay);

		$threadList->setPage($page)
			->setPerpage($pwforum->forumset['threadperpage'] ? $pwforum->forumset['threadperpage'] : Wekit::config('bbs', 'thread.perpage'))
			->setIconNew($pwforum->foruminfo['newtime']);

		if ($tab == 'digest') {
			Wind::import('SRV:forum.srv.threadList.PwDigestThread');
			$dataSource = new PwDigestThread($pwforum->fid, $type, $orderby);
		} elseif ($orderby == 'postdate') {
			Wind::import('SRV:forum.srv.threadList.PwSearchThread');
			$dataSource = new PwSearchThread($pwforum);
			$dataSource->setOrderby($orderby);
			if ($type) $dataSource->setType($type);
		} elseif ($type) {
			Wind::import('SRV:forum.srv.threadList.PwTypeThread');
			$dataSource = new PwTypeThread($fid, $type);
		} else {
			Wind::import('SRV:forum.srv.threadList.PwCommonThread');
			$dataSource = new PwCommonThread($pwforum);
		}
		$threadList->execute($dataSource);

		$this->setOutput($threadList->getList(), 'threadList');
		$this->setOutput($fid, 'fid');
		$this->setOutput($type, 'type');
		$this->setOutput($tab, 'tab');
		$this->setOutput($pwforum, 'pwforum');
		$this->setOutput($pwforum->headguide(), 'headguide');
		$this->setOutput($threadList->icon, 'icon');
		$this->setOutput($threadList->uploadIcon, 'uploadIcon');
		$this->setOutput($operateThread, 'operateThread');
		$this->setOutput($pwforum->forumset['numofthreadtitle'] ? $pwforum->forumset['numofthreadtitle'] : 26, 'numofthreadtitle');
		$this->setOutput((!$this->loginUser->uid && !$this->loginUser->getPermission('allow_post')) ? ' J_qlogin_trigger' : '', 'postNeedLogin');

		$this->setOutput($threadList->page, 'page');
		$this->setOutput($threadList->perpage, 'perpage');
		$this->setOutput($threadList->total, 'count');
		$this->setOutput($threadList->maxPage, 'totalpage');
		$this->setOutput($orderby, 'orderby');
		$this->setOutput($threadList->getUrlArgs(), 'urlargs');

		$classification = $this->_initTopictypes($fid, $type);
		
		//版块风格
		$pwforum->foruminfo['style'] && $this->setTheme('forum', $pwforum->foruminfo['style']);
		
		//seo设置
		Wind::import('SRV:seo.bo.PwSeoBo');
		$lang = Wind::getComponent('i18n');
		if ($threadList->page <=1) {
			if ($type)
				PwSeoBo::setDefaultSeo($lang->getMessage('SEO:bbs.thread.run.type.title'), '', $lang->getMessage('SEO:bbs.thread.run.type.description'));
			else 
				PwSeoBo::setDefaultSeo($lang->getMessage('SEO:bbs.thread.run.title'), '', $lang->getMessage('SEO:bbs.thread.run.description'));
		}
		PwSeoBo::init('bbs', 'thread', $fid);
		PwSeoBo::set(array(
			'{forumname}' => $pwforum->foruminfo['name'],
			'{forumdescription}' => Pw::substrs($pwforum->foruminfo['descrip'], 100, 0, false),
			'{classification}' => $classification,
			'{page}' => $threadList->page
		));
	}
	
	private function _initTopictypes($fid, $type) {
		$topictypes = $this->_getTopictypeService()->getTopicTypesByFid($fid);
		if ($topictypes['all_types'][$type]['parentid']) {
			$topictypeService = Wekit::load('forum.srv.PwTopicTypeService');
			$topictypes = $topictypeService->sortTopictype($type,$topictypes);
		}
		$this->setOutput($topictypes, 'topictypes');
		return $topictypes['all_types'][$type]['name'];
	}
	
	private function _getTopictypeService(){
		return Wekit::load('forum.PwTopicType');
	}
}