<?php
Wind::import('ADMIN:library.AdminBaseController');
Wind::import('WINDID:service.school.dm.WindidSchoolDm');
Wind::import('WINDID:service.school.vo.WindidSchoolSo');

/**
 * 全局-资料库-学校库
 *
 * @author xiaoxia.xu <xiaoxia.xuxx@aliyun-inc.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: SchooldataController.php 8787 2012-04-26 03:11:33Z xiaoxia.xuxx $
 * @package applications.config.admin
 */
class SchooldataController extends AdminBaseController {
	private $type = array(1 => '小学', 2 => '中学', 3 => '大学');

	/* (non-PHPdoc)
	 * @see WindController::run()
	 */
	public function run() {
		list($type, $areaid, $name, $first) = $this->getInput(array('type', 'areaid', 'name', 'first'));
		!$type && $type = 3;
		$schoolSo = new WindidSchoolSo();
		$schoolSo->setName($name)
			->setTypeid($type)
			->setFirstChar($first)
			->setAreaid($areaid);
		
		$list = array();
		$areaRoute = Wekit::load('area.srv.PwAreaService')->getAreaRout($areaid);
		if ($areaid) {
			$list = $this->_getDs()->searchSchool($schoolSo, 100);
		}
		$this->setOutput($list, 'list');
		$this->setOutput($schoolSo->getData(), 'data');
		$this->setOutput($areaRoute, 'route');
		$this->setOutput($type, 'type');
		$this->setOutput($this->type, 'schools');
	}

	/**
	 * 更新学校
	 */
	public function updateAction() {
		list($update, $add, $areaid, $typeid) = $this->getInput(array('update', 'add', 'areaid', 'typeid'), 'post');
		foreach ($update as $id => $name) {
			$dm = new WindidSchoolDm();
			$dm->setSchoolid($id)
				->setName($name)
				->setFirstChar($this->_getService()->getFirstChar($name));
			$r = $this->_getDs()->updateSchool($dm);
			if ($r instanceof WindidError) $this->showError('ADMIN:school.error.' . $r->getCode());
		}
		$addDms = array();
		foreach ($add as $name) {
			$dm = new WindidSchoolDm();
			$dm->setName($name)
				->setTypeid($typeid)
				->setAreaid($areaid)
				->setFirstChar($this->_getService()->getFirstChar($name));
			$addDms[] = $dm;
		}
		$r = $this->_getDs()->batchAddSchool($addDms);
		if ($r instanceof WindidError) $this->showError('ADMIN:school.error.' . $r->getCode());
		$this->showMessage('success');
	}
	
	/**
	 * 删除学校
	 */
	public function deleteAction() {
		$schoolid = $this->getInput('schoolid');
		if (!$schoolid) $this->showError('ADMIN:school.schoolid.error');
		$this->_getDs()->deleteSchool($schoolid);
		$this->showMessage('ADMIN:school.delete.success');
	}
	
	/**
	 * 学校Ds
	 *
	 * @return WindidSchool
	 */
	private function _getDs() {
		return Windid::load('school.WindidSchool');
	}
	
	/**
	 * 学校的service
	 *
	 * @return PwSchoolService
	 */
	private function _getService() {
		return Wekit::load('school.srv.PwSchoolService');
	}
}