<?php
Wind::import('LIB:base.PwBaseController');
/**
 * the last known user to change this file in the repository  <$LastChangedBy: gao.wanggao $>
 * @author $Author: gao.wanggao $ Foxsee@aliyun.com
 * @copyright ?2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: ApiController.php 16031 2012-08-17 08:18:58Z gao.wanggao $ 
 * @package 
 */
class ApiController extends PwBaseController {
	
	public function run() {
		$moduleId = (int)$this->getInput('id', 'get');
		$token = $this->getInput('token', 'get');
		$out = $this->getInput('format', 'get');
		$script = $this->_getScriptDs()->getScript($moduleId);
		if (!$token || !$script || $script['token'] != $token) exit('fail');
		!$out && $out = 'script';
		if (!in_array($out, array('script', 'json', 'xml'))) exit('fail');
		$method = $out.'Format';
		return $this->$method($moduleId);
	}
	
	protected function scriptFormat($moduleId) {
		Wind::import('SRV:design.bo.PwDesignModuleBo');
    	$bo = new PwDesignModuleBo($moduleId);
    	$module = $bo->getModule();
    	if ($module['module_type'] != PwDesignModule::TYPE_SCRIPT) exit('fail');
    	$bo->setStdId();
    	$key = Wekit::load('design.srv.display.PwDesignDisplay')->bindDataKey($moduleId);
    	$data[$key] = $bo->getData(true);
    	$this->setOutput($data, '__design_data');
    	$this->setTemplate('TPL:design.api_script');
	}
	
	protected function jsonFormat($moduleId) {
		$_data = array();
		Wind::import('SRV:design.bo.PwDesignModuleBo');
    	$bo = new PwDesignModuleBo($moduleId);
    	$module = $bo->getModule();
    	if ($module['module_type'] != PwDesignModule::TYPE_SCRIPT) exit('fail');
    	$data = $bo->getData(false);
		foreach ($data AS $v) {
    		$_data[] = unserialize($v['extend_info']);
    	}
    	header('Content-type: application/json');
		echo WindJson::encode($_data);
		exit;
	}
	
	protected function xmlFormat($moduleId) {
		Wind::import('SRV:design.bo.PwDesignModuleBo');
    	$bo = new PwDesignModuleBo($moduleId);
    	$module = $bo->getModule();
    	if ($module['module_type'] != PwDesignModule::TYPE_SCRIPT) exit('fail');
    	$data = $bo->getData(false);
    	$dom = new DOMDocument('1.0','utf-8');
        $root = $dom->createElement('root');
        $dom->appendChild($root);
    	foreach ($data AS $v) {
    		$v['extend_info'] = unserialize($v['extend_info']);
    		$child = $dom->createElement('data');
    		foreach ($v['extend_info'] AS $_k=>$_v) {
    			$_k = $dom->createElement($_k);
             	$_k->appendChild($dom->createTextNode($_v));
				$child->appendChild($_k);
				$root->appendChild($child);
    		}
    	}
    	header('Content-type: application/xml');
		echo $dom->saveXML();	
		exit;
	}
	
	
	private function _getScriptDs() {
		return Wekit::load('design.PwDesignScript');
	}

}
?>