<?php
Wind::import('LIB:base.PwBaseController');
/**
 * the last known user to change this file in the repository  <$LastChangedBy: gao.wanggao $>
 * @author $Author: gao.wanggao $ Foxsee@aliyun.com
 * @copyright ?2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: ExportController.php 17990 2012-09-10 13:12:07Z gao.wanggao $ 
 * @package 
 */
class ExportController  extends PwBaseController {
	
	public  function beforeAction($handlerAdapter) {
		parent::beforeAction($handlerAdapter);
		Wekit::load('design.PwDesignPermissions');
		$permissions = $this->_getPermissionsService()->getPermissionsForUserGroup($this->loginUser->uid);
		if ($permissions < PwDesignPermissions::IS_DESIGN ) $this->showError("DESIGN:permissions.fail");
	}
	
	public function run() {
	
	}
	
	public function dorunAction() {
		$pageid = (int)$this->getInput('pageid', 'get');
		$pageDs = $this->_getPageDs();
		$pageInfo = $pageDs->getPage($pageid);
		if (!$pageInfo) $this->showError("operate.fail");
		if ($pageInfo['page_type'] == PwDesignPage::PORTAL) { //$this->showError("DESIGN:page.emport.fail");
			$this->doZip($pageInfo);
		} else {
			$this->doTxt($pageInfo);
		}
		
		$this->showMessage("operate.success");
	}
	
	protected function doZip($pageInfo) {
		Wind::import('SRV:design.srv.PwDesignExportZip');
		$srv = new PwDesignExportZip($pageInfo['page_id']);
		$this->forceDownload($srv->zip(), $pageInfo['page_name'], 'zip');
	}
	
	/**
	 * 导出当前页设计数据
	 * Enter description here ...
	 */
	protected function doTxt($pageInfo) {	
		$ids = explode(',', $pageInfo['module_ids']);
		$names = explode(',', $pageInfo['module_names']);
		$modules = $this->_getModuleDs()->fetchModule($ids);
		foreach ($modules AS &$module) {
			unset($module['isused'], $module['module_id']);
		}
		$structures = $this->_getStructureDs()->fetchStruct($names);
		foreach ($structures AS &$struct) {
			unset($struct['struct_name']);
		}
		$segments = $this->_getSegmentDs()->getSegmentByPageid($pageInfo['page_id']);
		foreach ($segments AS $k=>$v) {
			if (!$v['segment_tpl']) continue;
			$txtSegment[$k] = $v['segment_struct'];
		}
		$txtPage['module_ids'] = $pageInfo['module_ids'];
		$txtPage['struct_names'] = $pageInfo['struct_names'];
		$_nr = "\n";
		$_time = Pw::getTime();
		$_title = $_nr;
		$_text['page']= $txtPage;
		$_text['segment'] = $txtSegment;
		$_text['structure'] = $structures;
		$_text['module'] = $modules;
		$_text = wordwrap(base64_encode(serialize($_text)), 100, $_nr, true);
		$_end = $_nr;
		$filename = $pageInfo['page_name'] ? $pageInfo['page_name'] : $_time;
		$_text = $_title . $_text . $_end;
		$this->forceDownload($_text, $filename, 'txt');
	}
	
	protected function forceDownload($string, $filename, $ext = 'txt') {
		$router = Wind::getApp()->getComponent('router');
		$agent = $router->request->getServer('HTTP_USER_AGENT');
		if ((preg_match("/MSIE/", $agent))) {
			$filename = urlencode($filename);
		}
		$filename .= '.'.$ext;
		ob_end_clean();
		header('Content-Encoding: none');
		header("Content-type: application/octet-stream");
		header('Content-type: text/html; charset='.Wekit::app()->charset.'');
        header("Accept-Ranges: bytes");
        header("Accept-Length: ".Pw::strlen($string));
        header("Content-Disposition: attachment; filename=".$filename);
        echo $string;
        @flush();
		@ob_flush();
		exit;
	}
	
	private function _getPermissionsService() {
		return Wekit::load('design.srv.PwDesignPermissionsService');
	}
	
	private function _getSegmentDs() {
		return Wekit::load('design.PwDesignSegment');
	}
	
	private function _getModuleDs() {
		return Wekit::load('design.PwDesignModule');
	}
	
	private function _getStructureDs() {
		return Wekit::load('design.PwDesignStructure');
	}
	
	private function _getPageDs() {
		return Wekit::load('design.PwDesignPage');
	}
	
	private function _getPortalDs() {
		return Wekit::load('design.PwDesignPortal');
	}
}
?>