<?php
Wind::import('LIB:base.PwBaseController');
Wind::import('SRV:design.bo.PwDesignStructureBo');
/**
 * the last known user to change this file in the repository  <$LastChangedBy: gao.wanggao $>
 * @author $Author: gao.wanggao $ Foxsee@aliyun.com
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: StructureController.php 18176 2012-09-11 12:00:54Z gao.wanggao $ 
 * @package 
 */
class StructureController extends PwBaseController{
	
	public $bo;
	
	public function beforeAction($handlerAdapter) {
		parent::beforeAction($handlerAdapter);
		Wind::import('SRV:design.PwDesignPermissions');
		$permissions = $this->_getPermissionsService()->getPermissionsForUserGroup($this->loginUser->uid);
		if ($permissions < PwDesignPermissions::IS_DESIGN ) $this->showError("DESIGN:permissions.fail");
		$name = $this->getInput('name','post');
		Wind::import('SRV:design.bo.PwDesignStructureBo');
		$this->bo = new PwDesignStructureBo($name);
	}
	
	public function titleAction() {
		$titles = $this->bo->getTitle();
		$pageid = (int)$this->getInput('pageid', 'post');
		$tab = $this->getInput('tab', 'post');
		if (!$titles['titles']){
			if ($tab) {
				$i = 1;
				foreach ($tab AS $v) {
					$titles['titles'][] = array('title'=>'栏目'.$i,'tab'=>$v);
					$i++;
				}
				$this->setOutput('tab', 'structure');
			} else {
				$titles['titles'] = array(array('title'=>''));
			}
		}
		$this->setOutput($this->_getDesignService()->getSysFontSize(), 'sysfontsize');
		$this->setOutput($titles, 'titles');
		$this->setOutput($this->bo->name, 'name');
		$this->setOutput($pageid, 'pageid');
	}

	public function doedittitleAction() {
		$html = '';
		$array = array();
		$pageid = (int)$this->getInput('pageid', 'post');
		$title = $this->getInput('title','post');
		if ($pageid < 1) $this->showError("permissions.fail");
		$link = $this->getInput('link','post');
		$image = $this->getInput('image','post');
		$float = $this->getInput('float','post');
		$margin = $this->getInput('margin','post');
		$fontsize = $this->getInput('fontsize','post');
		$fontcolor = $this->getInput('fontcolor','post');
		$fontbold = $this->getInput('fontbold','post');
		$fontunderline = $this->getInput('fontunderline','post');
		$fontitalic = $this->getInput('fontitalic','post');
		$bgimage = $this->getInput('bgimage','post');
		$bgcolor = $this->getInput('bgcolor','post');
		$bgposition = $this->getInput('bgposition','post');
		$structure = $this->getInput('structure','post');
		$tab = $this->getInput('tab','post');
		$styleSrv = $this->_getStyleService();
		

		$background['image'] = $bgimage;
		$background['color'] = $bgcolor;
		$background['position'] = $bgposition;
		foreach ($title AS $k=>$value) {
			$_tmp = array(
				'title'=>WindSecurity::escapeHTML($title[$k]),
				'link'=>$link[$k],
				'image'=>$image[$k],
				'float'=>$float[$k],
				'margin'=>(int)$margin[$k],
				'fontsize'=>(int)$fontsize[$k],
				'fontcolor'=>$fontcolor[$k],
				'fontbold'=>$fontbold[$k],
				'fontunderline'=>$fontunderline[$k],
				'fontitalic'=>$fontitalic[$k],
			);
			$style = $this->_buildTitleStyle($_tmp);
			$styleSrv->setStyle($style);
			list($dom,$jstyle) = $styleSrv->getCss();
			$jtitle = $image[$k] ? '<img src="'.$_tmp['image'].'" title="'.$_tmp['title'].'">' : $_tmp['title'];
			if ($jtitle) {
				if ($structure == 'tab') {
					$html .= '<li role="tab">';
					$html .= '<a data-id="'.$tab[$k].'" href="'.$_tmp['link'].'"';
					$html .= $jstyle ? ' style="'.$jstyle.'"' : '' ;
					$html .= '>';
					$html .= $jtitle;
					$html .= $_tmp['link'] ? '</a>' : '';
					$html .= '</li>' ;
				} else {
					$html .= '<span';
					$html .= $jstyle && !$_tmp['link']? ' style="'.$jstyle.'"' : '' ;
					$html .= '>';
					$html .= $_tmp['link'] ? '<a href="'.$_tmp['link'].'" style="'.$jstyle.'">' : '';
					$html .= $jtitle;
					$html .= $_tmp['link'] ? '</a>' : '';
					$html .= '</span>';
				}
				$array['titles'][] = $_tmp;
			}
		}
		$data['tab'] = $html;
		if ($background) {
			$array['background'] = $background;
			$bg = array('background'=>$background);
			$styleSrv->setStyle($bg);
			list($dom, $data['background']) = $styleSrv->getCss();
		}
		Wind::import('SRV:design.dm.PwDesignStructureDm');
 		$dm = new PwDesignStructureDm();
 		$style = $this->bo->getStyle();
 		$dm->setStructTitle($array)
 			->setStructname($this->bo->name)
 			->setStructStyle($style['font'], $style['link'], $style['border'], $style['margin'], $style['padding'], $style['background'], $style['styleclass']);
		$resource = $this->_getStructureDs()->replaceStruct($dm);
		if ($resource instanceof PwError) $this->showError($resource->getError());
		$this->setOutput($data, 'data');
		$this->showMessage("operate.success");
	}
	
	//导入模块的标题编辑
	public function editAction() {
		$title = $this->bo->getTitle();
		$this->setOutput($title, 'title');
		$this->setOutput($this->bo->name, 'name');
	}
	
	public function doeditAction() {
		$title = $this->getInput('title','post');
		Wind::import('SRV:design.dm.PwDesignStructureDm');
 		$dm = new PwDesignStructureDm();
 		$dm->setStructTitle($title)
 			->setStructname($this->bo->name);
		$resource = $this->_getStructureDs()->replaceStruct($dm);
		if ($resource instanceof PwError) $this->showError($resource->getError());
		$this->setOutput($title, 'data');
		$this->showMessage("operate.success");
	}
	
	public function styleAction() {
		$srv = $this->_getDesignService();
		$this->setOutput($srv->getSysStyleClass(), 'sysstyle');
		$this->setOutput($srv->getSysFontSize(), 'sysfontsize');
		$this->setOutput($srv->getSysBorderStyle(), 'sysborder');
		$this->setOutput($srv->getSysLineWidth(), 'syslinewidth');
		$this->setOutput($this->bo->getStyle(), 'style');
		$this->setOutput($this->bo->name, 'name');
	}
	
	public function doeditstyleAction() {
		$styleclass = $this->getInput('styleclass','post');
		$font = $this->getInput('font','post');
		$link = $this->getInput('link','post');
		$border = $this->getInput('border','post');
		$margin = $this->getInput('margin','post');
		$padding = $this->getInput('padding','post');
		$background = $this->getInput('background','post');
		
		if ($border['isdiffer']) {
			unset($border['linewidth']);
			unset($border['style']);
			unset($border['color']);
		}
		
		if ($margin['isdiffer']) {
			unset($margin['both']);
		}
		if ($padding['isdiffer']) {
			unset($padding['both']);
		}
		
		Wind::import('SRV:design.dm.PwDesignStructureDm');
 		$dm = new PwDesignStructureDm();
 		$dm->setStructStyle($font,$link,$border,$margin,$padding,$background,$styleclass)
 			->setStructName($this->bo->name)
 			->setStructTitle($this->bo->getTitle());
		$resource = $this->_getStructureDs()->replaceStruct($dm);
		if ($resource instanceof PwError) $this->showError($resource->getError());
		$styleSrv = $this->_getStyleService();
		$styleSrv->setDom($this->bo->name);
		$style = array('font'=>$font, 'link'=>$link, 'border'=>$border, 'margin'=>$margin, 'padding'=>$padding, 'background'=>$background, 'styleclass'=>$styleclass);
		$styleSrv->setStyle($style);
		$_style['styleDomId'] = $styleSrv->getCss($style);
		$_style['styleDomIdLink'] = $styleSrv->getLink($style);
		$_style['styleDomClass'] = $styleclass;
		$this->setOutput($_style, 'data');
		$this->showMessage("operate.success");
	}
	
	public function deleteAction() {
		$this->_getStructureDs()->deleteStruct($this->bo->name);
		$this->showMessage("operate.success");
	}
	
	private function _buildTitleStyle($style) {
		return array(
				'float'=>array('type'=>$style['float'],'margin'=>$style['margin']),
				'font'=>array('size'=>$style['fontsize'],'color'=>$style['fontcolor'],'bold'=>$style['fontbold'],'underline'=>$style['fontunderline'],'italic'=>$style['fontitalic']),
				//'background'=>array('color'=>$style['bgcolor'],'image'=>$style['bgimage'],'position'=>$style['bgposition']),
		);
	}
	
	protected function _getPermissionsService() {
		return Wekit::load('design.srv.PwDesignPermissionsService');
	}
	
	private function _getStructureDs() {
		return Wekit::load('design.PwDesignStructure');
	}
	
	private function _getDesignService() {
		return Wekit::load('design.srv.PwDesignService');
	}
	
	private function _getStyleService() {
		return Wekit::load('design.srv.PwDesignStyle');
	}
	
	private function _getBakDs() {
		return Wekit::load('design.PwDesignBak');
	}
}
?>