<?php
Wind::import('APPS:design.controller.DesignBaseController');
/**
 * the last known user to change this file in the repository  <$LastChangedBy: gao.wanggao $>
 * @author $Author: gao.wanggao $ Foxsee@aliyun.com
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: StyleController.php 17726 2012-09-08 08:52:39Z gao.wanggao $ 
 * @package 
 */
class StyleController extends DesignBaseController{
	
	public function beforeAction($handlerAdapter) {
		parent::beforeAction($handlerAdapter);
		Wekit::load('design.PwDesignPermissions');
		$permissions = $this->_getPermissionsService()->getPermissionsForModule($this->loginUser->uid,$this->bo->moduleid);
		if ($permissions < PwDesignPermissions::IS_ADMIN ) $this->showError("DESIGN:permissions.fail");
	}
	
	public function editAction() {
		$srv = $this->_getDesignService();
		$this->setOutput($srv->getSysListClass(), 'sysstyle');
		$this->setOutput($srv->getSysFontSize(), 'sysfontsize');
		$this->setOutput($srv->getSysBorderStyle(), 'sysborder');
		$this->setOutput($srv->getSysLineWidth(), 'syslinewidth');
		$this->setOutput($this->bo->getStyle(), 'style');
		$this->setOutput($this->bo->moduleid, 'moduleid');
	}
	
	public function doeditAction() {
		$styleclass = $this->getInput('styleclass','post');
		$font = $this->getInput('font','post');
		$link = $this->getInput('link','post');
		$border = $this->getInput('border','post');
		$margin = $this->getInput('margin','post');
		$padding = $this->getInput('padding','post');
		$background = $this->getInput('background','post');
		
		if ($border['isdiffer']) {
			unset($border['linewidth']);
			unset($border['style']);
			unset($border['color']);
		}
		
		if ($margin['isdiffer']) {
			unset($margin['both']);
		}
		if ($padding['isdiffer']) {
			unset($padding['both']);
		}
		Wind::import('SRV:design.dm.PwDesignModuleDm');
 		$dm = new PwDesignModuleDm($this->bo->moduleid);
 		$dm->setStyle($font,$link,$border,$margin,$padding,$background,$styleclass);
		$resource = $this->_getModuleDs()->updateModule($dm);
		if ($resource instanceof PwError) $this->showError($resource->getError());
		$display = Wekit::load('design.srv.display.PwDesignDisplay');
		$styleSrv = $this->_getStyleService();
		$styleSrv->setDom($display->bindDataKey($this->bo->moduleid));
		$style = array('font'=>$font, 'link'=>$link, 'border'=>$border, 'margin'=>$margin, 'padding'=>$padding, 'background'=>$background, 'styleclass'=>$styleclass);
		$styleSrv->setStyle($style);
		$_style['styleDomId'] = $styleSrv->getCss($style);
		$_style['styleDomIdLink'] = $styleSrv->getLink($style);
		$_style['styleDomClass'] = $styleclass;
		$this->setOutput($_style, 'data');
		$this->showMessage("operate.success");
	}
	
	private function _getModuleDs() {
		return Wekit::load('design.PwDesignModule');
	}
	
	private function _getDesignService() {
		return Wekit::load('design.srv.PwDesignService');
	}
	
	private function _getStyleService() {
		return Wekit::load('design.srv.PwDesignStyle');
	}
	
	private function _getBakDs() {
		return Wekit::load('design.PwDesignBak');
	}
}
?>