<?php
Wind::import('APPS:design.controller.DesignBaseController');
/**
 * the last known user to change this file in the repository  <$LastChangedBy: gao.wanggao $>
 * @author $Author: gao.wanggao $ Foxsee@aliyun.com
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: TemplateController.php 17721 2012-09-08 07:45:19Z gao.wanggao $ 
 * @package 
 */
class TemplateController extends DesignBaseController{
	
	public function beforeAction($handlerAdapter) {
		parent::beforeAction($handlerAdapter);
		Wekit::load('design.PwDesignPermissions');
		$permissions = $this->_getPermissionsService()->getPermissionsForModule($this->loginUser->uid,$this->bo->moduleid);
		if ($permissions < PwDesignPermissions::IS_ADMIN ) $this->showError("DESIGN:permissions.fail");
	}
	
	public function editAction() {
		$module = $this->bo->getModule();
		$compid = '';
		$components = $this->_getComponentDs()->getComponentByFlag($this->bo->getModel());
		$tpl = $this->bo->getTemplate();
		$this->setOutput($components, 'components');
		if ($tpl == '') {
			$comp = array_shift($components);
			if ($comp) {
				$compid = $comp['comp_id'];
				$tpl  = $comp['comp_tpl'];
			}
		} else {
			$compid = $module['module_compid']; 
		}
		$this->setOutput($this->bo->getSignKey(), 'signkeys');
		$this->setOutput($compid, 'compid');
		$this->setOutput($tpl, 'tpl');
	}
	
	public function getcompAction() {
		$compid = (int)$this->getInput('compid','post');
		$component = $this->_getComponentDs()->getComponent($compid);
		if ($compid) {
			$tpl = $component['comp_tpl'];
		} else {
			$tpl = $this->bo->getTemplate();
		}
		$this->setOutput($tpl, 'data');
		$this->showMessage("operate.success");
	}
	
	public function doeditAction() {
		$tpl = $this->getInput('tpl','post');
		$compid = (int)$this->getInput('compid','post');
		if (!$this->_getDesignService()->checkTemplate($tpl)) $this->showError("DESIGN:template.error");
		Wind::import('SRV:design.dm.PwDesignModuleDm');
 		$dm = new PwDesignModuleDm($this->bo->moduleid);
 		$dm->setModuleTpl($tpl)
 			->setCompid($compid);
 		$resource = $this->_getModuleDs()->updateModule($dm);
		if ($resource instanceof PwError) $this->showError($resource->getError());
		Wind::import('SRV:design.srv.data.PwAutoData');
		$srv = new PwAutoData($this->bo->moduleid);
		$srv->addAutoData();
		$this->showMessage("operate.success");
	}
	
	public function dosaveAction() {
		$tplname = $this->getInput('tplname','post');
		$tpl = $this->getInput('tpl','post');
		if (!$this->_getDesignService()->checkTemplate($tpl)) $this->showError("DESIGN:template.error");
		$return = $this->_getComponentDs()->addComponent($this->bo->getModel(), $tplname, $tpl);
		if ($return) $this->showMessage("operate.success");
		$this->showError("operate.success");
	}
	
	private function _getDesignService() {
		return Wekit::load('design.srv.PwDesignService');
	}
	
	private function _getCompileService() {
		return Wekit::load('design.srv.PwDesignCompile');
	}
	
	private function _getDataDs() {
		return Wekit::load('design.PwDesignData');
	}
	
	private function _getPushDs() {
		return Wekit::load('design.PwDesignPush');
	}
	
	private function _getModuleDs() {
		return Wekit::load('design.PwDesignModule');
	}
	
	private function _getComponentDs() {
		return Wekit::load('design.PwDesignComponent');
	}
}
?>