
DROP TABLE IF EXISTS `pw_acloud_apis`;
CREATE TABLE `pw_acloud_apis` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `template` text,
  `argument` varchar(255) NOT NULL DEFAULT '',
  `argument_type` varchar(255) NOT NULL DEFAULT '',
  `fields` varchar(255) NOT NULL DEFAULT '',
  `status` tinyint(3) NOT NULL DEFAULT '0',
  `category` tinyint(3) NOT NULL DEFAULT '0',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  `modified_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_name` (`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `pw_acloud_apps`;
CREATE TABLE `pw_acloud_apps` (
  `app_id` char(22) NOT NULL DEFAULT '',
  `app_name` varchar(60) NOT NULL DEFAULT '',
  `app_token` char(128) NOT NULL DEFAULT '',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  `modified_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`app_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `pw_acloud_app_configs`;
CREATE TABLE `pw_acloud_app_configs` (
  `app_id` char(22) NOT NULL DEFAULT '',
  `app_key` varchar(30) NOT NULL DEFAULT '',
  `app_value` text,
  `app_type` tinyint(3) NOT NULL DEFAULT '1',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  `modified_time` int(10) unsigned NOT NULL DEFAULT '0',
  UNIQUE KEY `app_id` (`app_id`,`app_key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `pw_acloud_extras`;
CREATE TABLE `pw_acloud_extras` (
  `ekey` varchar(100) NOT NULL DEFAULT '',
  `evalue` text,
  `etype` tinyint(3) NOT NULL DEFAULT '1',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  `modified_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`ekey`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `pw_acloud_keys`;
CREATE TABLE `pw_acloud_keys` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key1` char(128) NOT NULL DEFAULT '',
  `key2` char(128) NOT NULL DEFAULT '',
  `key3` char(128) NOT NULL DEFAULT '',
  `key4` char(128) NOT NULL DEFAULT '',
  `key5` char(128) NOT NULL DEFAULT '',
  `key6` char(128) NOT NULL DEFAULT '',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  `modified_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `pw_acloud_sql_log`;
CREATE TABLE `pw_acloud_sql_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `log` text,
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `pw_acloud_table_settings`;
CREATE TABLE `pw_acloud_table_settings` (
  `name` varchar(255) NOT NULL DEFAULT '',
  `status` tinyint(3) NOT NULL DEFAULT '0',
  `category` tinyint(3) NOT NULL DEFAULT '0',
  `primary_key` varchar(20) NOT NULL DEFAULT '',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  `modified_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `pw_admin_auth`;
CREATE TABLE `pw_admin_auth` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `uid` int(10) NOT NULL DEFAULT '0',
  `username` varchar(15) NOT NULL DEFAULT '',
  `roles` varchar(255) NOT NULL DEFAULT '',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  `modified_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_uid` (`uid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `pw_admin_custom`;
CREATE TABLE `pw_admin_custom` (
  `username` varchar(15) NOT NULL,
  `custom` text,
  PRIMARY KEY (`username`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='后台常用菜单表';

DROP TABLE IF EXISTS `pw_admin_log`;
CREATE TABLE `pw_admin_log` (
  `logid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` int(10) unsigned NOT NULL,
  `username` char(50) NOT NULL DEFAULT '',
  `operation` varchar(255) NOT NULL DEFAULT '',
  `ip` int(10) unsigned NOT NULL,
  `timestamp` int(10) unsigned NOT NULL,
  PRIMARY KEY (`logid`),
  KEY `idx_userid` (`userid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `pw_admin_role`;
CREATE TABLE `pw_admin_role` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(15) NOT NULL DEFAULT '',
  `auths` text,
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  `modified_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_name` (`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `pw_advertisement`;
CREATE TABLE `pw_advertisement` (
  `pid` int(10) unsigned NOT NULL,
  `identifier` varchar(30) NOT NULL,
  `type_id` tinyint(3) unsigned NOT NULL,
  `width` smallint(6) NOT NULL DEFAULT '0',
  `height` smallint(6) NOT NULL DEFAULT '0',
  `status` tinyint(3) NOT NULL DEFAULT '0',
  `schedule` varchar(100) NOT NULL,
  `show_type` tinyint(3) NOT NULL DEFAULT '0',
  `condition` text,
  UNIQUE KEY `pid` (`pid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `pw_album`;
CREATE TABLE `pw_album` (
  `albumid` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `created_uid` int(10) NOT NULL DEFAULT '0',
  `privacy` tinyint(1) NOT NULL DEFAULT '0',
  `album_type` tinyint(1) NOT NULL DEFAULT '1',
  `photo_num` smallint(6) unsigned NOT NULL DEFAULT '0',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  `modified_time` int(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(30) NOT NULL DEFAULT '',
  `cover` varchar(100) NOT NULL DEFAULT '',
  `descrip` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`albumid`),
  KEY `idx_createduid` (`created_uid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='相册';

DROP TABLE IF EXISTS `pw_album_photo`;
CREATE TABLE `pw_album_photo` (
  `photoid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `albumid` smallint(6) NOT NULL DEFAULT '0',
  `ifthumb` tinyint(1) NOT NULL DEFAULT '0',
  `comment_num` smallint(6) unsigned NOT NULL DEFAULT '0',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(50) NOT NULL DEFAULT '',
  `path` varchar(100) NOT NULL DEFAULT '',
  `descrip` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`photoid`),
  KEY `idx_albumid` (`albumid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='相册照片';

DROP TABLE IF EXISTS `pw_album_photo_comment`;
CREATE TABLE `pw_album_photo_comment` (
  `commentid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `photoid` int(10) unsigned NOT NULL DEFAULT '0',
  `created_uid` int(10) unsigned NOT NULL DEFAULT '0',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  `created_username` varchar(15) NOT NULL DEFAULT '',
  `content` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`commentid`),
  KEY `idx_photoid` (`photoid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='相册照片评论';

DROP TABLE IF EXISTS `pw_announce`;
CREATE TABLE `pw_announce` (
  `aid` smallint(6) NOT NULL AUTO_INCREMENT,
  `vieworder` smallint(6) NOT NULL DEFAULT '0',
  `created_userid` int(10) unsigned NOT NULL DEFAULT '0',
  `typeid` tinyint(1) NOT NULL DEFAULT '0',
  `url` varchar(80) DEFAULT '',
  `subject` varchar(100) NOT NULL DEFAULT '',
  `content` mediumtext,
  `start_date` int(10) unsigned NOT NULL DEFAULT '0',
  `end_date` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`aid`),
  KEY `idx_startdate` (`start_date`),
  KEY `idx_vieworder` (`vieworder`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='公告管理表';

DROP TABLE IF EXISTS `pw_application`;
CREATE TABLE `pw_application` (
  `app_id` char(20) NOT NULL DEFAULT '',
  `name` varchar(100) NOT NULL DEFAULT '',
  `alias` varchar(100) NOT NULL DEFAULT '',
  `logo` varchar(100) NOT NULL DEFAULT '',
  `author_name` varchar(30) NOT NULL DEFAULT '',
  `author_icon` varchar(100) NOT NULL DEFAULT '',
  `author_email` varchar(200) NOT NULL DEFAULT '',
  `website` varchar(200) NOT NULL DEFAULT '',
  `version` varchar(50) NOT NULL DEFAULT '',
  `pw_version` varchar(50) NOT NULL DEFAULT '',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  `modified_time` int(10) unsigned NOT NULL DEFAULT '0',
  `description` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`app_id`),
  UNIQUE KEY `alias` (`alias`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `pw_application_log`;
CREATE TABLE `pw_application_log` (
  `app_id` char(20) NOT NULL DEFAULT '',
  `log_type` char(10) NOT NULL DEFAULT '',
  `data` text,
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  `modified_time` int(10) unsigned NOT NULL DEFAULT '0',
  UNIQUE KEY `app_id` (`app_id`,`log_type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `pw_app_poll`;
CREATE TABLE `pw_app_poll` (
  `poll_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `voter_num` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `isafter_view` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `isinclude_img` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `option_limit` smallint(6) unsigned NOT NULL DEFAULT '0',
  `regtime_limit` int(10) unsigned NOT NULL DEFAULT '0',
  `created_userid` int(10) unsigned NOT NULL DEFAULT '0',
  `app_type` smallint(6) unsigned NOT NULL DEFAULT '0',
  `expired_time` int(10) unsigned NOT NULL DEFAULT '0',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`poll_id`),
  KEY `idx_createduserid_createdtime` (`created_userid`,`created_time`),
  KEY `idx_voternum` (`voter_num`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `pw_app_poll_option`;
CREATE TABLE `pw_app_poll_option` (
  `option_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `poll_id` int(10) unsigned NOT NULL DEFAULT '0',
  `voted_num` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `content` varchar(255) NOT NULL DEFAULT '',
  `image` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`option_id`),
  KEY `idx_pollid` (`poll_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `pw_app_poll_thread`;
CREATE TABLE `pw_app_poll_thread` (
  `tid` int(10) unsigned NOT NULL DEFAULT '0',
  `poll_id` int(10) unsigned NOT NULL DEFAULT '0',
  `created_userid` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`tid`),
  KEY `idx_pollid` (`poll_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `pw_app_poll_voter`;
CREATE TABLE `pw_app_poll_voter` (
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `poll_id` int(10) unsigned NOT NULL DEFAULT '0',
  `option_id` int(10) unsigned NOT NULL DEFAULT '0',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `idx_uid_createdtime` (`uid`,`created_time`),
  KEY `idx_pollid` (`poll_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `pw_attachs`;
CREATE TABLE `pw_attachs` (
  `aid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(80) NOT NULL DEFAULT '',
  `type` varchar(15) NOT NULL DEFAULT '',
  `size` int(10) unsigned NOT NULL DEFAULT '0',
  `path` varchar(80) NOT NULL DEFAULT '',
  `ifthumb` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `created_userid` int(10) unsigned NOT NULL DEFAULT '0',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  `app` varchar(15) NOT NULL DEFAULT '',
  `app_id` int(10) unsigned NOT NULL DEFAULT '0',
  `descrip` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`aid`),
  KEY `idx_app_appid` (`app`,`app_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `pw_attachs_thread`;
CREATE TABLE `pw_attachs_thread` (
  `aid` int(10) unsigned NOT NULL DEFAULT '0',
  `fid` smallint(6) unsigned NOT NULL DEFAULT '0',
  `tid` int(10) unsigned NOT NULL DEFAULT '0',
  `pid` int(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(80) NOT NULL DEFAULT '',
  `type` varchar(15) NOT NULL DEFAULT '',
  `size` int(10) unsigned NOT NULL DEFAULT '0',
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  `width` smallint(6) unsigned NOT NULL DEFAULT '0',
  `height` smallint(6) unsigned NOT NULL DEFAULT '0',
  `path` varchar(80) NOT NULL DEFAULT '',
  `ifthumb` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `special` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `cost` int(10) unsigned NOT NULL DEFAULT '0',
  `ctype` smallint(6) unsigned NOT NULL DEFAULT '0',
  `created_userid` int(10) unsigned NOT NULL DEFAULT '0',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  `descrip` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`aid`),
  KEY `idx_createduserid` (`created_userid`),
  KEY `idx_tid_pid` (`tid`,`pid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `pw_attachs_thread_buy`;
CREATE TABLE `pw_attachs_thread_buy` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `aid` int(10) unsigned NOT NULL DEFAULT '0',
  `created_userid` int(10) unsigned NOT NULL DEFAULT '0',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  `cost` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `ctype` tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_aid` (`aid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='帖子附件购买记录';

DROP TABLE IF EXISTS `pw_attention`;
CREATE TABLE `pw_attention` (
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `touid` int(10) unsigned NOT NULL DEFAULT '0',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`touid`,`uid`),
  KEY `idx_uid_createdtime` (`uid`,`created_time`),
  KEY `idx_touid_createdtime` (`touid`,`created_time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `pw_attention_fresh`;
CREATE TABLE `pw_attention_fresh` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `src_id` int(10) unsigned NOT NULL DEFAULT '0',
  `created_userid` int(10) unsigned NOT NULL DEFAULT '0',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_createduserid_createdtime` (`created_userid`,`created_time`),
  KEY `idx_type_srcid` (`type`,`src_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `pw_attention_fresh_index`;
CREATE TABLE `pw_attention_fresh_index` (
  `fresh_id` int(10) unsigned NOT NULL DEFAULT '0',
  `tid` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`fresh_id`),
  KEY `idx_tid` (`tid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='新鲜事与帖子关联表';

DROP TABLE IF EXISTS `pw_attention_fresh_relations`;
CREATE TABLE `pw_attention_fresh_relations` (
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `fresh_id` int(10) unsigned NOT NULL DEFAULT '0',
  `type` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `created_userid` int(10) unsigned NOT NULL DEFAULT '0',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `idx_uid_createdtime` (`uid`,`created_time`),
  KEY `idx_freshid` (`fresh_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `pw_attention_recommend_cron`;
CREATE TABLE `pw_attention_recommend_cron` (
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='可能认识的人更新任务表';

DROP TABLE IF EXISTS `pw_attention_recommend_friends`;
CREATE TABLE `pw_attention_recommend_friends` (
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `recommend_uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '潜在好友',
  `same_uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '共同好友',
  UNIQUE KEY `idx_uid_puid_suid` (`uid`,`recommend_uid`,`same_uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `pw_attention_type`;
CREATE TABLE `pw_attention_type` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(30) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_uid` (`uid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `pw_attention_type_relations`;
CREATE TABLE `pw_attention_type_relations` (
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `touid` int(10) unsigned NOT NULL DEFAULT '0',
  `typeid` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`uid`,`touid`,`typeid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `pw_bbs_forum`;
CREATE TABLE `pw_bbs_forum` (
  `fid` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `parentid` smallint(6) unsigned NOT NULL DEFAULT '0',
  `type` enum('category','forum','sub','sub2') NOT NULL DEFAULT 'forum',
  `issub` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `hassub` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `descrip` text,
  `vieworder` smallint(6) unsigned NOT NULL DEFAULT '0',
  `across` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `manager` varchar(255) NOT NULL DEFAULT '',
  `uppermanager` varchar(255) NOT NULL DEFAULT '',
  `icon` varchar(100) NOT NULL DEFAULT '',
  `logo` varchar(100) NOT NULL DEFAULT '',
  `fup` varchar(30) NOT NULL DEFAULT '',
  `isshow` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `isshowsub` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `newtime` smallint(6) unsigned NOT NULL DEFAULT '0',
  `password` varchar(32) NOT NULL DEFAULT '',
  `allow_visit` varchar(255) NOT NULL DEFAULT '',
  `allow_read` varchar(255) NOT NULL DEFAULT '',
  `allow_post` varchar(255) NOT NULL DEFAULT '',
  `allow_reply` varchar(255) NOT NULL DEFAULT '',
  `allow_upload` varchar(255) NOT NULL DEFAULT '',
  `allow_download` varchar(255) NOT NULL DEFAULT '',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  `created_username` varchar(15) NOT NULL DEFAULT '',
  `created_userid` int(10) unsigned NOT NULL DEFAULT '0',
  `created_ip` int(10) unsigned NOT NULL DEFAULT '0',
  `style` varchar(20) NOT NULL DEFAULT '',
  PRIMARY KEY (`fid`),
  KEY `idx_issub_vieworder` (`issub`,`vieworder`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `pw_bbs_forum_extra`;
CREATE TABLE `pw_bbs_forum_extra` (
  `fid` smallint(6) unsigned NOT NULL DEFAULT '0',
  `seo_description` varchar(255) NOT NULL DEFAULT '',
  `seo_keywords` varchar(255) NOT NULL DEFAULT '',
  `settings_basic` text,
  `settings_credit` text,
  PRIMARY KEY (`fid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `pw_bbs_forum_statistics`;
CREATE TABLE `pw_bbs_forum_statistics` (
  `fid` smallint(6) unsigned NOT NULL DEFAULT '0',
  `todayposts` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `todaythreads` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `article` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `posts` int(10) unsigned NOT NULL DEFAULT '0',
  `threads` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `subposts` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `subthreads` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `lastpost_info` char(35) NOT NULL DEFAULT '',
  `lastpost_time` int(10) unsigned NOT NULL DEFAULT '0',
  `lastpost_username` varchar(15) NOT NULL DEFAULT '',
  `lastpost_tid` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`fid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `pw_bbs_forum_user`;
CREATE TABLE `pw_bbs_forum_user` (
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `fid` smallint(6) unsigned NOT NULL DEFAULT '0',
  `join_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`uid`,`fid`),
  KEY `idx_fid_jointime` (`fid`,`join_time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='版块会员';

DROP TABLE IF EXISTS `pw_bbs_posts`;
CREATE TABLE `pw_bbs_posts` (
  `pid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `fid` smallint(6) unsigned NOT NULL DEFAULT '0',
  `tid` int(10) unsigned NOT NULL DEFAULT '0',
  `disabled` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `ischeck` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `ifshield` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `replies` int(10) unsigned NOT NULL DEFAULT '0',
  `useubb` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `aids` smallint(6) unsigned NOT NULL DEFAULT '0',
  `rpid` int(10) unsigned NOT NULL DEFAULT '0',
  `subject` varchar(100) NOT NULL DEFAULT '',
  `content` text,
  `like_count` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `sell_count` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  `created_username` varchar(15) NOT NULL DEFAULT '',
  `created_userid` int(10) unsigned NOT NULL DEFAULT '0',
  `created_ip` varchar(40) NOT NULL DEFAULT '',
  `reply_notice` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `modified_time` int(10) unsigned NOT NULL DEFAULT '0',
  `modified_username` varchar(15) NOT NULL DEFAULT '',
  `modified_userid` int(10) unsigned NOT NULL DEFAULT '0',
  `modified_ip` varchar(40) NOT NULL DEFAULT '',
  `reminds` varchar(255) NOT NULL DEFAULT '',
  `word_version` smallint(6) unsigned NOT NULL DEFAULT '0',
  `manage_remind` varchar(150) NOT NULL DEFAULT '',
  `topped` tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`pid`),
  KEY `idx_tid_disabled_createdtime` (`tid`,`disabled`,`created_time`),
  KEY `idx_disabled_createdtime` (`disabled`,`created_time`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `pw_bbs_posts_reply`;
CREATE TABLE `pw_bbs_posts_reply` (
  `pid` int(10) unsigned NOT NULL DEFAULT '0',
  `rpid` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`pid`),
  KEY `idx_rpid_pid` (`rpid`,`pid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='回复的回复';

DROP TABLE IF EXISTS `pw_bbs_posts_topped`;
CREATE TABLE `pw_bbs_posts_topped` (
  `pid` int(10) unsigned NOT NULL DEFAULT '0',
  `tid` int(10) unsigned NOT NULL,
  `floor` int(10) unsigned NOT NULL DEFAULT '0',
  `created_userid` int(10) unsigned NOT NULL DEFAULT '0',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`pid`),
  KEY `idx_tid_createdtime` (`tid`,`created_time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='贴内置顶';

DROP TABLE IF EXISTS `pw_bbs_specialsort`;
CREATE TABLE `pw_bbs_specialsort` (
  `sort_type` char(16) NOT NULL DEFAULT '',
  `fid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `tid` int(10) unsigned NOT NULL DEFAULT '0',
  `pid` int(10) unsigned NOT NULL DEFAULT '0',
  `extra` int(10) NOT NULL DEFAULT '0',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  `end_time` int(10) unsigned NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `pw_bbs_threads`;
CREATE TABLE `pw_bbs_threads` (
  `tid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `fid` smallint(6) unsigned NOT NULL DEFAULT '0',
  `topic_type` int(10) unsigned NOT NULL DEFAULT '0',
  `subject` varchar(100) NOT NULL DEFAULT '',
  `overtime` int(10) unsigned NOT NULL DEFAULT '0',
  `highlight` varchar(64) NOT NULL DEFAULT '',
  `inspect` varchar(30) NOT NULL DEFAULT '',
  `ifshield` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `digest` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `topped` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `disabled` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `ischeck` tinyint(3) NOT NULL DEFAULT '1',
  `replies` int(10) unsigned NOT NULL DEFAULT '0',
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  `like_count` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `special` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `tpcstatus` int(10) unsigned NOT NULL DEFAULT '0',
  `ifupload` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  `created_username` varchar(15) NOT NULL DEFAULT '',
  `created_userid` int(10) unsigned NOT NULL DEFAULT '0',
  `created_ip` varchar(40) NOT NULL DEFAULT '',
  `modified_time` int(10) unsigned NOT NULL DEFAULT '0',
  `modified_username` varchar(15) NOT NULL DEFAULT '',
  `modified_userid` int(10) unsigned NOT NULL DEFAULT '0',
  `modified_ip` varchar(40) NOT NULL DEFAULT '',
  `lastpost_time` int(10) unsigned NOT NULL DEFAULT '0',
  `lastpost_userid` int(10) unsigned NOT NULL DEFAULT '0',
  `lastpost_username` varchar(15) CHARACTER SET utf8 COLLATE utf8_czech_ci NOT NULL DEFAULT '',
  `special_sort` tinyint(4) NOT NULL DEFAULT '0',
  `reply_notice` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `reply_topped` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `thread_status` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`tid`),
  KEY `idx_fid_disabled_lastposttime` (`fid`,`disabled`,`lastpost_time`),
  KEY `idx_disabled_createdtime` (`disabled`,`created_time`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `pw_bbs_threads_buy`;
CREATE TABLE `pw_bbs_threads_buy` (
  `tid` int(10) unsigned NOT NULL DEFAULT '0',
  `pid` int(10) unsigned NOT NULL DEFAULT '0',
  `created_userid` int(10) unsigned NOT NULL DEFAULT '0',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  `ctype` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `cost` mediumint(8) unsigned NOT NULL DEFAULT '0',
  KEY `idx_tid_pid_createdtime` (`tid`,`pid`,`created_time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `pw_bbs_threads_cate_index`;
CREATE TABLE `pw_bbs_threads_cate_index` (
  `tid` int(10) unsigned NOT NULL DEFAULT '0',
  `cid` smallint(6) unsigned NOT NULL DEFAULT '0',
  `fid` smallint(6) unsigned NOT NULL DEFAULT '0',
  `disabled` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  `lastpost_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`tid`),
  KEY `idx_cid_lastposttime` (`cid`,`lastpost_time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='帖子索引表-分类索引';

DROP TABLE IF EXISTS `pw_bbs_threads_content`;
CREATE TABLE `pw_bbs_threads_content` (
  `tid` int(10) unsigned NOT NULL DEFAULT '0',
  `useubb` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `aids` smallint(6) unsigned NOT NULL DEFAULT '0',
  `content` text,
  `sell_count` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `reminds` varchar(255) NOT NULL DEFAULT '',
  `word_version` smallint(6) unsigned NOT NULL DEFAULT '0',
  `tags` varchar(255) NOT NULL DEFAULT '',
  `manage_remind` varchar(150) NOT NULL DEFAULT '',
  PRIMARY KEY (`tid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `pw_bbs_threads_digest_index`;
CREATE TABLE `pw_bbs_threads_digest_index` (
  `tid` int(10) unsigned NOT NULL DEFAULT '0',
  `fid` smallint(6) unsigned NOT NULL DEFAULT '0',
  `cid` smallint(6) unsigned NOT NULL DEFAULT '0',
  `topic_type` int(10) unsigned NOT NULL DEFAULT '0',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  `lastpost_time` int(10) unsigned NOT NULL DEFAULT '0',
  `operator` varchar(15) NOT NULL DEFAULT '',
  `operator_userid` int(10) unsigned NOT NULL DEFAULT '0',
  `operator_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`tid`),
  KEY `idx_cid_lastposttime` (`cid`,`lastpost_time`),
  KEY `idx_fid_lastposttime_topictype` (`fid`,`lastpost_time`,`topic_type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='精华帖子索引表';

DROP TABLE IF EXISTS `pw_bbs_threads_index`;
CREATE TABLE `pw_bbs_threads_index` (
  `tid` int(10) unsigned NOT NULL DEFAULT '0',
  `fid` smallint(6) unsigned NOT NULL DEFAULT '0',
  `disabled` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  `lastpost_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`tid`),
  KEY `idx_lastposttime` (`lastpost_time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='帖子索引表-新帖索引';

DROP TABLE IF EXISTS `pw_bbs_threads_overtime`;
CREATE TABLE `pw_bbs_threads_overtime` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tid` int(10) unsigned NOT NULL DEFAULT '0',
  `m_type` enum('topped','highlight') NOT NULL,
  `overtime` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_tid_mtype` (`tid`,`m_type`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `pw_bbs_threads_sort`;
CREATE TABLE `pw_bbs_threads_sort` (
  `fid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `tid` int(10) unsigned NOT NULL DEFAULT '0',
  `extra` int(10) NOT NULL DEFAULT '0',
  `sort_type` varchar(20) NOT NULL DEFAULT '',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  `end_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`fid`,`tid`),
  KEY `idx_tid` (`tid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='帖子排序表';

DROP TABLE IF EXISTS `pw_bbs_topic_type`;
CREATE TABLE `pw_bbs_topic_type` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `fid` int(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL,
  `parentid` int(10) unsigned NOT NULL DEFAULT '0',
  `logo` varchar(255) NOT NULL DEFAULT '',
  `vieworder` tinyint(3) NOT NULL DEFAULT '0',
  `issys` tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `pw_bbs_topped`;
CREATE TABLE `pw_bbs_topped` (
  `fid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `tid` int(10) unsigned NOT NULL DEFAULT '0',
  `pid` int(10) unsigned NOT NULL DEFAULT '0',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  `end_time` int(10) unsigned NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `pw_cache`;
CREATE TABLE `pw_cache` (
  `cache_key` char(32) NOT NULL,
  `cache_value` text,
  `cache_expire` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`cache_key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `pw_common_config`;
CREATE TABLE `pw_common_config` (
  `name` varchar(30) NOT NULL,
  `namespace` varchar(15) NOT NULL DEFAULT 'global',
  `value` text,
  `vtype` enum('string','array','object') NOT NULL DEFAULT 'string',
  `description` text,
  PRIMARY KEY (`namespace`,`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='网站配置表';

DROP TABLE IF EXISTS `pw_common_cron`;
CREATE TABLE `pw_common_cron` (
  `cron_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `subject` varchar(50) NOT NULL DEFAULT '',
  `loop_type` varchar(10) NOT NULL DEFAULT '',
  `loop_daytime` varchar(50) NOT NULL DEFAULT '',
  `cron_file` varchar(50) NOT NULL DEFAULT '',
  `isopen` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  `modified_time` int(10) unsigned NOT NULL DEFAULT '0',
  `next_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`cron_id`),
  KEY `idx_next_time` (`next_time`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='计划任务表';

DROP TABLE IF EXISTS `pw_common_emotion`;
CREATE TABLE `pw_common_emotion` (
  `emotion_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `emotion_name` varchar(20) NOT NULL DEFAULT '',
  `emotion_folder` varchar(20) NOT NULL DEFAULT '',
  `emotion_icon` varchar(50) NOT NULL DEFAULT '',
  `vieworder` int(10) unsigned NOT NULL DEFAULT '0',
  `isused` tinyint(3) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`emotion_id`),
  KEY `idx_catid` (`category_id`),
  KEY `idx_isused` (`isused`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='表情数据表';

DROP TABLE IF EXISTS `pw_common_emotion_category`;
CREATE TABLE `pw_common_emotion_category` (
  `category_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_name` varchar(20) NOT NULL DEFAULT '',
  `emotion_folder` varchar(20) NOT NULL DEFAULT '',
  `emotion_apps` varchar(50) NOT NULL DEFAULT '',
  `orderid` int(10) unsigned NOT NULL DEFAULT '0',
  `isopen` tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`category_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='表情分类表';

DROP TABLE IF EXISTS `pw_common_nav`;
CREATE TABLE `pw_common_nav` (
  `navid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `parentid` int(10) unsigned NOT NULL DEFAULT '0',
  `rootid` int(10) unsigned NOT NULL DEFAULT '0',
  `type` varchar(32) NOT NULL DEFAULT '',
  `sign` varchar(32) NOT NULL DEFAULT '',
  `name` char(50) NOT NULL DEFAULT '',
  `style` char(50) NOT NULL DEFAULT '',
  `link` char(100) NOT NULL DEFAULT '',
  `alt` char(50) NOT NULL DEFAULT '',
  `target` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `isshow` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `orderid` tinyint(4) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`navid`),
  KEY `idx_type` (`type`),
  KEY `idx_rootid` (`rootid`),
  KEY `idx_orderid` (`orderid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='导航表';

DROP TABLE IF EXISTS `pw_common_process`;
CREATE TABLE `pw_common_process` (
  `flag` varchar(20) NOT NULL DEFAULT '',
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `expired_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`flag`(10),`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='进程控制表';

DROP TABLE IF EXISTS `pw_credit_log`;
CREATE TABLE `pw_credit_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ctype` varchar(8) NOT NULL DEFAULT '',
  `affect` int(10) NOT NULL DEFAULT '0',
  `logtype` varchar(40) NOT NULL DEFAULT '',
  `descrip` varchar(255) NOT NULL DEFAULT '',
  `created_userid` int(10) unsigned NOT NULL DEFAULT '0',
  `created_username` varchar(15) NOT NULL DEFAULT '',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_createduserid_createdtime` (`created_userid`,`created_time`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='积分日志表';

DROP TABLE IF EXISTS `pw_credit_log_operate`;
CREATE TABLE `pw_credit_log_operate` (
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `operate` varchar(40) NOT NULL DEFAULT '',
  `num` smallint(6) unsigned NOT NULL DEFAULT '0',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`uid`,`operate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='积分操作日志表';

DROP TABLE IF EXISTS `pw_design_bak`;
CREATE TABLE `pw_design_bak` (
  `bak_type` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `page_id` int(10) unsigned NOT NULL DEFAULT '0',
  `is_snapshot` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '是否快照',
  `bak_info` text,
  PRIMARY KEY (`page_id`,`bak_type`,`is_snapshot`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='门户务份表';

DROP TABLE IF EXISTS `pw_design_component`;
CREATE TABLE `pw_design_component` (
  `comp_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `model_flag` varchar(20) NOT NULL DEFAULT '',
  `comp_name` varchar(50) NOT NULL DEFAULT '',
  `comp_tpl` text,
  PRIMARY KEY (`comp_id`),
  KEY `idx_modelflag` (`model_flag`(10))
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='模版元件表';

DROP TABLE IF EXISTS `pw_design_cron`;
CREATE TABLE `pw_design_cron` (
  `module_id` int(10) unsigned NOT NULL DEFAULT '0',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`module_id`),
  KEY `idx_createdtime` (`created_time`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COMMENT='门户更新任务表';

DROP TABLE IF EXISTS `pw_design_data`;
CREATE TABLE `pw_design_data` (
  `data_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `from_type` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `from_app` varchar(20) NOT NULL DEFAULT '',
  `from_id` int(10) unsigned NOT NULL DEFAULT '0',
  `module_id` int(10) unsigned NOT NULL DEFAULT '0',
  `standard` varchar(255) NOT NULL DEFAULT '',
  `style` varchar(255) NOT NULL DEFAULT '',
  `extend_info` text,
  `data_type` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `is_reservation` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `vieworder` int(10) unsigned NOT NULL DEFAULT '0',
  `start_time` int(10) unsigned NOT NULL DEFAULT '0',
  `end_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`data_id`),
  KEY `idx_moduleid` (`module_id`),
  KEY `idx_datatype` (`data_type`),
  KEY `idx_vieworder` (`vieworder`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='数据缓存表';

DROP TABLE IF EXISTS `pw_design_module`;
CREATE TABLE `pw_design_module` (
  `module_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `page_id` int(10) unsigned NOT NULL DEFAULT '0',
  `module_struct` varchar(20) NOT NULL DEFAULT '',
  `model_flag` varchar(20) NOT NULL DEFAULT '',
  `module_name` varchar(50) NOT NULL DEFAULT '',
  `module_property` text,
  `module_title` text,
  `module_style` text,
  `module_compid` int(10) unsigned NOT NULL DEFAULT '0',
  `module_tpl` text,
  `module_cache` varchar(255) NOT NULL DEFAULT '',
  `isused` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `module_type` tinyint(1) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`module_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='调用模块表';

DROP TABLE IF EXISTS `pw_design_page`;
CREATE TABLE `pw_design_page` (
  `page_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `page_type` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `page_name` varchar(50) NOT NULL DEFAULT '',
  `page_router` varchar(50) NOT NULL DEFAULT '',
  `page_unique` int(10) unsigned NOT NULL DEFAULT '0',
  `is_unique` int(10) unsigned NOT NULL DEFAULT '0',
  `module_ids` varchar(255) NOT NULL DEFAULT '',
  `struct_names` varchar(255) NOT NULL DEFAULT '',
  `segments` varchar(255) NOT NULL DEFAULT '',
  `design_lock` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`page_id`),
  KEY `idx_pagerouter` (`page_router`(10))
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='页面信息表';

DROP TABLE IF EXISTS `pw_design_permissions`;
CREATE TABLE `pw_design_permissions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `design_type` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `design_id` int(10) unsigned NOT NULL DEFAULT '0',
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `permissions` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`),
  KEY `idx_designtype_designid_uid` (`design_type`,`design_id`,`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='设计片段权限表';

DROP TABLE IF EXISTS `pw_design_portal`;
CREATE TABLE `pw_design_portal` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pagename` varchar(50) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `keywords` varchar(255) NOT NULL DEFAULT '',
  `description` varchar(255) NOT NULL DEFAULT '',
  `domain` varchar(50) NOT NULL DEFAULT '',
  `cover` varchar(255) NOT NULL DEFAULT '',
  `isopen` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `header` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `navigate` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `footer` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `template` varchar(50) NOT NULL DEFAULT '',
  `style` text,
  `created_uid` int(10) unsigned NOT NULL DEFAULT '0',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_pagename` (`pagename`(5))
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='自定义页面信息表';

DROP TABLE IF EXISTS `pw_design_push`;
CREATE TABLE `pw_design_push` (
  `push_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `push_from_id` int(10) unsigned NOT NULL DEFAULT '0',
  `push_from_model` varchar(20) NOT NULL DEFAULT '',
  `module_id` int(10) unsigned NOT NULL DEFAULT '0',
  `push_standard` varchar(255) NOT NULL DEFAULT '',
  `push_style` varchar(255) NOT NULL DEFAULT '',
  `push_orderid` int(10) unsigned NOT NULL DEFAULT '0',
  `push_extend` text,
  `created_userid` int(10) unsigned NOT NULL DEFAULT '0',
  `author_uid` int(10) unsigned NOT NULL DEFAULT '0',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `neednotice` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `check_uid` int(10) unsigned NOT NULL DEFAULT '0',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  `start_time` int(10) unsigned NOT NULL DEFAULT '0',
  `end_time` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`push_id`),
  KEY `idx_end_time` (`end_time`),
  KEY `idx_status` (`status`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='信息推送表';

DROP TABLE IF EXISTS `pw_design_script`;
CREATE TABLE `pw_design_script` (
  `module_id` int(10) unsigned NOT NULL,
  `token` char(10) NOT NULL DEFAULT '',
  `view_times` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`module_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='模块调用管理表';

DROP TABLE IF EXISTS `pw_design_segment`;
CREATE TABLE `pw_design_segment` (
  `segment` varchar(20) NOT NULL DEFAULT '',
  `page_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `segment_tpl` text,
  `segment_struct` text,
  PRIMARY KEY (`segment`,`page_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='门户片段表';

DROP TABLE IF EXISTS `pw_design_shield`;
CREATE TABLE `pw_design_shield` (
  `shield_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `from_app` varchar(20) NOT NULL DEFAULT '',
  `from_id` int(10) unsigned NOT NULL DEFAULT '0',
  `module_id` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`shield_id`),
  KEY `idx_moduleid` (`module_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='门户模块数据屏蔽表';

DROP TABLE IF EXISTS `pw_design_structure`;
CREATE TABLE `pw_design_structure` (
  `struct_name` varchar(20) NOT NULL DEFAULT '',
  `struct_title` text,
  `struct_style` text,
  PRIMARY KEY (`struct_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='结构数据表';

DROP TABLE IF EXISTS `pw_domain`;
CREATE TABLE `pw_domain` (
  `domain_key` varchar(100) NOT NULL DEFAULT '',
  `domain_type` varchar(15) NOT NULL DEFAULT '',
  `domain` varchar(15) NOT NULL DEFAULT '',
  `root` varchar(45) NOT NULL DEFAULT '',
  `first` char(1) NOT NULL DEFAULT '' COMMENT '域名首字母便于更新',
  `id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '部署应用的id值',
  PRIMARY KEY (`domain_key`),
  KEY `idx_domaintype` (`domain_type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='二级域名';

DROP TABLE IF EXISTS `pw_draft`;
CREATE TABLE `pw_draft` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `created_userid` int(10) unsigned NOT NULL DEFAULT '0',
  `title` varchar(100) NOT NULL DEFAULT '',
  `content` text,
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_uid` (`created_userid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='草稿箱';

DROP TABLE IF EXISTS `pw_frag_template`;
CREATE TABLE `pw_frag_template` (
  `tpl_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `frag_cid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `tpl_name` varchar(50) NOT NULL DEFAULT '',
  `template` text,
  PRIMARY KEY (`tpl_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `pw_hook`;
CREATE TABLE `pw_hook` (
  `name` varchar(50) NOT NULL DEFAULT '',
  `app_id` char(20) NOT NULL DEFAULT '',
  `app_name` varchar(100) NOT NULL DEFAULT '',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  `modified_time` int(10) unsigned NOT NULL DEFAULT '0',
  `document` text,
  PRIMARY KEY (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `pw_hook_inject`;
CREATE TABLE `pw_hook_inject` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `hook_name` varchar(100) NOT NULL DEFAULT '',
  `alias` varchar(100) NOT NULL DEFAULT '',
  `class` varchar(100) NOT NULL DEFAULT '',
  `method` varchar(100) NOT NULL DEFAULT '',
  `loadway` varchar(20) NOT NULL DEFAULT '',
  `expression` varchar(100) NOT NULL DEFAULT '',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  `modified_time` int(10) unsigned NOT NULL DEFAULT '0',
  `description` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_hook_name` (`hook_name`,`alias`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `pw_invite_code`;
CREATE TABLE `pw_invite_code` (
  `code` char(32) NOT NULL DEFAULT '',
  `created_userid` int(10) NOT NULL DEFAULT '0',
  `invited_userid` int(10) NOT NULL DEFAULT '0',
  `ifused` tinyint(1) NOT NULL DEFAULT '0',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  `modified_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`code`),
  KEY `idx_createduid` (`created_userid`),
  KEY `idx_inviteduid` (`invited_userid`),
  KEY `idx_createdtime` (`created_time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='邀请码记录表';

DROP TABLE IF EXISTS `pw_like_content`;
CREATE TABLE `pw_like_content` (
  `likeid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `typeid` int(10) unsigned NOT NULL DEFAULT '0',
  `fromid` int(10) unsigned NOT NULL DEFAULT '0',
  `isspecial` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `users` varchar(50) NOT NULL DEFAULT '',
  `reply_pid` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`likeid`),
  KEY `idx_isspecial` (`isspecial`),
  KEY `idx_typeid_fromid` (`typeid`,`fromid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='喜欢内容表';

DROP TABLE IF EXISTS `pw_like_log`;
CREATE TABLE `pw_like_log` (
  `logid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `likeid` int(10) unsigned NOT NULL DEFAULT '0',
  `tagids` varchar(50) NOT NULL DEFAULT '',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`logid`),
  KEY `idx_uid` (`uid`),
  KEY `idx_created_time` (`created_time`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='喜欢记录表';

DROP TABLE IF EXISTS `pw_like_source`;
CREATE TABLE `pw_like_source` (
  `sid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `subject` varchar(250) NOT NULL DEFAULT '',
  `sourceUrl` varchar(50) NOT NULL DEFAULT '',
  `fromApp` varchar(20) NOT NULL DEFAULT '',
  `fromid` int(10) unsigned NOT NULL DEFAULT '0',
  `like_count` mediumint(8) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`sid`),
  KEY `idx_fromid` (`fromid`,`fromApp`(10))
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='喜欢app来源表';

DROP TABLE IF EXISTS `pw_like_statistics`;
CREATE TABLE `pw_like_statistics` (
  `signkey` varchar(20) NOT NULL,
  `likeid` int(10) unsigned NOT NULL DEFAULT '0',
  `typeid` int(10) unsigned NOT NULL DEFAULT '0',
  `fromid` int(10) unsigned NOT NULL DEFAULT '0',
  `number` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `idx_number` (`number`),
  KEY `idx_signkey` (`signkey`(10))
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='喜欢静态数据表';

DROP TABLE IF EXISTS `pw_like_tag`;
CREATE TABLE `pw_like_tag` (
  `tagid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `tagname` varchar(20) NOT NULL DEFAULT '',
  `number` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`tagid`),
  KEY `idx_uid` (`uid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='喜欢分类表';

DROP TABLE IF EXISTS `pw_like_tag_relations`;
CREATE TABLE `pw_like_tag_relations` (
  `logid` int(10) unsigned NOT NULL,
  `tagid` int(10) unsigned NOT NULL,
  KEY `idx_logid` (`logid`),
  KEY `idx_tagid` (`tagid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='喜欢分类-喜欢关系表';

DROP TABLE IF EXISTS `pw_link`;
CREATE TABLE `pw_link` (
  `lid` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `vieworder` tinyint(3) NOT NULL DEFAULT '0',
  `name` varchar(15) NOT NULL DEFAULT '',
  `url` varchar(255) NOT NULL DEFAULT '',
  `descrip` varchar(255) NOT NULL DEFAULT '',
  `logo` varchar(100) NOT NULL DEFAULT '',
  `iflogo` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `ifcheck` tinyint(3) NOT NULL DEFAULT '0',
  `contact` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`lid`),
  KEY `idx_ifcheck_vieworder` (`ifcheck`,`vieworder`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='友情链接表';

DROP TABLE IF EXISTS `pw_link_relations`;
CREATE TABLE `pw_link_relations` (
  `lid` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `typeid` smallint(6) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`lid`,`typeid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='友情链接分类关系表';

DROP TABLE IF EXISTS `pw_link_type`;
CREATE TABLE `pw_link_type` (
  `typeid` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `typename` varchar(6) NOT NULL DEFAULT '',
  `vieworder` smallint(6) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`typeid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='友情链接分类表';

DROP TABLE IF EXISTS `pw_medal_info`;
CREATE TABLE `pw_medal_info` (
  `medal_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL DEFAULT '',
  `path` varchar(50) NOT NULL DEFAULT '',
  `image` varchar(50) NOT NULL DEFAULT '',
  `icon` varchar(50) NOT NULL DEFAULT '',
  `descrip` varchar(255) NOT NULL DEFAULT '',
  `medal_type` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `receive_type` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `medal_gids` varchar(50) NOT NULL DEFAULT '',
  `award_type` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `award_condition` smallint(5) unsigned NOT NULL DEFAULT '0',
  `expired_days` smallint(5) unsigned NOT NULL DEFAULT '0',
  `isopen` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `vieworder` tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`medal_id`),
  KEY `idx_orderid` (`vieworder`),
  KEY `idx_isopen` (`isopen`),
  KEY `idx_award_type` (`award_type`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='勋章信息表';

DROP TABLE IF EXISTS `pw_medal_log`;
CREATE TABLE `pw_medal_log` (
  `log_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `medal_id` int(10) unsigned NOT NULL DEFAULT '0',
  `award_status` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT '1,进行2，申请3，领取4,显示',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  `expired_time` int(10) unsigned NOT NULL DEFAULT '0',
  `log_order` tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`log_id`),
  UNIQUE KEY `idx_uid_medalid` (`uid`,`medal_id`),
  KEY `idx_expired_time` (`expired_time`),
  KEY `idx_log_order` (`log_order`),
  KEY `idx_awardstatus` (`award_status`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='勋章记录表';

DROP TABLE IF EXISTS `pw_medal_user`;
CREATE TABLE `pw_medal_user` (
  `uid` int(10) unsigned NOT NULL,
  `medals` varchar(255) NOT NULL DEFAULT '',
  `counts` int(10) unsigned NOT NULL DEFAULT '0',
  `expired_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`uid`),
  KEY `idx_counts` (`counts`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='勋章用户-统计表';

DROP TABLE IF EXISTS `pw_message_config`;
CREATE TABLE `pw_message_config` (
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `privacy` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `notice_types` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='消息用户配置表';

DROP TABLE IF EXISTS `pw_message_notices`;
CREATE TABLE `pw_message_notices` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `typeid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `param` int(10) NOT NULL DEFAULT '0',
  `is_read` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `is_ignore` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `extend_params` text,
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  `modified_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_uid_read_modifiedtime` (`uid`,`is_read`,`modified_time`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='通知表';

DROP TABLE IF EXISTS `pw_online_guest`;
CREATE TABLE `pw_online_guest` (
  `ip` int(10) unsigned NOT NULL DEFAULT '0',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  `modify_time` int(10) unsigned NOT NULL DEFAULT '0',
  `fid` int(10) unsigned NOT NULL DEFAULT '0',
  `tid` int(10) unsigned NOT NULL DEFAULT '0',
  `request` char(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`ip`,`created_time`),
  KEY `idx_fid` (`fid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='在线-游客表';

DROP TABLE IF EXISTS `pw_online_statistics`;
CREATE TABLE `pw_online_statistics` (
  `signkey` char(20) NOT NULL DEFAULT '',
  `number` int(10) unsigned NOT NULL DEFAULT '0',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`signkey`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='在线-数据统计表';

DROP TABLE IF EXISTS `pw_online_user`;
CREATE TABLE `pw_online_user` (
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `username` char(15) NOT NULL DEFAULT '',
  `modify_time` int(10) unsigned NOT NULL DEFAULT '0',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  `gid` int(10) unsigned NOT NULL DEFAULT '0',
  `fid` int(10) unsigned NOT NULL DEFAULT '0',
  `tid` int(10) unsigned NOT NULL DEFAULT '0',
  `request` char(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`uid`),
  KEY `idx_fid` (`fid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='在线-用户表';

DROP TABLE IF EXISTS `pw_pay_order`;
CREATE TABLE `pw_pay_order` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `order_no` char(30) NOT NULL DEFAULT '',
  `price` decimal(8,2) NOT NULL DEFAULT '0.00',
  `number` smallint(6) unsigned NOT NULL DEFAULT '0',
  `state` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `payemail` varchar(60) NOT NULL DEFAULT '',
  `paymethod` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `paytype` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `buy` int(10) unsigned NOT NULL DEFAULT '0',
  `created_userid` int(10) unsigned NOT NULL DEFAULT '0',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  `extra_1` int(10) unsigned NOT NULL DEFAULT '0',
  `extra_2` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_orderno` (`order_no`),
  KEY `idx_createduserid` (`created_userid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='支付订单表';

DROP TABLE IF EXISTS `pw_recycle_reply`;
CREATE TABLE `pw_recycle_reply` (
  `pid` int(10) unsigned NOT NULL DEFAULT '0',
  `tid` int(10) unsigned NOT NULL DEFAULT '0',
  `fid` int(10) unsigned NOT NULL DEFAULT '0',
  `operate_time` int(10) unsigned NOT NULL DEFAULT '0',
  `operate_username` varchar(15) NOT NULL DEFAULT '',
  `reason` text,
  PRIMARY KEY (`pid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `pw_recycle_topic`;
CREATE TABLE `pw_recycle_topic` (
  `tid` int(10) unsigned NOT NULL DEFAULT '0',
  `fid` smallint(6) unsigned NOT NULL DEFAULT '0',
  `operate_time` int(10) unsigned NOT NULL DEFAULT '0',
  `operate_username` varchar(15) NOT NULL DEFAULT '',
  `reason` text,
  PRIMARY KEY (`tid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `pw_remind`;
CREATE TABLE `pw_remind` (
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `touid` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `pw_report`;
CREATE TABLE `pw_report` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` smallint(5) unsigned NOT NULL DEFAULT '0',
  `type_id` int(10) NOT NULL DEFAULT '0',
  `content` varchar(100) NOT NULL DEFAULT '',
  `content_url` varchar(255) NOT NULL DEFAULT '',
  `author_userid` int(10) unsigned NOT NULL DEFAULT '0',
  `created_userid` int(10) unsigned NOT NULL DEFAULT '0',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  `reason` varchar(255) NOT NULL DEFAULT '',
  `ifcheck` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `operate_userid` int(10) unsigned NOT NULL DEFAULT '0',
  `operate_time` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `pw_seo`;
CREATE TABLE `pw_seo` (
  `mod` varchar(15) NOT NULL DEFAULT '',
  `page` varchar(20) NOT NULL DEFAULT '',
  `param` varchar(20) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `keywords` varchar(255) NOT NULL DEFAULT '',
  `description` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`mod`,`page`,`param`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='seo';

DROP TABLE IF EXISTS `pw_space`;
CREATE TABLE `pw_space` (
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `space_name` varchar(50) NOT NULL DEFAULT '',
  `space_descrip` varchar(255) NOT NULL DEFAULT '',
  `space_domain` varchar(20) NOT NULL DEFAULT '',
  `space_style` varchar(20) NOT NULL DEFAULT '',
  `back_image` varchar(255) NOT NULL DEFAULT '',
  `visit_count` int(10) unsigned NOT NULL DEFAULT '0',
  `visitors` varchar(255) NOT NULL DEFAULT '',
  `tovisitors` varchar(255) NOT NULL DEFAULT '',
  `space_privacy` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`uid`),
  KEY `idx_space_domain` (`space_domain`(10))
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='个人空间信息表';

DROP TABLE IF EXISTS `pw_style`;
CREATE TABLE `pw_style` (
  `app_id` char(20) NOT NULL DEFAULT '',
  `iscurrent` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `style_type` char(10) NOT NULL DEFAULT '',
  `name` varchar(100) NOT NULL DEFAULT '',
  `alias` varchar(100) NOT NULL DEFAULT '',
  `logo` varchar(100) NOT NULL DEFAULT '',
  `author_name` varchar(30) NOT NULL DEFAULT '',
  `author_icon` varchar(100) NOT NULL DEFAULT '',
  `author_email` varchar(200) NOT NULL DEFAULT '',
  `website` varchar(200) NOT NULL DEFAULT '',
  `version` varchar(50) NOT NULL DEFAULT '',
  `pw_version` varchar(50) NOT NULL DEFAULT '',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  `modified_time` int(10) unsigned NOT NULL DEFAULT '0',
  `description` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`app_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `pw_tag`;
CREATE TABLE `pw_tag` (
  `tag_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `parent_tag_id` int(10) unsigned NOT NULL DEFAULT '0',
  `tag_name` char(60) NOT NULL DEFAULT '',
  `tag_logo` varchar(255) NOT NULL DEFAULT '',
  `ifhot` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `excerpt` varchar(255) NOT NULL DEFAULT '',
  `content_count` int(10) unsigned NOT NULL DEFAULT '0',
  `attention_count` int(10) unsigned NOT NULL DEFAULT '0',
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  `created_userid` int(10) unsigned NOT NULL DEFAULT '0',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  `iflogo` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `seo_title` varchar(255) NOT NULL DEFAULT '',
  `seo_description` varchar(255) NOT NULL DEFAULT '',
  `seo_keywords` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`tag_id`),
  UNIQUE KEY `idx_tagname` (`tag_name`),
  KEY `idx_parenttagid` (`parent_tag_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='话题表';

DROP TABLE IF EXISTS `pw_tag_attention`;
CREATE TABLE `pw_tag_attention` (
  `uid` int(10) unsigned NOT NULL,
  `tag_id` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `last_read_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`tag_id`,`uid`),
  KEY `idx_uid_lastreadtime` (`uid`,`last_read_time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='话题关注表';

DROP TABLE IF EXISTS `pw_tag_category`;
CREATE TABLE `pw_tag_category` (
  `category_id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `category_name` char(20) NOT NULL DEFAULT '',
  `alias` varchar(15) NOT NULL DEFAULT '',
  `vieworder` smallint(6) unsigned NOT NULL DEFAULT '0',
  `tag_count` int(10) unsigned NOT NULL DEFAULT '0',
  `seo_title` varchar(255) NOT NULL DEFAULT '',
  `seo_description` varchar(255) NOT NULL DEFAULT '',
  `seo_keywords` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`category_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='话题分类表';

DROP TABLE IF EXISTS `pw_tag_category_relation`;
CREATE TABLE `pw_tag_category_relation` (
  `tag_id` int(10) unsigned NOT NULL DEFAULT '0',
  `category_id` smallint(6) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`category_id`,`tag_id`),
  KEY `idx_tagid` (`tag_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='话题分类关系表';

DROP TABLE IF EXISTS `pw_tag_record`;
CREATE TABLE `pw_tag_record` (
  `tag_id` int(10) unsigned NOT NULL DEFAULT '0',
  `is_reply` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `idx_tagid` (`tag_id`),
  KEY `idx_updatetime` (`update_time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='话题排行统计表';

DROP TABLE IF EXISTS `pw_tag_relation`;
CREATE TABLE `pw_tag_relation` (
  `tag_id` int(10) unsigned NOT NULL,
  `content_tag_id` int(10) unsigned NOT NULL DEFAULT '0',
  `type_id` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `param_id` int(10) unsigned NOT NULL DEFAULT '0',
  `ifcheck` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`type_id`,`param_id`,`content_tag_id`),
  KEY `idx_tagid_typeid` (`tag_id`,`type_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='话题内容关系表';

DROP TABLE IF EXISTS `pw_task`;
CREATE TABLE `pw_task` (
  `taskid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pre_task` int(10) unsigned NOT NULL DEFAULT '0',
  `is_auto` tinyint(1) NOT NULL DEFAULT '0',
  `is_display_all` tinyint(1) NOT NULL DEFAULT '0',
  `view_order` smallint(6) NOT NULL DEFAULT '0',
  `is_open` tinyint(3) NOT NULL DEFAULT '0',
  `start_time` int(10) unsigned NOT NULL DEFAULT '0',
  `end_time` int(10) unsigned NOT NULL DEFAULT '0',
  `period` smallint(6) NOT NULL DEFAULT '0',
  `title` varchar(100) NOT NULL DEFAULT '',
  `description` varchar(255) NOT NULL DEFAULT '',
  `icon` varchar(200) NOT NULL DEFAULT '',
  `user_groups` varchar(255) NOT NULL DEFAULT '-1',
  `reward` varchar(255) NOT NULL DEFAULT '',
  `conditions` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`taskid`),
  KEY `idx_pretask` (`pre_task`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='任务';

DROP TABLE IF EXISTS `pw_task_cache`;
CREATE TABLE `pw_task_cache` (
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `task_ids` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='任务缓存';

DROP TABLE IF EXISTS `pw_task_group`;
CREATE TABLE `pw_task_group` (
  `taskid` int(10) unsigned NOT NULL DEFAULT '0',
  `gid` int(10) NOT NULL DEFAULT '0',
  `is_auto` tinyint(1) NOT NULL DEFAULT '0',
  `end_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`gid`,`taskid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='任务索引';

DROP TABLE IF EXISTS `pw_task_user`;
CREATE TABLE `pw_task_user` (
  `taskid` int(10) unsigned NOT NULL DEFAULT '0',
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `task_status` tinyint(3) NOT NULL DEFAULT '0',
  `is_period` tinyint(1) NOT NULL DEFAULT '0',
  `step` varchar(100) NOT NULL DEFAULT '',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  `finish_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`uid`,`taskid`),
  KEY `idx_uid_taskstatus` (`uid`,`task_status`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='任务用户';

DROP TABLE IF EXISTS `pw_user`;
CREATE TABLE `pw_user` (
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `username` varchar(15) NOT NULL DEFAULT '',
  `email` varchar(40) NOT NULL DEFAULT '',
  `password` char(32) NOT NULL DEFAULT '',
  `status` smallint(6) NOT NULL DEFAULT '0' COMMENT '状态',
  `vippoint` int(10) unsigned NOT NULL DEFAULT '0',
  `memberpoint` int(10) unsigned NOT NULL DEFAULT '0',
  `groupid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `vipid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `memberid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `regdate` int(10) unsigned NOT NULL DEFAULT '0',
  `realname` varchar(50) NOT NULL DEFAULT '',
  `groups` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`uid`),
  UNIQUE KEY `idx_username` (`username`),
  KEY `idx_email` (`email`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='用户基本表';

DROP TABLE IF EXISTS `pw_user_active_code`;
CREATE TABLE `pw_user_active_code` (
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `email` varchar(80) NOT NULL DEFAULT '',
  `code` varchar(10) NOT NULL DEFAULT '',
  `send_time` int(10) unsigned NOT NULL DEFAULT '0',
  `active_time` int(10) unsigned NOT NULL DEFAULT '0',
  `typeid` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='用户邮箱激活码表';

DROP TABLE IF EXISTS `pw_user_ban`;
CREATE TABLE `pw_user_ban` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `typeid` char(20) NOT NULL DEFAULT '',
  `fid` int(10) unsigned NOT NULL DEFAULT '0',
  `end_time` int(10) unsigned NOT NULL DEFAULT '0',
  `created_userid` int(10) unsigned NOT NULL DEFAULT '0',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  `reason` varchar(80) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_uid_typeid_fid` (`uid`,`typeid`,`fid`),
  KEY `idx_createdUid` (`created_userid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='用户禁止记录表';

DROP TABLE IF EXISTS `pw_user_behavior`;
CREATE TABLE `pw_user_behavior` (
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `behavior` char(20) NOT NULL DEFAULT '',
  `number` int(10) NOT NULL DEFAULT '0',
  `expired_time` int(10) unsigned NOT NULL DEFAULT '0',
  `extend_info` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`uid`,`behavior`(10))
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='用户行为统计表';

DROP TABLE IF EXISTS `pw_user_belong`;
CREATE TABLE `pw_user_belong` (
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `gid` mediumint(8) NOT NULL DEFAULT '0',
  `endtime` int(10) unsigned NOT NULL DEFAULT '0',
  UNIQUE KEY `idx_uid_gid` (`uid`,`gid`),
  KEY `idx_gid` (`gid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='用户所属用户组表';

DROP TABLE IF EXISTS `pw_user_data`;
CREATE TABLE `pw_user_data` (
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `lastvisit` int(10) unsigned NOT NULL DEFAULT '0',
  `lastloginip` varchar(20) NOT NULL DEFAULT '',
  `lastpost` int(10) unsigned NOT NULL DEFAULT '0',
  `lastactivetime` int(10) unsigned NOT NULL DEFAULT '0',
  `onlinetime` int(10) unsigned NOT NULL DEFAULT '0',
  `trypwd` varchar(16) NOT NULL DEFAULT '' COMMENT '尝试的登录错误信息，trydate|trynum',
  `postcheck` varchar(16) NOT NULL DEFAULT '',
  `postnum` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `digest` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `todaypost` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `todayupload` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `findpwd` varchar(26) NOT NULL DEFAULT '' COMMENT '找回密码尝试错误次数,trydate|trynum',
  `follows` int(10) unsigned NOT NULL DEFAULT '0',
  `fans` int(10) unsigned NOT NULL DEFAULT '0',
  `message_tone` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `messages` smallint(5) unsigned NOT NULL DEFAULT '0',
  `notices` smallint(5) unsigned NOT NULL DEFAULT '0',
  `likes` int(10) unsigned NOT NULL DEFAULT '0',
  `punch` varchar(200) NOT NULL DEFAULT '',
  `credit1` int(10) NOT NULL DEFAULT '0',
  `credit2` int(10) NOT NULL DEFAULT '0',
  `credit3` int(10) NOT NULL DEFAULT '0',
  `credit4` int(10) NOT NULL DEFAULT '0',
  `credit5` int(10) NOT NULL DEFAULT '0',
  `credit6` int(10) NOT NULL DEFAULT '0',
  `credit7` int(10) NOT NULL DEFAULT '0',
  `credit8` int(10) NOT NULL DEFAULT '0',
  `join_forum` varchar(255) NOT NULL DEFAULT '',
  `recommend_friend` text,
  `last_credit_affect_log` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='用户扩展数据表';

DROP TABLE IF EXISTS `pw_user_education`;
CREATE TABLE `pw_user_education` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `schoolid` int(10) unsigned NOT NULL DEFAULT '0',
  `degree` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `start_time` smallint(5) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_uid_startTime` (`uid`,`start_time`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='用户教育信息表';

DROP TABLE IF EXISTS `pw_user_groups`;
CREATE TABLE `pw_user_groups` (
  `gid` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(64) NOT NULL DEFAULT '',
  `type` enum('default','member','system','special','vip') NOT NULL DEFAULT 'default',
  `image` varchar(32) NOT NULL DEFAULT '',
  `points` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`gid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='用户组表';

DROP TABLE IF EXISTS `pw_user_info`;
CREATE TABLE `pw_user_info` (
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `gender` tinyint(1) NOT NULL DEFAULT '0',
  `byear` smallint(6) unsigned NOT NULL DEFAULT '0',
  `bmonth` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `bday` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `location` int(10) NOT NULL DEFAULT '0',
  `hometown` int(10) NOT NULL DEFAULT '0',
  `homepage` varchar(75) NOT NULL DEFAULT '',
  `qq` varchar(12) NOT NULL DEFAULT '',
  `msn` varchar(40) NOT NULL DEFAULT '',
  `aliww` varchar(30) NOT NULL DEFAULT '',
  `mobile` varchar(16) NOT NULL DEFAULT '',
  `alipay` varchar(30) NOT NULL DEFAULT '',
  `bbs_sign` text,
  `profile` text,
  `regreason` varchar(200) NOT NULL DEFAULT '',
  `telphone` varchar(20) NOT NULL DEFAULT '',
  `address` varchar(100) NOT NULL DEFAULT '',
  `zipcode` varchar(10) NOT NULL DEFAULT '',
  `secret` varchar(500) NOT NULL DEFAULT '',
  PRIMARY KEY (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='用户扩展基本信息表二';

DROP TABLE IF EXISTS `pw_user_login_ip_recode`;
CREATE TABLE `pw_user_login_ip_recode` (
  `ip` varchar(20) NOT NULL DEFAULT '',
  `last_time` varchar(10) NOT NULL DEFAULT '',
  `error_count` smallint(6) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`ip`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='用户IP登录记录表-用户IP登录限制';

DROP TABLE IF EXISTS `pw_user_permission_groups`;
CREATE TABLE `pw_user_permission_groups` (
  `gid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `rkey` varchar(64) NOT NULL DEFAULT '',
  `rtype` enum('basic','system','systemforum') NOT NULL DEFAULT 'basic',
  `rvalue` text,
  `vtype` enum('string','array') NOT NULL DEFAULT 'string',
  PRIMARY KEY (`gid`,`rkey`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='用户组权限表';

DROP TABLE IF EXISTS `pw_user_register_check`;
CREATE TABLE `pw_user_register_check` (
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `ifchecked` tinyint(1) NOT NULL DEFAULT '1',
  `ifactived` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='用户注册审核记录表';

DROP TABLE IF EXISTS `pw_user_register_ip`;
CREATE TABLE `pw_user_register_ip` (
  `ip` varchar(20) NOT NULL DEFAULT '',
  `last_regdate` int(10) unsigned NOT NULL DEFAULT '0',
  `num` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`ip`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='登录的IP统计表';

DROP TABLE IF EXISTS `pw_user_tag`;
CREATE TABLE `pw_user_tag` (
  `tag_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL DEFAULT '',
  `ifhot` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `used_count` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`tag_id`),
  UNIQUE KEY `idx_name` (`name`),
  KEY `idx_usedcount` (`used_count`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='用户个人标签基本信息表';

DROP TABLE IF EXISTS `pw_user_tag_relation`;
CREATE TABLE `pw_user_tag_relation` (
  `tag_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`uid`,`tag_id`),
  KEY `idx_createdtime` (`created_time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='用户个人标签与用户的关系表';

DROP TABLE IF EXISTS `pw_user_verify`;
CREATE TABLE `pw_user_verify` (
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `realname` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `phone` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `email` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `pay` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `paper` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`uid`),
  KEY `idx_realname` (`realname`),
  KEY `idx_phone` (`phone`),
  KEY `idx_email` (`email`),
  KEY `idx_pay` (`pay`),
  KEY `idx_paper` (`paper`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `pw_user_work`;
CREATE TABLE `pw_user_work` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `company` varchar(100) NOT NULL DEFAULT '',
  `starty` smallint(4) NOT NULL DEFAULT '0',
  `endy` smallint(4) NOT NULL DEFAULT '0',
  `startm` tinyint(2) NOT NULL DEFAULT '0',
  `endm` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_uid_starty_startm` (`uid`,`starty`,`startm`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `pw_weibo`;
CREATE TABLE `pw_weibo` (
  `weibo_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `src_id` int(10) unsigned NOT NULL DEFAULT '0',
  `content` text,
  `type` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `comments` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `extra` text,
  `like_count` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `created_userid` int(10) unsigned NOT NULL DEFAULT '0',
  `created_username` varchar(15) NOT NULL DEFAULT '',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`weibo_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `pw_weibo_comment`;
CREATE TABLE `pw_weibo_comment` (
  `comment_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `weibo_id` int(10) unsigned NOT NULL DEFAULT '0',
  `content` text,
  `extra` text,
  `created_userid` int(10) unsigned NOT NULL DEFAULT '0',
  `created_username` varchar(15) NOT NULL DEFAULT '',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_id`),
  KEY `idx_weiboid_createdtime` (`weibo_id`,`created_time`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `pw_windid_app`;
CREATE TABLE `pw_windid_app` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL DEFAULT '',
  `siteurl` varchar(128) NOT NULL DEFAULT '',
  `secretkey` varchar(50) NOT NULL DEFAULT '',
  `apifile` varchar(128) NOT NULL  DEFAULT '',
  `synlogin` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `pw_windid_area`;
CREATE TABLE `pw_windid_area` (
  `areaid` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL DEFAULT '',
  `joinname` varchar(100) NOT NULL DEFAULT '',
  `parentid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `vieworder` smallint(6) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`areaid`),
  KEY `idx_name` (`name`),
  KEY `idx_parentid_vieworder` (`parentid`,`vieworder`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='统一地区库';

DROP TABLE IF EXISTS `pw_windid_config`;
CREATE TABLE `pw_windid_config` (
  `name` varchar(30) NOT NULL,
  `namespace` varchar(15) NOT NULL DEFAULT 'global',
  `value` text,
  `vtype` enum('string','array','object') NOT NULL DEFAULT 'string',
  `descrip` text,
  PRIMARY KEY (`namespace`,`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='windid配置表';

DROP TABLE IF EXISTS `pw_windid_message`;
CREATE TABLE `pw_windid_message` (
  `message_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `from_uid` int(10) unsigned NOT NULL DEFAULT '0',
  `content` text,
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`message_id`),
  KEY `idx_fromuid` (`from_uid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `pw_windid_message_dialog`;
CREATE TABLE `pw_windid_message_dialog` (
  `dialog_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `to_uid` int(10) unsigned NOT NULL DEFAULT '0',
  `from_uid` int(10) unsigned NOT NULL DEFAULT '0',
  `unread_count` smallint(5) unsigned NOT NULL DEFAULT '0',
  `message_count` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `last_message` text,
  `modified_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`dialog_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `pw_windid_message_relation`;
CREATE TABLE `pw_windid_message_relation` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `dialog_id` int(10) unsigned NOT NULL DEFAULT '0',
  `message_id` int(10) unsigned NOT NULL DEFAULT '0',
  `is_read` tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_messageid` (`message_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `pw_windid_notify`;
CREATE TABLE `pw_windid_notify` (
  `nid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `app1` smallint(5) unsigned NOT NULL DEFAULT '0',
  `operation` varchar(50) NOT NULL DEFAULT '',
  `param` varchar(100) NOT NULL DEFAULT '',
  `timestamp` int(10) NOT NULL DEFAULT '0',
  `complete` tinyint(3) NOT NULL DEFAULT '0',
  PRIMARY KEY (`nid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `pw_windid_school`;
CREATE TABLE `pw_windid_school` (
  `schoolid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(32) NOT NULL DEFAULT '',
  `areaid` int(10) NOT NULL DEFAULT '0',
  `typeid` tinyint(3) NOT NULL DEFAULT '0',
  `first_char` char(1) NOT NULL DEFAULT '',
  PRIMARY KEY (`schoolid`),
  KEY `idx_areaid_firstchar` (`areaid`,`first_char`),
  KEY `idx_name_firstchar` (`name`,`first_char`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='统一的windid学校库';

DROP TABLE IF EXISTS `pw_windid_user`;
CREATE TABLE `pw_windid_user` (
  `uid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `username` varchar(15) NOT NULL DEFAULT '',
  `email` varchar(80) NOT NULL DEFAULT '',
  `password` char(32) NOT NULL DEFAULT '',
  `salt` char(6) NOT NULL DEFAULT '',
  `safecv` char(8) NOT NULL DEFAULT '',
  `regdate` int(10) unsigned NOT NULL DEFAULT '0',
  `regip` varchar(20) NOT NULL DEFAULT '',
  PRIMARY KEY (`uid`),
  UNIQUE KEY `idx_username` (`username`),
  KEY `idx_email` (`email`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COMMENT='windid用户基本信息表';

DROP TABLE IF EXISTS `pw_windid_user_black`;
CREATE TABLE `pw_windid_user_black` (
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `blacklist` text,
  PRIMARY KEY (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='用户黑名单';

DROP TABLE IF EXISTS `pw_windid_user_data`;
CREATE TABLE `pw_windid_user_data` (
  `uid` int(10) unsigned NOT NULL,
  `messages` smallint(6) NOT NULL DEFAULT '0',
  `credit1` int(10) NOT NULL DEFAULT '0',
  `credit2` int(10) NOT NULL DEFAULT '0',
  `credit3` int(10) NOT NULL DEFAULT '0',
  `credit4` int(10) NOT NULL DEFAULT '0',
  `credit5` int(10) NOT NULL DEFAULT '0',
  `credit6` int(10) NOT NULL DEFAULT '0',
  `credit7` int(10) NOT NULL DEFAULT '0',
  `credit8` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='windid用户数据';

DROP TABLE IF EXISTS `pw_windid_user_info`;
CREATE TABLE `pw_windid_user_info` (
  `uid` int(10) unsigned NOT NULL,
  `icon` varchar(100) NOT NULL DEFAULT '',
  `gender` tinyint(1) NOT NULL DEFAULT '0',
  `byear` smallint(4) unsigned NOT NULL DEFAULT '0',
  `bmonth` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `bday` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `hometown` int(10) NOT NULL DEFAULT '0',
  `location` int(10) NOT NULL DEFAULT '0',
  `homepage` varchar(128) NOT NULL DEFAULT '',
  `qq` varchar(12) NOT NULL DEFAULT '',
  `aliww` varchar(30) NOT NULL DEFAULT '',
  `mobile` varchar(16) NOT NULL DEFAULT '',
  `alipay` varchar(80) NOT NULL DEFAULT '',
  `msn` varchar(80) NOT NULL DEFAULT '',
  PRIMARY KEY (`uid`),
  KEY `idx_bday` (`bday`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='windid用户扩展基本信息表二';

DROP TABLE IF EXISTS `pw_word`;
CREATE TABLE `pw_word` (
  `word_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `word_type` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `word` varchar(100) NOT NULL DEFAULT '',
  `word_replace` varchar(100) NOT NULL DEFAULT '',
  `word_from` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `created_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`word_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;