<?php
Wind::import('LIB:base.PwBaseController');
/**
 * the last known user to change this file in the repository  <$LastChangedBy: gao.wanggao $>
 * @author $Author: gao.wanggao $ Foxsee@aliyun.com
 * @copyright ?2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: MylikeController.php 6836 2012-03-27 04:05:46Z gao.wanggao $
 * @package
 */
class MylikeController extends PwBaseController {

	public function beforeAction($handlerAdapter) {
		parent::beforeAction($handlerAdapter);
		if ($this->loginUser->uid < 1) $this->forwardRedirect(WindUrlHelper::createUrl('u/login/run/'));
	}

	public function run() {
		$page = (int) $this->getInput('page', 'get');
		$tagid = (int) $this->getInput('tag', 'get');
		$perpage = 10;
		$page = $page > 1 ? $page : 1;
		$service = $this->_getBuildLikeService();
		$tagLists = $service->getTagsByUid($this->loginUser->uid);
		if ($tagid > 0) {
			$resource = $this->_getLikeService()->allowEditTag($this->loginUser->uid, $tagid);
			if ($resource instanceof PwError) $this->showError($resource->getError());
			$count = $resource['number'];
			$logids = $service->getLogidsByTagid($tagid, $page, $perpage);
			$logLists = $service->getLogLists($logids);
		} else {
			list($start, $perpage) = Pw::page2limit($page, $perpage);
			$count = $this->_getLikeLogDs()->getLikeCount($this->loginUser->uid);
			$logLists = $service->getLogList($this->loginUser->uid, $page, $perpage);
		}
		$likeLists = $service->getLikeList();
		$likeInfos = $service->getLikeInfo();
		$hotBrand = $this->_getLikeService()->getLikeBrand('day1', 0, 10, true);
		$args = $tagid > 0 ? "tag=$tagid" : '';
		$this->setOutput($args, 'args');
		$this->setOutput($logLists, 'logLists');
		$this->setOutput($likeLists, 'likeLists');
		$this->setOutput($likeInfos, 'likeInfos');
		$this->setOutput($tagLists, 'tagLists');
		$this->setOutput($hotBrand, 'hotBrand');
		$this->setOutput($count, 'count');
		$this->setOutput($page, 'page');
		$this->setOutput($perpage, 'perpage');
		
		// seo设置
		Wind::import('SRV:seo.bo.PwSeoBo');
		$lang = Wind::getComponent('i18n');
		PwSeoBo::setCustomSeo($lang->getMessage('SEO:like.mylike.run.title'), '', '');
	}

	public function taAction() {
		// seo设置
		Wind::import('SRV:seo.bo.PwSeoBo');
		$lang = Wind::getComponent('i18n');
		PwSeoBo::setCustomSeo($lang->getMessage('SEO:like.mylike.ta.title'), '', '');
	}

	public function dataAction() {
		$page = (int) $this->getInput('page', 'get');
		$start = (int) $this->getInput('start', 'get');
		$start >= 100 && $start = 100;
		$perpage = 20;
		$_data = '';
		$logLists = $this->_getBuildLikeService()->getFollowLogList($this->loginUser->uid, $start, $perpage);
		$likeLists = $this->_getBuildLikeService()->getLikeList();
		$likeInfos = $this->_getBuildLikeService()->getLikeInfo();
		$replyInfos = $this->_getBuildLikeService()->getLastReplyInfo();
		foreach ($logLists as $k => $logList) {
			if (!isset($likeInfos[$logList['likeid']])) continue;
			$_data[$k]['fromid'] = $likeLists[$logList['likeid']]['fromid'];
			$_data[$k]['fromtype'] = $likeLists[$logList['likeid']]['typeid'];
			$_data[$k]['url'] = $likeInfos[$logList['likeid']]['url'];
			$_data[$k]['image'] = $likeInfos[$logList['likeid']]['image'];
			$_data[$k]['descrip'] = $likeInfos[$logList['likeid']]['content'];
			$_data[$k]['uid'] = $likeInfos[$logList['likeid']]['uid'];
			$_data[$k]['username'] = $likeInfos[$logList['likeid']]['username'];
			$_data[$k]['avatar'] = Pw::getAvatar($likeInfos[$logList['likeid']]['uid'], 'small');
			$_data[$k]['space'] = WindUrlHelper::createUrl(
				'space/index/run/?uid=' . $likeInfos[$logList['likeid']]['uid']);
			$_data[$k]['lasttime'] = Pw::time2str($likeInfos[$logList['likeid']]['lasttime'], 'auto');
			$_data[$k]['like_count'] = $likeInfos[$logList['likeid']]['like_count'];
			$_data[$k]['reply_pid'] = $replyInfos[$likeLists[$logList['likeid']]['reply_pid']];
			$_data[$k]['reply_uid'] = $replyInfos[$likeLists[$logList['likeid']]['reply_pid']]['uid'];
			$_data[$k]['reply_avatar'] = Pw::getAvatar($replyInfos[$likeLists[$logList['likeid']]['reply_pid']]['uid'],
				'small');
			$_data[$k]['reply_space'] = WindUrlHelper::createUrl(
				'space/index/run/?uid=' . $replyInfos[$likeLists[$logList['likeid']]['reply_pid']]['uid']);
			$_data[$k]['reply_username'] = $replyInfos[$likeLists[$logList['likeid']]['reply_pid']]['username'];
			$_data[$k]['reply_content'] = $replyInfos[$likeLists[$logList['likeid']]['reply_pid']]['content'];
			$_data[$k]['like_url'] = WindUrlHelper::createUrl(
				'like/mylike/doLike/?typeid=' . $_data[$k]['fromtype'] . '&fromid=' . $_data[$k]['fromid']);
		}
		$this->setOutput($_data, 'data');
		$this->showMessage('operate.success');
	}

	public function getTagListAction() {
		$array = array();
		$lists = $this->_getLikeTagService()->getInfoByUid($this->loginUser->uid);
		$this->setOutput($lists, 'data');
		$this->showMessage('BBS:like.success');
	}

	/**
	 * 增加喜欢
	 *
	 */
	public function doLikeAction() {
		
		$typeid = (int) $this->getInput('typeid', 'get');
		$fromid = (int) $this->getInput('fromid', 'get');
		if ($typeid < 1 || $fromid < 1) $this->showError('BBS:like.fail');
		$resource = $this->_getLikeService()->addLike($this->loginUser, $typeid, $fromid);
		if ($resource instanceof PwError) $this->showError($resource->getError());
		
		$needcheck = false;
		if($resource['extend']['needcheck'])  $needcheck = false;
		$data['likecount'] = $resource['likecount'];
		$data['needcheck'] = $needcheck;
		$this->setOutput($data, 'data');
		$this->showMessage('BBS:like.success');
	}

	/**
	 * 删除我的喜欢
	 *
	 * 如果喜欢内容总喜欢数小于1，同时删除喜欢内容
	 */
	public function doDelLikeAction() {
		$logid = (int) $this->getInput('logid', 'get');
		if ($logid < 0) $this->showError('BBS:like.fail');
		$resource = $this->_getLikeService()->delLike($this->loginUser->uid, $logid);
		if ($resource) $this->showMessage('BBS:like.success');
		$this->showError('BBS:like.fail');
	}

	/**
	 * 标签更新
	 *
	 */
	public function doAddTagAction() {
		$tagids = $this->getInput('tagid', 'post');
		$logid = $this->getInput('logid', 'post');
		$tags = $this->getInput('tagname', 'post');
		//if ($logid < 1 || empty($tags)) $this->showError('BBS:like.fail');
		$resource = $this->_getLikeService()->addLikeTag($this->loginUser->uid, $tagids, $logid, $tags);
		if ($resource instanceof PwError) $this->showError($resource->getError());
		$this->setOutput($resource, 'data');
		$this->showMessage('BBS:like.success');
	}

	/**
	 * 标签删除
	 *
	 */
	public function doDelTagAction() {
		$tagid = (int) $this->getInput('tag', 'get');
		$info = $this->_getLikeService()->allowEditTag($this->loginUser->uid, $tagid);
		if ($info instanceof PwError) $this->showError($info->getError());
		if (!$this->_getLikeTagService()->deleteInfo($tagid)) $this->showError('BBS:like.fail');
		$this->_getLikeRelationsService()->deleteInfos($tagid);
		$this->showMessage('BBS:like.success', true, WindUrlHelper::createUrl('like/mylike/run/'));
	}

	/**
	 * 编辑标签
	 *
	 */
	public function doEditTagAction() {
		$tagid = (int) $this->getInput('tag', 'post');
		$tagname = trim($this->getInput('tagname', 'post'));
		if (WindString::strlen($tagname) < 2) $this->showError('BBS:like.tagname.is.short');
		if (WindString::strlen($tagname) > 10) $this->showError('BBS:like.tagname.is.lenth');
		$tags = $this->_getLikeTagService()->getInfoByUid($this->loginUser->uid);
		$allow = false;
		foreach ($tags as $tag) {
			if ($tag['tagid'] == $tagid) $allow = true;
			if ($tag['tagname'] == $tagname) $this->showError('BBS:like.fail.already.tagname');
		}
		if (!$allow) $this->showError('BBS:like.fail');
		Wind::import('SRV:like.dm.PwLikeTagDm');
		$dm = new PwLikeTagDm($tagid);
		$dm->setTagname($tagname);
		$resource = $this->_getLikeTagService()->updateInfo($dm);
		if ($resource instanceof PwError) $this->showError($resource->getError());
		$this->setOutput($tagname, 'data');
		$this->showMessage('BBS:like.success');
	}

	private function _getLikeRelationsService() {
		return Wekit::load('like.PwLikeRelations');
	}

	private function _getLikeTagService() {
		return Wekit::load('like.PwLikeTag');
	}

	private function _getBuildLikeService() {
		return Wekit::load('like.srv.PwBuildLikeService');
	}

	private function _getLikeService() {
		return Wekit::load('like.srv.PwLikeService');
	}
	
	private function _getLikeLogDs() {
		return Wekit::load('like.PwLikeLog');
	}
}
?>