<?php
Wind::import('LIB:base.PwBaseController');

/**
 * 前台管理面板
 *
 * @author jinlong.panjl <jinlong.panjl@aliyun-inc.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: BaseManageController.php 17604 2012-09-07 02:42:35Z xiaoxia.xuxx $
 * @package wind
 */
class BaseManageController extends PwBaseController {

	/* (non-PHPdoc)
	 * @see PwBaseController::beforeAction()
	 */
	public function beforeAction($handlerAdapter) {
		parent::beforeAction($handlerAdapter);
		if ($this->loginUser->uid < 1) {
			$this->showError('USER:user.not.login');
		}
		$this->setCurrent();
		$this->setLayout('manage_layout');
	}
	
	protected function setCurrent() {
		$c = $this->getInput('c');
		$this->setGlobal($c, 'manageLeft');
	}
}