<?php
Wind::import('APPS:.profile.controller.BaseProfileController');
Wind::import('SRV:user.PwUserBan');

/**
 * 用户头像处理
 *
 * @author xiaoxia.xu <xiaoxia.xuxx@aliyun-inc.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: AvatarController.php 17415 2012-09-05 08:00:40Z xiaoxia.xuxx $
 * @package src.products.u.controller.profile
 */
class AvatarController extends BaseProfileController {
	
	/* (non-PHPdoc)
	 * @see WindController::run()
	 */
	public function run() {
		$this->setCurrentLeft('avatar');
		
		$isAvatarBan = false;
		if ($this->loginUser->info['status'] & PwUser::STATUS_BAN_AVATAR) {
			/* @var $banService PwUserBanService */
			$banService = Wekit::load('user.srv.PwUserBanService');
			$list = $banService->getBanInfoByUid($this->loginUser->uid, PwUserBan::BAN_AVATAR);
			if ($list) {
				$isAvatarBan = true;
				$banInfo = current(current($list));
				if ($banInfo['created_userid'] == 0) {
					$banInfo['operator'] = 'system';
				} else {
					$operatorInfo = Wekit::load('user.PwUser')->getUserByUid($banInfo['created_userid']);
					$banInfo['operator'] = $operatorInfo['username'];
				}
				$banInfo['end_time'] = $banInfo['end_time'] > 0 ? Pw::time2str($banInfo['end_time'], 'Y年m月d日 H:i') : '永久';
				$this->setOutput($banInfo, 'banInfo');
			}
		}
		$this->setOutput($isAvatarBan, 'isAvatarBan');
		$this->setOutput($this->getInput('type'), 'type');
		$this->setLayout('');
		$this->setTemplate('profile_avatar');
		
		// seo设置
		Wind::import('SRV:seo.bo.PwSeoBo');
		$lang = Wind::getComponent('i18n');
		PwSeoBo::setCustomSeo($lang->getMessage('SEO:profile.avatar.run.title'), '', '');
	}
}
