<?php
Wind::import('APPS:u.service.helper.PwUserHelper');

/**
 * 左边导航和资料tab扩展
 *
 * @author xiaoxia.xu <xiaoxia.xuxx@aliyun-inc.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: BaseProfileController.php 17025 2012-08-30 08:55:23Z xiaoxia.xuxx $
 * @package src.products.u.controller.profile
 */
class BaseProfileController extends PwBaseController {
	
	protected $defaultGroups = array(
			0 => array('name' => '普通组', 'gid' => '0'), 
		);
	protected $bread = array();

	/* (non-PHPdoc)
	 * @see PwBaseController::beforeAction()
	 */
	public function beforeAction($handlerAdapter) {
		parent::beforeAction($handlerAdapter);
		if (!$this->loginUser->isExists()) {
			$this->forwardRedirect(WindUrlHelper::createUrl('u/login/run?_type=' . $this->getInput('_type')));
		}
		if (!$this->getRequest()->getIsAjaxRequest()) {
			$this->setLayout('profile_layout');
		}
	}
	
	/**
	 * 获得个人中心菜单服务
	 *
	 * @return PwUserProfileMenuService
	 */
	protected function getMenuService() {
		return Wekit::load('APPS:profile.service.PwUserProfileMenuService');
	}
	
	/** 
	 * 设置当前设置项
	 * 
	 * @param string $left
	 */
	protected function setCurrentLeft($left = '') {
		$menus = $this->getMenuService()->getProfileLeftMenu();
		$currentMenu = $left ? $left : $this->getInput('_left');
		if (!$currentMenu) {
			$_temp = array_keys($menus);
			$currentMenu = $_temp[0];
			unset($_temp);
		}
		$menus[$currentMenu]['current'] = 'current';
		$this->bread['left'] = array('url' => WindUrlHelper::createUrl($menus[$currentMenu]['url'], array('_left' => $currentMenu)), 'title' => $menus[$currentMenu]['title']);
		$this->setGlobal($menus, 'profileLeft');
	}
	
	/** 
	 * 设置当前选项卡
	 *
	 * @param string $action
	 */
	protected function setCurrentTab() {
		$menus = $this->getMenuService()->getProfileTabMenu();
		$currentMenu = $this->getInput('_tab');
		if (!$currentMenu) {
			$_temp = array_keys($menus);
			$currentMenu = $_temp[0];
			unset($_temp);
		}
		$menus[$currentMenu]['current'] = 'current';
		$this->appendBread($menus[$currentMenu]['title'], WindUrlHelper::createUrl($menus[$currentMenu]['url'], array('_tab' => $currentMenu)));
		$this->setOutput($menus, 'profile_tab');
	}
	
	/**
	 * 是否开启了认证
	 * 
	 * @return boolean
	 */
	protected function isAuthentication() {
		return Wekit::config('authentication', 'open') === 1 ? true : false;
	}
	
	/**
	 * 设置面包屑
	 *
	 * @param string $title
	 * @param string $url
	 */
	protected function appendBread($title, $url) {
		$this->bread[] = array('url' => $url, 'title' => $title);
		return $this;
	}
	
	/* (non-PHPdoc)
	 * @see PwBaseController::afterAction()
	 */
	public function afterAction($handlerAdapter) {
		parent::afterAction($handlerAdapter);
		$bread = array($this->bread['left']);
		unset($this->bread['left']);
		$this->bread && $bread = array_merge($bread, $this->bread);
		$this->setGlobal($bread, 'profileBread');
	}
}