<?php
Wind::import('APPS:.profile.controller.BaseProfileController');
Wind::import('SRV:user.srv.PwUserProfileService');
Wind::import('SRV:user.validator.PwUserValidator');
Wind::import('SRV:user.PwUserBan');
		
/**
 * 用户资料页面
 *
 * @author xiaoxia.xu <xiaoxia.xuxx@aliyun-inc.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: IndexController.php 18181 2012-09-11 12:17:25Z xiaoxia.xuxx $
 * @package src.products.u.controller.profile
 */
class IndexController extends BaseProfileController {
	
	/* (non-PHPdoc)
	 * @see BaseProfileController::beforeAction()
	 */
	public function beforeAction($handlerAdapter) {
		parent::beforeAction($handlerAdapter);
		$this->setOutput($this->isAuthentication(), 'authen');
	}

	/* (non-PHPdoc)
	 * @see WindController::run()
	 */
	public function run() {
		$userInfo = Wekit::load('user.PwUser')->getUserByUid($this->loginUser->uid, PwUser::FETCH_INFO);
		$userInfo = array_merge($this->loginUser->info, $userInfo);
		list($year, $month, $day) = PwUserHelper::getBirthDay();
		$this->setCurrentLeft();
		$this->setCurrentTab();
		
		$this->setOutput($this->_buildArea($userInfo['location']), 'location');
		$this->setOutput($this->_buildArea($userInfo['hometown']), 'hometown');
		

		$_cache = Wekit::cache()->get('group_right');

		$isAllowSign = false;
		if ($_cache[$this->loginUser->gid]['allow_sign']) {
			$isAllowSign = true;
			$isSignBan = false;
			if ($this->loginUser->info['status'] & PwUser::STATUS_BAN_SIGN) {
				/* @var $banService PwUserBanService */
				$banService = Wekit::load('user.srv.PwUserBanService');
				$list = $banService->getBanInfoByUid($this->loginUser->uid, PwUserBan::BAN_SIGN);
				if ($list) {
					$isSignBan = true;
				}
			}
		}
		
		$this->setOutput($isAllowSign, 'isAllowSign');
		$this->setOutput($isSignBan, 'isSignBan');
		$this->setOutput($year, 'years');
		$this->setOutput($month, 'months');
		$this->setOutput($day, 'days');
		$this->setOutput($userInfo, 'userinfo');
		
		// seo设置
		Wind::import('SRV:seo.bo.PwSeoBo');
		$lang = Wind::getComponent('i18n');
		PwSeoBo::setCustomSeo($lang->getMessage('SEO:profile.index.run.title'), '', '');
	}
	
	/** 
	 * 编辑用户信息
	 */
	public function dorunAction() {
		$userDm = new PwUserInfoDm();
		$userDm->setUid($this->loginUser->uid);
		if (false === $this->isAuthentication()) {
			$userDm->setRealname($this->getInput('realname', 'post'));
		}
		$userDm->setByear($this->getInput('byear', 'post'));
		$userDm->setBmonth($this->getInput('bmonth', 'post'));
		$userDm->setBday($this->getInput('bday', 'post'));
		$userDm->setGender($this->getInput('gender', 'post'));
		$userDm->setHometown($this->getInput('hometown', 'post'));
		$userDm->setLocation($this->getInput('location', 'post'));
		$userDm->setHomepage($this->getInput('homepage', 'post'));
		$userDm->setProfile($this->getInput('profile', 'post'));
		//没有禁止签名的时候方可编辑签名
		$_cache = Wekit::cache()->get('group_right');
		if ($_cache[$this->loginUser->gid]['allow_sign'] && !($this->loginUser->info['status'] & PwUser::STATUS_BAN_SIGN)) {
			$userDm->setBbsSign($this->getInput('bbs_sign', 'post'));
		}
		/* @var $userService PwUserService */
		$userService = Wekit::load('user.srv.PwUserService');
		/*用户资料设置完成-基本资料-service钩子点:m_profile_dorun*/
		$result = $userService->editUser($userDm, PwUser::FETCH_MAIN + PwUser::FETCH_INFO);
		if ($result instanceof PwError) {
			$this->showError($result->getError());
		} else {
			$this->loginUser->info = array_merge($this->loginUser->info, $userDm->getData());
			$this->showMessage('USER:user.edit.profile.success');
		}
	}
	
	/**
	 * 联系方式
	 */
	public function contactAction() {
		$userInfo = Wekit::load('user.PwUser')->getUserByUid($this->loginUser->uid, PwUser::FETCH_INFO);
		$this->setOutput($userInfo, 'userinfo');
		$this->setCurrentLeft();
		$this->setCurrentTab();
	}
	
	/** 
	 * 编辑联系方式
	 */
	public function docontactAction() {
		$userDm = new PwUserInfoDm();
		$userDm->setUid($this->loginUser->uid);
		$userDm->setTelphone($this->getInput('telphone', 'post'));
		$userDm->setAddress($this->getInput('address', 'post'));
		$userDm->setZipcode($this->getInput('zipcode', 'post'));
		$userDm->setAliww($this->getInput('aliww', 'post'));
		$userDm->setQq($this->getInput('qq', 'post'));
		$userDm->setMsn($this->getInput('msn', 'post'));
		if (false === $this->isAuthentication()) {
			list($alipay, $mobile, $email) = $this->getInput(array('alipay', 'mobile', 'email'), 'post');
			if ($alipay) {
				$r = PwUserValidator::isAlipayValid($alipay, $this->loginUser->username);
				if ($r instanceof PwError) $this->showError($r->getError());
			}
			if ($mobile) {
				$r = PwUserValidator::isMobileValid($mobile, $this->loginUser->username);
				if ($r instanceof PwError) $this->showError($r->getError());
			}
			if ($email) {
				$r = PwUserValidator::isEmailValid($email, $this->loginUser->username);
				if ($r instanceof PwError) $this->showError($r->getError());
			}
			$userDm->setEmail($email);
			$userDm->setMobile($mobile);
			$userDm->setAlipay($alipay);
		}
		/* @var $userService PwUserService */
		$userService = Wekit::load('user.srv.PwUserService');
		/*用户资料设置完成-联系方式-service钩子点:m_profile_dorun*/
		$result = $userService->editUser($userDm, PwUser::FETCH_INFO + PwUser::FETCH_MAIN);
		if ($result instanceof PwError) {
			$this->showError($result->getError());
		} else {
			$this->loginUser->info = array_merge($this->loginUser->info, $userDm->getData());
			$this->showMessage('USER:user.edit.contact.success');
		}
	}
	
	/**
	 * 个人标签
	 */
	public function emptyAction() {
		$this->setCurrentLeft();
		$this->setTemplate('profile_empty');
	}
	
	/* (non-PHPdoc)
	 * @see PwBaseController::setDefaultTemplateName()
	 */
	protected function setDefaultTemplateName($handlerAdapter) {
		$this->setTemplate('profile_' . $handlerAdapter->getAction());
	}
	
	/**
	 * 设置地区显示
	 * 
	 * @return array
	 */
	private function _buildArea($areaid) {
		$default = array(array('areaid' => '', 'name' => ''), array('areaid' => '', 'name' => ''), array('areaid' => '', 'name' => ''));
		if (!$areaid) {
			return $default;
		}
		/* @var $areaSrv PwAreaService*/
		$areaSrv = Wekit::load('area.srv.PwAreaService');
		$rout = $areaSrv->getAreaRout($areaid);
		return WindUtility::mergeArray($default, $rout);
	}
}