<?php

/**
 * 个人中心-扩展菜单服务
 *
 * @author xiaoxia.xu <x_824@sina.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: PwUserProfileMenuService.php 9805 2012-05-10 02:21:24Z xiaoxia.xuxx $
 * @package src.products.u.service
 */
class PwUserProfileMenuService {
	private $menuConfig = null;
	private $cacheKey = 'u_profile_menus';
	private $menuFile = 'APPS:profile.conf.profilemenu.php';
	private $extend = array('profile_tab', 'profile_left');
	
	/**
	 * 获得个人中心-资料-tab页扩展项
	 *
	 * @return array
	 */
	public function getProfileTabMenu() {
		$menuConfig = $this->_getMenuConfig();
		return $menuConfig['profile_tab'];
	}
	
	/**
	 * 获得个人中心-左侧菜单扩展项
	 *
	 * @return array
	 */
	public function getProfileLeftMenu() {
		$menuConfig = $this->_getMenuConfig();
		return $menuConfig['profile_left'];
	}
	
	/**
	 * 获得菜单配置
	 * 
	 * @return array
	 */
	private function _getMenuConfig() {
		if ($this->menuConfig !== null) return $this->menuConfig;
		$menuFile = Wind::getRealPath($this->menuFile, true);
		
		//TODO 增加数据库扩展
		/* extend menus by database */
		$_menus = $this->getCache($menuFile);
		if (!$_menus) {
			$menus = $this->parseMenuFile($menuFile);
			$_menus = $this->checkMenuConfig($menus, $_menus);
			$this->setCache($menuFile, $_menus);
		}
		$this->menuConfig = $_menus;
		return $this->menuConfig;
	}

	/**
	 * 检查配置文件格式
	 *
	 * @param array $menus
	 * @param array $cacheMenus
	 * @return array
	 */
	private function checkMenuConfig($menus, $cacheMenus) {
		foreach ($this->extend as $point) {
			foreach ($menus[$point] as $key => $_menu) {
				if (isset($cacheMenus[$point][$key])) continue;
				$_menu = array(
					'title' => isset($_menu['title']) ? $_menu['title'] : '',
					'url' => isset($_menu['url']) ? $_menu['url'] : '',
					'icon' => isset($_menu['icon']) ? $_menu['icon'] : '',
				);
				$cacheMenus[$point][$key] = $_menu;
			}
		}
		return $cacheMenus;
	}
	
	/**
	 * 解析配置文件
	 *
	 * @param string $menuFile
	 * @return array
	 */
	private function parseMenuFile($menuFile) {
		/* @var $_configParser WindConfigParser */
		$_configParser = Wind::getApp()->getComponent('configParser');
		return $_configParser->parse($menuFile);
	}
	
	/**
	 * 获得缓存内容
	 *
	 * @param string $mainMenuConfFile
	 * @return array
	 */
	private function getCache($mainMenuConfFile) {
		$cacheKey = $this->cacheKey . filemtime($mainMenuConfFile);
		$cache = Wind::getApp()->getComponent('windCache');
		return $cache ? $cache->get($cacheKey) : array();
	}
	
	/**
	 * 更新缓存
	 *
	 * @param string $key
	 * @param array $data
	 * @return boolean
	 */
	private function setCache($key, $data) {
		$cacheKey = $this->cacheKey . filemtime($key);
		$cache = Wind::getApp()->getComponent('windCache');
		return $cache && $cache->set($cacheKey, $data);
	}
}