<?php
Wind::import('WIND:router.route.AbstractWindRoute');
/**
 * pw - 伪静态/二级域名的路由(仅用于前台)
 *
 * @author Shi Long <long.shi@alibaba-inc.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: PwRewriteRoute.php 17734 2012-09-08 10:06:26Z long.shi $
 * @package modules.rewrite
 */
class PwRewriteRoute extends AbstractWindRoute {
	
	/**
	 * @var PwCacheService
	 */
	private $_cache = null;
	private $entrance = 'APPS:rewrite.conf.entrance';
	/**
	 * 特殊规则的rewrite
	 */
	private $rewrite_special = false;
	
	/**
	 * 普通规则的rewrite
	 */
	private $rewrite_common = false;
	
	/**
	 * 符合特殊情况时，url串省略mca参数
	 */
	private $omit_mca = false;
	public $dynamicDomain = array();
	public $dynamic = array();
	/**
	 * 符合特殊二级域名时,后面皆可省略的情况
	 */
	private $onlydomain = false;
	protected $params = array('a' => 3, 'c' => 2, 'm' => 1);
	protected $_init = false;
	protected $base = '';
	protected $default = array('m' => 'default', 'c' => 'index', 'a' => 'run');
	
	/*
	 * (non-PHPdoc) @see WindRewriteRoute::match()
	 */
	public function match($request) {
		$this->init();
		$this->base = $request->getBaseUrl();
		$args = $this->_matchDomain($request->getHostInfo(), $request->isSecure());
		$_args = $this->_matchScript($request->getScript());
		$return = array_merge($args, $_args, 
			$this->_matchPath(str_replace($request->getBaseUrl(), '', $request->getRequestUri())));
		// 首页设置
		if (empty($return) || $return == $this->default) {
			$home = Wekit::load('config.PwConfig')->getConfigByName('site', 'homeRouter');
			$args = @unserialize($home['value']);
			return $args ? $args : array();
		} else {
			return $return;
		}
	}

	/**
	 * 解析url - 公开方法
	 *
	 * 返回false 表示外链
	 * 返回array 为解析好的参数
	 *
	 * @param string $url        	
	 * @return array
	 */
	public function matchUrl($url) {
		Wind::import('SRV:domain.srv.helper.PwDomainHelper');
		$r = PwDomainHelper::parse_url($url);
		list($host, $isSecure, $script, $path) = $r;
		if ($host && !PwDomainHelper::isMyBrother($host, 
			Wind::getApp()->getRequest()->getHostInfo())) {
			return false;
		}
		$this->init();
		
		$args = $this->_matchDomain($host, $isSecure);
		$_args = $this->_matchScript($script);
		return array_merge($this->default, $args, $_args, $this->_matchPath($path, true));
	}
	
	/*
	 * (non-PHPdoc) @see WindRewriteRoute::build()
	 */
	public function build($router, $action, $args = array()) {
		$this->init(true);
		list($_m, $_c, $_a, $args) = $this->_resolveMca($router, $action, $args);
		$domain = $this->_buildDomain($_m, $_c, $_a, $args);
		if ($this->onlydomain) return $domain;
		$url = $this->_buildUrl($_m, $_c, $_a, $router, $args);
		if (3 < count($this->dynamicDomain)) {
			$this->dynamicDomain[] = $url;
		}
		return $domain . $url;
	}

	/**
	 * 解析url - 普通伪静态
	 *
	 * @param WindHttpRequest $request        	
	 * @param string $path        	
	 * @return array null
	 */
	private function _matchCommon($path) {
		$pattern = '/^(\w+)(\/\w+)(\/\w+)(.*)$/i';
		if (!preg_match($pattern, $path, $matches)) return array();
		$params = array();
		foreach ($this->params as $k => $v) {
			$value = isset($matches[$v]) ? $matches[$v] : '';
			$params[$k] = trim($value, '-/');
		}
		return array_merge($params, WindUrlHelper::urlToArgs(trim($matches[4], '?'), true));
	}

	/**
	 * 解析url - 二级域名
	 *
	 * @param WindHttpRequest $request        	
	 * @param string $path        	
	 * @return array null
	 */
	private function _matchDomain($host, $isSecure = false) {
		/* 解析二级域名 */
		if (empty($host)) return array();
		// 获取域名首字母
		$l = $isSecure ? $host[8] : $host[7];
		$domain = $this->_getDomain($l);
		if ($domain && isset($domain[$host])) {
			list($a, $c, $m, $args) = WindUrlHelper::resolveAction($domain[$host]);
			return array_merge($args, array('m' => $m, 'c' => $c, 'a' => $a));
		}
		return array();
	}

	/**
	 * 解析脚本
	 *
	 * @param WindHttpRequest $request        	
	 * @return array
	 */
	private function _matchScript($script) {
		if (empty($script)) return array();
		$multi = $this->_getMulti();
		if (isset($multi[$script])) {
			$route = explode('/', $multi[$script]);
			return array('m' => $route[0], 'c' => $route[1], 'a' => $route[2]);
		}
		return array();
	}

	/**
	 * 生成url - 普通伪静态
	 *
	 * @param array $route        	
	 * @param
	 *        	array WindRouter
	 * @param array $args        	
	 * @return string
	 */
	private function _buildCommon($router, $route, $args) {
		$reverse = '/%s/%s/%s';
		$_args = array();
		
		$flag = 0;
		$methods = array(
			'a' => 'getDefaultAction', 
			'c' => 'getDefaultController', 
			'm' => 'getDefaultModule');
		$flags = array('a' => 0, 'c' => 1, 'm' => 3);
		$consts = array('a' => 1, 'c' => 3, 'm' => 7);
		foreach ($this->params as $k => $v) {
			if ($route[$k] === $router->$methods[$k]() && $flag === $flags[$k]) $flag = $consts[$k];
			$_args[$v] = $route[$k];
			unset($args[$k]);
		}
		if ($flag == 7 && empty($args)) return '';
		$_args[0] = $reverse;
		ksort($_args);
		$url = call_user_func_array("sprintf", $_args);
		return $url . ($args ? '?' . WindUrlHelper::argsToUrl($args) : '');
	}

	/**
	 * 生成url - 二级域名
	 *
	 * @param array $route        	
	 * @param array $args        	
	 * @return string
	 */
	private function _buildDomain($_m, $_c, $_a, $args) {
		/* 二级域名 */
		$key = "$_m/$_c/$_a";
		list($domain, $type) = $this->_getDomainByType($key);
		if (!empty($domain)) {
			$domainKey = $this->_getDomainKey();
			if (isset($domainKey[$key])) {
				$id = $domainKey[$key];
				if (!isset($args[$id])) {
					return '';
				} else {
					if (isset($domain[$args[$id]])) {
						$return = $domain[$args[$id]];
						$this->omit_mca = true;
						1 == count($args) && $this->onlydomain = true;
						return $return . $this->base;
					} else if ($type == 'forum') {
						$this->dynamicDomain[] = '<?php $__route_domain=' . var_export($domain, 
							true) . ';';
						if (1 == count($args)) {
							$this->dynamicDomain[] = 'if($__route_domain[' . $args[$id] . ']){ echo $__route_domain[' . $args[$id] . '].\'' . $this->base . '\';}else{ ?>';
						} else {
							$this->dynamicDomain[] = 'if($__route_domain[' . $args[$id] . ']){ echo $__route_domain[' . $args[$id] . '].\'' . $this->base . '\';?>';
							$this->dynamicDomain[] = '<?php }else{ ?>';
						}
						$this->dynamicDomain[] = '<?php } ?>';
					}
				}
			}
		}
		return $this->_getModuleDomain($_m);
	}

	/**
	 * 生成url串
	 *
	 * @param string $_m        	
	 * @param string $_c        	
	 * @param string $_a        	
	 * @param WindRouter $router        	
	 * @param array $args        	
	 * @return string
	 */
	private function _buildUrl($_m, $_c, $_a, $router, $args) {
		if ($this->rewrite_special) {
			$rule = $this->_getRule();
			if (!empty($rule)) {
				$_args = $args;
				foreach ($rule as $v) {
					if ($v['route'] == "$_m/$_c/$_a") {
						$format = array();
						preg_match_all('/\{(\w+)\}/', $v['format'], $matches);
						if (empty($matches[1])) continue;
						if (strpos($v['format'], '{fname}') !== false) {
							if ($this->dynamicDomain) continue;
							list($domain) = $this->_getDomainByType('bbs/thread/run', 0);
							$this->dynamic[] = '<?php $__route_rewrite=' . var_export($domain, true) . ';';
							$this->dynamic[] = $_args['fid'] ? '($__route_rewrite[' . $_args['fid'] . '] ? $__route_rewrite[' . $_args['fid'] . '] : \'fname\')' : '\'fname\'';
							is_numeric($_args['fid']) && $format['{fname}'] = $domain[$_args['fid']] ? $domain[$_args['fid']] : 'fname';
							!isset($_args['fid']) && $format['{fname}'] = 'fname';
						}
						foreach ($matches[1] as $code) {
							if ($code != 'fname') {
								$format['{' . $code . '}'] = isset($_args[$code]) ? $_args[$code] : ($code == 'page' ? 1 : 0);
								unset($_args[$code]);
							}
						}
						if ('forum' == $this->_getDomainType("$_m/$_c/$_a")) unset($_args['fid']);
						return '/' . strtr($v['format'], $format) . ($_args ? '?' . WindUrlHelper::argsToUrl(
							$_args) : '');
					}
				}
			}
		}
		if ($this->rewrite_common) {
			return $this->_buildCommon($router, array('m' => $_m, 'c' => $_c, 'a' => $_a), $args);
		} else {
			/* 非rewrite时获取脚本文件 */
			$script = $this->_buildScript($_m, $_c, $_a);
			$url = '';
			if ($this->omit_mca)
				$url = $args ? $script . '?' . WindUrlHelper::argsToUrl($args) : $script;
			else {
				$_args = array();
				if ($_m !== $router->getDefaultModule()) $_args['m'] = $_m;
				if ($_c !== $router->getDefaultController()) $_args['c'] = $_c;
				if ($_a !== $router->getDefaultAction()) $_args['a'] = $_a;
				$args = array_merge($_args, $args);
				$url = $args ? $script . '?' . WindUrlHelper::argsToUrl($args) : '';
			}
			return $url;
		}
	}

	/**
	 * 解析url串
	 *
	 * @param WindHttpRequest $request        	
	 * @param string $path        	
	 * @return array
	 */
	private function _matchPath($path, $rawDecode = false) {
		$path = trim($path, '/');
		if (empty($path)) return array();
		if ($this->rewrite_special) {
			/* 解析特殊伪静态 */
			$rule = $this->_getRule();
			if (!empty($rule)) {
				list($rewritePath, $queryPath) = explode('?', $path . '?', 2);
				foreach ($rule as $k => $v) {
					if ($k == 'default') continue;
					if (preg_match($v['pattern'], $rewritePath, $matches)) {
						$matches = array_diff_key($matches, range(0, intval(count($matches) / 2)));
						$args = WindUrlHelper::urlToArgs(trim($queryPath, '?'), true);
						if ($k == 'thread' || $k == 'cate') {
							if (!isset($matches['fid']) && isset($matches['fname'])) {
								$domain = $this->_getForumDomain();
								if (isset($domain[$matches['fname']])) {
									list($_a, $_c, $_m, $_args) = WindUrlHelper::resolveAction(
										$domain[$matches['fname']]['domain_key']);
									return array_merge($matches, 
										array('m' => $_m, 'c' => $_c, 'a' => $_a), $_args + $args);
								}
							} else if (isset($matches['fid'])) {
								$forums = Wekit::load('forum.PwForum')->getForumList();
								$action = array(
									'category' => array('m' => 'bbs', 'c' => 'cate', 'a' => 'run'),
									'forum' => array('m' => 'bbs', 'c' => 'thread', 'a' => 'run'),
									'sub' => array('m' => 'bbs', 'c' => 'thread', 'a' => 'run'),
									'sub2' => array('m' => 'bbs', 'c' => 'thread', 'a' => 'run'),
									);
								return array_merge($matches, 
										$action[$forums[$matches['fid']]['type']], $args);
							}
						}
						$route = explode('/', $v['route']);
						return array_merge($matches, 
							array('m' => $route[0], 'c' => $route[1], 'a' => $route[2]), $args);
					}
				}
			}
		}
		
		/* 解析普通伪静态 */
		if ($this->rewrite_common && strpos($path, '.php') === false) return $this->_matchCommon(
			$path);
		
		$r = WindUrlHelper::urlToArgs($path);
		if ($rawDecode) return $r;
		$return = array();
		isset($r['m']) && $return['m'] = $r['m'];
		isset($r['c']) && $return['c'] = $r['c'];
		isset($r['a']) && $return['a'] = $r['a'];
		return $return;
	}

	/**
	 * 万事俱备
	 */
	protected function init($build = false) {
		if (!$this->_init) {
			$this->_cache = Wekit::load('domain.srv.PwDomainService')->getDomainCache();
			$rule = $this->_getRule();
			if (isset($rule['default'])) {
				$this->rewrite_common = true;
				unset($rule['default']);
			}
			$rule && $this->rewrite_special = true;
			$this->_init = true;
		}
		if ($build) {
			$this->omit_mca = $this->onlydomain = false;
			$this->dynamicDomain = $this->dynamic = array();
		}
	}

	/**
	 * 初始化配置
	 *
	 * @return array
	 */
	private function _getRule() {
		static $conf = null;
		if ($conf === null) {
			$rule = Wekit::cache()->get('rewrite_rule');
			$conf = $rule ? $rule : array();
		}
		return $conf;
	}

	/**
	 * 初始化配置
	 *
	 * @return array
	 */
	private function _getDomain($letter) {
		return $this->_cache->get("domain_$letter");
	}

	/**
	 * 初始化配置
	 *
	 * @return array
	 */
	private function _getDomainKey() {
		return array(
			'bbs/cate/run' => 'fid', 
			'bbs/thread/run' => 'fid', 
			'bbs/read/run' => 'fid', 
			'space/index/run' => 'uid', 
			'special/index/run' => 'id');
	}
	
	private function _getDomainType($type) {
		$all = array(
			'bbs/cate/run' => 'forum',
			'bbs/thread/run' => 'forum',
			'bbs/read/run' => 'forum',
			'space/index/run' => 'space',
			'special/index/run' => 'special');
		return isset($all[$type]) ? $all[$type] : '';
	}

	/**
	 * 根据类型获取域名
	 *
	 * @return array
	 */
	private function _getDomainByType($type, $absolute = 1) {
		$domain_type = $this->_getDomainType($type);
		if (!$domain_type) return array(array(), '');
		static $domain = array();
		if (!isset($domain[$type][$absolute])) {
			$temp = array();
			if (!$absolute || Wekit::config('domain', "{$domain_type}.isopen")) {
				$r = Wekit::load('domain.PwDomain')->getByType($domain_type);
				foreach ($r as $v) {
					$temp[$v['id']] = $absolute ? 'http://' . $v['domain'] . '.' . $v['root'] : $v['domain'];
				}
			}
			$domain[$type][$absolute] = $temp;
		}
		return array($domain[$type][$absolute], $domain_type);
	}

	/**
	 * 获取版块域名
	 *
	 * @param string $key
	 * @return array  
	 */
	private function _getForumDomain($key = 'domain') {
		$temp = array();
		$r = Wekit::load('domain.PwDomain')->getByType('forum');
		foreach ($r as $v) {
			$temp[$v[$key]] = $v;
		}
		return $temp;
	}

	/**
	 * 初始化配置
	 *
	 * @return array
	 */
	private function _getAppType() {
		static $conf = null;
		if ($conf === null) {
			$conf = $this->_cache->get('domain_app');
			$conf = $conf ? $conf : array();
		}
		return $conf;
	}

	/**
	 * 初始化配置
	 *
	 * @return array
	 */
	private function _getMulti() {
		static $conf = null;
		if ($conf === null) {
			$conf = @include (Wind::getRealPath($this->entrance));
			$conf = $conf ? $conf : array();
		}
		return $conf;
	}

	/**
	 * 获取应用域名
	 *
	 * @param string $_m        	
	 * @return string
	 */
	private function _getModuleDomain($_m) {
		$appType = $this->_getAppType();
		if (isset($appType[$_m])) return $appType[$_m] . $this->base;
		return isset($appType['default']) ? $appType['default'] . $this->base : '';
	}

	/**
	 * 分析参数
	 *
	 * @param AbstractWindRouter $router
	 * @param string $action
	 * @param array $args
	 * @return array 
	 */
	private function _resolveMca($router, $action, $args) {
		list($_a, $_c, $_m, $args) = WindUrlHelper::resolveAction($action, $args);
		$_m = $_m ? $_m : $router->getDefaultModule();
		$_c = $_c ? $_c : $router->getDefaultController();
		$_a = $_a ? $_a : $router->getDefaultAction();
		return array($_m, $_c, $_a, $args);
	}

	/**
	 * 生成脚本文件
	 *
	 * @param string $_m        	
	 * @param string $_c        	
	 * @param string $_a        	
	 * @return string
	 */
	private function _buildScript($_m, $_c, $_a) {
		$pattern = "$_m/$_c/$_a";
		foreach ($this->_getMulti() as $k => $v) {
			if ($v == $pattern) {
				$this->omit_mca = true;
				return "/$k";
			}
		}
		return '/index.php';
	}
}

?>