<?php
Wind::import('APPS:admin.library.AdminBaseController');
/**
 * 二级域名
 *
 * @author Shi Long <long.shi@alibaba-inc.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: DomainController.php 16646 2012-08-27 06:43:29Z long.shi $
 * @package rewrite.admin
 */
class DomainController extends AdminBaseController {

	/*
	 * (non-PHPdoc) @see WindController::run()
	 */
	public function run() {
		$root = Wekit::config('site', 'cookie.domain');
		if ($root) {
			$domain = Wekit::config('domain');
			$addons = $this->_service()->getAddOns();
			foreach ($addons as $k => $v) {
				$r = $this->_ds()->getByDomainKey($v[1] ? $v[1] : "$k/index/run");
				$addons[$k][] = isset($r['domain']) ? $r['domain'] : '';
			}
			$this->setOutput($domain, 'domain');
			$this->setOutput($addons, 'addons');
		}
		$this->setOutput($root, 'root');
	}

	/**
	 * 保存修改
	 */
	public function doModifyAction() {
		$root = Wekit::config('site', 'cookie.domain');
		if (empty($root)) $this->showError('DOMAIN:cookie.domain.empty');
		list($app, $domain, $domain_hold) = $this->getInput(
			array('app', 'domain', 'domain_hold'));
		
		// 判断域名是否重复
		$unique = array();
		Wind::import('SRV:config.bo.PwConfigBo');
		Wind::import('SRV:domain.dm.PwDomainDm');
		$bo = new PwConfigBo('domain');
		$addons = $this->_service()->getAddOns();
		foreach ($app as $key => $value) {
			$domainKey = $addons[$key][1] ? $addons[$key][1] : "$key/index/run";
			if ($value) {
				//域名重复
				in_array($value, $unique) && $this->showError(
				array('REWRITE:domain.same', array($value)));
				$unique[] = $value;
				//添加应用域名
				$dm = new PwDomainDm();
				$dm->setDomain($value)->setRoot(substr($root, 1))->setDomainKey(
					$domainKey)->setDomainType('app')->setFirst($value[0]);
				$r = $this->_ds()->replaceDomain($dm);
				if ($r instanceof PwError) $this->showError($r->getError());
			} else {
				$this->_ds()->deleteByDomainKey($domainKey);
			}
		}
		
		foreach ($domain as $k => $v) {
			$domain_root = '';
			if ($v['isopen']) {
				if (!$app['default']) $this->showError('REWRITE:default.empty');
				$domain_root = $v['root'] ? $v['root'] . $root : substr($root, 1);
				$dm = new PwDomainDm();
				$dm->setRoot($domain_root)->setDomainType($k);
				$r = $this->_ds()->updateByDomainType($dm);
				if ($r instanceof PwError) $this->showError($r->getError());
			}
			$bo->set("$k.isopen", $v['isopen'])->set("$k.root", $domain_root);
		}
		$bo->set('domain.hold', $domain_hold);
		$bo->flush();
		
		$this->_service()->refreshAllCache();
		$this->showMessage('success');
	}

	/**
	 * @return PwDomain
	 */
	private function _ds() {
		return Wekit::load('domain.PwDomain');
	}
	
	/**
	 * @return PwDomainService
	 */
	private function _service() {
		return Wekit::load('domain.srv.PwDomainService');
	}
}

?>