<?php
Wind::import('APPS:admin.library.AdminBaseController');
/**
 * 后台伪静态
 *
 * @author Shi Long <long.shi@alibaba-inc.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: RewriteController.php 17480 2012-09-06 02:18:37Z long.shi $
 * @package rewrite.admin
 */
class RewriteController extends AdminBaseController {
	/*
	 * (non-PHPdoc) @see WindController::run()
	 */
	public function run() {
		$addons = Wekit::load('domain.srv.PwDomainService')->getAddOns('rewrite');
		$rewrite = Wekit::config('rewrite');
		$this->setOutput($addons, 'addons');
		$this->setOutput($rewrite, 'rewrite');
	}

	/**
	 * 设置伪静态
	 */
	public function doModifyAction() {
		list($format, $isopen) = $this->getInput(array('format', 'isopen'));
		Wind::import('SRV:config.bo.PwConfigBo');
		$bo = new PwConfigBo('rewrite');
		foreach ($format as $k => $v) {
			if (empty($v) && isset($isopen[$k])) $this->showError('REWRITE:format.empty');
			$bo->set("format.$k", $v);
		}
		$addons = Wekit::load('domain.srv.PwDomainService')->getAddOns('rewrite');
		$rewriteData = array();
		$unique = array();
		foreach ($addons as $k1 => $v1) {
			$open = isset($isopen[$k1]) ? 1 : 0;
			$bo->set("isopen.$k1", $open);
			if ($open) {
				$format_i = preg_replace('/\{\w+\}/', '', $format[$k1]);
				if (in_array($format_i, $unique)) {
					$this->showError('REWRITE:format.conflict');
				}
				$unique[] = $format_i;
				if ($k1 == 'thread') {
					$rewriteData['cate'] = array(
						'format' => $format[$k1],
						'pattern' => $this->_compileFormat($format[$k1]),
						'route' => 'bbs/cate/run');
				}
				$rewriteData[$k1] = array(
					'format' => $format[$k1], 
					'pattern' => $this->_compileFormat($format[$k1]), 
					'route' => $v1[2]);
			}
		}
		Wekit::cache()->set('rewrite_rule', $rewriteData);
		$bo->flush();
		Wekit::load('domain.srv.PwDomainService')->refreshTplCache();
		$this->showMessage('success');
	}

	private function _compileFormat($format) {
		$format = preg_quote($format, '/');
		$format = str_replace('\{fname\}', '(?P<fname>[a-z0-9]+)', $format);
		$format = str_replace('\{page\}', '(?P<page>([0-9]+|e))', $format);
		$format = preg_replace('/\\\{(\w+)\\\}/', '(?P<\\1>\d+)', $format);
		return '/^' . $format . '$/i';
	}
}

?>