<?php
Wind::import('LIB:base.PwBaseController');
Wind::import('SRV:space.bo.PwSpaceModel');

/**
 * the last known user to change this file in the repository  <$LastChangedBy$>
 * @author $Author$ Foxsee@aliyun.com
 * @copyright ?2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id$ 
 * @package 
 */
class SpaceBaseController extends PwBaseController {
	
	public $space;
	
	/**
	 * (non-PHPdoc)
	 * @see src/library/base/PwBaseController::beforeAction()
	 */
	public  function beforeAction($handlerAdapter) {
		parent::beforeAction($handlerAdapter);
		$spaceUid = (int)$this->getInput('uid','get');
		if ($spaceUid < 1) {
			if ($userName = $this->getInput('username','get')) {
				$user = Wekit::load('user.PwUser')->getUserByName($userName);
				$spaceUid = isset($user['uid'])? $user['uid'] : 0;
			} else {
				$this->showError('SPACE:space.guest');
			}
		}
		if ($spaceUid < 1) $spaceUid = $this->loginUser->uid;
		$this->space = new PwSpaceModel($spaceUid);
	
		if (!$this->space->space['uid']){
			$user = Wekit::load('user.PwUser')->getUserByUid($spaceUid);
			if ($user) {
				Wekit::load('space.dm.PwSpaceDm');
 				$dm = new PwSpaceDm($spaceUid);
 				$dm->setVisitCount(0);
				Wekit::load('space.PwSpace')->addInfo($dm);
				$this->space = new PwSpaceModel($spaceUid);
			} else {
				//$this->forwardRedirect(WindUrlHelper::createUrl('u/login/run/'));
				$this->showError('SPACE:space.not.exist');
			}
			
		}
		$this->space->setTome($spaceUid, $this->loginUser->uid);
		$this->space->setVisitUid($this->loginUser->uid);
		if (!$this->space->allowView('space')) $this->forwardRedirect(WindUrlHelper::createUrl('space/ban/run/?uid='.$spaceUid));
		$this->setTheme('space', $this->space->space['space_style']);
	}
	
	/**
	 * (non-PHPdoc)
	 * @see src/library/base/PwBaseController::afterAction()
	 */
	public function afterAction($handlerAdapter) {
		parent::afterAction($handlerAdapter);
		$host = $this->space->tome == PwSpaceModel::MYSELF ? '我' : 'Ta';
		$this->setOutput($this->space, 'space');
		$this->setOutput($host, 'host');
		$online = Wekit::load('online.srv.PwOnlineService');
		$visitor = $online->getVisitor();
		if (!is_array($visitor)) return false;
		$service = Wekit::load('space.srv.PwSpaceService');
		$service->signVisitor($this->space->spaceUid, $this->loginUser->uid);
		$service->signToVisitor($this->space->spaceUid, $this->loginUser->uid);	
	}
}
?>