<?php
Wind::import('APPS:space.controller.SpaceBaseController');
/**
 * the last known user to change this file in the repository  <$LastChangedBy$>
 * @author $Author$ Foxsee@aliyun.com
 * @copyright ?2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id$
 * @package
 */
class ThreadController extends SpaceBaseController {
	
	/**
	 * 我的帖子
	 *
	 */
	public function run() {
		list($page, $perpage) = $this->getInput(array('page', 'perpage'));
		$page = $page ? $page : 1;
		$perpage = 20;
		list($start, $limit) = Pw::page2limit($page, $perpage);
		$count = $this->_getCountThread($this->space->spaceUid,$this->loginUser->uid);
		if ($count) {
			$threads = $this->_getThread($this->space->spaceUid,$this->loginUser->uid,$limit,$start);
			$topic_type = array();
			foreach ($threads as &$v) {
				$topic_type[] = $v['topic_type'];
				if ($v['ifshield']) {
					$v['highlight_style'] = 'text-decoration: line-through';
					$v['subject'] = '此帖已被屏蔽';
				}
			}
			$topictypes = Wekit::load('forum.PwTopicType')->fetchTopicType($topic_type);
		}
		
		$args = array('uid'=>$this->space->spaceUid);
		$this->setOutput(http_build_query($args), 'args');
		$this->setOutput($count, 'count');
		$this->setOutput($page, 'page');
		$this->setOutput($perpage, 'perpage');
		$this->setOutput($threads, 'threads');
		$this->setOutput($topictypes, 'topictypes');
		$this->setOutput('thread', 'src');
		
		// seo设置
		Wind::import('SRV:seo.bo.PwSeoBo');
		$lang = Wind::getComponent('i18n');
		$des = $lang->getMessage('SEO:space.thread.run.description', array($this->space->spaceUser['username']));
		if ($page <= 1) PwSeoBo::setCustomSeo($lang->getMessage('SEO:space.thread.run.title', array($this->space->spaceUser['username'], $this->space->space['space_name'])), '', $des);
		else PwSeoBo::setCustomSeo($lang->getMessage('SEO:space.thread.run.page.title', array($this->space->spaceUser['username'], $page, $this->space->space['space_name'])), '', $des);
	}
	
	/**
	 * 我的回复
	 *
	 */
	public function postAction() {
		list($page, $perpage) = $this->getInput(array('page', 'perpage'));
		$page = $page ? $page : 1;
		$perpage = 20;
		list($start, $limit) = Pw::page2limit($page, $perpage);
		$count = $this->_getCountPost($this->space->spaceUid,$this->loginUser->uid);
		if ($count) {
			$tmpPosts = $this->_getPost($this->space->spaceUid,$this->loginUser->uid,$limit,$start);
			$posts = $tids = array();
			foreach ($tmpPosts as $v) {
				$tids[] = $v['tid'];
			}
			$threads = $this->_getThreadDs()->fetchThread($tids);
			foreach ($tmpPosts as $v) {
				$v['threadSubject'] = WindString::substr($threads[$v['tid']]['subject'], 0, 30, '', true);
				$v['content'] = WindString::substr($v['content'], 0, 30, '', true);
				$v['created_time'] = PW::time2str($v['created_time'],'auto');
				$posts[] = $v;
			}
		}
		$args = array('uid'=>$this->space->spaceUid);
		$this->setOutput($args, 'args');
		$this->setOutput($count, 'count');
		$this->setOutput($page, 'page');
		$this->setOutput($perpage, 'perpage');
		$this->setOutput($posts, 'posts');
		$this->setOutput('thread', 'src');
		
		// seo设置
		Wind::import('SRV:seo.bo.PwSeoBo');
		$lang = Wind::getComponent('i18n');
		$des = $lang->getMessage('SEO:space.thread.post.description', array($this->space->spaceUser['username']));
		if ($page <= 1) PwSeoBo::setCustomSeo($lang->getMessage('SEO:space.thread.post.title', array($this->space->spaceUser['username'], $this->space->space['space_name'])), '', $des);
		else PwSeoBo::setCustomSeo($lang->getMessage('SEO:space.thread.post.page.title', array($this->space->spaceUser['username'], $page, $this->space->space['space_name'])), '', $des);
	}
	
	private function _getCountThread($spaceUid,$loginUid) {
		return ($spaceUid == $loginUid) ? $this->_getThreadExpandDs()->countDisabledThreadByUid($spaceUid) : $this->_getThreadDs()->countThreadByUid($spaceUid);
	}
	
	private function _getThread($spaceUid,$loginUid,$limit,$start) {
		return ($spaceUid == $loginUid) ? $this->_getThreadExpandDs()->getDisabledThreadByUid($spaceUid,$limit,$start) : $this->_getThreadDs()->getThreadByUid($spaceUid,$limit,$start);
	}
	
	private function _getCountPost($spaceUid,$loginUid) {
		return ($spaceUid == $loginUid) ? $this->_getThreadExpandDs()->countDisabledPostByUid($spaceUid) : $this->_getThreadDs()->countPostByUid($spaceUid);
	}
	
	private function _getPost($spaceUid,$loginUid,$limit,$start) {
		return ($spaceUid == $loginUid) ? $this->_getThreadExpandDs()->getDisabledPostByUid($spaceUid,$limit,$start) : $this->_getThreadDs()->getPostByUid($spaceUid,$limit,$start);
	}
	
	/**
	 * Enter description here ...
	 *
	 * @return PwThreadExpand
	 */
	protected function _getThreadExpandDs() {
		return Wekit::load('forum.PwThreadExpand');
	}
	
	/**
	 * Enter description here ...
	 *
	 * @return PwThread
	 */
	protected function _getThreadDs() {
		return Wekit::load('forum.PwThread');
	}
}
?>