<?php
Wind::import('WIND:filter.WindActionFilter');
Wind::import('SRV:task.srv.PwTaskApply');

/**
 * Enter description here ...
 *
 * @author xiaoxia.xu <xiaoxia.xuxx@aliyun-inc.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: PwTaskFilter.php 15766 2012-08-13 06:14:43Z xiaoxia.xuxx $
 * @package src.applications.task.filter
 */
class PwTaskFilter extends WindActionFilter {
	
	/* (non-PHPdoc)
	 * @see WindHandlerInterceptor::preHandle()
	 */
	public function preHandle() {}

	/* (non-PHPdoc)
	 * @see WindHandlerInterceptor::postHandle()
	 */
	public function postHandle() {
		if (!Wekit::config('site', 'task.isOpen')) return true;
		/* @var $userBo PwUserBo */
		$userBo = PwUserBo::getLoginUser();
		if (!$userBo->isExists()) return true;
		
		//TODO 自动任务发放机制
		//过滤Ajax递交/产品是bbs|u/递交的方式是post
//		if ($this->getRequest()->getIsAjaxRequest()) return true;
		if (!in_array($this->router->getModule(), array('bbs', 'u'))) return true;
		if (!in_array(strtolower($this->getRequest()->getRequestMethod()), array('post', 'get'))) return true;
		//整点或是整半的时候发放
// 		if (!in_array(Pw::time2str(Pw::getTime(), 'i'), array('00', '30'))) return false;

		//行为分析
		$tody = Pw::time2str(Pw::getTime(), 'Y-m-d');
		/* @var $behaviorsDs PwUserBehavior */
		$behaviorsDs = Wekit::load('user.PwUserBehavior');
		$behaviors = $behaviorsDs->getBehaviorList($userBo->uid);
		$send = false;
		foreach ($behaviors as $_item) {
			$is_tody = ($tody == Pw::time2str($_item['extend_info'], 'Y-m-d'));
			switch ($_item['behavior']) {
				case 'login_days':
					$send = $_item['number'] % 3 == 0;
					break;
				case 'post_days':
					$send = $is_tody && $_item['number'] % 2 == 0;
					break;
				case 'thread_days':
					$send = $is_tody && ($behaviors['thread_count']['number'] == 1 || $behaviors['thread_count']['number'] % 50 == 0);
					break;
			}
			if (true === $send) break;
		}
		
		if ($send) return $this->sendTask($userBo->uid);
		//TODO 其他随机情况
		return true;
	}
	
	/**
	 * 发送给用户自动任务
	 *
	 * @param int $uid 用户ID
	 * @return boolean
	 */
	private function sendTask($uid) {
		/* @var $taskService PwTaskService */
		$taskService = Wekit::load('SRV:task.srv.PwTaskService');
		$userTask = new PwTaskApply($uid);
		$autoTaskIds = $taskService->getAutoApplicableTaskList($uid, 1);
		$userTask->autoApplies($autoTaskIds);
		return true;
	}
}