<?php
Wind::import('SRV:user.srv.PwLoginService');
Wind::import('APPS:u.service.helper.PwUserHelper');

/**
 * 登录
 *
 * @author xiaoxia.xu <xiaoxia.xuxx@aliyun-inc.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: LoginController.php 17259 2012-09-04 07:49:32Z xiaoxia.xuxx $
 * @package products.u.controller
 */
class LoginController extends PwBaseController {
	
	/*
	 * (non-PHPdoc) @see PwBaseController::beforeAction()
	 */
	public function beforeAction($handlerAdapter) {
		parent::beforeAction($handlerAdapter);
		$action = $handlerAdapter->getAction();
		if ($this->loginUser->isExists() && !in_array($action, array('showverify', 'logout', 'show'))) {
			
			$inviteCode = $this->getInput('invite');
			if ($inviteCode) {
				$user = Wekit::load('SRV:invite.srv.PwInviteFriendService')->invite($inviteCode, $this->loginUser->uid);
				if ($user instanceof PwError) {
					$this->showError($user->getError());
				}
			}
			
			if ($action == 'fast') {
				$this->showMessage('USER:login.success');
			} elseif ($action == 'welcome') {
				$this->forwardAction('u/login/show');
			} elseif($this->getRequest()->getIsAjaxRequest()) {
				$this->showError('USER:login.exists');
			} else {
				$this->forwardRedirect($this->_filterUrl());
			}
		}
	}
	
	/*
	 * (non-PHPdoc) 页面登录页 @see WindController::run()
	 */
	public function run() {
		$this->setOutput(in_array('userlogin', Wekit::config('verify', 'showverify')), 'verify');
		$this->setOutput('用户登录', 'title');
		$this->setOutput($this->_filterUrl(false), 'url');
		$this->setOutput(PwUserHelper::getLoginMessage(), 'loginWay');
		$this->setOutput($this->getInput('invite'), 'invite');
		$this->setTemplate('login');
	}

	/**
	 * 快捷登录
	 */
	public function fastAction() {
		$this->setOutput(in_array('userlogin', Wekit::config('verify', 'showverify')), 'verify');
		$this->setOutput($this->_filterUrl(), 'url');
		$this->setOutput(PwUserHelper::getLoginMessage(), 'loginWay');
		$this->setTemplate('login_fast');
	}

	/**
	 * 页面登录
	 */
	public function dorunAction() {
		$userForm = $this->_getLoginForm();
		
		/* [验证验证码是否正确] */
		if (in_array('userlogin', Wekit::config('verify', 'showverify'))) {
			$veryfy = $this->_getVerifyService();
			if ($veryfy->checkVerify($userForm['code']) !== true) {
				$this->showError('USER:verifycode.error');
			}
		}
		$question = $userForm['question'];
		if ($question == -4) {
			$question = $this->getInput('myquestion', 'post');
		}
		
		/* [验证用户名和密码是否正确] */
		$login = new PwLoginService();
		$this->runHook('c_login_dorun', $login);
		
		$isSuccess = $login->login($userForm['username'], $userForm['password'], $this->getRequest()->getClientIp(), $question, $userForm['answer']);
		if ($isSuccess instanceof PwError) {
			$this->showError($isSuccess->getError());
		}
		$info = $login->sysUser($isSuccess['uid']);
		$identity = PwLoginService::createLoginIdentify($info);
		$identity = base64_encode($identity . '|' . $this->getInput('backurl'));
		
		/* [是否需要设置安全问题] */
		/* @var $userService PwUserService */
		$userService = Wekit::load('user.srv.PwUserService');
		if (empty($isSuccess['safecv']) && $userService->mustSettingSafeQuestion($info['uid'])) {
			$this->addMessage(
				array('url' => WindUrlHelper::createUrl('u/login/setquestion?_statu=' . $identity)), 'check');
		}
		$this->showMessage('', 'u/login/welcome?_statu=' . $identity);
	}

	/**
	 * 页头登录
	 */
	public function dologinAction() {
		$userForm = $this->_getLoginForm();
		
		$login = new PwLoginService();
		$result = $login->login($userForm['username'], $userForm['password'], $this->getRequest()->getClientIp());
		if ($result instanceof PwError) {
			$this->showError($result->getError());
		} else {
			$info = $login->sysUser($result['uid']);
			$identity = PwLoginService::createLoginIdentify($info);
			$backUrl = $this->getInput('backurl');
			if (!$backUrl) $backUrl = $this->getRequest()->getServer('HTTP_REFERER');
			$identity = base64_encode($identity . '|' . $backUrl);
			
			if ($result['safecv']) {
				$url = WindUrlHelper::createUrl('u/login/showquestion?_statu=' . $identity);
			} elseif (Wekit::load('user.srv.PwUserService')->mustSettingSafeQuestion($info['uid'])) {
				$url = WindUrlHelper::createUrl('u/login/setquestion?_statu=' . $identity);
			} elseif (in_array('userlogin', Wekit::config('verify', 'showverify'))) {
				$url = WindUrlHelper::createUrl('u/login/showquestion?_statu=' . $identity);
			}
			$this->addMessage(array('url' => $url), 'check');
			$this->showMessage('USER:login.success', 'u/login/welcome?_statu=' . $identity);
		}
	}

	/**
	 * 显示安全问题
	 */
	public function showquestionAction() {
		$statu = $this->checkUserInfo();
		$verify = in_array('userlogin', Wekit::config('verify', 'showverify'));
		$login = new PwLoginService();
		$hasQuestion = $login->isSetSafecv($this->loginUser->uid);
		if (!$hasQuestion && !$verify) {
			$this->forwardRedirect(WindUrlHelper::createUrl('u/login/welcome', array('_statu' => $statu)));
		}
		$this->setOutput($hasQuestion, 'hasQuestion');
		$this->setOutput($this->_getQuestions(), 'safeCheckList');
		$this->setOutput($verify, 'verify');
		$this->setOutput($statu, '_statu');
		$this->setTemplate('login_question');
	}

	/**
	 * 检查安全问题是否正确---也头登录的弹窗，带有验证码
	 */
	public function doshowquestionAction() {
		$statu = $this->checkUserInfo();
		$code = $this->getInput('code', 'post');
		if (in_array('userlogin', Wekit::config('verify', 'showverify'))) {
			$veryfy = $this->_getVerifyService();
			if (false === $veryfy->checkVerify($code)) $this->showError('USER:verifycode.error');
		}
		$login = new PwLoginService();
		$hasQuestion = $login->isSetSafecv($this->loginUser->uid);
		if ($hasQuestion) {
			list($question, $answer) = $this->getInput(array('question', 'answer'), 'post');
			if ($question == -4) {
				$question = $this->getInput('myquestion', 'post');
			}
			$result = $login->checkQuestion($this->loginUser->uid, $question, $answer, $this->getRequest()->getClientIp());
			if ($result instanceof PwError) {
				$this->showError($result->getError());
			}
		}
		$this->showMessage('USER:login.success', 'u/login/welcome?_statu=' . $statu);
	}

	/**
	 * 验证密码
	 */
	public function checkpwdAction() {
		list($password, $username) = $this->getInput(array('password', 'username'), 'post');
		$login = new PwLoginService();
		$info = $login->login($username, $password, $this->getRequest()->getClientIp());
		if ($info instanceof PwError) {
			$this->showError($info->getError());
		}
		$this->showMessage();
	}

	/**
	 * 验证安全问题
	 */
	public function checkquestionAction() {
		$statu = $this->checkUserInfo();
		list($question, $answer) = $this->getInput(array('question', 'answer'), 'post');
		$userLoginBp = new PwLoginService();
		$result = $userLoginBp->checkQuestion($this->loginUser->uid, $question, $answer, $this->getRequest()->getClientIp());
		if ($result instanceof PwError) {
			$this->showError($result->getError());
		}
		$this->showMessage();
	}

	/**
	 * 设置安全问题弹窗
	 */
	public function setquestionAction() {
		$statu = $this->checkUserInfo();
		$mustSetting = Wekit::load('user.srv.PwUserService')->mustSettingSafeQuestion(
			$this->loginUser->uid);
		$verify = in_array('userlogin', Wekit::config('verify', 'showverify'));
		if (!$mustSetting && !$verify) {
			$this->forwardRedirect(WindUrlHelper::createUrl('u/login/welcome', array('_statu' => $statu)));
		}
		$this->setOutput($this->_getQuestions(), 'safeCheckList');
		$this->setOutput($statu, '_statu');
		$this->setOutput($verify, 'verify');
		$this->setTemplate('login_setquestion');
	}

	/**
	 * 执行设置安全问题
	 */
	public function dosettingAction() {
		$statu = $this->checkUserInfo();
		$code = $this->getInput('code', 'post');
		if (in_array('userlogin', Wekit::config('verify', 'showverify'))) {
			$veryfy = $this->_getVerifyService();
			if (false === $veryfy->checkVerify($code)) {
				$this->showError('USER:verifycode.error');
			}
		}
		list($question, $answer) = $this->getInput(array('question', 'answer'), 'post');
		if (!$question || !$answer) $this->showError('USER:login.question.setting');
		if (intval($question) === -4) {
			$question = $this->getInput('myquestion', 'post');
			if (!$question) $this->showError('USER:login.question.setting');
		}
		
		/* @var $userDs PwUser */
		$userDs = Wekit::load('user.PwUser');
		$userDm = new PwUserInfoDm();
		$userDm->setUid($this->loginUser->uid)->setQuestion($question, $answer);
		if (($result = $userDs->editUser($userDm, PwUser::FETCH_MAIN)) instanceof PwError) {
			$this->showError($result->getError());
		}
		$this->showMessage('USER:login.question.setting.success', 'u/login/welcome?_statu=' . $statu);
	}

	/**
	 * 登录成功
	 */
	public function welcomeAction() {
		$identify = $this->checkUserInfo();
		if (($this->loginUser->info['status'] & PwUser::STATUS_UNACTIVE) == PwUser::STATUS_UNACTIVE) {
			Wind::import('SRV:user.srv.PwRegisterService');
			$identify = PwRegisterService::createRegistIdentify($this->loginUser->uid, 
				$this->loginUser->info['password']);
			$this->forwardAction('u/register/sendActiveEmail', array('_statu' => $identify, 'from' => 'login'), true);
		}
		$login = new PwLoginService();
		$login->welcome($this->loginUser, $this->getRequest()->getClientIp());
		if (($this->loginUser->info['status'] & PwUser::STATUS_UNCHECK) == PwUser::STATUS_UNCHECK) {
			$this->showError('USER:login.active.check');
		}
		list(, $refUrl) = explode('|', base64_decode($identify));
		if (!$refUrl) $refUrl = WindUrlHelper::createUrl();
		$this->forwardRedirect($refUrl);
	}
	
	/**
	 * 提示信息
	 */
	public function showAction() {
		if (($this->loginUser->info['status'] & PwUser::STATUS_UNCHECK) == PwUser::STATUS_UNCHECK) {
			$this->showError('USER:login.active.check');
		}
		$this->forwardRedirect($this->_filterUrl());
	}

	/**
	 * 检查用户输入的用户名
	 */
	public function checknameAction() {
		$login = new PwLoginService();
		$info = $login->auth($this->getInput('username'), '');
		if (-1 == $info['status']) $this->showError('USER:user.error.-14');
		if (!empty($info['safecv'])) {
			$status = PwLoginService::createLoginIdentify($login->sysUser($info['uid']));
			$identify = base64_encode($status . '|');
			$this->addMessage($this->_getQuestions(), 'safeCheck');
			$this->addMessage($identify, '_statu');
			$this->showMessage();
		}
		$this->showMessage();
	}

	/**
	 * 退出
	 *
	 * @return void
	 */
	public function logoutAction() {
		$this->setOutput('用户登出', 'title');
		/* @var $userService PwUserService */
		$userService = Wekit::load('user.srv.PwUserService');
		if ($userService->logout()) {
			$url = $this->getInput('backurl');
			if (!$url) $url = $this->getRequest()->getServer('HTTP_REFERER');
			if (!$url) $url = WindUrlHelper::createUrl('u/login/run');
			$this->forwardRedirect($url);
		}
		$this->showMessage('USER:loginout.fail');
	}

	/**
	 * 检查用户信息合法性
	 *
	 * @return string
	 */
	private function checkUserInfo() {
		$identify = $this->getInput('_statu', 'get');
		!$identify && $identify = $this->getInput('_statu', 'post');

		if (!$identify) $this->showError('USER:illegal.request');
		list($identify, $url) = explode('|', base64_decode($identify));
		list($uid, $password) = PwLoginService::parseLoginIdentify(rawurldecode($identify));
		
		$info = $this->_getUserDs()->getUserByUid($uid, PwUser::FETCH_MAIN);
		if (!$info || Pw::getPwdCode($info['password']) != $password) {
			$this->showError('USER:illegal.request');
		}
		$this->loginUser = new PwUserBo($uid);
		return base64_encode($identify . '|' . $url);
	}

	/**
	 * 获得安全问题列表
	 *
	 * @return array
	 */
	private function _getQuestions() {
		$questions = PwUserHelper::getSafeQuestion();
		$questions[-4] = '自定义安全问题';
		return $questions;
	}

	/**
	 * 获得用户DS
	 *
	 * @return PwUser
	 */
	private function _getUserDs() {
		return Wekit::load('user.PwUser');
	}
	
	private function _getVerifyService() {
		return Wekit::load("verify.srv.PwCheckVerifyService");
	}

	/**
	 * 过滤来源URL
	 *
	 * TODO
	 * 
	 * @return string
	 */
	private function _filterUrl($returnDefault = true) {
		$url = $this->getInput('backurl');
		if (!$url) $url = $this->getRequest()->getServer('HTTP_REFERER');
		if ($url) {
			// 排除来自注册页面/自身welcome/show的跳转
			$args = WindUrlHelper::urlToArgs($url);
			if ($args['m'] == 'u' && in_array($args['c'], array('register', 'login'))) {
				$url = '';
			}
		}
		if (!$url && $returnDefault) $url = WindUrlHelper::createUrl('');
		return $url;
	}

	/**
	 * @return array
	 */
	private function _getLoginForm() {
		$data = array();
		list($data['username'], $data['password'], $data['question'], $data['answer'], $data['code']) = $this->getInput(
			array('username', 'password', 'question', 'answer', 'code'), 'post');
		if (empty($data['username']) || empty($data['password'])) $this->showError('USER:login.user.require', 'u/login/run');
		return $data;
	}
}