<?php
Wind::import('SRV:user.srv.PwRegisterService');
Wind::import('APPS:u.service.helper.PwUserHelper');
Wind::import('SRV:user.validator.PwUserValidator');

/**
 * 用户登录/注册controller
 *
 * @author xiaoxia.xu <xiaoxia.xuxx@aliyun-inc.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: RegisterController.php 17974 2012-09-10 12:17:09Z liusanbian $
 * @package src.products.u.controller
 */
class RegisterController extends PwBaseController {
	
	/* (non-PHPdoc)
	 * @see PwBaseController::beforeAction()
	 */
	public function beforeAction($handlerAdapter) {
		parent::beforeAction($handlerAdapter);
		$this->setOutput('用户注册', 'title');
		$config = Wekit::config('register');
		if (0 == $config['type'] && ('close' != $handlerAdapter->getAction())) {
			$this->forwardAction('u/register/close');
		}
	}
	
	/* (non-PHPdoc)
	 *  用户注册
	 * 如果开启同一个IP地址在一定时间内不能再次注册
	 * @see WindController::run()
	 */
	public function run() {
		$this->init();
		$this->setOutput($this->getInput('invite'), 'invite');
		$this->setOutput(urlencode(WindUrlHelper::createUrl('bbs/index/run')), 'backurl');
		$this->setTemplate('register');
	}
	
	/**
	 * 邀请码链接
	 */
	public function inviteAction() {
		$config = Wekit::config('register');
		if ($config['type'] != 2) $this->showError('USER:invite.close');
		$this->init();
		$inviteCode = $this->getInput('code', 'get');
		$this->setOutput($inviteCode, 'invitecode');
		$this->setTemplate('register');
	}
	
	/**
	 * 检查邀请码是否可以用
	 */
	public function checkInvitecodeAction() {
		$code = $this->getInput('invitecode', 'post');
		/* @var $inviteService PwInviteCodeService */
		$inviteService = Wekit::load('invite.srv.PwInviteCodeService');
		if (($info = $inviteService->allowUseInviteCode($code)) instanceof PwError) {
			$this->showError($info->getError());
		}
		$info = $this->_getUserDs()->getUserByUid($info['created_userid']);
		$this->showMessage(array('USER:invite.code.check.success', array('username' => $info['username'])));
	}
	
	/**
	 * 执行用户注册
	 */
	public function dorunAction() {
		$this->setOutput('注册', 'title');
		
		$registerService = new PwRegisterService();
		$registerService->setUserDm($this->_getUserDm());
		/*[u_regsiter]:插件扩展*/
		$this->runHook('c_register', $registerService);
		if (($info = $registerService->register()) instanceof PwError) {
			$this->showError($info->getError());
		} else {
			$identity = PwRegisterService::createRegistIdentify($info['uid'], $info['password']);
			if (1 == Wekit::config('register', 'active.mail')) {
				$this->forwardAction('u/register/sendActiveEmail', array('_statu' => $identity), true);
			} else {
				$this->forwardAction('u/register/welcome', array('_statu' => $identity), true);
			}
		}
	}

	/**
	 * 发送激活邮箱
	 */
	public function sendActiveEmailAction() {
		$statu = $this->checkRegisterUser();
		if (($this->loginUser->info['status'] & PwUser::STATUS_UNACTIVE) != PwUser::STATUS_UNACTIVE) {
			$this->setOutput('activeEmail', 'type');
			$this->setTemplate('register_about');
			return;
		}
		$registerService = new PwRegisterService();
		$info = $this->loginUser->info;
		if (false == $registerService->checkIfActiveEmailSend($info['uid'], $info['email'])) {
			$registerService->sendEmailActive($info['username'], $info['email'], $statu, $info['uid']);
		}
		
		$mailList = array('gmail.com' => 'google.com');
		list(, $mail) = explode('@', $info['email'], 2);
		$gotoEmail = 'http://mail.' . (isset($mailList[$mail]) ? $mailList[$mail] : $mail);
		
		$this->setOutput($info['email'], 'email');
		$this->setOutput($info['username'], 'username');
		$this->setOutput($gotoEmail , 'gotoEmail');
		$this->setOutput($statu, '_statu');
		$this->setOutput($this->getInput('from'), 'from');
		$this->setTemplate('register_emailactive');
	}
	
	/**
	 * 再次发送激活邮件
	 */
	public function sendActiveEmailAgainAction() {
		$_statu = $this->checkRegisterUser();
		if (($this->loginUser->info['status'] & PwUser::STATUS_UNACTIVE) != PwUser::STATUS_UNACTIVE) {
			$this->showMessage('USER:active.email.dumplicate');
		}
		$registerService = new PwRegisterService();
		$registerService->sendEmailActive($this->loginUser->info['username'], $this->loginUser->info['email']);
		$this->showMessage('USER:active.sendemail.success');
	}
	
	/**
	 * 更改邮箱
	 */
	public function editEmailAction() {
		$_statu = $this->checkRegisterUser();
		if (($this->loginUser->info['status'] & PwUser::STATUS_UNACTIVE) != PwUser::STATUS_UNACTIVE) {
			$this->showMessage('USER:active.email.dumplicate', 'u/login/run');
		}
		$email = $this->getInput('email', 'post');
		if ($this->_getUserDs()->checkEmailExist($email, $this->loginUser->info['username'])) {
			$this->showError('USER:user.error.-10');
		} else {
			$userInfo = new PwUserInfoDm();
			$userInfo->setUid($this->loginUser->uid)->setEmail($email);
			$this->_getUserDs()->editUser($userInfo, PwUser::FETCH_MAIN);
			$registerService = new PwRegisterService();
			$registerService->sendEmailActive($this->loginUser->info['username'], $email, $_statu, $this->loginUser->uid);
			$this->showMessage('USER:active.editemail.success', 'u/register/sendActiveEmail?_statu=' . $_statu);
		}
	}

	/**
	 * 激活邮箱链接
	 */
	public function activeEmailAction() {
		$_statu = $this->checkRegisterUser();
		if (($this->loginUser->info['status'] & PwUser::STATUS_UNACTIVE) != PwUser::STATUS_UNACTIVE) {
//			$this->showMessage('USER:active.email.success', 'u/register/welcome?_statu=' . $_statu);
			$this->setOutput('activeEmail', 'type');
			$this->setTemplate('register_about');
			return;
		}
		$code = $this->getInput('code');
		$PwUserRegisterBp = new PwRegisterService();
		$result = $PwUserRegisterBp->activeEmail($this->loginUser->uid, $this->loginUser->info['email'], $code);
		if ($result instanceof PwError) $this->showError($result->getError());
		$this->setOutput('activeEmailSuccess', 'type');
		$this->setOutput($_statu, '_statu');
		$this->setTemplate('register_about');
//		$this->showMessage('USER:active.email.success', 'u/register/welcome?_statu=' . $_statu);
	}
	
	/**
	 * 完成注册，显示欢迎信息
	 */
	public function welcomeAction() {
		if (!$this->getInput('_statu')) $this->forwardRedirect(WindUrlHelper::createUrl('u/register/run'));
		$statu = $this->checkRegisterUser();
		if (($this->loginUser->info['status'] & PwUser::STATUS_UNACTIVE) == PwUser::STATUS_UNACTIVE) {
			$this->forwardAction('u/register/sendActiveEmail', array('_statu' => $statu), true);
		}
		Wind::import('SRV:user.srv.PwLoginService');
		$login = new PwLoginService();
		$login->welcome($this->loginUser, $this->getRequest()->getClientIp());
		
		$this->forwardRedirect(WindUrlHelper::createUrl('u/register/guide'));
	}
	
	/**
	 * 用户引导页面
	 *
	 */
	public function guideAction() {
		if (!$this->loginUser->isExists()) $this->forwardRedirect(WindUrlHelper::createUrl(''));
		$key = $this->getInput('key');
		/* @var $guideService PwUserRegisterGuideService */
		$guideService = Wekit::load('APPS:u.service.PwUserRegisterGuideService');
		$next = $guideService->getNextGuide($key);
		if (!$next) {
			if (Wekit::config('register', 'active.check')) {
				$this->setOutput(1, 'check');
			}
			$this->setOutput($this->loginUser->info['username'], 'username');
			$this->setOutput('success', 'type');
			$this->setTemplate('register_about');
		} else {
			$this->forwardRedirect(WindUrlHelper::createUrl($next['guide']));
		}
	}

	/**
	 * 检查邮箱唯一性
	 */
	public function checkemailAction() {
		list($email, $username) =$this->getInput(array('email', 'username'), 'post');
		$result = PwUserValidator::isEmailValid($email, $username);
		if ($result instanceof PwError) $this->showError($result->getError());
		$this->showMessage();
	}
	
	/**
	 * 检查用户名的唯一性
	 */
	public function checkusernameAction() {
		$username = $this->getInput('username', 'post');
		$result = PwUserValidator::isUsernameValid($username);
		if ($result instanceof PwError) $this->showError($result->getError());
		$this->showMessage();
	}

	/**
	 * 检查密码复杂度是否符合
	 */
	public function checkpwdAction() {
		list($pwd, $username) = $this->getInput(array('pwd', 'username'), 'post');
		$result = PwUserValidator::isPwdValid($pwd, $username);
		if ($result instanceof PwError) $this->showError($result->getError());
		$this->addMessage(PwUserHelper::checkPwdStrong($pwd), 'rank');
		$this->showMessage();
	}
	
	/**
	 * 检查密码强度
	 */
	public function checkpwdStrongAction() {
		$pwd = $this->getInput('pwd', 'post');
		$this->addMessage(PwUserHelper::checkPwdStrong($pwd), 'rank');
		$this->showMessage();
	}
	
	
	/**
	 * 购买用户邮箱激活码
	 */
	public function buymailcodeAction() {
		//TODO 购买邀请码
	}
	
	/**
	 * 验证用户标识
	 *
	 * @return string
	 */
	private function checkRegisterUser() {
		$identify = $this->getInput('_statu', 'get');
		!$identify && $identify = $this->getInput('_statu', 'post');
		if (!$identify) $this->showError('USER:illegal.request');
		list($uid, $password) = PwRegisterService::parserRegistIdentify($identify);
		$info = $this->_getUserDs()->getUserByUid($uid, PwUser::FETCH_MAIN);
		if (Pw::getPwdCode($info['password']) != $password) {
			$this->showError('USER:illegal.request');
		}
		$this->loginUser = new PwUserBo($uid);
		return $identify;
	}
	
	/**
	 * 初始化
	 */
	private function init() {
		$registerService = new PwRegisterService();
		$result = $registerService->checkIp($this->getRequest()->getClientIp());
		if ($result instanceof PwError) $this->showMessage($result->getError());
		$resource = Wind::getApp()->getComponent('i18n');
		list($_pwdMsg, $_pwdArgs) = PwUserValidator::buildPwdShowMsg();
		list($_nameMsg, $_nameArgs) = PwUserValidator::buildNameShowMsg();
		$this->setOutput($resource->getMessage($_pwdMsg, $_pwdArgs), 'pwdReg');
		$this->setOutput($resource->getMessage($_nameMsg, $_nameArgs), 'nameReg');
		$this->setOutput(in_array('register', Wekit::config('verify', 'showverify')), 'verify');
		$this->setOutput(Wekit::config('register'), 'config');
		$this->setOutput(PwUserHelper::getRegFieldsMap(), 'needFields');
		$this->setOutput(array('location', 'hometown'), 'areaFields');
	}
	
	/**
	 * 关闭
	 */
	public function closeAction() {
		$config = Wekit::config('register');
		$this->setOutput($config['close.msg'], 'close');
		$this->setTemplate('register_close');
	}
	
	/**
	 * 获得用户DS
	 *
	 * @return PwUser
	 */
	private function _getUserDs() {
		return Wekit::load('user.PwUser');
	}
	
	/**
	 * 获取注册的信息
	 *
	 * @return PwUserInfoDm
	 */
	private function _getUserDm() {
		list($username, $password, $repassword, $email, $aliww, $qq, $msn, $mobile, $hometown, $location, $question, $answer, $regreason, $code) =
		$this->getInput(array('username', 'password', 'repassword', 'email', 'aliww', 'qq', 'msn', 'mobile', 'hometown', 'location', 'question', 'answer', 'regreason', 'code'),
			'post');
		
		//	验证输入
		Wind::import('Wind:utility.WindValidator');
		$config = Wekit::config('register');
		if (!$username) $this->showError('USER:user.error.-1', 'u/register/run');
		if (!$password) $this->showError('USER:pwd.require', 'u/register/run');
		if (!$email) $this->showError('USER:user.error.-6', 'u/register/run');
		if (!WindValidator::isEmail($email)) $this->showError('USER:user.error.-7', 'u/register/run');
		
		foreach ($config['active.field'] as $field) {
			if (!$this->getInput($field, 'post')) $this->showError('USER:register.error.require.needField.' . $field, 'u/register/run');
		}
		if ($config['active.check'] && !$regreason) {
			$this->showError('USER:register.error.require.regreason', 'u/register/run');
		}
		if ($config['active.phone'] && !WindValidator::isTelNumber($mobile)) {
			$this->showError('USER:error.mobile', 'u/register/run');
		}
		if ($repassword != $password) $this->showError('USER:user.error.-20', 'u/register/run');
		if (in_array('register', Wekit::config('verify', 'showverify'))) {
			$veryfy = Wekit::load("verify.srv.PwCheckVerifyService");
			if (false === $veryfy->checkVerify($code)) $this->showError('USER:verifycode.error', 'u/register/run');
		}
		
		Wind::import('SRC:service.user.dm.PwUserInfoDm');
		$userDm = new PwUserInfoDm();
		$userDm->setUsername($username);
		$userDm->setPassword($password);
		$userDm->setEmail($email);
		$userDm->setRegdate(Pw::getTime());
		$userDm->setLastvisit(Pw::getTime());
		$userDm->setRegip(Wekit::app()->clientIp);
		
		$userDm->setAliww($aliww);
		$userDm->setQq($qq);
		$userDm->setMsn($msn);
		$userDm->setMobile($mobile);
		$userDm->setHometown($hometown);
		$userDm->setLocation($location);
		$userDm->setQuestion($question, $answer);
		$userDm->setRegreason($regreason);
		return $userDm;
	}
}