<?php
/**
 * 用户注册过滤
 *
 * @author xiaoxia.xu <xiaoxia.xuxx@aliyun-inc.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: UserRegisterFilter.php 15637 2012-08-09 09:20:55Z xiaoxia.xuxx $
 * @package 
 */
class UserRegisterFilter extends WindActionFilter {

	/* (non-PHPdoc)
	 * @see WindHandlerInterceptor::preHandle()
	 */
	public function preHandle() {
		/* @var $userBo PwUserBo */
		$userBo = PwUserBo::getLoginUser();
		if ($userBo->isExists() && !in_array($this->router->getAction(), array('welcome', 'guide'))) {
			
			//TODO 好友邀请链接
			$inviteCode = $this->getInput('invite');
			if ($inviteCode) {
				$user = Wekit::load('SRV:invite.srv.PwInviteFriendService')->invite($inviteCode, $userBo->uid);
				if ($user instanceof PwError) {
					$this->showError($user->getError());
				}
			}
			
			$referer = $this->getRequest()->getServer('HTTP_REFERER');
			$this->errorMessage->addError($referer, 'referer');
			$this->errorMessage->addError($referer, 'refresh');
			$this->errorMessage->sendError('USER:register.dumplicate');
		}
	}

	/* (non-PHPdoc)
	 * @see WindHandlerInterceptor::postHandle()
	 */
	public function postHandle() {
	}
}