<?php
Wind::import('ADMIN:library.AdminBaseController');
Wind::import('SRV:config.bo.PwConfigBo');

/**
 * 后台设置-验证机制配置
 *
 * @author Qiong Wu <papa0924@gmail.com>
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.phpwind.com
 * @version $Id: VerifyController.php 17559 2012-09-06 09:50:06Z gao.wanggao $
 * @package 
 */
class VerifyController extends AdminBaseController {
	
	/* (non-PHPdoc)
	 * @see WindController::run()
	 */
	public function run() {
		Wind::import('SRV:verify.srv.PwVerifyService');
		$srv =  new PwVerifyService('PwVerifyService_getVerifyType');
		$verifyType = $srv->getVerifyType();
		$service = $this->_loadConfigService();
		$config = $service->getValues('verify');
		$this->setOutput($config, 'config');
		$this->setOutput($verifyType, 'verifyType');
	}

	/**
	 * 配置增加表单处理器
	 *
	 * @return void
	 */
	public function dorunAction() {
		$questions = $this->getInput('contentQuestions', 'post');
		$_questions = array();
		foreach ($questions as $key => $value) {
			if (empty($value['ask']) && empty($value['answer'])) continue;
			$_questions[] = $value;
		
		}
		$config = new PwConfigBo('verify');
		$config->set('type', $this->getInput('type', 'post'))
			->set('randtype', $this->getInput('randtype', 'post'))
			->set('content.type', $this->getInput('contentType', 'post'))
			->set('content.length', $this->getInput('contentLength', 'post'))
			->set('content.questions', $_questions)
			->set('width', 240)
			->set('height', 60)
			->set('content.showanswer', $this->getInput('contentShowanswer', 'post'))
			->set('voice', $this->getInput('voice', 'post'))
			->flush();
		$this->showMessage('ADMIN:success');
	}
	
	/**
	 * 站点设置
	 *
	 * @return void
	 */
	public function setAction() {
		$service = $this->_loadConfigService();
		$config = $service->getValues('verify');
		$this->setOutput($config, 'config');
	}
			
	/**
	 * 全局配置增加表单处理器
	 *
	 * @return void
	 */
	public function dosetAction() {
		$config = new PwConfigBo('verify');
		$config->set('showverify', $this->getInput('showverify', 'post'))->flush();	
		$this->showMessage('ADMIN:success');
	
	}

	private function _loadConfigService() {
		 return Wekit::load('config.PwConfig');
	}
}