<?php
defined('WEKIT_VERSION') || exit('Forbidden');

Wind::import('SRV:poll.srv.PwPollDisplay');
Wind::import('SRV:poll.srv.dataSource.PwFetchPollByOrder');
Wind::import('SRV:poll.srv.dataSource.PwFetchPollByUid');

/**
 * 我的投票
 *
 * @author MingXing Sun <mingxing.sun@aliyun-inc.com> 2012-01-12
 * @copyright ©2003-2103 phpwind.com
 * @license http://www.windframework.com
 * @version $Id: MyController.php 3219 2012-01-12 06:43:45Z mingxing.sun $
 * @package admin
 * @subpackage controller
 */

class MyController extends PwBaseController {
	
	public $page = 1;
	public $perpage = 5;
	
	public function beforeAction($handlerAdapter) {
		parent::beforeAction($handlerAdapter);
		if (!$this->loginUser->isExists()) {
			$this->forwardAction('u/login/run', array('backurl' => WindUrlHelper::createUrl('vote/my/run')));
		}
	}
	
	public function run(){
 		$page = $this->getInput('page');
 		$this->page = $page < 1 ? 1 : intval($page);
		list($start, $limit) = Pw::page2limit($this->page, $this->perpage);
		
		$total = $this->_getPollVoterDs()->countByUid(PwUserBo::getLoginUser()->uid);
		$poll = $total ? $this->_getPollVoterDs()->getPollByUid(PwUserBo::getLoginUser()->uid, $limit, $start) : array();
		
		$pollInfo = array();
		
		if ($poll) {
			$pollid = array();
			foreach ($poll as $value) {
				$pollid[] = $value['poll_id'];
			}
			
			Wind::import('SRV:poll.srv.dataSource.PwFetchPollByPollid');
			$pollDisplay = new PwPollDisplay(new PwFetchPollByPollid($pollid, count($pollid)));
			$pollInfo = $this->_buildPoll($pollDisplay->gather(), 'my');
		}
		
		$latestPollDisplay = new PwPollDisplay(new PwFetchPollByOrder(10, 0, array('created_time'=>'0')));
		$latestPoll = $latestPollDisplay->gather();
		
		$this->setOutput($total, 'total');
		$this->setOutput($pollInfo, 'pollInfo');
		$this->setOutput($latestPoll, 'latestPoll');
		$this->setOutput($this->page, 'page');
		$this->setOutput($this->perpage, 'perpage');
		$this->setOutput(
			array(
				'allowview' => $this->loginUser->getPermission('allow_view_vote'),
				'allowvote'=> $this->loginUser->getPermission('allow_participate_vote')
			)
		, 'pollGroup');
		
		// seo设置
		Wind::import('SRV:seo.bo.PwSeoBo');
		$lang = Wind::getComponent('i18n');
		PwSeoBo::setCustomSeo($lang->getMessage('SEO:vote.my.run.title'), '', '');
	}
	
	public function createAction(){
		$page = $this->getInput('page');
 		$this->page = $page < 1 ? 1 : intval($page);
		list($start, $limit) = Pw::page2limit($this->page, $this->perpage);
		
		$total = $this->_getPollDs()->countPollByUid($this->loginUser->uid);
		
		$pollInfo = array();
		
		if ($total) {
			$pollDisplay = new PwPollDisplay(new PwFetchPollByUid(PwUserBo::getLoginUser()->uid, $limit, $start));
			$pollInfo = $this->_buildPoll($pollDisplay->gather());
		}
		
		$latestPollDisplay = new PwPollDisplay(new PwFetchPollByOrder(10, 0, array('created_time'=>'0')));
		$latestPoll = $latestPollDisplay->gather();
		
		$this->setOutput($total, 'total');
		$this->setOutput($pollInfo, 'pollInfo');
		$this->setOutput($latestPoll, 'latestPoll');
		$this->setOutput($this->page, 'page');
		$this->setOutput($this->perpage, 'perpage');
		$this->setOutput(
			array(
				'allowview' => $this->loginUser->getPermission('allow_view_vote'),
				'allowvote'=> $this->loginUser->getPermission('allow_participate_vote')
			)
		, 'pollGroup');
	}
	
	private function _buildPoll($data, $action = 'create') {
		$reuslt = array();
		switch ($action) {
			case 'create':
				$pollid = $myPollid = array();
				foreach ($data as $value) {
					$pollid[] = $value['poll_id'];
				}
				
				$loginUserPollids = $this->_getPollVoterDs()->getPollByUidAndPollid($this->loginUser->uid, $pollid);
		
				foreach ($data as $value) {
					$value['isvoted'] = in_array($value['poll_id'], $loginUserPollids)  ? true : false;
					$reuslt[] = $value;
				}
				
				break;
				
			case 'my' :
				foreach ($data as $value) {
					$value['isvoted'] = 1;
					$reuslt[] = $value;
				}
				break;
		}
		
		return $reuslt;
	}
	
	/**
	 * 获取投票service服务层
	 *
	 * @return PwPollService
	 */
	protected function _getPwPollService(){
		return Wekit::load('poll.srv.PwPollService');
	}
	
	/**
	 * get PwPollVoter
	 *
	 * @return PwPollVoter
	 */
	protected function _getPollVoterDs(){
		return Wekit::load('poll.PwPollVoter');
	}
	
	/**
	 * get PwPoll
	 *
	 * @return PwPoll
	 */
	protected function _getPollDs(){
		return Wekit::load('poll.PwPoll');
	}
}